

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppAnalyticsRoleOperation.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppAnalyticsRoleOperation
--  | Description:   Creates/ delete entries in  DM2Cloud table
--  |
--  |			create analytics servers cloud
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppAnalyticsRoleOperation.sp,v $ $Id: AppAnalyticsRoleOperation.sp,v 1.1.4.11 2020/08/24 15:17:18 sjohnson Exp $";
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppAnalyticsRoleOperation')
BEGIN
	print '>>> Drop Stored Procedure: AppAnalyticsRoleOperation <<<'
	drop procedure AppAnalyticsRoleOperation
END
IF EXISTS (select * from GxQscripts where name='AppAnalyticsRoleOperation')
	delete from GxQscripts where name = 'AppAnalyticsRoleOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAnalyticsRoleOperation')
	delete from GXDBVersions where aliasname = 'AppAnalyticsRoleOperation'
GO
print '... Creating Procedure: AppAnalyticsRoleOperation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppAnalyticsRoleOperation
  @i_userID INT,
  @i_inputXml XML   
AS
  DECLARE @o_errorCode integer = 0
  DECLARE @o_errorStr varchar(max) = 'Success'
DECLARE @opType INT = 0
DECLARE @roleId INT = 0
DECLARE @cloudId INT = 0
DECLARE @installTime int = dbo.GetUnixTime(GETDATE())
DECLARE @opEvMsgId          INT = 0
DECLARE @dataIsEvent        INT = 0
DECLARE @opMsgId            INT = 0
DECLARE @opId               INT = 0
DECLARE @paramMsgId         INT = 0
DECLARE @roleList			NVARCHAR(1024)
/*
<App_RoleOperation cloudId="7"><roles roleId="2" operationType="1" status="3" /></App_RoleOperation>
*/
EXEC AppValidateIndexServerRole @i_userID, @i_inputXml, @o_errorCode OUTPUT, @o_errorStr OUTPUT
IF @o_errorCode > 0
BEGIN
	GOTO errorexit
END
SET @cloudId = ISNULL (( SELECT ref.value('@cloudId', 'INT')
                              FROM @i_inputXml.nodes ('App_RoleOperation') R(ref)), 0)
IF (OBJECT_ID('tempdb.dbo.#analyticsRolesTbl') IS NOT NULL) DROP TABLE #analyticsRolesTbl
CREATE TABLE #analyticsRolesTbl (t_roleId INT, t_opType INT, t_status INT)
INSERT INTO #analyticsRolesTbl
SELECT DISTINCT  ref.value('@roleId', 'INT') , ref.value('@operationType', 'INT'), ref.value('@status', 'INT')
FROM @i_inputXml.nodes ('App_RoleOperation/roles') R(ref)
-- SET GUI AUDIT OPERATION
DECLARE @pseudoClientId INT = ISNULL((SELECT pseudoClientId FROM DM2Cloud (nolock) WHERE cloudId = @cloudId),0)
DECLARE @cloudDisplayName NVARCHAR(1024) = ISNULL((SELECT name FROM DM2Cloud (nolock) WHERE cloudId = @cloudId), N'')
SET @opMsgId = (605 | (CAST(POWER(2, 24) AS BIGINT) * 84))
DECLARE @appId INT= ISNULL((SELECT TOP 1 id FROM APP_Application (NOLOCK) WHERE clientId= @pseudoClientId AND apptypeId =64),0)
--
BEGIN TRY
BEGIN transaction
	IF EXISTS (SELECT 1 FROM #analyticsRolesTbl WHERE t_opType = 1 )--common::OperationType_ADD
	BEGIN
		--ADDED PREVIOUSLY DELETED ROLES
		UPDATE DM2CloudCoreRole
		SET roleProps = '',
			attribute = 0,
			modifiedTime = @installTime
		FROM DM2CloudCoreRole R
			JOIN  #analyticsRolesTbl ON R.roleId =t_roleId
WHERE cloudId = @cloudId AND attribute = 0x00004 AND t_opType = 1
		--DELETE already existing roles
		DELETE T
		FROM #analyticsRolesTbl T
		JOIN DM2CloudCoreRole ON CloudId =@CloudId AND roleId = t_roleId
		WHERE t_opType = 1 AND status = 1
		IF EXISTS (SELECT 1 FROM #analyticsRolesTbl WHERE t_opType = 1)
		BEGIN
			MERGE DM2CloudCoreRole AS R
			USING(SELECT  t_roleId, t_opType, t_status FROM #analyticsRolesTbl WHERE t_opType = 1 ) AS U (t_roleId, t_opType, t_status)
			ON (R.roleId = U.t_roleId AND cloudId= @cloudId)
			WHEN MATCHED THEN
				UPDATE SET status=t_status
			WHEN NOT MATCHED THEN
				INSERT (cloudId,roleId, createTime, roleProps, attribute, modifiedTime, status)
				VALUES(@cloudId,t_roleId, @installTime, '', 0,0, t_status);
			SET  @o_errorCode = @@ERROR
			IF @o_errorCode <> 0
			BEGIN
				SET @o_errorCode= 12752 --ROLE_OPERATION_FAILED
				SET @o_errorStr = 'Failed to create role info.'
			END
IF EXISTS (SELECT 1 FROM DM2CloudCoreRole WHERE roleId = 4 AND cloudId = @cloudId)
				AND NOT EXISTS (SELECT 1 FROM GXGlobalParam WHERE name = 'DOWNLOAD_CENTER_INDEX_SERVER_CLIENTID')
			BEGIN
				DECLARE @clientId INT = ISNULL((SELECT TOP 1 clientId FROM DM2SearchServerCoreInfo (NOLOCK) WHERE cloudId = @cloudId AND cloudType = 1),0) --App::CloudServerType_AnalyticsEngine
				DECLARE @portNo INT = ISNULL((SELECT TOP 1 portNo FROM DM2SearchServerCoreInfo (NOLOCK) WHERE cloudId = @cloudId AND cloudType = 1),0) --App::CloudServerType_AnalyticsEngine
				DECLARE @hostName NVARCHAR(1024) = ISNULL((SELECT TOP 1 net_hostName FROM APP_Client (NOLOCK) WHERE Id = @clientId),N'')
				IF @clientId > 0 AND @portNo > 0 AND @hostName != N''
				BEGIN
					INSERT INTO GXGlobalParam (name, value, created , modified) VALUES('DOWNLOAD_CENTER_INDEX_SERVER_CLIENTID', CAST (@pseudoClientId AS nvarchar(255)), @installTime, 0)
					INSERT INTO GXGlobalParam (name, value, created , modified) VALUES('DOWNLOAD_CENTER_HOST', CAST (@hostName AS nvarchar(255)), @installTime, 0)
					INSERT INTO GXGlobalParam (name, value, created , modified) VALUES('DOWNLOAD_CENTER_URL', (N'http://' + CAST (@hostName AS nvarchar(255))), @installTime, 0)
				END
			END
IF EXISTS (SELECT 1 FROM DM2CloudCoreRole WHERE roleId = 12 AND cloudId = @cloudId)
			BEGIN
IF NOT EXISTS (SELECT 1 FROM DM2Cloud (NOLOCK) WHERE (flags & 4) > 0)
					INSERT INTO DM2Cloud ( commcellId, name,  flags, createTime, cloudType, displayName)
VALUES (2, 'Mailbox Index', 4,  @installTime, 7, 'Mailbox Index')  --CV_VIRTUAL_CLOUD_MAILBOXINDEX
IF NOT EXISTS (SELECT 1 FROM DM2Cloud (NOLOCK) WHERE (flags & 2) > 0)
					INSERT INTO DM2Cloud (commcellId, name,  flags, createTime, cloudType, displayName)
VALUES (2, 'Journal Index', 2,  @installTime, 7, 'Journal Index')  --CV_VIRTUAL_CLOUD_MAILBOXINDEX
			END
			--audit only if there are roles to be added
			SELECT @roleList = COALESCE(@roleList+',' ,'') + M.roleTypeName
			FROM #analyticsRolesTbl T
			JOIN DM2CloudRoleMaster M (NOLOCK) ON T.t_roleId = M.roleType
			WHERE t_opType = 1
			--delete existing roles as contents from temp table to avoid duplicates
			DELETE  R
			FROM #analyticsRolesTbl R
			JOIN DM2CloudRoleMaster RM WITH (NOLOCK) ON R.t_roleId =RM.roleType
			JOIN APP_ScFilterFile SF (NOLOCK) ON SF.fileName ='\%'+ RM.roleTypeName +'%'
			WHERE SF.componentNameId = @appId AND SF.type = 1 AND t_opType = 1
			--add contents
			IF EXISTS (SELECT 1 FROM #analyticsRolesTbl WHERE t_opType = 1)
			BEGIN
				INSERT INTO APP_ScFilterFile (componentNameId, type, fileName, created, modified)
				SELECT DISTINCT  @appId,  1, '\%'+ RM.roleTypeName +'%', @installTime, 0
				FROM #analyticsRolesTbl R
				INNER JOIN DM2CloudRoleMaster RM WITH (NOLOCK) ON R.t_roleId =RM.roleType
				WHERE t_opType = 1 AND RM.roleTypeName <> 'System Default'
			END
		END
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userID, 3 , @pseudoClientId, @opEvMsgId OUTPUT, @opId OUTPUT
		SELECT @roleList= ISNULL(@roleList,''), @cloudDisplayName =  ISNULL(@cloudDisplayName,'')
		-- SET GUI AUDIT PARAMETER
		EXEC EvGuiAuditSetParamData @opId, @roleList, @dataIsEvent
		EXEC EvGuiAuditSetParamData @opId, @cloudDisplayName, @dataIsEvent
SET @paramMsgId = (1634 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userID
	END
	IF EXISTS (SELECT 1 FROM #analyticsRolesTbl WHERE t_opType = 2 )--common::OperationType_DELETE
	BEGIN
--AppAnalyticsDeleteOperation.spb
--DOWNLOAD_CENTER
IF EXISTS (SELECT TOP 1 1 FROM #analyticsRolesTbl WHERE t_opType = 2 AND t_roleId = 4)
BEGIN
	--delete information for Download center role
IF EXISTS (SELECT 1 FROM DM2CloudCoreRole WHERE roleId = 4 AND cloudId = @cloudId)
			AND EXISTS (SELECT 1 FROM GXGlobalParam WHERE name = 'DOWNLOAD_CENTER_INDEX_SERVER_CLIENTID' )
		BEGIN
			DECLARE @dcIndexSvrClientId INT = ISNULL((SELECT CAST (value AS INT) FROM GXGlobalParam WHERE name = 'DOWNLOAD_CENTER_INDEX_SERVER_CLIENTID'),0)
			IF @dcIndexSvrClientId >0 AND  @pseudoClientId =  @dcIndexSvrClientId
				DELETE FROM GXGLOBALPARAM WHERE NAME IN ('DOWNLOAD_CENTER_CLIENT_ID_DONOTUSE','DOWNLOAD_CENTER_HOST','DOWNLOAD_CENTER_URL','DOWNLOAD_CENTER_INDEX_SERVER_CLIENTID', 'DOWNLOAD_CENTER_CLIENT_ID_RETRY')
		END
END
--reset cloudid to 0 for reviewset
IF EXISTS (SELECT TOP 1 1 FROM #analyticsRolesTbl WHERE t_opType = 2 AND t_roleId = 8)
BEGIN
IF EXISTS (SELECT TOP 1 1 FROM DM2CloudCoreRole WHERE roleId = 8)
	AND EXISTS (SELECT TOP 1 1 FROM DM2Container (NOLOCK) WHERE cloudId = @cloudId)
	BEGIN
		UPDATE DM2Container
		SET cloudId = 0
		WHERE cloudId = @cloudId
	END
END
--delete subclient contents from APP_ScFilterFile table
DELETE S
FROM APP_ScFilterFile  S
JOIN #analyticsRolesTbl T ON componentNameId = @appId AND T.t_opType = 2
JOIN DM2CloudRoleMaster RM (NOLOCK) ON T.t_roleId =RM.roleType
WHERE  fileName = ('\%'+ RM.roleTypeName +'%')
--delete from DM2CloudCoreRole table
DELETE DM2CloudCoreRole
WHERE cloudId = @cloudId
AND roleId IN (SELECT t_roleId FROM #analyticsRolesTbl WHERE t_opType = 2 )
--EXCHANGE_INDEX
IF EXISTS (SELECT TOP 1  1 FROM #analyticsRolesTbl WHERE t_opType = 2 AND t_roleId = 12)
BEGIN
IF NOT EXISTS (SELECT 1 FROM DM2CloudCoreRole WHERE roleId = 12)
	BEGIN
DELETE FROM DM2Cloud WHERE (flags & 4) > 0 OR (flags & 2) > 0
	END
END
--
		SELECT @roleList = COALESCE(@roleList+',' ,'') + M.roleTypeName
        FROM #analyticsRolesTbl T
		JOIN DM2CloudRoleMaster M ON T.t_roleId = M.roleType
        WHERE t_opType = 2
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userID, 3 , @pseudoClientId, @opEvMsgId OUTPUT, @opId OUTPUT
		SELECT @roleList= ISNULL(@roleList,''), @cloudDisplayName =  ISNULL(@cloudDisplayName,'')
		-- SET GUI AUDIT PARAMETER
		EXEC EvGuiAuditSetParamData @opId, @roleList, @dataIsEvent
		EXEC EvGuiAuditSetParamData @opId, @cloudDisplayName, @dataIsEvent
SET @paramMsgId = (1635 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userID
	END
	IF EXISTS (SELECT 1 FROM #analyticsRolesTbl WHERE t_opType = 3 )--common::OperationType_MODIFY
	BEGIN
		UPDATE DM2CloudCoreRole
		SET roleProps = '',
			attribute = 0,
			modifiedTime = @installTime
		FROM DM2CloudCoreRole R
			JOIN  #analyticsRolesTbl ON R.roleId =t_roleId
		WHERE cloudId = @cloudId AND t_opType = 3
	END
	COMMIT transaction
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    Set @o_errorCode = ERROR_NUMBER()
    SET @o_errorStr  = ERROR_MESSAGE()
	 -- Rollback any active or uncommittable transactions before
     -- inserting information in the ErrorLog
    IF XACT_STATE() <> 0
    BEGIN
        ROLLBACK TRANSACTION;
    END
	;THROW
END CATCH
errorexit:
-- Rollback any active or uncommittable transactions
IF XACT_STATE() <> 0
BEGIN
    ROLLBACK TRANSACTION;
END
SELECT @o_errorCode AS o_errorCode, @o_errorStr AS o_errorStr
IF (OBJECT_ID('tempdb.dbo.#analyticsRolesTbl') IS NOT NULL) DROP TABLE #analyticsRolesTbl
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppAnalyticsRoleOperation')
	delete from GxQscripts where name = 'AppAnalyticsRoleOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAnalyticsRoleOperation')
	delete from GXDBVersions where aliasname = 'AppAnalyticsRoleOperation'
GO

insert into GXDBVersions values(2, 'AppAnalyticsRoleOperation',  '00010001000400110000', 'AppAnalyticsRoleOperation', '00010001000400110000')
GO

