

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppAnalyticsPermissionCheck.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppAnalyticsPermissionCheck
--  | Description:   Creates/ delete entries in  DM2Cloud table
--  |
--  |			create analytics servers cloud
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppAnalyticsPermissionCheck.sp,v $ $Id: AppAnalyticsPermissionCheck.sp,v 1.1.2.6 2019/05/31 20:17:27 pankajkumar Exp $";
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppAnalyticsPermissionCheck')
BEGIN
	print '>>> Drop Stored Procedure: AppAnalyticsPermissionCheck <<<'
	drop procedure AppAnalyticsPermissionCheck
END
IF EXISTS (select * from GxQscripts where name='AppAnalyticsPermissionCheck')
	delete from GxQscripts where name = 'AppAnalyticsPermissionCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAnalyticsPermissionCheck')
	delete from GXDBVersions where aliasname = 'AppAnalyticsPermissionCheck'
GO
print '... Creating Procedure: AppAnalyticsPermissionCheck'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppAnalyticsPermissionCheck
  @i_userID INT,
  @i_cloudId INT,
  @i_indexServerClientId INT = 0,
  @i_opType INT=0
AS
  DECLARE @o_errorCode integer = 0
  DECLARE @o_errorStr varchar(max) = 'Success'
--assign cloudId if not present
IF( @i_cloudId = 0)
	SELECt @i_cloudId = cloudId FROM DM2CLOUD (NOLOCK) WHERE pseudoClientId = @i_indexServerClientId
-- check validity of the cloud
IF @i_cloudId = 0 OR NOT EXISTS (SELECT 1 FROM DM2CLOUD (NOLOCK) WHERE cloudId = @i_cloudId)
BEGIN
	SET @o_errorStr = 'Invalid cloudId.'
	SET @o_errorCode = 12708 -- CLOUD_ID_INVALID
	GOTO errorexit
END
--check permission for physical clients
DECLARE @nodeList TABLE (t_clientId INT)
INSERT INTO @nodeList (t_clientId )
SELECT clientId
FROM DM2SearchServerCoreInfo S (NOLOCK)
WHERE cloudId = @i_cloudId AND  cloudType IN (5, 9)
--check permission for index server client Id
IF @i_opType = 2 --delete
BEGIN
	INSERT INTO @nodeList (t_clientId )
	SELECT pseudoClientId
	FROM DM2Cloud (NOLOCK)
	WHERE cloudId = @i_cloudId
END
--Check if COMMCELL level Agent mgmt permision set
DECLARE @isAllAgentAssociationsSet INT = 0
EXEC sec_checkPermissionOnEntity @i_userID, 2 /*EV_MANAGE_APPLICATION*/, @isAllAgentAssociationsSet OUTPUT, 1 /*COMMCELL_ENTITY*/, 2
IF @isAllAgentAssociationsSet = 0
BEGIN
	IF OBJECT_ID('tempdb.dbo.#clientList') IS NOT NULL DROP TABLE #clientList
	CREATE TABLE #clientList
	(
		t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
	)
	--get ALL association COMMCELL LEVEL check ENDUSER
EXEC sec_getIdaObjectsForUser @i_userId, 3 /*CLIENT_ENTITY*/ , 2 /*EV_MANAGE_APPLICATION*/, 0, '#clientList'
	IF EXISTS (SELECT 1 FROM @nodeList WHERE t_clientId NOT IN (SELECT t_clientId FROM #clientList ))
	BEGIN
		SET @o_errorStr = 'Agent Management permission is not avaiable.'
		SET @o_errorCode =  12729				--USER_PERMISSION_NOT_AVAIABLE = 12729;
		GOTO errorexit
	END
	IF OBJECT_ID('tempdb.dbo.#clientList') IS NOT NULL DROP TABLE #clientList
END
--
IF @i_opType = 2 --delete
BEGIN
	--Check if COMMCELL level Install permision set
	DECLARE @isInstallAssociationsSet INT = 0
EXEC sec_checkPermissionOnEntity @i_userID, 7 /*EV_MANAGE_INSTALLATION */, @isInstallAssociationsSet OUTPUT, 1 /*COMMCELL_ENTITY*/, 2
	IF @isInstallAssociationsSet = 0
	BEGIN
		--check capability for index server client Id
		DECLARE @indexServerClientId INT = ISNULL((SELECT pseudoClientId FROM DM2Cloud (NOLOCK) WHERE cloudId = @i_cloudId), 0)
EXEC sec_checkPermissionOnEntity @i_userID, 7 /*EV_MANAGE_INSTALLATION */, @isInstallAssociationsSet OUTPUT, 3, @indexServerClientId
		IF @isInstallAssociationsSet = 0
		BEGIN
			SET @o_errorStr = 'Install Package/Update permission is not avaiable.'
			SET @o_errorCode =  12729				--USER_PERMISSION_NOT_AVAIABLE = 12729;
			GOTO errorexit
		END
	END
END
--
errorexit:
--OUTPUT
SELECT @o_errorCode AS 'o_errorCode', @o_errorStr AS 'o_errorStr'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppAnalyticsPermissionCheck')
	delete from GxQscripts where name = 'AppAnalyticsPermissionCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAnalyticsPermissionCheck')
	delete from GXDBVersions where aliasname = 'AppAnalyticsPermissionCheck'
GO

insert into GXDBVersions values(2, 'AppAnalyticsPermissionCheck',  '00010001000200060000', 'AppAnalyticsPermissionCheck', '00010001000200060000')
GO

