

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppAnalyticsNodePoolOperation.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppAnalyticsNodePoolOperation
--  | Description:   Creates/ delete entries in DM2SearchServerCodeInfo, DM2Cloud
--  |                and DM2CloudCoreRole tables
--  |
--  |			create solr servers cloud
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppAnalyticsNodePoolOperation.sp,v $ $Id: AppAnalyticsNodePoolOperation.sp,v 1.1.2.8.14.1 2021/01/08 20:31:07 pankajkumar Exp $";
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppAnalyticsNodePoolOperation')
BEGIN
	print '>>> Drop Stored Procedure: AppAnalyticsNodePoolOperation <<<'
	drop procedure AppAnalyticsNodePoolOperation
END
IF EXISTS (select * from GxQscripts where name='AppAnalyticsNodePoolOperation')
	delete from GxQscripts where name = 'AppAnalyticsNodePoolOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAnalyticsNodePoolOperation')
	delete from GXDBVersions where aliasname = 'AppAnalyticsNodePoolOperation'
GO
print '... Creating Procedure: AppAnalyticsNodePoolOperation'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppAnalyticsNodePoolOperation
  @i_userID INT,
  @i_inputXml XML,
  @o_errorCode INT OUTPUT,
  @o_errorStr varchar(512) OUTPUT
AS
SET @o_errorCode = 0
SET @o_errorStr = 'Success'
DECLARE @opType INT = 0
DECLARE @clientId INT = 0
DECLARE @cloudId INT = 0
DECLARE @portNo INT = 0
DECLARE @cloudType INT = 0
DECLARE @commcellId INT = 2
DECLARE @status INT = 0
DECLARE @nodeProps NVARCHAR(2048)
DECLARE @clientName NVARCHAR(2048)
DECLARE @indexDir NVARCHAR(2048)
DECLARE @cloudPoolDisplayName NVARCHAR(2048)
DECLARE @jvmMemory INT = 0
DECLARE @installTime int = dbo.GetUnixTime(GETDATE())
DECLARE @cloudName NVARCHAR(1024)
DECLARE @opEvMsgId          INT = 0
DECLARE @dataIsEvent        INT = 0
DECLARE @opMsgId            INT = 0
DECLARE @opId               INT = 0
DECLARE @paramMsgId         INT = 0
/*<App_NodeOperation cloudId="18">
                       <nodes opType="1" status="3">
                           <nodeClientEntity clientId="2" />
                           <nodeMetaInfos name="analytics_datadirectory" value="C:\Program Files\CommVault\AEDataNew" />
						    <nodeMetaInfos name="analytics_jvmMaxMem" value="4098" />
							 <nodeMetaInfos name="analytics_startport" value="20000" />
							  <nodeMetaInfos name="analytics_stopport" value="20010" />
                       </nodes>
               </App_NodeOperation>
*/
SET @status = ISNULL (( SELECT ref.value('@status', 'INT')
                              FROM @i_inputXml.nodes ('App_NodeOperation/nodes') R(ref)), 0)
--get node properties
DECLARE @nodeProperties TABLE (t_clientId INT, t_name NVARCHAR(1024), T_value NVARCHAR(1024))
INSERT INTO @nodeProperties
SELECT ref.value('nodeClientEntity[1]/@clientId', 'INT'), ref1.value('@name', 'NVARCHAR(1024)'), ref1.value('@value', 'NVARCHAR(1024)')
 FROM @i_inputXml.nodes ('App_NodeOperation/nodes') R(ref)
 CROSS APPLY R.ref.nodes('nodeMetaInfos') as R1(ref1)
--get node metaprops xml
DECLARE @nodeOperation TABLE (t_OpType INT, t_clientId INT, t_nodeMetaInfos NVARCHAR(2048), t_portNo INT, t_clientName NVARCHAR(2048), t_JvmMemory INT)
INSERT INTO @nodeOperation (t_OpType, t_clientId)
SELECT ref.value('@opType', 'INT'), ref.value('nodeClientEntity[1]/@clientId', 'INT')
FROM @i_inputXml.nodes ('App_NodeOperation/nodes') R(ref)
SET @cloudId = ISNULL (( SELECT ref.value('@cloudId', 'INT')
                              FROM @i_inputXml.nodes ('App_NodeOperation') R(ref)), 0)
SET @cloudType = ISNULL((SELECT cloudType FROM DM2Cloud WHERE  cloudId = @cloudId ),0)
--index location is stored into DM2Cloud table
DELETE @nodeProperties WHERE t_name IN ( 'INDEXLOCATION', 'URL', 'WEBSERVER','ISENABLED','ISASSOCIATED')
UPDATE @nodeOperation
SET t_nodeMetaInfos =(SELECT t_name as '@name', T_value AS '@value'
				FROM @nodeProperties P WHERE P.t_clientId = N.t_clientId FOR XML PATH('nodeMetaInfos'), ROOT('NodeMetaProp')),
t_portNo =(SELECT  CAST (T_value AS INT) FROM @nodeProperties P WHERE P.t_clientId = N.t_clientId AND P.t_name = 'PORTNO'),
t_jvmMemory =(SELECT  CAST (T_value AS INT) FROM @nodeProperties P WHERE P.t_clientId = N.t_clientId AND P.t_name = 'JVMMAXMEMORY')
FROM @nodeOperation N
UPDATE @nodeOperation
SET t_clientName = C.name
FROM APP_Client C (NOLOCK)
WHERE c.ID =t_clientId
--
-- SET GUI AUDIT OPERATION
SET @opMsgId = (604 | (CAST(POWER(2, 24) AS BIGINT) * 84))
SET @cloudPoolDisplayName = ISNULL((SELECT name FROM DM2Cloud (NOLOCK) WHERE  cloudId = @cloudId ), N'')
--
BEGIN transaction
	DECLARE nodeOperationCur CURSOR FOR
            SELECT t_OpType, t_clientId, t_nodeMetaInfos, t_portNo, t_clientName, t_jvmMemory
            FROM @nodeOperation
    OPEN nodeOperationCur
    -- Process each SCG configured
    FETCH NEXT FROM nodeOperationCur INTO @opType, @clientId, @nodeProps, @portNo, @clientName, @jvmMemory
    WHILE @@fetch_status = 0
    BEGIN
		IF @opType =  1 --common::OperationType_ADD
		BEGIN
			-- all looks good, create properties
declare @engineType int = (16 | 8)
			DECLARE @coreName nvarchar(1024)
			SET @coreName = 'Cloud_' + CAST(@CloudId as varchar(10)) + '_Client_' + CAST(@ClientId as varchar(10)) + '_Core'
DECLARE @coreRoles INT = 8 | 16
			--ADD A NEW NODE
			IF NOT EXISTS (SELECT 1 FROM DM2SearchServerCoreInfo (NOLOCK) WHERE CloudId = @CloudId AND ClientId = @ClientId AND cloudType= @cloudType )
			BEGIN
				INSERT INTO DM2SearchServerCoreInfo
				(
					CoreName, CommCellId, CloudId, ClientId,
					CreateTime,
					SoftState, Enabled,
					Attributes,
					ServiceLink, CoreRoles,
					CollectionSize, FreeSpace, OccupiedSpace,
					Description,
					skippedItems, failedItems, numFiles, numEmails, status, cloudType, portNo, nodeProps, modifiedTime
				)
				VALUES
				(
					@coreName, @CommCellId, @CloudId, @ClientId,
					getutcdate(),
					1, 1,
					0,	'', @coreRoles,
					0, -1, 0,
					'',	0, 0, 0, 0, @status, @cloudType, @portNo, @nodeProps,0
				)
			END
			ELSE
			BEGIN
				UPDATE DM2SearchServerCoreInfo
				SET nodeProps = @nodeProps, portNo = @portNo
				WHERE CloudId = @CloudId AND ClientId = @ClientId AND cloudType= @cloudType AND status != 1
			END
			IF NOT EXISTS (SELECT 1 FROM app_firewalltppm (NOLOCK) WHERE fromEntityId = @ClientId AND toEntityId = @ClientId AND toPortNumber= @portNo)
				INSERT INTO  app_firewalltppm (tppmType, fromEntityType, fromEntityId, fromPortNumber, toEntityType, toEntityId, toPortNumber, status, tppmParams)
VALUES (8, 3, @clientId, 8700, 3, @clientId, @portNo, 1, '')	--Fix for MR:206555
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userID, 3 , @clientId, @opEvMsgId OUTPUT, @opId OUTPUT
			SELECT @cloudPoolDisplayName =  ISNULL(@cloudPoolDisplayName,''), @clientName = ISNULL(@clientName,''), @jvmMemory = ISNULL(@jvmMemory, 0), @portNo = ISNULL(@portNo, 0)
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @clientName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @cloudPoolDisplayName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @jvmMemory, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @portNo, @dataIsEvent
SET @paramMsgId = (1631 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userID
		END
		ELSE IF @opType =  2 --common::OperationType_DELETE
		BEGIN
			DELETE F
			FROM APP_FirewallTppm F
			JOIN DM2SearchServerCoreInfo S ON F.toEntityId = S.clientId AND F.toPortNumber = S.portNo
WHERE F.tppmType = 8 --TPPMType::DYNAMIC_TPPM=8
				AND F.fromEntityId = @clientId
				AND F.toEntityId = @clientId
AND F.toEntityType = 3
				AND S.cloudType = @cloudType
			DELETE DM2SearchServerCoreInfo
			WHERE cloudId = @cloudId AND  cloudType = @cloudType AND clientId = @clientId
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userID, 3 , @clientId, @opEvMsgId OUTPUT, @opId OUTPUT
			SELECT @cloudPoolDisplayName =  ISNULL(@cloudPoolDisplayName,''), @clientName = ISNULL(@clientName,''), @jvmMemory = ISNULL(@jvmMemory, 0), @portNo = ISNULL(@portNo, 0)
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @clientName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @cloudPoolDisplayName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @jvmMemory, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @portNo, @dataIsEvent
SET @paramMsgId = (1633 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userID
		END
		ELSE IF @opType =  3 --common::OperationType_MODIFY
		BEGIN
			DECLARE @oldPortNo INT = (SELECT portNo FROM DM2SearchServerCoreInfo (NOLOCK) WHERE  cloudId = @cloudId AND  cloudType = @cloudType AND clientId = @clientId)
			--update port no for pool node as well as associated index server node
			UPDATE DM2SearchServerCoreInfo
			SET portNo = @portNo,
				modifiedTime = @installTime
			WHERE cloudType IN (5,9) AND clientId = @clientId AND portNo != @portNo
			--update node property for pool
			UPDATE DM2SearchServerCoreInfo
			SET nodeProps = @nodeProps,
				modifiedTime = @installTime
			WHERE cloudId = @cloudId AND  cloudType = @cloudType AND clientId = @clientId AND nodeProps != @nodeProps
			UPDATE app_firewalltppm
			SET toPortNumber = @portNo
WHERE fromEntityId = @clientId AND toEntityId = @clientId AND toPortNumber = @oldPortNo AND tppmType = 8 --TPPMType::DYNAMIC_TPPM=8
			--update node property for associated index server node
			DECLARE @nodePropXml XML  = ISNULL((SELECT TOP 1 nodeProps FROM DM2SearchServerCoreInfo (NOLOCK) WHERE cloudType = 5 AND clientId = @clientId), '')
			--get node properties
			DECLARE @oldNodeProps TABLE (tr_clientId INT,tr_name NVARCHAR(1024), tr_value NVARCHAR(1024))
			INSERT INTO @oldNodeProps
			SELECT  @clientId, ref.value('@name', 'NVARCHAR(1024)'),ref.value('@value', 'NVARCHAR(1024)')
                    FROM @nodePropXml.nodes ('NodeMetaProp/nodeMetaInfos') R(ref)
			UPDATE @oldNodeProps
			SET tr_value = t_value
			FROM @nodeProperties
			WHERE tr_clientId = t_clientId
					AND ((t_name = 'PORTNO' AND tr_name = 'PORTNO')
						OR (t_name = 'JVMMAXMEMORY' AND tr_name = 'JVMMAXMEMORY')
						)
			UPDATE DM2SearchServerCoreInfo
			SET nodeProps =(SELECT tr_name as '@name', tr_value AS '@value'
							FROM @oldNodeProps P WHERE P.tr_clientId = clientId FOR XML PATH('nodeMetaInfos'), ROOT('NodeMetaProp'))
			WHERE cloudType = 5 AND clientId = @clientId
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userID, 3 , @clientId, @opEvMsgId OUTPUT, @opId OUTPUT
			SELECT @cloudPoolDisplayName =  ISNULL(@cloudPoolDisplayName,''), @clientName = ISNULL(@clientName,''), @jvmMemory = ISNULL(@jvmMemory, 0), @portNo = ISNULL(@portNo, 0)
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @clientName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @cloudPoolDisplayName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @jvmMemory, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @portNo, @dataIsEvent
SET @paramMsgId = (1632 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userID
		END
	FETCH NEXT FROM nodeOperationCur INTO @opType, @clientId, @nodeProps, @portNo, @clientName, @jvmMemory
    END
    CLOSE nodeOperationCur
    DEALLOCATE nodeOperationCur
errorexit:
	if @o_errorCode <> 0 begin
		if @@TRANCOUNT > 0 rollback transaction
	end
	else begin
		if @@TRANCOUNT > 0 commit transaction
	end
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppAnalyticsNodePoolOperation')
	delete from GxQscripts where name = 'AppAnalyticsNodePoolOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAnalyticsNodePoolOperation')
	delete from GXDBVersions where aliasname = 'AppAnalyticsNodePoolOperation'
GO

insert into GXDBVersions values(2, 'AppAnalyticsNodePoolOperation',  'v1.1.2.8.14.1', 'AppAnalyticsNodePoolOperation', 'v1.1.2.8.14.1')
GO

