

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppAnalyticsNodeOperation.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppAnalyticsNodeOperation
--  | Description:   Creates/ delete entries in DM2SearchServerCodeInfo, DM2Cloud
--  |                and DM2CloudCoreRole tables
--  |
--  |			create solr servers cloud
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppAnalyticsNodeOperation.sp,v $ $Id: AppAnalyticsNodeOperation.sp,v 1.1.4.17.14.1 2021/01/08 20:31:09 pankajkumar Exp $";
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppAnalyticsNodeOperation')
BEGIN
	print '>>> Drop Stored Procedure: AppAnalyticsNodeOperation <<<'
	drop procedure AppAnalyticsNodeOperation
END
IF EXISTS (select * from GxQscripts where name='AppAnalyticsNodeOperation')
	delete from GxQscripts where name = 'AppAnalyticsNodeOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAnalyticsNodeOperation')
	delete from GXDBVersions where aliasname = 'AppAnalyticsNodeOperation'
GO
print '... Creating Procedure: AppAnalyticsNodeOperation'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppAnalyticsNodeOperation
  @i_userID INT,
  @i_inputXml XML   
AS
  DECLARE @o_errorCode integer = 0
  DECLARE @o_errorStr varchar(max) = 'Success'
DECLARE @opType INT = 0
DECLARE @clientId INT = 0
DECLARE @cloudId INT = 0
DECLARE @portNo INT = 0
DECLARE @cloudType INT = 0
DECLARE @commcellId INT = 2
DECLARE @nodeProps NVARCHAR(2048)
DECLARE @clientName NVARCHAR(2048)
DECLARE @indexDir NVARCHAR(2048)
DECLARE @cloudDisplayName NVARCHAR(2048)
DECLARE @jvmMemory INT = 0
DECLARE @installTime int = dbo.GetUnixTime(GETDATE())
DECLARE @cloudName NVARCHAR(1024)
DECLARE @opEvMsgId          INT = 0
DECLARE @dataIsEvent        INT = 0
DECLARE @opMsgId            INT = 0
DECLARE @opId               INT = 0
DECLARE @paramMsgId         INT = 0
/*<App_NodeOperation cloudId="18">
      <nodes opType="1" status="3">
             <nodeClientEntity clientId="2" />
              <nodeMetaInfos name="analytics_datadirectory" value="C:\Program Files\CommVault\AEDataNew" />  <nodeMetaInfos name="analytics_jvmMaxMem" value="4098" />  <nodeMetaInfos name="analytics_startport" value="20000" />  <nodeMetaInfos name="analytics_stopport" value="20010" />
      </nodes>
 </App_NodeOperation>
*/
SET @cloudId = ISNULL (( SELECT ref.value('@cloudId', 'INT')
                              FROM @i_inputXml.nodes ('App_NodeOperation') R(ref)), 0)
SET @cloudType = ISNULL((SELECT cloudType FROM DM2Cloud (NOLOCK) WHERE  cloudId = @cloudId ),0)
If  @cloudType = 0 OR @cloudType NOT IN (1,
5,
6,
9)
BEGIN
	SET @o_errorStr = 'Invalid cloud Type.'
	SET @o_errorCode = 12722 -- INVALID_SERVER_TYPE
	GOTO errorexit
END
If  @cloudType = 6 --HAC Cluster
BEGIN
	EXEC AppValidateHACClusterNode @i_userID, @i_inputXml, @cloudType, @o_errorCode OUTPUT, @o_errorStr OUTPUT
	IF @o_errorCode > 0
	BEGIN
		GOTO errorexit
	END
	EXEC AppHACNodeOperation @i_userID, @i_inputXml, @o_errorCode OUTPUT, @o_errorStr OUTPUT
	GOTO errorexit
END
EXEC AppValidateIndexServerNode @i_userID, @i_inputXml, @cloudType, @o_errorCode OUTPUT, @o_errorStr OUTPUT
IF @o_errorCode > 0
BEGIN
	GOTO errorexit
END
If  @cloudType = 9
BEGIN
	EXEC AppAnalyticsNodePoolOperation @i_userID, @i_inputXml, @o_errorCode OUTPUT, @o_errorStr OUTPUT
	GOTO errorexit
END
--get nodes
DECLARE @nodeOperation TABLE (t_OpType INT, t_clientId INT, t_nodeMetaInfos NVARCHAR(2048), t_portNo INT, t_clientName NVARCHAR(2048), t_JvmMemory INT, t_indexDir NVARCHAR(260))
INSERT INTO @nodeOperation (t_OpType, t_clientId)
SELECT ref.value('@opType', 'INT'), ref.value('nodeClientEntity[1]/@clientId', 'INT')
FROM @i_inputXml.nodes ('App_NodeOperation/nodes') R(ref)
--get node properties
	DECLARE @nodeProperties TABLE (t_clientId INT, t_name NVARCHAR(1024), T_value NVARCHAR(1024))
	INSERT INTO @nodeProperties
	SELECT ref.value('nodeClientEntity[1]/@clientId', 'INT'), ref1.value('@name', 'NVARCHAR(1024)'), ref1.value('@value', 'NVARCHAR(1024)')
	 FROM @i_inputXml.nodes ('App_NodeOperation/nodes') R(ref)
	 CROSS APPLY R.ref.nodes('nodeMetaInfos') as R1(ref1)
--get existing node props XML from DB
DECLARE @nodePropertiesDBXML TABLE (t_clientId INT, t_nodeProps XML)
INSERT INTO @nodePropertiesDBXML (t_clientId, t_nodeProps)
SELECT DISTINCT ClientId, NodeProps
FROM  DM2SearchServerCoreInfo (nolock)
WHERE   cloudId = @cloudId AND  cloudType = @cloudType
--get existing node meta properties from DB
IF EXISTS(SELECT TOP 1 1 FROM @nodePropertiesDBXML)
BEGIN
	DECLARE @nodeNameValueMapDB TABLE (t_clientId INT, t_name NVARCHAR(1024), t_value NVARCHAR(1024))
	INSERT INTO @nodeNameValueMapDB
	SELECT DISTINCT t_clientId, ref1.value('@name', 'NVARCHAR(1024)'), ref1.value('@value', 'NVARCHAR(1024)')
	FROM  @nodePropertiesDBXML N
		CROSS APPLY N.t_nodeProps.nodes('NodeMetaProp/nodeMetaInfos') as R1(ref1)
	WHERE LEN(ref1.value('@value', 'NVARCHAR(1024)')) >0
	--populate missing properties from DB to input information
	INSERT INTO @nodeProperties
	SELECT PB.t_clientId, PB.t_name, PB.t_value
	FROM  @nodeProperties P
	RIGHT JOIN	@nodeNameValueMapDB PB ON P.t_clientId = PB.t_clientId AND P.t_name = PB.t_name
	WHERE P.t_name IS NULL
END
--delete unwanted meta props, does not need to be stored into db, getting fetch dynamically during GUI retrival
DELETE @nodeProperties WHERE t_name IN ('URL', 'WEBSERVER','ISENABLED','ISASSOCIATED')
IF  @cloudType = 1
BEGIN
	--if node level does contains index directory then get index directory from cloud level
	DECLARE @cloudIndexDir NVARCHAR(512) =''
	IF NOT EXISTS (SELECT TOP 1 1 FROM @nodeProperties WHERE t_name = 'INDEXLOCATION')
	BEGIN
		DECLARE @nodeNameValueMap1 TABLE (t_name NVARCHAR(1024), t_value NVARCHAR(1024))
		INSERT INTO @nodeNameValueMap1 (t_name, t_value)
		EXEC APPGetDM2CloudMetaProp @cloudId , 'INDEXLOCATION'
		SET @cloudIndexDir = ISNULL((SELECT TOP 1 t_value FROM @nodeNameValueMap1 WHERE t_name = 'INDEXLOCATION'),'')
	END
	--for standalone mode, index location is stored into DM2SearchServerCoreinfo table
	UPDATE @nodeOperation
	SET t_nodeMetaInfos =(SELECT t_name as '@name', T_value AS '@value'
					FROM @nodeProperties P WHERE P.t_clientId = N.t_clientId FOR XML PATH('nodeMetaInfos'), ROOT('NodeMetaProp')),
	t_portNo = (SELECT  CAST (T_value AS INT) FROM @nodeProperties P WHERE P.t_clientId = N.t_clientId AND P.t_name = 'PORTNO'),
	t_jvmMemory =(SELECT  CAST (T_value AS INT) FROM @nodeProperties P WHERE P.t_clientId = N.t_clientId AND P.t_name = 'JVMMAXMEMORY'),
	t_indexDir = ISNULL((SELECT  T_value  FROM @nodeProperties P WHERE P.t_clientId = N.t_clientId AND P.t_name = 'INDEXLOCATION'), @cloudIndexDir)
	FROM @nodeOperation N
END
ELSE IF @cloudType = 5
BEGIN
	UPDATE @nodeOperation
	SET t_nodeMetaInfos = S.nodeProps,
		t_portNo = S.portno,
		t_jvmMemory =(SELECT  CAST (T_value AS INT) FROM @nodeProperties P WHERE P.t_clientId = N.t_clientId AND P.t_name = 'JVMMAXMEMORY')
	FROM @nodeOperation N
	JOIN DM2SearchServerCoreInfo S (NOLOCK) ON N.t_clientId = S.clientId
WHERE S.cloudType =9
	--for cluster cloud mode, index location is stored into DM2Cloud table
	DECLARE @nodeNameValueMap TABLE (t_name NVARCHAR(1024), t_value NVARCHAR(1024))
	INSERT INTO @nodeNameValueMap (t_name, t_value)
	EXEC APPGetDM2CloudMetaProp @cloudId , 'INDEXLOCATION'
	UPDATE @nodeOperation
	SET t_indexDir = ISNULL((SELECT TOP 1 t_value FROM @nodeNameValueMap WHERE t_name = 'INDEXLOCATION'),'')
END
UPDATE @nodeOperation
SET t_clientName = C.name
FROM APP_Client C (NOLOCK)
WHERE c.ID =t_clientId
-- SET GUI AUDIT OPERATION
SET @opMsgId = (602 | (CAST(POWER(2, 24) AS BIGINT) * 84))
SET @cloudDisplayName = ISNULL((SELECT name FROM DM2Cloud (NOLOCK) WHERE  cloudId = @cloudId ), N'')
--
BEGIN transaction
	DECLARE nodeOperationCur CURSOR FOR
              SELECT t_OpType, t_clientId, t_nodeMetaInfos, t_portNo, t_clientName, t_jvmMemory, t_indexDir
            FROM @nodeOperation
    OPEN nodeOperationCur
    -- Process each SCG configured
    FETCH NEXT FROM nodeOperationCur INTO @opType, @clientId, @nodeProps, @portNo, @clientName, @jvmMemory, @indexDir
    WHILE @@fetch_status = 0
    BEGIN
		IF @opType =  1 --common::OperationType_ADD
		BEGIN
			-- all looks good, create properties
declare @engineType int = (16 | 8)
			DECLARE @coreName nvarchar(1024)
			SET @coreName = 'Cloud_' + CAST(@CloudId as varchar(10)) + '_Client_' + CAST(@ClientId as varchar(10)) + '_Core'
DECLARE @coreRoles INT = 8 | 16
			DECLARE @status INT = ISNULL (( SELECT status FROM DM2SearchServerCoreInfo (NOLOCK) WHERE ClientId = @ClientId AND cloudType= 9), 0)
			--ADD A NEW NODE
			IF NOT EXISTS (SELECT 1 FROM DM2SearchServerCoreInfo (NOLOCK) WHERE CloudId = @CloudId AND ClientId = @ClientId AND cloudType= @cloudType )
			BEGIN
				--Mark first Node as default node for standalone only
IF NOT EXISTS (SELECT 1 FROM DM2SearchServerCoreInfo (NOLOCK) WHERE CloudId = @CloudId AND cloudType= 1 AND coreRoles & 128>0)
SET @coreRoles =  @coreRoles | 128
				INSERT INTO DM2SearchServerCoreInfo
				(
					CoreName, CommCellId, CloudId, ClientId,
					CreateTime,
					SoftState, Enabled,
					Attributes,
					ServiceLink, CoreRoles,
					CollectionSize, FreeSpace, OccupiedSpace,
					Description,
					skippedItems, failedItems, numFiles, numEmails, status, cloudType, portNo, nodeProps, modifiedTime
				)
				VALUES
				(
					@coreName, @CommCellId, @CloudId, @ClientId,
					getutcdate(),
					1, 1,
					0,	'', @coreRoles,
					0, -1, 0,
					'',	0, 0, 0, 0, @status, @cloudType, @portNo, @nodeProps,0
				)
			END
IF @cloudType IN (1,9)
				AND NOT EXISTS (SELECT 1 FROM app_firewalltppm (NOLOCK) WHERE fromEntityId = @ClientId AND toEntityId = @ClientId AND toPortNumber= @portNo)
		            INSERT INTO  app_firewalltppm (tppmType, fromEntityType, fromEntityId, fromPortNumber, toEntityType, toEntityId, toPortNumber, status, tppmParams)
VALUES (8, 3, @clientId, 8700, 3, @clientId, @portNo, 1, '') --Fix for MR:206555
IF @cloudType = 1
			BEGIN
				IF NOT EXISTS (SELECT 1 FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = @clientId AND attrName = N'Analytics_CloudId')
					insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
					values (@ClientId, N'Analytics_CloudId', 1 /*PROPERTY_STRING*/, cast(@CloudId as nvarchar(15)), @installTime, 0, 0)
				IF NOT EXISTS (SELECT 1 FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = @clientId AND attrName = N'AnalyticSearchEngineEnabled')
					insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
					values (@ClientId, N'AnalyticSearchEngineEnabled', 2 /*PROPERTY_BOOLEAN*/, N'1', @installTime, 0, 0)
				IF NOT EXISTS (SELECT 1 FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = @clientId AND attrName = N'Analytics_index-dir')
					insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
					values (@ClientId, N'Analytics_index-dir', 1 /*PROPERTY_STRING*/, @indexDir, @installTime, 0, 0)
				IF NOT EXISTS (SELECT 1 FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = @clientId AND attrName = N'Analytics_Memory_MB')
					insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
					values (@ClientId, N'Analytics_Memory_MB', 7 /*PROPERTY_INTEGER*/, cast(@jvmMemory as nvarchar(10)) , @installTime, 0, 0)
				IF NOT EXISTS (SELECT 1 FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = @clientId AND attrName = N'Analytics_baseport')
					insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
					values (@ClientId, N'Analytics_baseport', 1 /*PROPERTY_STRING*/, cast(@portNo as nvarchar(10)), @installTime, 0, 0)
			END
			IF @cloudType IN (1 ,5)
			BEGIN
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userID, 3 , @clientId, @opEvMsgId OUTPUT, @opId OUTPUT
				-- SET GUI AUDIT PARAMETER
				SELECT @cloudDisplayName =  ISNULL(@cloudDisplayName,''), @clientName = ISNULL(@clientName,''), @jvmMemory = ISNULL(@jvmMemory, 0), @portNo = ISNULL(@portNo, 0), @indexDir = ISNULL(@indexDir, '')
				EXEC EvGuiAuditSetParamData @opId, @clientName, @dataIsEvent
				EXEC EvGuiAuditSetParamData @opId, @cloudDisplayName, @dataIsEvent
				EXEC EvGuiAuditSetParamData @opId, @jvmMemory, @dataIsEvent
				EXEC EvGuiAuditSetParamData @opId, @portNo, @dataIsEvent
				EXEC EvGuiAuditSetParamData @opId, @indexDir, @dataIsEvent
SET @paramMsgId = (1626 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userID
			END
		END
		ELSE IF @opType =  2 --common::OperationType_DELETE
		BEGIN
			--in case of Standalone, set mark another Node as default node, when default node is being deleted
IF @cloudType = 1
			BEGIN
DECLARE @isDefaultNode INT = ISNULL((SELECT TOP 1 1 FROM DM2SearchServerCoreInfo (NOLOCK) WHERE cloudId = @cloudId AND  cloudType = @cloudType AND clientId = @clientId AND coreRoles & 128 >0),0)
IF  @isDefaultNode = 1 AND EXISTS (SELECT 1 FROM DM2SearchServerCoreInfo (NOLOCK) WHERE cloudId = @cloudId AND  cloudType = @cloudType AND  coreRoles & 128 =0)
				BEGIN
					--Mark any other node as Default node
					WITH CTE AS (
					SELECT TOP 1 coreRoles
					FROM  DM2SearchServerCoreInfo
WHERE cloudId = @cloudId AND  cloudType = @cloudType AND coreRoles & 128 = 0
					)
UPDATE CTE SET coreRoles = coreRoles | 128
				END
			END
IF @cloudType IN (1,9)
				DELETE F
				FROM APP_FirewallTppm F
				JOIN DM2SearchServerCoreInfo S ON F.toEntityId = S.clientId AND F.toPortNumber = S.portNo
WHERE F.tppmType = 8 --TPPMType::DYNAMIC_TPPM=8
					AND F.fromEntityId = @clientId
					AND F.toEntityId = @clientId
AND F.toEntityType = 3
					AND S.cloudType = @cloudType
			DELETE DM2SearchServerCoreInfo
			WHERE cloudId = @cloudId AND  cloudType = @cloudType AND clientId = @clientId
			DELETE FROM APP_ClientProp WHERE componentNameId = @clientId AND modified = 0
	       AND ( attrname IN ( N'Analytics_CloudId', N'Analytics_CloudType', N'Analytics_baseport', N'Analytics_hostname', N'Analytics_QPS_URL', N'AnalyticSearchEngineEnabled',  N'AnalyticsEngineType',N'Analytics_index-dir', N'Analytics_Memory_MB',N'Analytics_RolesInfo', N'Analytics_stopPort'))
IF @cloudType IN (1,5)
			BEGIN
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userID, 3 , @clientId, @opEvMsgId OUTPUT, @opId OUTPUT
				-- SET GUI AUDIT PARAMETER
				SELECT @cloudDisplayName =  ISNULL(@cloudDisplayName,''), @clientName = ISNULL(@clientName,''), @jvmMemory = ISNULL(@jvmMemory, 0), @portNo = ISNULL(@portNo, 0), @indexDir = ISNULL(@indexDir, '')
				EXEC EvGuiAuditSetParamData @opId, @clientName, @dataIsEvent
				EXEC EvGuiAuditSetParamData @opId, @cloudDisplayName, @dataIsEvent
				EXEC EvGuiAuditSetParamData @opId, @jvmMemory, @dataIsEvent
				EXEC EvGuiAuditSetParamData @opId, @portNo, @dataIsEvent
				EXEC EvGuiAuditSetParamData @opId, @indexDir, @dataIsEvent
SET @paramMsgId = (1628 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userID
			END
		END
		ELSE IF @opType =  3 --common::OperationType_MODIFY
		BEGIN
			DECLARE @oldPortNo INT = (SELECT portNo FROM DM2SearchServerCoreInfo (NOLOCK) WHERE  cloudId = @cloudId AND  cloudType = @cloudType AND clientId = @clientId)
			UPDATE DM2SearchServerCoreInfo
			SET nodeProps = @nodeProps,
				portNo = @portNo,
				modifiedTime = @installTime
			WHERE cloudId = @cloudId AND  cloudType = @cloudType AND clientId = @clientId
			IF @cloudType = 1
			BEGIN
				UPDATE app_firewalltppm
            	SET toPortNumber = @portNo
WHERE fromEntityId = @clientId AND toEntityId = @clientId AND toPortNumber = @oldPortNo AND tppmType = 8 --TPPMType::DYNAMIC_TPPM=8
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userID, 3 , @clientId, @opEvMsgId OUTPUT, @opId OUTPUT
				-- SET GUI AUDIT PARAMETER
				SELECT @cloudDisplayName =  ISNULL(@cloudDisplayName,''), @clientName = ISNULL(@clientName,''), @jvmMemory = ISNULL(@jvmMemory, 0), @portNo = ISNULL(@portNo, 0), @indexDir = ISNULL(@indexDir, '')
				EXEC EvGuiAuditSetParamData @opId, @clientName, @dataIsEvent
				EXEC EvGuiAuditSetParamData @opId, @cloudDisplayName, @dataIsEvent
				EXEC EvGuiAuditSetParamData @opId, @jvmMemory, @dataIsEvent
				EXEC EvGuiAuditSetParamData @opId, @portNo, @dataIsEvent
				EXEC EvGuiAuditSetParamData @opId, @indexDir, @dataIsEvent
SET @paramMsgId = (1627 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userID
			END
		END
	FETCH NEXT FROM nodeOperationCur INTO @opType, @clientId, @nodeProps, @portNo, @clientName, @jvmMemory, @indexDir
    END
    CLOSE nodeOperationCur
    DEALLOCATE nodeOperationCur
errorexit:
	if @o_errorCode <> 0 begin
		if @@TRANCOUNT > 0 rollback transaction
	end
	else begin
		if @@TRANCOUNT > 0 commit transaction
	end
	select @o_errorCode AS o_errorCode, @o_errorStr AS o_errorStr
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppAnalyticsNodeOperation')
	delete from GxQscripts where name = 'AppAnalyticsNodeOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAnalyticsNodeOperation')
	delete from GXDBVersions where aliasname = 'AppAnalyticsNodeOperation'
GO

insert into GXDBVersions values(2, 'AppAnalyticsNodeOperation',  'v1.1.4.17.14.1', 'AppAnalyticsNodeOperation', 'v1.1.4.17.14.1')
GO

