

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppAnalyticsGetFlatNodeInfos.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppAnalyticsGetFlatNodeInfos
--  | Description:   Retrieves the flattened view of all index server, indexserver pool information including roles, pseudoclient information
--  |
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppAnalyticsGetFlatNodeInfos.sp,v $ $Id: AppAnalyticsGetFlatNodeInfos.sp,v 1.1.2.5 2020/08/24 15:18:03 sjohnson Exp $";
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppAnalyticsGetFlatNodeInfos')
BEGIN
	print '>>> Drop Stored Procedure: AppAnalyticsGetFlatNodeInfos <<<'
	drop procedure AppAnalyticsGetFlatNodeInfos
END
IF EXISTS (select * from GxQscripts where name='AppAnalyticsGetFlatNodeInfos')
	delete from GxQscripts where name = 'AppAnalyticsGetFlatNodeInfos'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAnalyticsGetFlatNodeInfos')
	delete from GXDBVersions where aliasname = 'AppAnalyticsGetFlatNodeInfos'
GO
print '... Creating Procedure: AppAnalyticsGetFlatNodeInfos'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppAnalyticsGetFlatNodeInfos
  @i_status INT = 1
AS
BEGIN
	/*
		This SP is similar to DM2GetAllAnalyticsEngine with addtional information.
		Its mainly used for caching the flattened table
	*/
  DECLARE @CloudId INT
  DECLARE @CloudName NVARCHAR(256)
  DECLARE @CloudServerType INT
  DECLARE @IndexServerClientId INT
  DECLARE @InternalCloudName NVARCHAR(256)
  DECLARE @BaseUrl NVARCHAR(512)
  DECLARE @NodeClientId INT
  DECLARE @NodeClientName NVARCHAR(256)
  DECLARE @NodeHostName NVARCHAR(256)
  DECLARE @NodeBasePort INT   	
  DECLARE @IndexServerPoolClientId INT
  DECLARE @RolesInfo VARCHAR(256)
  DECLARE @NodeManagledName NVARCHAR(1024)
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL
		DROP TABLE #getIndexServers
	CREATE TABLE #getIndexServers
	(
			CloudId INT,
			CloudName  NVARCHAR(256),
			CloudServerType INT,
			IndexServerClientId INT,
			InternalCloudName NVARCHAR(256),
			BaseUrl NVARCHAR(512),
			NodeClientId INT,
			NodeClientName NVARCHAR(256),
			NodeHostName NVARCHAR(256),
			NodeBasePort INT,
			IndexServerPoolClientId INT,
			RolesInfo VARCHAR(256),
			NodeStatus INT,
			CloudStatus INT,
			NodeManagledName NVARCHAR(1024) --ClientHostName + "*" + ClientName + "*" + ClientCvdPort + "*" + ClientEvmgrcPort
	)
	INSERT INTO #getIndexServers (
		CloudId, CloudServerType, IndexServerClientId, InternalCloudName,
		BaseUrl, NodeClientId, NodeClientName,
		NodeHostName, NodeBasePort,  IndexServerPoolClientId,
		RolesInfo, NodeStatus, CloudStatus,NodeManagledName)
	SELECT C.cloudId, C.cloudType, C.pseudoClientId, C.name,
		'http://'+ CL.net_hostname + ':' + CAST (S.Portno AS nvarchar(20)), S.ClientId, CL.name,
		CL.net_hostname, S.portNo,   C.indexServerPoolClientId,
		RoleInfos = ISNULL(STUFF((SELECT ',' + CONVERT(VARCHAR(8),CR.roleId)
						FROM DM2CloudCoreRole CR WHERE CR.cloudId = C.cloudId AND (@i_status = 0 OR CR.Status = @i_status)
						FOR XML PATH('')
						),1,1,''), ''),
		S.status, C.status,
		CL.net_hostname + '*'+ CL.name + '*' + CAST(CL.cvdPort AS VARCHAR(10)) + '*' + CAST(CL.evmgrcPort AS VARCHAR(10))
	FROM  DM2Cloud C (NOLOCK)
		JOIN DM2SearchServerCoreInfo S (NOLOCK) ON S.CloudId = C.cloudId
			AND (@i_status = 0 OR (S.Status = @i_status AND C.Status = @i_status))
			AND S.CloudType IN (1,4,5,9)
		JOIN APP_Client CL (NOLOCK) ON S.ClientId = CL.id
	UPDATE #getIndexServers
	SET CloudName = CL.name
	FROM APP_Client CL (NOLOCK)
	WHERE #getIndexServers.indexServerClientId = CL.id
	SELECT * FROM #getIndexServers
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppAnalyticsGetFlatNodeInfos')
	delete from GxQscripts where name = 'AppAnalyticsGetFlatNodeInfos'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAnalyticsGetFlatNodeInfos')
	delete from GXDBVersions where aliasname = 'AppAnalyticsGetFlatNodeInfos'
GO

insert into GXDBVersions values(2, 'AppAnalyticsGetFlatNodeInfos',  '00010001000200050000', 'AppAnalyticsGetFlatNodeInfos', '00010001000200050000')
GO

