

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppAnalyticsGetBackupCollectionInfo.sp] ---------- 

--  +========================================================================+
--  | Name:          AppAnalyticsGetBackupCollectionInfo
--  | Description:   retrieves the collection information and node information for the input cloudId and role information
--  |
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppAnalyticsGetBackupCollectionInfo.sp,v $ $Id: AppAnalyticsGetBackupCollectionInfo.sp,v 1.1.2.9 2020/08/07 22:14:06 smukherjee Exp $";
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppAnalyticsGetBackupCollectionInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppAnalyticsGetBackupCollectionInfo <<<'
	drop procedure AppAnalyticsGetBackupCollectionInfo
END
IF EXISTS (select * from GxQscripts where name='AppAnalyticsGetBackupCollectionInfo')
	delete from GxQscripts where name = 'AppAnalyticsGetBackupCollectionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAnalyticsGetBackupCollectionInfo')
	delete from GXDBVersions where aliasname = 'AppAnalyticsGetBackupCollectionInfo'
GO
print '... Creating Procedure: AppAnalyticsGetBackupCollectionInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppAnalyticsGetBackupCollectionInfo
  @i_xml XML
AS
BEGIN
  DECLARE @o_xmlText XML;
	/*
		Summary:
			This SP retrieves the collection information and node information for the input cloudId and role information
		Samples:
			Request:
				<App_SolrBackUpRequest indexServerClientId="12" cloudId="0" roleName="Exchange Index" />
			Response:
					<App_SolrBackUpResponse>
						<nodesList nodeName="abcd.com:2303_solr" baseUrl="http://abcd:2303" clientId="123" clientName="abcd" />
						<nodesList nodeName="defg.com:2803_solr" baseUrl="http://defg:2803" clientId="456" clientName="defg" />
						<metadataCollections collectionName="metadata_idx_abcd" />
						<metadataCollections collectionName="metaidx_idx_1232" />
						<dataCollections collectionName="UserMBx_123" />
						<dataCollections collectionName="JuournlaMBx_123" />
						<genericResp errorCode="0" />
					</App_SolrBackUpResponse>
	*/
	DECLARE @o_errorCode INT = 0,
			@o_errorMsg VARCHAR(512)
	DECLARE  @l_cloudId INT = 0,
			 @l_roleName VARCHAR(256) = '',
			 @l_roleId	INT = 0,
			 @l_indexserverClientId INT = 0
	SELECT	@l_cloudId = ISNULL (ref.value('@cloudId', 'INT'),0),
			@l_roleName = ISNULL (ref.value('@roleName', 'VARCHAR(256)'),''),
			@l_roleId = ISNULL (ref.value('@roleId', 'INT'),0),
			@l_indexserverClientId = ISNULL (ref.value('@indexServerClientId', 'INT'),0)
	FROM @i_xml.nodes ('App_SolrBackUpRequest') R(ref)
	IF( @l_roleName = '' AND @l_roleId > 0)
		SELECT @l_roleName = M.roleType FROM DM2CloudRoleMaster AS M WHERE M.roleId = @l_roleId
	IF @l_cloudId = 0 AND @l_indexserverClientId > 0
		SELECT @l_cloudId = C.cloudId FROM DM2Cloud AS C WHERE C.pseudoClientId = @l_indexserverClientId
	--Create temp table for index server fetch
	--
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL
		DROP TABLE #getIndexServers
	CREATE TABLE #getIndexServers
		(     serverURL NVARCHAR(512),
				clientId INT,
				clientName NVARCHAR(256),
				cloudId INT,
				hostName NVARCHAR(256),
				basePort INT,
				engineName  NVARCHAR(256),
				serverType INT,
				indexServerClientId INT,
				internalCloudName NVARCHAR(256)
		)
    --Create temp table to fetch collectioninformation
	--
	IF OBJECT_ID('tempdb.dbo.#getCollectionInfoOutTbl') IS NOT NULL
		DROP TABLE #getCollectionInfoOutTbl
	CREATE TABLE #getCollectionInfoOutTbl
	(
        DatasourceId INT,
		CloudId INT,
		CollectionName VARCHAR(128),
		SourceType VARCHAR(30),
		SubsourceType VARCHAR(30),
		IdxServerClientId INT
	)
	--Create temp table to fetch federated DS
	--
	IF OBJECT_ID('tempdb.dbo.#getDataSourceWithFederatedDS') IS NOT NULL
		DROP TABLE #getDataSourceWithFederatedDS
	CREATE TABLE #getDataSourceWithFederatedDS
	(
        DatasourceId INT,
		CoreName VARCHAR(128),
		FederatedDSId INT,
		CollectionName VARCHAR(128),
		CloudId INT,
		IdxServerClientId INT,
		SourceType VARCHAR(30),
		SubsourceType VARCHAR(30)
	)
	--Create temp table to keep static collection info
	IF OBJECT_ID('tempdb.dbo.#getStaticCollectionInfoOutTbl') IS NOT NULL
		DROP TABLE #getStaticCollectionInfoOutTbl
	CREATE TABLE #getStaticCollectionInfoOutTbl
	(
        DatasourceId INT,
		CloudId INT,
		CoreName VARCHAR(128),
		SourceType VARCHAR(30),
		SubsourceType VARCHAR(30),
		IdxServerClientId INT
	)
	IF(@l_cloudId <= 0 OR NOT EXISTs (SELECT TOP 1 1 FROM DM2Cloud WHERE cloudId = @l_cloudId))
	BEGIN
		SELECT @o_errorCode = 1, @o_errorMsg = 'Input requires valid cloudID'
	END
	ELSE IF (@l_roleName = '')
	BEGIN
		SELECT @o_errorCode = 2, @o_errorMsg = 'Input requires valid roleInformation'
	END
	ELSE
	BEGIN
			DECLARE @l_multinodeFederatedID INT = (select PropertyId from SEProperty where PropertyGuid = 'B2A95D3F-73F1-42DB-8419-382C2241ABAC')
			IF OBJECT_ID('tempdb.dbo.#tempFederatedDSTbl') IS NOT NULL
				DROP TABLE #tempFederatedDSTbl
			CREATE TABLE #tempFederatedDSTbl
			(
				DataSourceId INT
			)
			INSERT INTO #tempFederatedDSTbl (DataSourceId)
				SELECT DataSourceId from SEDataSourceProperty where PropertyId = @l_multinodeFederatedID
			INSERT INTO #tempFederatedDSTbl (DataSourceId)
				SELECT PropertyValue from SEDataSourceProperty where PropertyId = @l_multinodeFederatedID
			--Fetch index servers
			--
			EXEC DM2GetIndexServers @i_cloudId = @l_cloudId
			--Fetch collection based on the input role information
			--
			EXEC AppGetCloudCollectionInfo @l_cloudId, @i_shouldSelectOutput=0, @i_propertyName1 = 'roletypename', @i_propertyValue1 = @l_roleName,@i_flattenCvNode = 1
			--INCLUDE Federated DS here for CvCloud
				INSERT INTO #getDataSourceWithFederatedDS(FederatedDSId,DatasourceId,CloudId,IdxServerClientId,CoreName,CollectionName,SourceType,SubsourceType)
					select SER.FederatedDataSourceId,TEMP.DatasourceId,TEMP.CloudId,TEMP.IdxServerClientId,TEMP.CollectionName,SEC.CoreName,TEMP.SourceType,TEMP.SubsourceType
				from #getCollectionInfoOutTbl TEMP
				INNER JOIN SEDataSourceRoute SER  ON TEMP.DataSourceId = SER.DataSourceId
				INNER JOIN DM2SearchServerCoreInfo SCI  ON SCI.CloudId = TEMP.CloudID AND SCI.ClientId = TEMP.IdxServerClientId
				INNER JOIN APP_Client CL  ON CL.id = SCI.ClientId
				LEFT JOIN SEDataSource SED on SED.DataSourceId = SER.FederatedDataSourceId
				INNER JOIN SECollectionInfo SEC on SED.CoreId = SEC.CoreId
				WHERE  SCI.CloudType IN (1,4,5) AND TEMP.CloudID = @l_cloudId
				--DELETE entries from #getCollectionInfoOutTbl to avoid duplicates further (all cores with routes gets deleted)
				IF EXISTS (SELECT 1 from #getDataSourceWithFederatedDS)
				BEGIN
					DELETE CI from #getCollectionInfoOutTbl CI INNER JOIN #getDataSourceWithFederatedDS FDS on FDS.DatasourceId = CI.DatasourceId
				END
			--Fetch default cores for the input role
				INSERT INTO #getStaticCollectionInfoOutTbl(CloudId,CoreName,IdxServerClientId,SourceType,SubsourceType)
				SELECT @l_cloudId,coreName,indexServerClientId,NULL,NULL from dbo.GetAnalyticsStaticCores(@l_roleName,@l_cloudId)
				INSERT INTO #getDataSourceWithFederatedDS(FederatedDSId,DatasourceId,CloudId,IdxServerClientId,CoreName,CollectionName,SourceType,SubsourceType)
				select null,CI.DatasourceId,CI.CloudId ,IdxServerClientId,CollectionName,CollectionName,SourceType,SubsourceType from #getCollectionInfoOutTbl CI
				MERGE #getDataSourceWithFederatedDS A
				USING #getStaticCollectionInfoOutTbl B
				ON(A.coreName = B.CoreName)
				WHEN NOT MATCHED THEN
				INSERT (FederatedDSId,DatasourceId,CloudId,IdxServerClientId,CoreName,CollectionName,SourceType,SubsourceType)
				VALUES (null,null,@l_cloudId,B.IdxServerClientId,B.CoreName,B.CoreName,B.SourceType,B.SubsourceType);
			--DELETE all entries now
			IF EXISTS (SELECT 1 from #getDataSourceWithFederatedDS)
				BEGIN
					DELETE CI from #getCollectionInfoOutTbl CI
					--Get rid of Federated DS
					DELETE FDS from #getDataSourceWithFederatedDS FDS INNER JOIN #tempFederatedDSTbl TFDS on TFDS.DatasourceId = FDS.DatasourceId
				END
			IF OBJECT_ID('tempdb.dbo.#tempFederatedDSTbl') IS NOT NULL
	            DROP TABLE #tempFederatedDSTbl
	END
SET @o_xmlText = ISNULL((
		SELECT
		(
			SELECT clientId '@clientId',
				LOWER(hostName + ':' + CONVERT(VARCHAR(8),baseport) + '_solr') '@nodeName',
				clientName '@clientName',
				serverURL '@baseUrl'
			FROM #getIndexServers
			FOR XML PATH('nodesList'), TYPE
		),
		(
			SELECT CI.CollectionName '@collectionName', CI.corename '@coreName',
			coalesce(case when len(IDS.clientName)>0 then IDS.clientName else null end,'') '@nodeName',
			coalesce(case when len(IDS.serverURL)>0 then concat(IDS.serverURL , '/solr') else null end,'') '@nodeUrl'
			FROM #getDataSourceWithFederatedDS AS CI LEFT Join #getIndexServers AS IDS on CI.IdxServerClientId=IDS.clientId
			WHERE  CI.SubsourceType = 'metainfo'
			FOR XML PATH('metadataCollections'), TYPE
		),
		(
			SELECT CI.CollectionName '@collectionName', CI.corename '@coreName',
			coalesce(case when len(IDS.clientName)>0 then IDS.clientName else null end,'') '@nodeName',
			coalesce(case when len(IDS.serverURL)>0 then concat(IDS.serverURL , '/solr') else null end,'') '@nodeUrl'
			FROM #getDataSourceWithFederatedDS AS CI LEFT Join #getIndexServers AS IDS on CI.IdxServerClientId=IDS.clientId
			WHERE CI.SubsourceType IS NULL OR CI.SubsourceType != 'metainfo' --IF subsourcetype is null then treat it as data core?
			FOR XML PATH('dataCollections'), TYPE
		),
		(
			SELECT @o_errorCode '@errorCode',
					@o_errorMsg '@errorMessage'
			FOR XML PATH('genericResp'),TYPE
		)
	FOR XML PATH(''), ROOT('App_SolrBackUpResponse')
	), '<App_SolrBackUpResponse/>')
SELECT @o_xmlText AS [o_xmlText]
	--drop temp tables
	IF OBJECT_ID('tempdb.dbo.#getCollectionInfoOutTbl') IS NOT NULL
		DROP TABLE #getCollectionInfoOutTbl
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL
		DROP TABLE #getIndexServers
	IF OBJECT_ID('tempdb.dbo.#getDataSourceWithFederatedDS') IS NOT NULL
		DROP TABLE #getDataSourceWithFederatedDS
	IF OBJECT_ID('tempdb.dbo.#getStaticCollectionInfoOutTbl') IS NOT NULL
		DROP TABLE #getStaticCollectionInfoOutTbl
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppAnalyticsGetBackupCollectionInfo')
	delete from GxQscripts where name = 'AppAnalyticsGetBackupCollectionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAnalyticsGetBackupCollectionInfo')
	delete from GXDBVersions where aliasname = 'AppAnalyticsGetBackupCollectionInfo'
GO

insert into GXDBVersions values(2, 'AppAnalyticsGetBackupCollectionInfo',  '00010001000200090000', 'AppAnalyticsGetBackupCollectionInfo', '00010001000200090000')
GO

