

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppAnalyticsCloudPoolOperation.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppAnalyticsCloudPoolOperation
--  | Description:   Creates/ delete entries in  DM2Cloud table
--  |
--  |			create analytics servers cloud
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppAnalyticsCloudPoolOperation.sp,v $ $Id: AppAnalyticsCloudPoolOperation.sp,v 1.1.2.4 2018/03/27 09:11:01 jiechen Exp $";
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppAnalyticsCloudPoolOperation <<<'

IF EXISTS (select * from sysobjects where name='AppAnalyticsCloudPoolOperation')
	drop procedure AppAnalyticsCloudPoolOperation
IF EXISTS (select * from GxQscripts where name='AppAnalyticsCloudPoolOperation')
	delete from GxQscripts where name = 'AppAnalyticsCloudPoolOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAnalyticsCloudPoolOperation')
	delete from GXDBVersions where aliasname = 'AppAnalyticsCloudPoolOperation'
GO
print '... Creating Procedure: AppAnalyticsCloudPoolOperation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppAnalyticsCloudPoolOperation
  @i_userID INT,
  @i_inputXml XML,  
  @i_pseudoClientId INT,
  @o_cloudId INT OUTPUT,
  @o_cloudName varchar(512) OUTPUT,
  @o_cloudDisplayName varchar(512) OUTPUT,
  @o_errorCode INT OUTPUT,
  @o_errorStr varchar(512) OUTPUT
AS
  DECLARE @o_indexServerPoolName nvarchar(256) = N''
SET  @o_cloudId = 0
SET  @o_cloudName = ''
SET  @o_cloudDisplayName = ''
SET @o_errorCode = 0
SET @o_errorStr = 'Success'
DECLARE @cloudId INT
DECLARE @indexServerPoolName nvarchar(256) = N''
DECLARE @indexServerPoolDisplayName nvarchar(256) = N''
DECLARE @cloudType INT = 0
DECLARE @commcellId INT = 2
DECLARE @cloudProps NVARCHAR(1024)
DECLARE @opType INT = 0
DECLARE @status INT = 0
DECLARE @zookeeperCloudId INT = 0
declare @installTime int = dbo.GetUnixTime(GETDATE())
DECLARE @opEvMsgId          INT = 0
DECLARE @dataIsEvent        INT = 0
DECLARE @opMsgId            INT = 0
DECLARE @opId               INT = 0
DECLARE @paramMsgId         INT = 0
DECLARE @pseudoClientId		INT = 0
/*
<App_CloudInfo opType="1" type="4">  <cloudNodes opType="1">  <nodeClientEntity clientId="4" />
 <nodeMetaInfos name="INDEXLOCATION" value="C:\Program Files\CommVault\AEDataNew" />
  <nodeMetaInfos name="analytics_jvmMaxMem" value="4098" />
   <nodeMetaInfos name="PORTNO" value="20000" />
     <nodeMetaInfos name="analytics_stopport" value="20010" />
	   </cloudNodes>  <solrCloudInfo>  <roles roleId="2" operationType="1" /> o
	    </solrCloudInfo>  <cloudInfoEntity indexServerPoolName="firstCloud" indexServerPoolDisplayName="firstCloud" />
		 </App_CloudInfo>
*/
SET @opType = ISNULL (( SELECT ref.value('@opType', 'INT')
                              FROM @i_inputXml.nodes ('App_CloudInfo') R(ref)), 0)
SET @cloudType = ISNULL (( SELECT ref.value('@type', 'INT')
                              FROM @i_inputXml.nodes ('App_CloudInfo') R(ref)), 0)
SET @status = ISNULL (( SELECT ref.value('@status', 'INT')
                              FROM @i_inputXml.nodes ('App_CloudInfo') R(ref)), 3)  --pending
SET @cloudId = ISNULL (( SELECT ref.value('@cloudId', 'INT')
                              FROM @i_inputXml.nodes ('App_CloudInfo/cloudInfoEntity') R(ref)), 0)
SET @indexServerPoolDisplayName = ISNULL (( SELECT ref.value('@cloudDisplayName', 'NVARCHAR(1024)')
                              FROM @i_inputXml.nodes ('App_CloudInfo/cloudInfoEntity') R(ref)), N'')
SET @indexServerPoolName =ISNULL (( SELECT ref.value('@cloudName', 'NVARCHAR(1024)')
                              FROM @i_inputXml.nodes ('App_CloudInfo/cloudInfoEntity') R(ref)), N'')
SET @cloudProps =ISNULL((SELECT ref.value('@name', 'NVARCHAR(1024)') as '@name', ref.value('@value', 'NVARCHAR(2048)') AS '@value'
					FROM @i_inputXml.nodes ('App_CloudInfo/cloudMetaInfos') R(ref) FOR XML PATH('cloudMetaInfos'), ROOT('CloudMetaProp')) ,N'')
SET @zookeeperCloudId = ISNULL (( SELECT ref.value('@clientGroupId', 'INT')
                              FROM @i_inputXml.nodes ('App_CloudInfo/solrCloudPoolInfo/zookerEntity') R(ref)), 0)
-- SET GUI AUDIT OPERATION
SET @opMsgId = (603 | (CAST(POWER(2, 24) AS BIGINT) * 84))
BEGIN TRY
BEGIN TRAN
	--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	IF @opType = 1 --common::OperationType_ADD
	BEGIN
		INSERT INTO DM2CLOUD (commcellId, Name,  description, flags, createTime, cloudType, cloudProps, zookeeperCloudId, displayName, attribute, modifiedTime, status, pseudoClientId, indexServerPoolClientId )
		VALUES (@commcellId, @indexServerPoolName,'', 1, @installTime, @cloudType, @cloudProps, @zookeeperCloudId, @indexServerPoolDisplayName, 0, 0, @status, @i_pseudoClientId, 0)
		SET @o_cloudId = ISNULL((SELECT cloudId FROM DM2CLOUD WHERE displayName = @indexServerPoolDisplayName),0)
		SET  @o_errorCode = @@ERROR
		IF @o_errorCode <> 0 OR @o_cloudId = 0
		BEGIN
			SET @o_errorStr = 'Failed to create index server pool.'
			SET @o_errorCode = 12701; --CLOUD_CREATION_FAILED
			GOTO errorexit
		END
		DECLARE @HACClusterName NVARCHAR(1024) = ISNULL((SELECT name FROM APP_Client (NOLOCK) WHERE id=@zookeeperCloudId),N'')
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userID, 3 , @i_pseudoClientId, @opEvMsgId OUTPUT, @opId OUTPUT
		-- SET GUI AUDIT PARAMETER
		EXEC EvGuiAuditSetParamData @opId, @indexServerPoolDisplayName, @dataIsEvent
		EXEC EvGuiAuditSetParamData @opId, @HACClusterName, @dataIsEvent
SET @paramMsgId = (1629 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userID
	END
	ELSE IF @opType =  2 --common::OperationType_DELETE
	BEGIN
		--DELETE firewall entries when index server pool is deleted
		DELETE F
		FROM app_firewalltppm F
		JOIN DM2SearchServerCoreInfo S (NOLOCK)  ON F.fromEntityId = S.ClientId AND  F.toEntityId = S.ClientId
		WHERE S.cloudId = @cloudId AND S.cloudType = 9
		--DELETE ASSOCIATED INDEX SERVER POOL NODES
		DELETE FROM DM2SearchServerCoreInfo WHERE cloudId = @cloudId AND cloudType = 9
		--DELETE ASSOCIATED INDEX SERVER POOL
		DELETE FROM DM2Cloud WHERE cloudId = @cloudId  AND cloudType = 9
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userID, 3 , @pseudoClientId, @opEvMsgId OUTPUT, @opId OUTPUT
		-- SET GUI AUDIT PARAMETER
		EXEC EvGuiAuditSetParamData @opId, @indexServerPoolDisplayName, @dataIsEvent
SET @paramMsgId = (1630 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userID
		--update output cloudId
		SET @o_cloudId = @cloudId
	END
	ELSE IF @opType =  3 --common::OperationType_MODIFY
	BEGIN
		UPDATE DM2Cloud
		SET cloudProps = @cloudProps,
			modifiedTime = @installTime
		WHERE cloudId = @cloudId AND cloudProps != @cloudProps AND LEN(@cloudProps) >0
		--update output cloudId
		SET @o_cloudId = @cloudId
	END
	--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	COMMIT TRAN
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
	-- Call procedure to get error information.
	EXECUTE dbo.GetError @o_errorStr OUTPUT , @o_errorCode OUTPUT
	-- Rollback any active or uncommittable transactions before
	-- inserting information in the ErrorLog
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRANSACTION;
	END
END CATCH;
errorexit:
	-- Rollback any active or uncommittable transactions before
	-- inserting information in the ErrorLog
	IF XACT_STATE() <> 0 AND @o_errorCode != 0
	BEGIN
		ROLLBACK TRANSACTION;
	END
--OUTPUT
SET  @o_cloudName = @o_indexServerPoolName
SET  @o_cloudDisplayName = @o_indexServerPoolName
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppAnalyticsCloudPoolOperation')
	delete from GxQscripts where name = 'AppAnalyticsCloudPoolOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAnalyticsCloudPoolOperation')
	delete from GXDBVersions where aliasname = 'AppAnalyticsCloudPoolOperation'
GO

insert into GXDBVersions values(2, 'AppAnalyticsCloudPoolOperation',  '00010001000200040000', 'AppAnalyticsCloudPoolOperation', '00010001000200040000')
GO

