

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppAnalyticsCloudOperation.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppAnalyticsCloudOperation
--  | Description:   Creates/ delete entries in  DM2Cloud table
--  |
--  |			create analytics servers cloud
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppAnalyticsCloudOperation.sp,v $ $Id: AppAnalyticsCloudOperation.sp,v 1.1.4.17.20.3 2021/02/04 08:35:08 pankajkumar Exp $";
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppAnalyticsCloudOperation')
BEGIN
	print '>>> Drop Stored Procedure: AppAnalyticsCloudOperation <<<'
	drop procedure AppAnalyticsCloudOperation
END
IF EXISTS (select * from GxQscripts where name='AppAnalyticsCloudOperation')
	delete from GxQscripts where name = 'AppAnalyticsCloudOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAnalyticsCloudOperation')
	delete from GXDBVersions where aliasname = 'AppAnalyticsCloudOperation'
GO
print '... Creating Procedure: AppAnalyticsCloudOperation'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppAnalyticsCloudOperation
  @i_userID INT,
  @i_inputXml XML   
AS
  DECLARE @o_cloudId integer = 0
  DECLARE @o_cloudName nvarchar(256) = N''
  DECLARE @o_cloudDisplayName nvarchar(256) = N''
  DECLARE @o_errorCode integer = 0
  DECLARE @o_errorStr varchar(512) = 'Success'
DECLARE @cloudId INT
DECLARE @cloudName nvarchar(256) = N''
DECLARE @cloudDisplayName nvarchar(256) = N''
DECLARE @clientId INT = 0
DECLARE @cloudType INT = 0
DECLARE @commcellId INT = 2
DECLARE @cloudProps NVARCHAR(1024)
DECLARE @opType INT = 0
DECLARE @status INT = 0
declare @installTime int = dbo.GetUnixTime(GETDATE())
DECLARE @opEvMsgId          INT = 0
DECLARE @dataIsEvent        INT = 0
DECLARE @opMsgId            INT = 0
DECLARE @opId               INT = 0
DECLARE @paramMsgId         INT = 0
DECLARE @pseudoClientId		INT = 0
DECLARE @indexServerPoolId	INT = 0
DECLARE @appId INT=0
DECLARE @planId INT=0
/*
<App_CloudInfo opType="1" type="4">  <cloudNodes opType="1">  <nodeClientEntity clientId="4" />
 <nodeMetaInfos name="INDEXLOCATION" value="C:\Program Files\CommVault\AEDataNew" />
  <nodeMetaInfos name="analytics_jvmMaxMem" value="4098" />
   <nodeMetaInfos name="PORTNO" value="20000" />
     <nodeMetaInfos name="analytics_stopport" value="20010" />
	   </cloudNodes>  <solrCloudInfo>  <roles roleId="2" operationType="1" />
	    </solrCloudInfo>  <cloudInfoEntity cloudName="firstCloud" cloudDisplayName="firstCloud" />
		 </App_CloudInfo>
*/
SET @cloudType = ISNULL (( SELECT ref.value('@type', 'INT')
                              FROM @i_inputXml.nodes ('App_CloudInfo') R(ref)), 0)
If  @cloudType = 0 OR @cloudType NOT IN (1,
5,
6,
9)
BEGIN
	SET @o_errorStr = 'Invalid cloud Type.'
	SET @o_errorCode = 12722 -- INVALID_SERVER_TYPE
	GOTO errorexit
END
EXEC AppValidateIndexServer @i_userID, @i_inputXml, @cloudType, @pseudoClientId OUTPUT, @o_errorCode OUTPUT, @o_errorStr OUTPUT
IF @o_errorCode > 0
BEGIN
	GOTO errorexit
END
IF @cloudType = 9
BEGIN
	EXEC AppAnalyticsCloudPoolOperation @i_userID, @i_inputXml, @pseudoClientId, @o_cloudId OUTPUT, @o_cloudName OUTPUT,@o_cloudDisplayName OUTPUT, @o_errorCode OUTPUT, @o_errorStr OUTPUT
	GOTO errorexit
END
IF @cloudType = 6
BEGIN
	EXEC AppHACCloudOperation @i_userID, @i_inputXml, @pseudoClientId, @o_cloudId OUTPUT, @o_cloudName OUTPUT,@o_cloudDisplayName OUTPUT, @o_errorCode OUTPUT, @o_errorStr OUTPUT
	GOTO errorexit
END
SET @opType = ISNULL (( SELECT ref.value('@opType', 'INT')
                              FROM @i_inputXml.nodes ('App_CloudInfo') R(ref)), 0)
SET @status = ISNULL (( SELECT ref.value('@status', 'INT')
                              FROM @i_inputXml.nodes ('App_CloudInfo') R(ref)), 3)  --pending
SET @cloudId = ISNULL (( SELECT ref.value('@cloudId', 'INT')
                              FROM @i_inputXml.nodes ('App_CloudInfo/cloudInfoEntity') R(ref)), 0)
SET @cloudDisplayName = ISNULL (( SELECT ref.value('@cloudDisplayName', 'NVARCHAR(1024)')
                              FROM @i_inputXml.nodes ('App_CloudInfo/cloudInfoEntity') R(ref)), N'')
SET @cloudName = ISNULL (( SELECT ref.value('@cloudName', 'NVARCHAR(1024)')
                              FROM @i_inputXml.nodes ('App_CloudInfo/cloudInfoEntity') R(ref)), N'')
SET @cloudProps =ISNULL((SELECT ref.value('@name', 'NVARCHAR(1024)') as '@name', ref.value('@value', 'NVARCHAR(2048)') AS '@value'
					FROM @i_inputXml.nodes ('App_CloudInfo/cloudMetaInfos') R(ref) FOR XML PATH('cloudMetaInfos'), ROOT('CloudMetaProp')) ,N'')
SET @indexServerPoolId = ISNULL (( SELECT ref.value('@cloudId', 'INT')
                              FROM @i_inputXml.nodes ('App_CloudInfo/solrCloudInfo/cloudPoolInfo') R(ref)), 0)
SET @planId = ISNULL (( SELECT ref.value('@planId', 'INT')
                              FROM @i_inputXml.nodes ('App_CloudInfo/planInfo') R(ref)), 0)
-- SET GUI AUDIT OPERATION
SET @opMsgId = (601 | (CAST(POWER(2, 24) AS BIGINT) * 84))
BEGIN TRY
BEGIN TRAN
	--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	IF @opType = 1 --common::OperationType_ADD
	BEGIN
		--Handle cloudId conflicts with search engine and index server
		--check if new index server cloudId is already occupied by search engine
			--yes, insert index server entries and then delete it and reinsert it, so that cloudId will be different for index server.
			--no, insert index server entries
		--retries max count =5
		--append pseudoclientd to clientid to make it unique
		SET @cloudName = @cloudName + CAST(@pseudoClientId AS VARCHAR(32))
		DECLARE @count INT = 0
		DECLARE @isSuccess BIT = 0
		WHILE @count < 5 AND @isSuccess = 0
		BEGIN
			INSERT INTO DM2Cloud (commcellId, Name,  description, flags, createTime, cloudType, cloudProps, zookeeperCloudId, displayName, attribute, modifiedTime, status, pseudoClientId, indexServerPoolClientId )
			VALUES (@commcellId, @cloudName,'', 1, @installTime, @cloudType, @cloudProps, 0, @cloudDisplayName, 0, 0, @status, @pseudoClientId, @indexServerPoolId)
			SET @o_cloudId = SCOPE_IDENTITY()
IF @o_cloudId IN (SELECT id FROM APP_ComponentProp (NOLOCK) WHERE componenttype = 1 AND propertyTypeId =1)
				DELETE FROM DM2Cloud WHERE cloudId = @o_cloudId
			ELSE
				SET @isSuccess = 1
			SET @count = @count +1
		END
		SET  @o_errorCode = @@ERROR
		IF @o_errorCode <> 0 OR @o_cloudId = 0
		BEGIN
			SET @o_errorStr = 'Failed to create anlaytics cloud.'
			SET @o_errorCode = 12701; --CLOUD_CREATION_FAILED
			GOTO errorexit
		END
		IF @cloudType IN (1,5)
		BEGIN
			--Associate to schedule
			IF @planId != 0
				EXEC AppIndexServerBackupSchedule @pseudoClientId
			DECLARE @IdxSvrPoolName NVARCHAR(1024) = ISNULL((SELECT name FROM APP_Client (NOLOCK) WHERE id=@indexServerPoolId),N'')
			DECLARE @cloudMode NVARCHAR(1024) = (CASE WHEN @cloudType =  1 THEN 'NonCloud'
													 WHEN @cloudType =  4 THEN 'Embedded'
													 WHEN @cloudType =  5 THEN 'Cluster'
													 ELSE ''
													 END)
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userID, 3 , @pseudoClientId, @opEvMsgId OUTPUT, @opId OUTPUT
			-- SET GUI AUDIT PARAMETER
			SELECT @cloudDisplayName =  ISNULL(@cloudDisplayName,'')
			EXEC EvGuiAuditSetParamData @opId, @cloudDisplayName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @cloudMode, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @IdxSvrPoolName, @dataIsEvent
			--GUIAUDIT_PARAMS_INDEX_SERVER_CLOUD_CREATE	Created Index Server [^1%s] with Cloud Mode [^2%s], Index Server Pool [^3%s]
SET @paramMsgId = (1624 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userID
		END
	END
	ELSE IF @opType =  2 --common::OperationType_DELETE
	BEGIN
		SET @clientId = ISNULL((SELECT TOP 1 clientId FROM DM2SearchServerCoreInfo (NOLOCK) WHERE cloudId = @cloudId AND cloudType = 1),0) --App::CloudServerType_AnalyticsEngine
		IF (OBJECT_ID('tempdb.dbo.#analyticsRolesTbl') IS NOT NULL) DROP TABLE #analyticsRolesTbl
		CREATE TABLE #analyticsRolesTbl (t_roleId INT, t_opType INT, t_status INT)
		INSERT INTO #analyticsRolesTbl (t_roleId, t_opType)
		SELECT roleId, 2
		FROM DM2CloudCoreRole (NOLOCK)
		WHERE cloudId = @cloudId
--AppAnalyticsDeleteOperation.spb
--DOWNLOAD_CENTER
IF EXISTS (SELECT TOP 1 1 FROM #analyticsRolesTbl WHERE t_opType = 2 AND t_roleId = 4)
BEGIN
	--delete information for Download center role
IF EXISTS (SELECT 1 FROM DM2CloudCoreRole WHERE roleId = 4 AND cloudId = @cloudId)
			AND EXISTS (SELECT 1 FROM GXGlobalParam WHERE name = 'DOWNLOAD_CENTER_INDEX_SERVER_CLIENTID' )
		BEGIN
			DECLARE @dcIndexSvrClientId INT = ISNULL((SELECT CAST (value AS INT) FROM GXGlobalParam WHERE name = 'DOWNLOAD_CENTER_INDEX_SERVER_CLIENTID'),0)
			IF @dcIndexSvrClientId >0 AND  @pseudoClientId =  @dcIndexSvrClientId
				DELETE FROM GXGLOBALPARAM WHERE NAME IN ('DOWNLOAD_CENTER_CLIENT_ID_DONOTUSE','DOWNLOAD_CENTER_HOST','DOWNLOAD_CENTER_URL','DOWNLOAD_CENTER_INDEX_SERVER_CLIENTID', 'DOWNLOAD_CENTER_CLIENT_ID_RETRY')
		END
END
--reset cloudid to 0 for reviewset
IF EXISTS (SELECT TOP 1 1 FROM #analyticsRolesTbl WHERE t_opType = 2 AND t_roleId = 8)
BEGIN
IF EXISTS (SELECT TOP 1 1 FROM DM2CloudCoreRole WHERE roleId = 8)
	AND EXISTS (SELECT TOP 1 1 FROM DM2Container (NOLOCK) WHERE cloudId = @cloudId)
	BEGIN
		UPDATE DM2Container
		SET cloudId = 0
		WHERE cloudId = @cloudId
	END
END
--delete subclient contents from APP_ScFilterFile table
DELETE S
FROM APP_ScFilterFile  S
JOIN #analyticsRolesTbl T ON componentNameId = @appId AND T.t_opType = 2
JOIN DM2CloudRoleMaster RM (NOLOCK) ON T.t_roleId =RM.roleType
WHERE  fileName = ('\%'+ RM.roleTypeName +'%')
--delete from DM2CloudCoreRole table
DELETE DM2CloudCoreRole
WHERE cloudId = @cloudId
AND roleId IN (SELECT t_roleId FROM #analyticsRolesTbl WHERE t_opType = 2 )
--EXCHANGE_INDEX
IF EXISTS (SELECT TOP 1  1 FROM #analyticsRolesTbl WHERE t_opType = 2 AND t_roleId = 12)
BEGIN
IF NOT EXISTS (SELECT 1 FROM DM2CloudCoreRole WHERE roleId = 12)
	BEGIN
DELETE FROM DM2Cloud WHERE (flags & 4) > 0 OR (flags & 2) > 0
	END
END
--
		IF (OBJECT_ID('tempdb.dbo.#analyticsRolesTbl') IS NOT NULL) DROP TABLE #analyticsRolesTbl
		--Delete file indexing association at client, subclient & backupset level
		DECLARE @datasourceIdTbl AS TABLE( dsId int)
		INSERT INTO @datasourceIdTbl
		SELECT DISTINCT  DS.DataSourceId
		FROM SEDataSource DS WITH (NOLOCK)
		INNER JOIN SECollectionInfo C WITH (NOLOCK) ON DS.CoreId = C.CoreId AND C.CloudID = @cloudId
		DELETE APP_ClientProp WHERE attrName =  'indexing datasource id' AND attrval IN (SELECT dsId FROM @datasourceIdTbl)
		DELETE APP_subclientProp WHERE attrName =  'indexing datasource id' AND attrval IN (SELECT dsId FROM @datasourceIdTbl)
		DELETE APP_BackupSetProp WHERE attrName =  'indexing datasource id' AND attrval IN (SELECT dsId FROM @datasourceIdTbl)
		--Delete firewall information if cloud is deleted
		DELETE F
		FROM APP_FirewallTppm F
		JOIN DM2SearchServerCoreInfo S (NOLOCK) ON fromEntityId = S.clientId AND  toEntityId = S.clientId
WHERE S.cloudId = @cloudId AND S.cloudType IN (1,9)
		AND F.tppmType = 8  --TPPMType::DYNAMIC_TPPM=8
		AND F.toPortNumber = S.portNo
		DELETE FROM DM2Cloud WHERE cloudId = @cloudId  AND cloudType IN (1,4,5)
		DELETE FROM DM2SearchServerCoreInfo WHERE cloudId = @cloudId AND cloudType IN (1,4,5)
		DELETE FROM APP_ClientProp WHERE componentNameId = @clientId AND modified = 0
		AND ( attrname IN ( N'Analytics_CloudId', N'Analytics_CloudType', N'Analytics_baseport', N'Analytics_hostname', N'Analytics_QPS_URL', N'AnalyticSearchEngineEnabled',  N'AnalyticsEngineType',N'Analytics_index-dir', N'Analytics_Memory_MB',N'Analytics_RolesInfo', N'Analytics_stopPort'))
		DELETE FROM TM_AssocEntity WHERE clientId = @pseudoClientId
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userID, 3 , @pseudoClientId, @opEvMsgId OUTPUT, @opId OUTPUT
		-- SET GUI AUDIT PARAMETER
		SELECT @cloudDisplayName =  ISNULL(@cloudDisplayName,'')
		EXEC EvGuiAuditSetParamData @opId, @cloudDisplayName, @dataIsEvent
SET @paramMsgId = (1625 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userID
		--update output cloudId
		SET @o_cloudId = @cloudId
		SET @o_cloudName = @cloudName
		SET @o_cloudDisplayName = @cloudDisplayName
	END
	ELSE IF @opType =  3 --common::OperationType_MODIFY
	BEGIN
		-- set Index server to Plan association
        IF ISNULL(@planId,0)> 0
        BEGIN
			DECLARE @oldPlanId INT = ISNULL((SELECT CAST(attrVal AS INT)
												FROM App_ClientProp (NOLOCK)
												WHERE componentNameId =  @pseudoClientId
AND attrName = 'Associated Plan'
														AND modified =0),0)
			DECLARE @subClientId INT = ISNULL((SELECT id
												FROM APP_Application (NOLOCK)
												WHERE clientid = @pseudoClientId
AND appTypeID = 64
AND subClientStatus & 0x00008>0
														),0)
			IF @oldPlanId != @planId
			BEGIN
				--if not asscoiated to plan earlier, insert
				IF @oldPlanId = 0
				BEGIN
					INSERT INTO App_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
VALUES(@pseudoClientId, 'Associated Plan', 7, @planId, @installTime, 0, 0)
					--insert plan info for subclient prop for existing setup
					INSERT INTO APP_SubClientProp (componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
VALUES (@subClientId,	'Associated Plan',	7	, @planId	,@installTime,	0,	0),
(@subClientId,	'Associated Plan Parent EntityType',	7,	3,	@installTime	,0	,0),
(@subClientId,	'Associated Plan Parent EntityId',	7	,@pseudoClientId,	@installTime,	0,	0)
					--in case if index server is not associated to schedule previously
					EXEC AppIndexServerBackupSchedule @pseudoClientId
				END
				ELSE
				BEGIN --update plan at client level
					-- Check if Auto index job is running for index server
					IF EXISTS (SELECT 1
								FROM JMBkpJobInfo BJ (NOLOCK)
								JOIN JMJobInfo JI (NOLOCK) ON BJ.jobId = JI.jobId
								JOIN APP_Application S (NOLOCK) ON BJ.applicationId = S.id
								WHERE S.clientId =@pseudoClientId AND JI.opType =150)  --AUTO_SCALING_INDEX_BACKUP
					OR EXISTS( SELECT 1
								FROM JMRstJobInfo RJ (NOLOCK)
								WHERE RJ.srcClientId = @pseudoClientId)
					BEGIN
						SET @o_errorStr = 'Failed to update plan. Autoscale index job is running.'
						SET @o_errorCode = 12702; --CLOUD_OPERATION_FAILED
						GOTO errorexit
					END
					ELSE
					BEGIN
						UPDATE App_ClientProp
						SET attrVal = @planId
WHERE componentNameId =  @pseudoClientId AND attrName = 'Associated Plan' AND modified =0
						UPDATE APP_SubClientProp
						SET attrVal = @planId
WHERE componentNameId =  @subClientId AND attrName = 'Associated Plan' AND modified =0
					END
				END
				--update sp at subclient level
DECLARE @spId INT = dbo.AppPlanGetEntityValueV2(@planId, 'Storage policy', 1)
				UPDATE APP_Application
				SET dataArchGrpId = @spId
				WHERE Clientid = @pseudoClientId
				--AUDIT
				DECLARE @oldPlanName NVARCHAR(256) =ISNULL((SELECT name FROM APP_Plan (nolock) WHERE id = @oldPlanId),N'')
				DECLARE @newPlanName NVARCHAR(256) =ISNULL((SELECT name FROM APP_Plan (nolock) WHERE id = @planId),N'')
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userID, 3 , @pseudoClientId, @opEvMsgId OUTPUT, @opId OUTPUT
				-- SET GUI AUDIT PARAMETER
				SELECT @cloudDisplayName =  ISNULL((SELECT name FROM APP_client (NOLOCK) WHERE id = @pseudoClientId),'')
				EXEC EvGuiAuditSetParamData @opId, @oldPlanName, @dataIsEvent
				EXEC EvGuiAuditSetParamData @opId, @newPlanName, @dataIsEvent
				EXEC EvGuiAuditSetParamData @opId, @cloudDisplayName, @dataIsEvent
SET @paramMsgId = (1870 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userID
			END
        END
		UPDATE DM2Cloud
		SET cloudProps = @cloudProps,
			modifiedTime = @installTime
		WHERE cloudId = @cloudId AND cloudProps != @cloudProps AND LEN(@cloudProps) >0
		--update output cloudId
		SET @o_cloudId = @cloudId
	END
	--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	COMMIT TRAN
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
	-- Call procedure to get error information.
	EXECUTE dbo.GetError @o_errorStr OUTPUT , @o_errorCode OUTPUT
	-- Rollback any active or uncommittable transactions before
	-- inserting information in the ErrorLog
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRANSACTION;
	END
END CATCH;
errorexit:
	-- Rollback any active or uncommittable transactions before
	-- inserting information in the ErrorLog
	IF XACT_STATE() <> 0 AND @o_errorCode != 0
	BEGIN
		ROLLBACK TRANSACTION;
	END
	SELECT @o_cloudName = name, @o_cloudDisplayName = displayName FROM DM2Cloud (NOLOCK) WHERE cloudId = @o_cloudId
--OUTPUT
SELECT @o_cloudId AS 'o_cloudId', @o_cloudName AS 'o_cloudName', @o_cloudDisplayName AS 'o_cloudDisplayName', @o_errorCode AS 'o_errorCode', @o_errorStr AS 'o_errorStr'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppAnalyticsCloudOperation')
	delete from GxQscripts where name = 'AppAnalyticsCloudOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAnalyticsCloudOperation')
	delete from GXDBVersions where aliasname = 'AppAnalyticsCloudOperation'
GO

insert into GXDBVersions values(2, 'AppAnalyticsCloudOperation',  'v1.1.4.17.20.3', 'AppAnalyticsCloudOperation', 'v1.1.4.17.20.3')
GO

