

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppAgentIdToPkgIdConverter.sp] ---------- 

--  +==============================================================================================================================+
--  |                       Name: AppAgentIdToPkgIdConverter()
--  | Description: Provides list of package Ids for given set of agentIds when variable fetchPkgFromAgent is set to 1.
--  |			   Alternatively provides list of agent Ids for given set of packageIds when varibale fetchPkgFromAgent is set to 0
--  |
--  |       Inputs: clientId (INT)
--  |               fetchPkgFromAgent (INT 0/1) : If 1, then SP outputs list of package ids for given appTypids.
--  |											      Else, SP outputs list of agent ids for given packageIds.
--  |               ids : Comma separated appTypeIds or packageIds depending upon how the user intends to use this SP
--  |
--  |      Output: errorCode, errorString, isLastAgent, o_ids
--  |      Author: sravanan
--  +==============================================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppAgentIdToPkgIdConverter')
BEGIN
	print '>>> Drop Stored Procedure: AppAgentIdToPkgIdConverter <<<'
	drop procedure AppAgentIdToPkgIdConverter
END
IF EXISTS (select * from GxQscripts where name='AppAgentIdToPkgIdConverter')
	delete from GxQscripts where name = 'AppAgentIdToPkgIdConverter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAgentIdToPkgIdConverter')
	delete from GXDBVersions where aliasname = 'AppAgentIdToPkgIdConverter'
GO
print '... Creating Procedure: AppAgentIdToPkgIdConverter'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppAgentIdToPkgIdConverter
  @clientId INT,
  @fetchPkgFromAgent INT,
  @ids NVARCHAR(MAX)
AS
  DECLARE @errorCode INT = 0
  DECLARE @errorString NVARCHAR(max)
  DECLARE @isLastAgent INT = 0
  DECLARE @o_ids NVARCHAR(max) = ''
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	DECLARE @Delimiter CHAR(1)
	SET @Delimiter = ','
	IF OBJECT_ID('tempdb.dbo.#IdsTable') IS NOT NULL DROP TABLE #IdsTable
	CREATE TABLE #IdsTable (id int);
	DECLARE @sqlStatement nvarchar(max) = 'INSERT INTO #IdsTable VALUES ('+REPLACE(@ids,',','),(')+')'
	EXEC (@sqlStatement);
	DECLARE @restrictedPackagesPresent INT = 0
	-- If fetchPkgFromAgent is 1, then input ids supplied consists of appTypeIds. The SP will generate all possible packageIds for these appTypeIds.
	IF(@fetchPkgFromAgent = 1)
	BEGIN
		-- If the given appTypeId is the last agent installed on client, then set isLastAgent to 1
		IF EXISTS(SELECT 1 FROM app_idaname WITH(NOLOCK) WHERE clientId = @clientId and apptypeId NOT IN (SELECT id FROM #idsTable))
		BEGIN
			SET @isLastAgent = 0
		END
		ELSE
			SET @isLastAgent = 1
		IF EXISTS(SELECT 1 FROM simInstalledPackages inst WITH(NOLOCK) WHERE inst.simPackageID IN
(51, 1301, 252, 1174) AND inst.clientId = @clientId)
		BEGIN
			SET @restrictedPackagesPresent = 1
			SET @isLastAgent = 0
		END
		SELECT @o_ids = COALESCE(@o_ids + @Delimiter,'') + CAST(#temps.[ids] AS nvarchar(100)) FROM (SELECT DISTINCT simmap.simPackageId as ids from APP_IDAName Ida WITH(NOLOCK) join simPackageMap simmap WITH(NOLOCK) on ida.appTypeId = simmap.appType
		join simInstalledPackages inst WITH(NOLOCK) on inst.simPackageID = simmap.simPackageId
		and inst.clientId = ida.clientId where ida.clientId = @clientId and ida.appTypeId in (SELECT id FROM #idsTable)
AND (simmap.simPackageId NOT IN(1, 1002, 702, 1101) OR @restrictedPackagesPresent = 0) ) as #temps
	END
	-- If fetchPkgFromAgent is 0, then input ids supplied consists of packageIds. The SP will generate all possible appTypes for these packageIds.
	ELSE
	BEGIN
		SELECT @o_ids = COALESCE(@o_ids + @Delimiter,'') + CAST(#temps.[ids] AS nvarchar(100)) FROM (SELECT DISTINCT Ida.appTypeId as ids from APP_IDAName Ida WITH(NOLOCK) join simPackageMap simmap WITH(NOLOCK) on ida.appTypeId = simmap.appType
		and simmap.simPackageId in (SELECT id FROM #idsTable) and ida.clientId = @clientId) as #temps
	END
	SET @o_ids = STUFF(@o_ids,1,1,'')
	IF OBJECT_ID('tempdb.dbo.#IdsTable') IS NOT NULL DROP TABLE #IdsTable
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = 'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
END CATCH
PROC_EXIT:
    SELECT @errorCode,@errorString,@isLastAgent,@o_ids
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppAgentIdToPkgIdConverter')
	delete from GxQscripts where name = 'AppAgentIdToPkgIdConverter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAgentIdToPkgIdConverter')
	delete from GXDBVersions where aliasname = 'AppAgentIdToPkgIdConverter'
GO

insert into GXDBVersions values(2, 'AppAgentIdToPkgIdConverter',  '00000000000000000000', 'AppAgentIdToPkgIdConverter', '00000000000000000000')
GO

