

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppAddIndexCacheStat.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppAddIndexCacheStat.sp,v $ $Id: AppAddIndexCacheStat.sp,v 1.1.2.2 2019/04/26 01:01:07 mmansano Exp $";
-- =========================================================
-- Author:		Gokul Pattabiraman
-- Description:	Get the App ID information for the given job.
-- =========================================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppAddIndexCacheStat')
BEGIN
	print '>>> Drop Stored Procedure: AppAddIndexCacheStat <<<'
	drop procedure AppAddIndexCacheStat
END
IF EXISTS (select * from GxQscripts where name='AppAddIndexCacheStat')
	delete from GxQscripts where name = 'AppAddIndexCacheStat'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAddIndexCacheStat')
	delete from GXDBVersions where aliasname = 'AppAddIndexCacheStat'
GO
print '... Creating Procedure: AppAddIndexCacheStat'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppAddIndexCacheStat
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @xmlText XML
AS
DECLARE @currentTime DATETIME = GETDATE()
SET NOCOUNT ON
MERGE IdxCacheStats WITH (HOLDLOCK) AS TARGET
USING (
    SELECT
        ref.value('@clientId', 'INT'),
        @currentTime,
        ref.value('@dbSizeMB', 'BIGINT'),
        ref.value('@logsSizeMB', 'BIGINT'),
        ref.value('@reportsSizeMB', 'BIGINT'),
        ref.value('@legacySizeMB', 'BIGINT'),
        ref.value('@otherSizeMB', 'BIGINT'),
        ref.value('@locationTableSizeMB', 'BIGINT')
    FROM @xmlText.nodes ('App_IndexCacheStats') R(ref)
) AS SOURCE(MAId, LogDate, DbSizeMB, LogsSizeMB, ReportsSizeMB, LegacySizeMB, OtherSizeMB, LocationTableSizeMB)
ON (TARGET.MAId = SOURCE.MAId)
WHEN MATCHED
THEN UPDATE SET
    TARGET.LogDate = SOURCE.LogDate,
    TARGET.DbSizeMB = SOURCE.DbSizeMB,
    TARGET.LogsSizeMB = SOURCE.LogsSizeMB,
    TARGET.ReportsSizeMB = SOURCE.ReportsSizeMB,
    TARGET.LegacySizeMB = SOURCE.LegacySizeMB,
    TARGET.OtherSizeMB = SOURCE.OtherSizeMB,
    TARGET.LocationTableSizeMB = SOURCE.LocationTableSizeMB
WHEN NOT MATCHED THEN
    INSERT (MAId, LogDate, DbSizeMB, LogsSizeMB, ReportsSizeMB, LegacySizeMB, OtherSizeMB, LocationTableSizeMB)
    VALUES (SOURCE.MAId, SOURCE.LogDate, SOURCE.DbSizeMB, SOURCE.LogsSizeMB, SOURCE.ReportsSizeMB, SOURCE.LegacySizeMB, SOURCE.OtherSizeMB, SOURCE.LocationTableSizeMB);
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppAddIndexCacheStat')
	delete from GxQscripts where name = 'AppAddIndexCacheStat'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAddIndexCacheStat')
	delete from GXDBVersions where aliasname = 'AppAddIndexCacheStat'
GO

insert into GXDBVersions values(2, 'AppAddIndexCacheStat',  '00010001000200020000', 'AppAddIndexCacheStat', '00010001000200020000')
GO

