

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppAddIdxDbPlaybackStats.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2020  CommVault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppAddIdxDbPlaybackStats.sp,v $ $Id: AppAddIdxDbPlaybackStats.sp,v 1.1.2.1.8.1 2021/02/17 10:03:06 mmansano Exp $";
-- =========================================================
-- Author: Marcelo Mansano
-- Description: Add Indexing V2 playback statistics to HistoryDB
-- =========================================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppAddIdxDbPlaybackStats')
BEGIN
	print '>>> Drop Stored Procedure: AppAddIdxDbPlaybackStats <<<'
	drop procedure AppAddIdxDbPlaybackStats
END
IF EXISTS (select * from GxQscripts where name='AppAddIdxDbPlaybackStats')
	delete from GxQscripts where name = 'AppAddIdxDbPlaybackStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAddIdxDbPlaybackStats')
	delete from GXDBVersions where aliasname = 'AppAddIdxDbPlaybackStats'
GO
print '... Creating Procedure: AppAddIdxDbPlaybackStats'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppAddIdxDbPlaybackStats
  @xmlText XML OUTPUT
AS
SET NOCOUNT ON;
DECLARE @bsGuid VARCHAR(36) = @xmlText.value('(/App_IndexPlaybackStats/@backupSetGuid)[1]', 'VARCHAR(36)')
DECLARE @dbGuid VARCHAR(36) = @xmlText.value('(/App_IndexPlaybackStats/@databaseGuid)[1]', 'VARCHAR(36)')
DECLARE @dbId INT = NULL
DECLARE @ccId INT
SELECT @dbId = IDX.id, @ccId = APP.origCCId
FROM App_IndexDBInfo IDX WITH(NOLOCK)
	JOIN APP_Application APP WITH(NOLOCK) ON APP.backupSet = IDX.backupSetId AND (dbo.isSubClientIndexEnabled(IDX.backupSetId) = 0 OR APP.GUID = IDX.dbName)
WHERE IDX.dbName = @dbGuid AND IDX.backupSetGUID = @bsGuid
IF @dbId IS NULL
BEGIN
	SELECT @xmlText = (SELECT 1 AS N'@errorCode', 'Failed to obtain index database id' AS N'@errorString' FOR XML PATH(N'App_GenericEntityResponse'), TYPE);
END
ELSE
BEGIN
	-- Add or update job entry in IdxDbPlaybackStats
	MERGE HistoryDB.dbo.IdxDbPlaybackStats WITH (HOLDLOCK) AS TARGET
	USING (
			SELECT
				ISNULL(ref.value('@jobId', 'BIGINT'), 0),
				@ccId,
				@dbId,
				ISNULL(ref.value('@itemsIndexed', 'BIGINT'), 0),
				ISNULL(ref.value('@addedFiles', 'INT'), 0),
				ISNULL(ref.value('@deletedFiles', 'INT'), 0),
				ISNULL(ref.value('@deletedFolders', 'INT'), 0),
				ISNULL(ref.value('@modifiedFiles', 'INT'), 0),
				(ISNULL(ref.value('@applicationSize', 'BIGINT'), 0) / POWER(1024, 2)),
				0 --flags
			FROM @xmlText.nodes('App_IndexPlaybackStats') R(ref)
		  ) AS SOURCE(jobId, commCellId, dbId, indexedItems, addedFiles, deletedFiles, deletedFolders, modifiedFiles, applicationSizeMB, flags)
	ON (TARGET.jobId = SOURCE.jobId AND TARGET.commCellId = SOURCE.commCellId AND TARGET.dbId = SOURCE.dbId)
	WHEN MATCHED THEN
		UPDATE SET
			TARGET.indexedItems = SOURCE.indexedItems,
			TARGET.addedFiles = SOURCE.addedFiles,
			TARGET.deletedFiles = SOURCE.deletedFiles,
			TARGET.deletedFolders = SOURCE.deletedFolders,
			TARGET.modifiedFiles = SOURCE.modifiedFiles,
			TARGET.applicationSizeMB = SOURCE.applicationSizeMB,
			TARGET.flags = SOURCE.flags
	WHEN NOT MATCHED THEN
		INSERT (jobId, commCellId, dbId, indexedItems, addedFiles, deletedFiles, deletedFolders, modifiedFiles, applicationSizeMB, flags)
			VALUES (SOURCE.jobId, SOURCE.commCellId, SOURCE.dbId, SOURCE.indexedItems, SOURCE.addedFiles, SOURCE.deletedFiles, SOURCE.deletedFolders, SOURCE.modifiedFiles, SOURCE.applicationSizeMB, SOURCE.flags);
	SELECT @xmlText = (SELECT 0 AS N'@errorCode', NULL AS N'@errorString' FOR XML PATH(N'App_GenericEntityResponse'), TYPE);
END
--
SET NOCOUNT OFF;
--
GO

IF EXISTS (select * from GxQscripts where name = 'AppAddIdxDbPlaybackStats')
	delete from GxQscripts where name = 'AppAddIdxDbPlaybackStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAddIdxDbPlaybackStats')
	delete from GXDBVersions where aliasname = 'AppAddIdxDbPlaybackStats'
GO

insert into GXDBVersions values(2, 'AppAddIdxDbPlaybackStats',  'v1.1.2.1.8.1', 'AppAddIdxDbPlaybackStats', 'v1.1.2.1.8.1')
GO

