

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppAddDistributedStorage.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppAddDistributedStorage')
BEGIN
	print '>>> Drop Stored Procedure: AppAddDistributedStorage <<<'
	drop procedure AppAddDistributedStorage
END
IF EXISTS (select * from GxQscripts where name='AppAddDistributedStorage')
	delete from GxQscripts where name = 'AppAddDistributedStorage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAddDistributedStorage')
	delete from GXDBVersions where aliasname = 'AppAddDistributedStorage'
GO
print '... Creating Procedure: AppAddDistributedStorage'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppAddDistributedStorage
  @userId INT,
  @localeId INT = 0,
  @xmlstr XML OUTPUT
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @errorCode INT = 0
	DECLARE @errorString NVARCHAR(MAX) = ''
	DECLARE @nowTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())
	DECLARE @outputEntityStr NVARCHAR(MAX)
	DECLARE @outputErrorStr NVARCHAR(MAX)
	DECLARE @HEDVIG	INT = 0x1
DECLARE @name NVARCHAR(255), @url NVARCHAR(MAX), @credentialId INT
DECLARE @nodes VARCHAR(MAX), @targets VARCHAR(MAX), @clusterName NVARCHAR(255)
DECLARE @clusterIdentifier VARCHAR(255)
	------ READ DISTRIBUTED STORAGE INFO FROM REQUEST XML ------
SET @name = ISNULL((SELECT ref.value('@distributedStorageName', 'NVARCHAR(255)') FROM @xmlstr.nodes('App_RegisterDistributedStorageRequest/distributedStorageInfo/distributedStorage') R(ref)), '')
	SET @url = ISNULL((SELECT ref.value('@url', 'NVARCHAR(MAX)') FROM @xmlstr.nodes('App_RegisterDistributedStorageRequest/distributedStorageInfo') R(ref)), '')
	SET @nodes = ISNULL((SELECT ref.value('@clusterNodes', 'NVARCHAR(MAX)') FROM @xmlstr.nodes('App_RegisterDistributedStorageRequest/distributedStorageInfo') R(ref)), '')
	SET @targets = ISNULL((SELECT ref.value('@targets', 'NVARCHAR(MAX)') FROM @xmlstr.nodes('App_RegisterDistributedStorageRequest/distributedStorageInfo') R(ref)), '')
	SET @credentialId = ISNULL((SELECT ref.value('@credentialId', 'INT') FROM @xmlstr.nodes('App_RegisterDistributedStorageRequest/distributedStorageInfo/credential/credentialRecord') R(ref)), 0)
SET @clusterIdentifier = ISNULL((SELECT ref.value('@clusterIdentifier', 'VARCHAR(255)') FROM @xmlstr.nodes('App_RegisterDistributedStorageRequest/distributedStorageInfo') R(ref)), '')
SET @clusterName = ISNULL((SELECT ref.value('@clusterName', 'NVARCHAR(255)') FROM @xmlstr.nodes('App_RegisterDistributedStorageRequest/distributedStorageInfo') R(ref)), '')
	------ CHECK IF REQUIRED FIELDS ARE VALID ------
	IF @userId <= 0
	BEGIN
SET @errorCode = (4625 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		GOTO PROC_EXIT
	END
	IF @name = '' OR @url = '' OR @credentialId = 0 OR @clusterIdentifier = ''
	BEGIN
SET @errorCode = (4626 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		GOTO PROC_EXIT
	END
	------ SECURITY CHECK ------
	DECLARE @userHasCapability INT = 0
EXEC sec_checkPermissionOnEntity @userId, 259, @userHasCapability OUTPUT, 1, 2
	IF @userHasCapability = 0
	BEGIN
		DECLARE @organizationId	INT = dbo.AppGetOrganizationForUser(@userId)
		IF @organizationId IS NULL
		BEGIN
SET @errorCode = (4625 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO PROC_EXIT
		END
		IF @organizationId <> 0
		BEGIN
EXEC sec_checkPermissionOnEntity @userId, 259, @userHasCapability OUTPUT, 61, @organizationId
		END
	END
	IF @userHasCapability = 0
	BEGIN
SET @errorCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		GOTO PROC_EXIT
	END
	------ CHECK IF DISTRIBUTED STORAGE WITH THE SAME NAME ALREADY EXISTS ------
	IF EXISTS (SELECT 1 FROM App_DistributedStorage (NOLOCK) WHERE name = @name)
	BEGIN
SET @errorCode = (4636 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = (SELECT Message FROM EvLocaleMsgs (NOLOCK) WHERE MessageId = @errorCode and localeId = @localeId)
		SET @errorString = REPLACE(@errorString, '^1%s', @name)
		GOTO PROC_EXIT
	END
	------  INERT RECORD TO App_DistributedStorage ------
	INSERT INTO App_DistributedStorage
	(name, url, credentialId, flags, clusterIdentifier)
	VALUES (@name, @url, @credentialId, @HEDVIG, @clusterIdentifier)
	DECLARE @distributedStorageId INT = SCOPE_IDENTITY()
	------  INSERT DISTRIBUTED STORAGE PROPERTIES ------
	INSERT INTO App_DistributedStorageProp
	(componentNameId, attrName, attrType, attrVal, created)
VALUES (@distributedStorageId, 'Cluster Nodes', 1, @nodes, @nowTime),
(@distributedStorageId, 'Targets', 1, @targets, @nowTime),
(@distributedStorageId, 'Cluster Name', 1, @clusterName, @nowTime)
	------  ASSOCIATE DISTRIBUTED STORAGE WITH CREDENTIAL RECORD
	INSERT INTO APP_CredentialAssoc
	(credentialId, entityType, entityId)
VALUES (@credentialId, 195, @distributedStorageId)
	------ SET UP CREATOR OF ADDED DISTRIBUTED STORAGE ------
	DECLARE @permissionsList NVARCHAR(MAX)
SET @permissionsList = CAST(260 AS NVARCHAR(10)) + ',' + CAST(107 AS NVARCHAR(10))
	EXEC sec_setCreatorForEntity @loggedInUserID = @userId,
                                                 @creatorRoleID = 0,
                                                 @creatorPermissions = @permissionsList,
                                                 @errorCode = @errorCode OUTPUT,
                                                 @errorString = @errorString OUTPUT,
@entityType1 = 195,
                                                 @entityId1 = @distributedStorageId,
                                                 @creatorUserId = @userId
	IF @errorCode <> 0
	BEGIN
		GOTO PROC_EXIT
	END
	------  AUDIT ADD DISTRIBUTED STORAGE OPERATION ------
DECLARE @opMsgId    INT = (698 | (CAST(POWER(2, 24) AS BIGINT) * 84))
	DECLARE @opEvMsgId  INT = 0
	DECLARE @opId       INT = 0
DECLARE @paramMsgId INT = (1849 | (CAST(POWER(2, 24) AS BIGINT) * 85))  -- Add Distributed Storage [^1%s]
	EXEC EvGuiAuditSetOperation  @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
	-- audit record parameter values
	EXEC EvGuiAuditSetParamData @opId, @name, 0
	-- tie up
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
	------  COMPILE OUTPUT ENTITY STRING ------
	SET @outputEntityStr = (SELECT @distributedStorageId AS '@distributedStorageId', @name AS '@distributedStorageName'
			FOR XML PATH ('distributedStorage'))
PROC_EXIT:
	IF @errorCode <> 0 AND @errorString = ''
	BEGIN
		SET @errorString = (SELECT Message FROM EvLocaleMsgs (NOLOCK) WHERE MessageId = @errorCode and localeId = @localeId)
	END
	SET @outputErrorStr = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH ('error'))
	DECLARE @outputStr NVARCHAR(MAX) = ISNULL(@outputEntityStr, '') + ISNULL(@outputErrorStr, '')
	SET @xmlstr = @outputStr
	SET @xmlstr = (SELECT @xmlstr FOR XML PATH(''), ROOT('App_RegisterDistributedStorageResponse'))
	select @xmlstr
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppAddDistributedStorage')
	delete from GxQscripts where name = 'AppAddDistributedStorage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAddDistributedStorage')
	delete from GXDBVersions where aliasname = 'AppAddDistributedStorage'
GO

insert into GXDBVersions values(2, 'AppAddDistributedStorage',  '00000000000000000000', 'AppAddDistributedStorage', '00000000000000000000')
GO

