

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppAddDeniedNavsToPersona.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +===================================================================+
--  |                     AppAddDeniedNavsToPersona          |
--  +===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppAddDeniedNavsToPersona')
BEGIN
	print '>>> Drop Stored Procedure: AppAddDeniedNavsToPersona <<<'
	drop procedure AppAddDeniedNavsToPersona
END
IF EXISTS (select * from GxQscripts where name='AppAddDeniedNavsToPersona')
	delete from GxQscripts where name = 'AppAddDeniedNavsToPersona'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAddDeniedNavsToPersona')
	delete from GXDBVersions where aliasname = 'AppAddDeniedNavsToPersona'
GO
print '... Creating Procedure: AppAddDeniedNavsToPersona'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppAddDeniedNavsToPersona
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS                         ---
  @newStatesMSPAdminDeniedNavs NVARCHAR(MAX),
  @newStatesMSPUserDeniedNavs NVARCHAR(MAX),
  @newStatesTenantAdminDeniedNavs NVARCHAR(MAX),
  @newStatesTenantUserDeniedNavs NVARCHAR(MAX),
  @newStatesRestrictedUserDeniedNavs NVARCHAR(MAX)
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN TRY
    DECLARE @localeId INT = 0;
	DECLARE @isGlobalLevelNavItemsSet INT = 0
IF EXISTS(SELECT 1 FROM GXGlobalParam(NOLOCK) WHERE NAME IN ('Restricted Nav Items For MSP Admin' ,'Restricted Nav Items For MSP User','Restricted Nav Items For Restricted Admin') and modified=0)
	BEGIN
		SET @isGlobalLevelNavItemsSet = 1
	END
	IF  @isGlobalLevelNavItemsSet = 1
	BEGIN
		SET @newStatesMSPAdminDeniedNavs = ISNULL(@newStatesMSPAdminDeniedNavs,'');
		SET @newStatesMSPUserDeniedNavs  = ISNULL(@newStatesMSPUserDeniedNavs,'');
		SET @newStatesTenantAdminDeniedNavs  = ISNULL(@newStatesTenantAdminDeniedNavs,'');
		SET @newStatesTenantUserDeniedNavs  = ISNULL(@newStatesTenantUserDeniedNavs,'');
		SET @newStatesRestrictedUserDeniedNavs  = ISNULL(@newStatesRestrictedUserDeniedNavs,'');
		If OBJECT_ID('tempdb.dbo.#deniedNavsInDB') IS NOT NULL
				DROP TABLE  #deniedNavsInDB
		CREATE TABLE #deniedNavsInDB (
			persona NVARCHAR(200),
			navItem NVARCHAR(50)
		);
		If OBJECT_ID('tempdb.dbo.#deniedNavsToAdd') IS NOT NULL
			DROP TABLE  #deniedNavsToAdd
		CREATE TABLE #deniedNavsToAdd (
			persona NVARCHAR(200),
			navItem NVARCHAR(50)
		);
		INSERT  INTO #deniedNavsToAdd(persona,navItem)
SELECT 'Restricted Nav Items For MSP Admin', _ID from  dbo.SplitStringByDelimiter( @newStatesMSPAdminDeniedNavs,',')
		INSERT  INTO #deniedNavsToAdd(persona,navItem)
SELECT 'Restricted Nav Items For MSP User', _ID from  dbo.SplitStringByDelimiter( @newStatesMSPUserDeniedNavs,',')
		INSERT  INTO #deniedNavsToAdd(persona,navItem)
SELECT 'Restricted Nav Items For Tenant User'  , _ID from  dbo.SplitStringByDelimiter( @newStatesTenantUserDeniedNavs,',')
		INSERT  INTO #deniedNavsToAdd(persona,navItem)
SELECT 'Restricted Nav Items For Tenant Admin', _ID from  dbo.SplitStringByDelimiter( @newStatesTenantAdminDeniedNavs,',')
		INSERT  INTO #deniedNavsToAdd(persona,navItem)
SELECT 'Restricted Nav Items For Restricted Admin', _ID from  dbo.SplitStringByDelimiter( @newStatesRestrictedUserDeniedNavs,',')
		DELETE FROM #deniedNavsToAdd WHERE navItem IS NULL OR navItem = ''
		INSERT INTO #deniedNavsInDB
			SELECT DISTINCT name, S._ID
			 FROM GXGlobalParam g (NOLOCK)
			 INNER JOIN #deniedNavsToAdd DA ON DA.persona=G.name
			 CROSS APPLY dbo.SplitStringByDelimiter(value,',') S
		INSERT INTO #deniedNavsInDB
			SELECT s.persona, s.navItem FROM #deniedNavsToAdd s (NOLOCK)
			LEFT JOIN #deniedNavsInDB t (NOLOCK) ON s.persona = t.persona and s.navItem = t.navItem WHERE t.navItem IS NULL
		UPDATE g set g.value=A.newNav
		FROM GXGlobalParam g
		INNER JOIN
		(SELECT B.persona, isnull(STUFF(
		(SELECT ',' + L.navItem
		FROM #deniedNavsInDB L WHERE L.persona = B.persona
		FOR XML PATH('')),1,1,''),'') AS newNav
			FROM #deniedNavsInDB AS B ) A on A.persona=g.name
	END
ERROR_EXIT:
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR);
THROW;
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppAddDeniedNavsToPersona')
	delete from GxQscripts where name = 'AppAddDeniedNavsToPersona'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAddDeniedNavsToPersona')
	delete from GXDBVersions where aliasname = 'AppAddDeniedNavsToPersona'
GO

insert into GXDBVersions values(2, 'AppAddDeniedNavsToPersona',  '00000000000000000000', 'AppAddDeniedNavsToPersona', '00000000000000000000')
GO

