

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppAddCustomProperty.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppAddCustomProperty.sp,v $ $Id: AppAddCustomProperty.sp,v 1.2.12.9 2018/03/22 01:40:04 jiechen Exp $";
--	+===================================================================+
--	|  					  AppAddCustomProperty							|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppAddCustomProperty <<<'

IF EXISTS (select * from sysobjects where name='AppAddCustomProperty')
	drop procedure AppAddCustomProperty
IF EXISTS (select * from GxQscripts where name='AppAddCustomProperty')
	delete from GxQscripts where name = 'AppAddCustomProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAddCustomProperty')
	delete from GXDBVersions where aliasname = 'AppAddCustomProperty'
GO
print '... Creating Procedure: AppAddCustomProperty'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppAddCustomProperty
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inUserId INT,
  @inLocaleId INT,
  @inXml XML
-----------------------------------------------------------
AS
  DECLARE @outXml XML
SET NOCOUNT ON
BEGIN
	DECLARE @clientId			INT = ISNULL (( SELECT ref.value('@clientId', 'INT')
													FROM @inXml.nodes ('App_AddCustomProperties/client') R(ref)), 0)
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @tempProp TABLE(propID INT, propName NVARCHAR(512))
	IF OBJECT_ID('tempdb.dbo.#propertyInfo') IS NOT NULL
	    DROP TABLE #propertyInfo
	CREATE TABLE #propertyInfo
	(
		propertyId		INT,
		propertyName	NVARCHAR(512),
		description		NVARCHAR(MAX),
		defaultValue	NVARCHAR(MAX),
		dataType		INT,
		type			INT,
		isList			INT,
		disabled		INT,
		global			INT,
		statusFlags		INT
	)
	BEGIN TRY
	-- Read the XML
	INSERT INTO #propertyInfo
	SELECT
			ISNULL((ref.value('@propertyId', 'INT')), 0),
			LTRIM(RTRIM((ref.value('@propertyName', 'NVARCHAR(512)')))),
			ISNULL((ref.value('@description', 'NVARCHAR(MAX)')), ''),
			LTRIM(RTRIM(ISNULL((ref.value('@defaultValue', 'NVARCHAR(MAX)')), ''))),
			ISNULL((ref.value('@dataType', 'INT')), 2), -- Default is String
			ISNULL(ref.value('@type', 'int'), 3), -- default to RECORDS_MANAGER for now
			ISNULL(ref.value('@isList', 'int'), 0),
			ISNULL(ref.value('@disabled', 'int'), 0),
			ISNULL(ref.value('@global', 'int'), 1), -- Default all are global
			0
	FROM
	@inXml.nodes('/App_AddCustomProperties/properties') doc(ref)
	-- TODO -- What security check do we need?
	BEGIN TRAN
	-- CHECK IF CLIENT EXIST
	IF @clientId = 0
	BEGIN
		SELECT @clientId = A.clientId FROM APP_SubClientProp SC WITH(NOLOCK)
			JOIN APP_Application A WITH(NOLOCK) ON A.id = SC.componentNameId
			WHERE SC.attrname='Edge Drive User Id' AND SC.attrVal = @inUserId
		-- CUSTOM PROPERTY FOR NOW IS ONLY SUPPORTED FOR RECORDS MANAGER AND CVLEGAL OBJECT STORE CLIENT
		IF ISNULL((SELECT attrVal FROM APP_ClientProp WITH(NOLOCK)
			WHERE componentNameId = @clientId AND attrName = 'System Drive Type'), 0) <> 3 /*RECORDS_MANAGER_CLIENT*/
		BEGIN
			-- FALL BACK TO CVLEGAL OBJECTSTORE CLIENT. I KNOW IT'S NOT A GOOD WAY TO DETECT BUT WE WILL FIX THIS EVENTUALLY.
			DECLARE @shareId INT = ISNULL((SELECT value FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'CvLegalAppShareId'), 0)
			SELECT @clientId = clientId FROM App_SyncCloudConfig WITH(NOLOCK) WHERE syncWebFolderId = @shareId
		END
	END
	IF NOT EXISTS (SELECT 1 FROM App_Client WITH(NOLOCK) WHERE id = @clientId)
	BEGIN
SET @errorCode = (1800 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = @errorCode AND [localeId] = @inLocaleId)
		SET @errorString = REPLACE(@errorString, '^1%s', @clientId)
		GOTO ERROR
	END
	-- CHECK IF USER HAS ADD CAPABILITY
	DECLARE @userHasCapability INT = 0
EXEC sec_checkPermissionOnEntity @inUserId, 208, @userHasCapability OUTPUT, 3, @clientId
	IF (@userHasCapability = 0)
	BEGIN
SET @errorCode = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = @errorCode AND [localeId] = @inLocaleId)
        SET @errorString = REPLACE(@errorString, '^1%s', (SELECT login FROM UMUsers WITH (NOLOCK) where id = @inUserId))
SET @errorString = REPLACE(@errorString, '^2%s', (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (3104 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @inLocaleId))
        SET @errorString = REPLACE(@errorString, '^3%s', (SELECT top 1 name FROM APP_Client with (NOLOCK) WHERE id = @clientId ))
		GOTO ERROR
	END
	-- CHECK FOR DUPLICATE PROPERTY
	IF EXISTS (SELECT 1 FROM App_CustomProperty CP WITH(NOLOCK) JOIN #propertyInfo P ON P.propertyName = CP.propertyName)
	BEGIN
SET @errorCode = (3066 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
		GOTO ERROR
	END
	UPDATE #propertyInfo
SET statusFlags |= 0x1
	WHERE disabled = 1
	UPDATE #propertyInfo
SET statusFlags |= 0x2
	WHERE isList = 1
	UPDATE #propertyInfo
SET statusFlags |= 0x4
	WHERE type = 2 --USER_DEFINED
	UPDATE #propertyInfo
SET statusFlags |= 0x10
	WHERE global = 1
	UPDATE #propertyInfo
SET statusFlags |= (CAST(0x10 AS INT) | CAST(0x20 AS INT))
	WHERE type = 3
	MERGE App_CustomProperty AS TARGET
	USING (SELECT propertyId, propertyName, defaultValue, dataType, description, statusFlags FROM #propertyInfo) AS
							SOURCE (propertyId, propertyName, defaultValue, dataType, description, statusFlags)
		ON (TARGET.propertyId = SOURCE.propertyId OR TARGET.propertyName = SOURCE.propertyName)
	WHEN NOT MATCHED BY TARGET THEN
		INSERT(propertyName, indexingFieldName, dataType, defaultValue, description, ownerId, statusFlags, createdTime)
		VALUES(SOURCE.propertyName, REPLACE(SOURCE.propertyName, ' ', '_'), SOURCE.dataType, SOURCE.defaultValue, SOURCE.description, @inUserId, SOURCE.statusFlags, @nowTime)
	output inserted.propertyId, inserted.propertyName INTO @tempProp;
	-- Update new propertyIds
	UPDATE #propertyInfo
	SET propertyId = T.propID
	FROM @tempProp T
	WHERE T.propName = #propertyInfo.propertyName
	-- ADD CREATOR OF THE ENTITY. RUN LOOP
	DECLARE @propid INT = 0
	DECLARE @permissionsList NVARCHAR(MAX)
SET @permissionsList = CAST(31  AS NVARCHAR(10)) + ',' + CAST(209 AS NVARCHAR(10)) + ',' + CAST(210 AS NVARCHAR(10))
+ ',' + CAST(107 AS NVARCHAR(10))
	DECLARE @propertyCurosor CURSOR
	SET @propertyCurosor = CURSOR FOR
						select propID from @tempProp WHERE propID > 0
	OPEN @propertyCurosor
	FETCH NEXT FROM @propertyCurosor INTO @propid
	WHILE @@FETCH_STATUS = 0
	BEGIN
		-- ADD CLIENT-PROPERTY MAPPING IN App_CompoenentProp TABLE
		INSERT INTO App_ComponentProp (componentType,componentId,propertyTypeId,dataType,longVal,longlongVal,created,modified)
VALUES(18, @propid, 1008, 9, @clientId, 0, dbo.GetUnixTime(GETUTCDATE()), 0)
		IF (@@ERROR <> 0)
		BEGIN
			SET @errorCode = @@ERROR
			SET @errorString = 'Failed to insert row to App_ComponentProp.'
			BREAK
		END
EXEC sec_setCreatorForEntity @inUserId, 0, @permissionsList, @errorCode OUTPUT, @errorString OUTPUT, 166, @propid
		if (@errorCode<>0)
		BEGIN
			IF @errorString = ''
				set @errorString = 'Add custom property failed.'
			BREAK
		END
		FETCH NEXT FROM @propertyCurosor INTO @propid
	END
	CLOSE @propertyCurosor;
	DEALLOCATE @propertyCurosor;
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
END CATCH
ERROR:
	IF @errorCode <> 0
	BEGIN
		IF XACT_STATE() <> 0
		BEGIN
			ROLLBACK TRAN
		END
		IF @errorString = ''
		BEGIN
SET @errorCode = (1287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) --TODO
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
		END
	END
	ELSE
		COMMIT TRAN
ERROR_EXIT:
		SET @outXml = (SELECT
								    (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
									 FOR XML PATH('error'), TYPE),
									(SELECT propertyId AS '@propertyId', propertyName AS '@propertyName'
									 FROM #propertyInfo
									 FOR XML PATH('properties'),TYPE)
							FOR XML PATH('App_CustomPropertyResponse'), TYPE)
	IF OBJECT_ID('tempdb.dbo.#propertyInfo') IS NOT NULL
	    DROP TABLE #propertyInfo
	SELECT @outXml
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppAddCustomProperty')
	delete from GxQscripts where name = 'AppAddCustomProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAddCustomProperty')
	delete from GXDBVersions where aliasname = 'AppAddCustomProperty'
GO

insert into GXDBVersions values(2, 'AppAddCustomProperty',  '00010002001200090000', 'AppAddCustomProperty', '00010002001200090000')
GO

