

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppAddContent.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppAddContent.sp,v $ $Id: AppAddContent.sp,v 1.11 2014/07/30 18:07:49 gharidas Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppAddContent   - Add content in the APP_ScFilterFile
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppAddContent <<<'

IF EXISTS (select * from sysobjects where name='AppAddContent')
	drop procedure AppAddContent
IF EXISTS (select * from GxQscripts where name='AppAddContent')
	delete from GxQscripts where name = 'AppAddContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAddContent')
	delete from GXDBVersions where aliasname = 'AppAddContent'
GO
print '... Creating Procedure: AppAddContent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppAddContent
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @scId integer,
  @sctype integer,
  @timeStamp integer
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
declare @errorCode				int
declare @errorString				nvarchar(1024)
set @errorCode = 0				  -- Assume it will work!
------------------------------------------------------------------------------------
--  GATHERED ENOUGH INFORMATION, TIME TO START INSERTING SOME DATA TO THE TABLES! --
------------------------------------------------------------------------------------
BEGIN
	If @sctype IN (21,22,23) --(CV_XML_CONTENT, CV_XML_YESDIRS_BACKUP_FILTERS, CV_XML_NODIRS_BACKUP_FILTERS)
	BEGIN
	-- For sharepoint XML content need to compare the content path inside xml.
	-- This is going to be slow, but at the moment there is no other way
	    Delete APP_ScFilterFileTemp
		from  APP_ScFilterFile as SP, APP_ScFilterFileTemp as SP2
		where  SP.componentnameId = @scID and  SP.type = @sctype and
		CAST(SP.fileName AS XML).value('(/EVGui_SharePointItem/@contentPath)[1]', 'nvarchar(MAX)') = CAST(SP2.fileName AS XML).value('(/EVGui_SharePointItem/@contentPath)[1]', 'nvarchar(MAX)')
		and  SP.modified = 0
	END
	ELSE
	BEGIN
	    Delete APP_ScFilterFileTemp from  APP_ScFilterFile as SP, APP_ScFilterFileTemp as SP2 where  SP.componentnameId = @scID and  SP.type = @sctype and SP.cs_fileName = SP2.cs_fileName and  SP.modified = 0
	END
--Check Error
	set @errorCode = @@error
	IF(@errorCode <> 0)
		GOTO ERROR_EXIT
--Error Check
	INSERT into APP_ScFilterFile (componentNameId, type, fileName, created, modified)
	     SELECT @scId , @sctype, filename, @timeStamp, 0  from APP_ScFilterFileTemp
--Check Error
	set @errorCode = @@error
	IF(@errorCode <> 0)
		GOTO ERROR_EXIT
--Error Check
END
ERROR_EXIT:
	EXEC SQLUtilTruncateTable 'APP_ScFilterFileTemp'
--------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
SELECT	1			         as TAG,
		NULL		         as Parent,
	@errorCode			     as [CVGui_GenericResp!1!errorCode],
	@errorString	         as [CVGui_GenericResp!1!errorMessage]
FOR XML EXPLICIT
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'AppAddContent')
	delete from GxQscripts where name = 'AppAddContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAddContent')
	delete from GXDBVersions where aliasname = 'AppAddContent'
GO

insert into GXDBVersions values(2, 'AppAddContent',  '00010011000000000000', 'AppAddContent', '00010011000000000000')
GO

