

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppAddCMCredentials.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppAddCMCredentials							    |
--	|				Add Credential Manager Records						|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppAddCMCredentials')
BEGIN
	print '>>> Drop Stored Procedure: AppAddCMCredentials <<<'
	drop procedure AppAddCMCredentials
END
IF EXISTS (select * from GxQscripts where name='AppAddCMCredentials')
	delete from GxQscripts where name = 'AppAddCMCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAddCMCredentials')
	delete from GXDBVersions where aliasname = 'AppAddCMCredentials'
GO
print '... Creating Procedure: AppAddCMCredentials'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppAddCMCredentials
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @ixml XML,
  @iSuppressOutput INT = 0
-----------------------------------------------------------
AS
  DECLARE @oxml XML
SET NOCOUNT ON
BEGIN TRY
	DECLARE @userId int
	DECLARE @locale int
	DECLARE @o_ErrorString   NVARCHAR(max) =''
	DECLARE @o_ErrorCode     integer=0
	DECLARE @validData       integer=1
	DECLARE @creatorUserOrGroupId   integer=0
	DECLARE @creatorType   integer=0
	DECLARE @recordType integer=0
	DECLARE @secXml xml = ''
	DECLARE @permissionsList NVARCHAR(MAX)
DECLARE @credentialName		NVARCHAR(255)
	DECLARE @errorTable TABLE (errorCode INT,errorString VARCHAR(MAX))
	DECLARE @curTime INTEGER = dbo.GetUnixTime(GetUTCDate())
SET @permissionsList = CAST(220 AS NVARCHAR(10)) + ',' + CAST(218 AS NVARCHAR(10))
	SET @userId = ISNULL((SELECT  ref.value('@userId', 'int')
	FROM @ixml.nodes('App_AddCredentialRecordReq/processinginstructioninfo/user') R ( ref )),0)
	SET @locale = ISNULL((SELECT  ref.value('@localeId', 'int')
	FROM @ixml.nodes('App_AddCredentialRecordReq/processinginstructioninfo/locale') R ( ref )),0)
	if OBJECT_ID('tempdb.dbo.#credToInsert') is not null drop table dbo.#credToInsert
	create table #credToInsert
	(
		credID int IDENTITY(1,1) PRIMARY KEY,
		ownerUserOrGroupId	integer,
		ownerIsUser			integer,
		credentialName		nvarchar(max),
		recordType			integer,
		userName		    nvarchar(max),
		password			nvarchar(max),
		credentialInfo		xml,
		description			nvarchar(max),
		enabled				integer,
		flags				integer,
		secAssoc            xml
	);
	if OBJECT_ID('tempdb.dbo.#credInserted') is not null drop table dbo.#credInserted
	create table #credInserted
	(
		credID int PRIMARY KEY,
		recordType int
	);
	INSERT INTO #credToInsert
	(ownerUserOrGroupId, ownerIsUser, credentialName, recordType,userName,password,credentialInfo,description,enabled,flags,secAssoc)
	SELECT
	    CASE ISNULL(Tbl.Col.value('(createAs/user/user/@_type_)[1]', 'int'),0)
WHEN 13 THEN Tbl.Col.value('(createAs/user/user/@userId)[1]', 'int')
ELSE (CASE ISNULL(Tbl.Col.value('(createAs/userGroup/@_type_)[1]', 'int'),0) WHEN 15 THEN Tbl.Col.value('(createAs/userGroup/@userGroupId)[1]', 'int') ELSE NULL END)
		END,
		CASE ISNULL(Tbl.Col.value('(createAs/user/user/@_type_)[1]', 'int'),0)
WHEN 13 THEN 13
ELSE (CASE ISNULL(Tbl.Col.value('(createAs/userGroup/@_type_)[1]', 'int'),0) WHEN 15 THEN 15 ELSE NULL END)
		END,
		Tbl.Col.value('(credentialRecord/@credentialName)[1]', 'nvarchar(max)'),
		Tbl.Col.value('(@recordType)[1]', 'int'),
		Tbl.Col.value('(record/@userName)[1]', 'nvarchar(max)'),
		ISNULL(Tbl.Col.value('(record/@password)[1]', 'nvarchar(max)'), ''),
		CAST(REPLACE(CAST(ISNULL(Tbl.Col.query('additionalInformation'), '') AS NVARCHAR(MAX)), 'additionalInformation', 'App_AdditionalCredInfo') AS XML),
		ISNULL(Tbl.Col.value('(@description)[1]', 'nvarchar(max)'),''),
		1,
(case Tbl.Col.value('(flags/@isWorkflowRecord)[1]', 'int') when 1 then 1 else 0 end) |
(case Tbl.Col.value('(flags/@hasAzureKeyVaultAccess)[1]', 'int') when 1 then 2 else 0 end) |
(case Tbl.Col.value('(flags/@hasAzureKeyVaultStorageAccess)[1]', 'int') when 1 then 4 else 0 end) |
(case Tbl.Col.value('(flags/@hidden)[1]', 'int') when 1 then 16 else 0 end) |
(case Tbl.Col.value('(flags/@hasAzureRSVAccess)[1]', 'int') when 1 then 8 else 0 end) ,
		ISNULL(CAST(REPLACE(CAST(Tbl.Col.query('(securityAssociations)')as NVARCHAR(MAX)), 'securityAssociations', 'App_SecurityAssociationForEntityList') as XML),NULL)
	 FROM @ixml.nodes('App_AddCredentialRecordReq/credentialRecordInfo') as Tbl(Col)
	 SET @validData = 1
	 IF @validData = 1
	 BEGIN
		SELECT @credentialName = I.credentialName
		FROM #credToInsert I
		JOIN APP_Credentials C ON C.credentialName = I.credentialName
		IF @credentialName IS NOT NULL
		BEGIN
SET @o_ErrorCode = (3779 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_ErrorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3779 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
			SET @o_ErrorString = REPLACE(@o_ErrorString, '^1%s', @credentialName)
			SET @validData = 0
		END
	 END
	 --Data validation checks
	 IF @validData = 1
	 BEGIN
		IF EXISTS (select 1 from #credToInsert where (ownerUserOrGroupId is NULL) OR (ownerIsUser is NULL) OR (credentialName is null) OR (recordType is NULL) OR (userName is NULL) OR (password is NULL))
		BEGIN
SET @o_ErrorCode = (3449 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_ErrorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3449 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
			SET @validData = 0
		END
	 END
	 --Owner USER/Group validation checks
	 IF @validData = 1
	 BEGIN
IF EXISTS (select 1 from #credToInsert where (ownerIsUser=15 and ownerUserOrGroupId not in (select distinct id from UMGroups)) OR ( ownerIsUser=13 and ownerUserOrGroupId not in (select DISTINCT id FROM UMUsers where id>0)))
		BEGIN
SET @o_ErrorCode = (3450 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_ErrorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3450 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
			SET @validData = 0
		END
	 END
	IF @validData = 1
	BEGIN
		 update #credToInsert
		 SET password =(CASE
				WHEN (CHARINDEX('|#',password, 1) > 0) THEN (dbo.base64decode(SUBSTRING(dbo.DecodeInvalidXMLChar(password),2,LEN(dbo.DecodeInvalidXMLChar(password)))))
				ELSE dbo.base64decode(password) END)
		 where password is NOT NULL
		DECLARE @credToInsert INT = 0
		DECLARE @credentialId INT = 0
		DECLARE @minLength INT = DATALENGTH('App_SecurityAssociationForEntityList')
		DECLARE insertCred CURSOR
		FOR SELECT credID, recordType FROM #credToInsert
		OPEN insertCred
		FETCH insertCred INTO @credToInsert, @recordType
		WHILE @@FETCH_STATUS = 0
		BEGIN
			INSERT INTO APP_Credentials
			(credentialName,recordType,userName,password,credentialInfo,description,created,enabled,flags)
			SELECT credentialName,recordType,userName,password,credentialInfo,description,@curTime,enabled,flags
			FROM #credToInsert where credID=@credToInsert
			SET @credentialId = @@IDENTITY
			SET @creatorUserOrGroupId = 0
			SET @creatorType = 0
			SET @secXml = ''
			SELECT @creatorUserOrGroupId=ownerUserOrGroupId, @creatorType=ownerIsUser, @secXml=secAssoc FROM #credToInsert WHERE credID=@credToInsert
			IF DATALENGTH(@secXml) > @minLength
			BEGIN
				INSERT INTO @errorTable
				EXEC[dbo].[sec_setSecurityAssociationsFromEntity]
				@xmlIn = @secXml,
				@userId = @userId,
				@isCmdLine = 0,
				@skipSecurityCheck = 1,
@entityType1 = 174,
				@entityId1 = @credentialId,
				@entityType2 = 0,
				@entityId2 = 0,
				@entityType3 = 0,
				@entityId3 = 0,
				@entityType4 = 0,
				@entityId4 = 0,
				@entityType5 = 0,
				@entityId5 = 0
				IF EXISTS(SELECT TOP 1 errorCode FROM @errorTable WHERE errorCode <> 0)
				BEGIN
					SET @o_ErrorCode = (SELECT TOP 1 errorCode FROM @errorTable WHERE errorCode <> 0)
					SET @o_ErrorString = (SELECT TOP 1 errorString FROM @errorTable WHERE errorCode <> 0)
					GOTO ERR_EXIT
				END
			END
			IF @creatorUserOrGroupId>0
			BEGIN
IF @creatorType = 13
					EXEC sec_setCreatorForEntity @loggedInUserID = @userId,
												 @creatorRoleID = 0,
												 @creatorPermissions = @permissionsList,
												 @errorCode = @o_ErrorCode OUTPUT,
												 @errorString = @o_ErrorString OUTPUT,
@entityType1 = 174,
												 @entityId1 = @credentialId,
												 @creatorUserId = @creatorUserOrGroupId
ELSE IF @creatorType = 15
					EXEC sec_setCreatorForEntity @loggedInUserID = @userId,
												 @creatorRoleID = 0,
												 @creatorPermissions = @permissionsList,
												 @errorCode = @o_ErrorCode OUTPUT,
												 @errorString = @o_ErrorString OUTPUT,
@entityType1 = 174,
												 @entityId1 = @credentialId,
												 @creatorUserGroupId = @creatorUserOrGroupId
			END
			IF @o_ErrorCode <> 0
				GOTO ERR_EXIT
			ELSE
			BEGIN
				INSERT INTO #credInserted(credID, recordType)
				Values(@credentialId,@recordType)
			END
			FETCH insertCred INTO @credToInsert, @recordType
		END
		SET @o_ErrorCode = 0
SET @o_ErrorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (29 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
		ERR_EXIT:
		CLOSE insertCred
		DEALLOCATE insertCred
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @o_ErrorCode = ERROR_NUMBER()
		--credentialName is Not Unique
SET @o_ErrorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2722 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
    --Close cursor
    IF ( CURSOR_STATUS('global', 'insertCred') >= 0  /* cursor is open */
        OR CURSOR_STATUS('local', 'insertCred') >= 0 )
    CLOSE insertCred
    IF ( CURSOR_STATUS('global','insertCred') = -1  /* cursor is closed */
        OR CURSOR_STATUS('local','insertCred') = -1 )
    DEALLOCATE insertCred
END CATCH
SET @oxml =
(SELECT
	(SELECT
       recordType AS '@recordType',
       (SELECT         credID          AS '@credentialId'
           FOR XML PATH('credentialRecord'), TYPE)
		   FROM #credInserted
		   FOR XML PATH('records'),TYPE),
	   (SELECT @o_ErrorCode '@errorCode', @o_ErrorString '@errorMessage'
    FOR XML PATH ('error'),TYPE)
	FOR XML PATH(''), ROOT('App_AddCredentialRecordResp')
)
IF OBJECT_ID('tempdb.dbo.#credToInsert') is not null drop table dbo.#credToInsert
if OBJECT_ID('tempdb.dbo.#credInserted') is not null drop table dbo.#credInserted
IF @iSuppressOutput = 0
	SELECT @oxml
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppAddCMCredentials')
	delete from GxQscripts where name = 'AppAddCMCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAddCMCredentials')
	delete from GXDBVersions where aliasname = 'AppAddCMCredentials'
GO

insert into GXDBVersions values(2, 'AppAddCMCredentials',  '00000000000000000000', 'AppAddCMCredentials', '00000000000000000000')
GO

