

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppAddAdvanceKeyInfoList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppAddAdvanceKeyInfoList')
BEGIN
	print '>>> Drop Stored Procedure: AppAddAdvanceKeyInfoList <<<'
	drop procedure AppAddAdvanceKeyInfoList
END
IF EXISTS (select * from GxQscripts where name='AppAddAdvanceKeyInfoList')
	delete from GxQscripts where name = 'AppAddAdvanceKeyInfoList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAddAdvanceKeyInfoList')
	delete from GXDBVersions where aliasname = 'AppAddAdvanceKeyInfoList'
GO
print '... Creating Procedure: AppAddAdvanceKeyInfoList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppAddAdvanceKeyInfoList
  @i_FileName nvarchar(max)
AS
BEGIN TRY
	DECLARE @errorCode  INTEGER
	SET @errorCode = 0
BEGIN TRANSACTION
	IF object_id('tempdb.dbo.#RegistryTempAdv') is not null DROP TABLE #RegistryTempAdv
		CREATE TABLE #RegistryTempAdv (XmlCol xml)
	DECLARE @SQLString nvarchar(max) = N'INSERT INTO #RegistryTempAdv(XmlCol) SELECT * FROM OPENROWSET ( BULK ''' + @i_FileName + ''', SINGLE_BLOB ) AS xmlData';
	EXECUTE sp_executesql @SQLString;
	DECLARE @InputXML XML
	SET @InputXML= (SELECT XmlCol from #RegistryTempAdv)
	IF object_id('tempdb.dbo.#tmpAPP_AdvanceKeyInfo') is not null DROP TABLE #tmpAPP_AdvanceKeyInfo
	CREATE TABLE #tmpAPP_AdvanceKeyInfo
        (
              id        integer identity(1,1),
              keyName     nvarchar(256) not NULL,
              relativePath    nvarchar(256) not NULL,
              type        nvarchar(80) not NULL,
              defaultValue    nvarchar(max),
              allowedValues nvarchar(512),
              minValue    bigint,
              maxValue    bigint,
              windows	 nvarchar(10),
              unix		 nvarchar(10),
              osType      integer,
              supportedPlatforms nvarchar(max),
              subSystem   nvarchar(512),
              keyDescription  nvarchar(max),
              additionalDocDescription nvarchar(max),
              createdIn	nvarchar(128),
			  scope	nvarchar(128),
			  validUntilRelease nvarchar(128),
			  isRestartRequired int,
			  isDebugKey int,
			  readOnly nvarchar(128),
			  supportedVersionsInformation nvarchar(max),
			  isHiddenKey int,
              primary key (id),
	)
	INSERT INTO #tmpAPP_AdvanceKeyInfo
		(keyName,relativePath,type,defaultValue,allowedValues,minValue,maxValue,windows,unix,supportedPlatforms,subSystem,keyDescription,additionalDocDescription,createdIn,scope,validUntilRelease,isRestartRequired,isDebugKey,readOnly,supportedVersionsInformation,isHiddenKey)
				SELECT  ref.value('@keyname', 'nvarchar(max)'),
				ISNULL(ref.value('@relativePath', 'nvarchar(max)'),''),
     	 		ISNULL(ref.value('@type','nvarchar(80)'),''),
				ISNULL(ref.value('@defaultValue','nvarchar(max)'),N''),
			 	ISNULL(ref.value('@supportedValues','nvarchar(512)'),N''),
				(CASE ISNUMERIC(ref.value('@minValue','nvarchar(512)')) WHEN 1 THEN ref.value('@minValue','bigint') ELSE NULL END),
				(CASE ISNUMERIC(ref.value('@maxValue','nvarchar(512)')) WHEN 1 THEN ref.value('@maxValue','bigint') ELSE NULL END),
				ISNULL(ref.value('@winPack','nvarchar(10)'),''),
				ISNULL(ref.value('@unixPack','nvarchar(10)'),N''),
				ISNULL(ref.value('@packages','nvarchar(512)'),N''),
			 	ISNULL(ref.value('@category', 'nvarchar(max)'),N''),
			 	(CASE ref.value('@docDescription', 'nvarchar(max)') WHEN '' THEN ISNULL(ref.value('@description', 'nvarchar(max)'),N'') WHEN NULL THEN ISNULL(ref.value('@description', 'nvarchar(max)'),N'') ELSE ref.value('@docDescription', 'nvarchar(max)') END),
			 	ISNULL(ref.value('@addDocDescription', 'nvarchar(max)'),N''),
			 	ISNULL(ref.value('@createdIn', 'nvarchar(max)'),N''),
			 	ISNULL(ref.value('@scope', 'nvarchar(max)'),N''),
			 	ISNULL(ref.value('@validUntilRelease', 'nvarchar(max)'),N''),
			 	ISNULL(ref.value('@isRestartRequired', 'INTEGER'),0),
				ISNULL(ref.value('@isDebugKey', 'INTEGER'),0),
			 	ISNULL(ref.value('@readOnly', 'nvarchar(max)'),N''),
				ISNULL(Convert(NVARCHAR(MAX), (SELECT
							CASE
								WHEN ref.value('@bv9Supported', 'INTEGER') = 1
									THEN ( SELECT '14' as '@releaseId' , '0' as '@startSP', '-1' as '@endSP' FOR XML PATH ('supportedVersions') ,TYPE )
							END,
							CASE
								WHEN  ref.value('@bv10Supported', 'INTEGER') = 1
									THEN ( SELECT '15' as '@releaseId', '0' as '@startSP', '-1' as '@endSP' FOR XML PATH ('supportedVersions') ,TYPE )
							END,
							CASE
								WHEN  ref.value('@bv11Supported', 'INTEGER') = 1
									THEN (
											SELECT (
													SELECT '16' as '@releaseId',
													CASE WHEN ref.value('@sv11StartSP','nvarchar(100)') like 'SP%' THEN CONVERT(INTEGER,STUFF(ref.value('@sv11StartSP', 'nvarchar(100)'),1,2,'')) ELSE 0 END as '@startSP',
													CASE WHEN ref.value('@sv11EndSP', 'nvarchar(100)') like 'SP%' THEN CONVERT(INTEGER,STUFF(ref.value('@sv11EndSP', 'nvarchar(100)'),1,2,'')) ELSE -1 END as '@endSP'
													FOR XML PATH ('supportedVersions') ,TYPE))
							END
 							FOR XML PATH ('supportedVersionsInformation'),TYPE)),'</supportedVersionsInformation>'),
					ISNULL(ref.value('@isHiddenKey', 'INTEGER'),0)
					FROM  @InputXML.nodes('AditionalSettingList/additionalSetting')
						R(ref)
	UPDATE #tmpAPP_AdvanceKeyInfo SET keyname = REPLACE(keyname,'&lt;','<') WHERE keyname like '%&lt;%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET keyname = REPLACE(keyname,'&gt;','>') WHERE keyname like '%&gt;%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET relativepath = REPLACE(relativepath,'&lt;','<') where relativepath like '%&lt;%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET relativepath = REPLACE(relativepath,'&gt;','>')  WHERE  relativepath like '%&gt;%'
	DELETE FROM #tmpAPP_AdvanceKeyInfo WHERE relativePath like 'HK%' and relativePath not like '%<%I%t%>%'
	--UPDATE #tmpAPP_AdvanceKeyInfo SET keyDescription = '<HTML>'+keyDescription+'</HTML>'
	UPDATE #tmpAPP_AdvanceKeyInfo SET type = UPPER(RTRIM(LTRIM(type)))
	DELETE FROM #tmpAPP_AdvanceKeyInfo WHERE type LIKE '' or relativePath LIKE ''
	UPDATE #tmpAPP_AdvanceKeyInfo SET type = 'STRING' WHERE type LIKE '%SZ%' AND type NOT LIKE '%MULTI%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET type = 'MULTISTRING' WHERE type LIKE '%MULTI%' or type LIKE '%REG_MULTI_SZ%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET type = 'INTEGER' WHERE type LIKE 'DWORD' or type LIKE '%INTEGER%' or type LIKE 'REG_DWORD'
	UPDATE #tmpAPP_AdvanceKeyInfo SET type = 'BOOLEAN' WHERE type LIKE '%BINARY%' OR type LIKE '%BOOLEAN%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET windows = UPPER(RTRIM(LTRIM(windows)))
	UPDATE #tmpAPP_AdvanceKeyInfo SET unix = UPPER(LTRIM(RTRIM(unix)))
	UPDATE #tmpAPP_AdvanceKeyInfo SET windows = LTRIM(RTRIM(windows)),unix = LTRIM(RTRIM(unix))
	UPDATE #tmpAPP_AdvanceKeyInfo SET windows = 'YES' WHERE LEN(windows) > 0
	UPDATE #tmpAPP_AdvanceKeyInfo SET unix = 'YES' WHERE LEN(unix) > 0
	UPDATE #tmpAPP_AdvanceKeyInfo SET windows = 'NO' WHERE LEN(windows) <= 0
	UPDATE #tmpAPP_AdvanceKeyInfo SET unix = 'NO' WHERE LEN(unix) <= 0
	UPDATE #tmpAPP_AdvanceKeyInfo SET osType = 3 WHERE windows LIKE 'YES' AND unix LIKE 'YES'
	UPDATE #tmpAPP_AdvanceKeyInfo SET osType = 2 WHERE windows LIKE 'NO' AND unix LIKE 'YES'
	UPDATE #tmpAPP_AdvanceKeyInfo SET osType = 1 WHERE windows LIKE 'YES' AND unix LIKE 'NO'
		UPDATE #tmpAPP_AdvanceKeyInfo SET relativePath = SUBSTRING(relativePath,CHARINDEX('\',relativePath,1)+1,LEN(relativePath))
		WHERE relativePath like '<I%t>\%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET relativePath = SUBSTRING(relativePath,CHARINDEX('/',relativePath,1)+1,LEN(relativePath))
		WHERE relativePath like '<I%t>/%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET relativePath = SUBSTRING(relativePath,CHARINDEX('>',relativePath,1)+1,LEN(relativePath))
		WHERE relativePath like '<I%t>%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET relativePath = SUBSTRING(relativePath,CHARINDEX('>',relativePath,1)+1,LEN(relativePath))
		WHERE relativePath like '<I%t>_%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET relativePath = SUBSTRING(relativePath,CHARINDEX('/',relativePath,1)+1,CHARINDEX('>',relativePath,CHARINDEX('/',relativePath,1))-CHARINDEX('/',relativePath,1)-1)
		WHERE relativePath like '<%t/%>%'
	UPDATE  #tmpAPP_AdvanceKeyInfo SET relativePath = LTRIM(RTRIM(REPLACE(relativePath,'/.properties',SPACE(1))))
		WHERE relativePath like '%/.properties'
	UPDATE #tmpAPP_AdvanceKeyInfo SET supportedPlatforms = RTRIM(LTRIM(supportedPlatforms))
	UPDATE #tmpAPP_AdvanceKeyInfo SET supportedPlatforms = '' WHERE supportedPlatforms like ','
	UPDATE #tmpAPP_AdvanceKeyInfo SET supportedPlatforms = REPLACE(supportedPlatforms,',','"/><packages val = "')
	UPDATE #tmpAPP_AdvanceKeyInfo SET supportedPlatforms = supportedPlatforms+'"/>'
	UPDATE #tmpAPP_AdvanceKeyInfo SET supportedPlatforms = '<packages val = "'+supportedPlatforms
	UPDATE #tmpAPP_AdvanceKeyInfo SET supportedPlatforms = LTRIM(RTRIM(REPLACE(supportedPlatforms,'<packages val = ""/>','')))
			WHERE supportedPlatforms like '%<packages val = ""/>%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET supportedPlatforms = '<packages val = "-1"/>' WHERE supportedPlatforms like ''
	UPDATE #tmpAPP_AdvanceKeyInfo SET supportedPlatforms = supportedPlatforms+'<isRestartRequired val="'+cast(isRestartRequired as varchar)+'"/>'
	UPDATE #tmpAPP_AdvanceKeyInfo SET supportedPlatforms = supportedPlatforms+'<isDebugKey val="'+cast(isDebugKey as varchar)+'"/>'
	UPDATE #tmpAPP_AdvanceKeyInfo SET supportedPlatforms = supportedPlatforms+'<isHiddenKey val="'+cast(isHiddenKey as varchar)+'"/>'
	UPDATE #tmpAPP_AdvanceKeyInfo SET allowedValues = RTRIM(LTRIM(allowedValues))
	UPDATE #tmpAPP_AdvanceKeyInfo SET allowedValues = '' WHERE allowedValues like '%<%' OR allowedValues like '%>%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET allowedValues = REPLACE(allowedValues,', ',',')
	UPDATE #tmpAPP_AdvanceKeyInfo SET allowedValues = REPLACE(allowedValues,' ,',',')
	UPDATE #tmpAPP_AdvanceKeyInfo SET allowedValues = REPLACE(allowedValues,',','"/><values val = "')
	UPDATE #tmpAPP_AdvanceKeyInfo SET allowedValues = allowedValues+'"/>'
	UPDATE #tmpAPP_AdvanceKeyInfo SET allowedValues = '<values val = "'+allowedValues
	UPDATE #tmpAPP_AdvanceKeyInfo SET allowedValues = LTRIM(RTRIM(REPLACE(allowedValues,'<values val = ""/>','')))
			WHERE allowedValues like '%<values val = ""/>%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET scope = '0' WHERE scope like '%ALL%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET scope = '1' WHERE scope like '%development%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET scope = '2' WHERE scope like '%CE%SystemTest%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET scope = '3' WHERE scope like '%Commvault%Partners%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET scope = '0' WHERE scope not in ('0','1','2','3')
	UPDATE #tmpAPP_AdvanceKeyInfo SET createdIn = '0' WHERE createdIn like '%ALL%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET createdIn = '2' WHERE createdIn like '%client%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET createdIn = '1' WHERE createdIn like '%media%agent%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET createdIn = '3' WHERE createdIn like '%commserver%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET createdIn = '0' WHERE createdIn not in ('0','1','2','3')
	UPDATE #tmpAPP_AdvanceKeyInfo SET validUntilRelease = RTRIM(LTRIM(SUBSTRING(validUntilRelease,0,PATINDEX('%.%',validUntilRelease))))
	UPDATE #tmpAPP_AdvanceKeyInfo SET validUntilRelease = '0' WHERE validUntilRelease like ''
	UPDATE #tmpAPP_AdvanceKeyInfo SET validUntilRelease = CAST(validUntilRelease as integer) + 5 WHERE validUntilRelease <> 0
	UPDATE #tmpAPP_AdvanceKeyInfo SET readOnly = 1 WHERE readOnly like '%true%' OR readOnly like '%yes%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET readOnly = 0 WHERE readOnly like '%false%' OR readOnly like '%no%'
	DELETE FROM #tmpAPP_AdvanceKeyInfo WHERE validUntilRelease < 13 and validUntilRelease <> 0
	UPDATE #tmpAPP_AdvanceKeyInfo SET type = 'STRING' WHERE (type LIKE '%STRING%' OR type LIKE '%REG_SIZE%' OR type LIKE '%STRING%') AND (type NOT LIKE '%MULTI%')
	UPDATE #tmpAPP_AdvanceKeyInfo SET type = 'INTEGER' WHERE type LIKE '%NUM%' or type LIKE 'INT'
	UPDATE #tmpAPP_AdvanceKeyInfo SET relativePath = RTRIM(LTRIM(SUBSTRING(relativePath,1,CHARINDEX('/.',relativePath,1)-1)))
		WHERE relativePath LIKE  '%/.%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET relativePath = RTRIM(LTRIM(SUBSTRING(relativePath,1,CHARINDEX('-',relativePath,1)-1)))
		WHERE relativePath LIKE  '%<%>%-%'
	DELETE FROM #tmpAPP_AdvanceKeyInfo WHERE relativepath LIKE '%HKLM\System%'
	DELETE FROM #tmpAPP_AdvanceKeyInfo WHERE keyName LIKE 'bCHECK_AUTOUPDATES' AND osType = 1
	UPDATE #tmpAPP_AdvanceKeyInfo SET relativepath = SUBSTRING(relativePath,PATINDEX('%<Instance>\%',relativePath)+LEN('<Instance>\'),LEN(relativePath)) where relativePath like '<Instance>\%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET relativepath = SUBSTRING(relativePath,PATINDEX('%<Instance Root>\%',relativePath)+LEN('<Instance Root>\'),LEN(relativePath)) WHERE relativepath like '%<Instance Root>\%' AND relativePath NOT lIKE '%,%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET relativePath = RTRIM(LTRIM(REPLACE(relativePath,'Instancexxx\',SPACE(1)))) where relativePath like '%instancexxx%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET relativepath = SUBSTRING(relativePath,0,PATINDEX('%(%)%',relativePath)) WHERE relativepath like '%(%)%' and relativepath not like '%(%)%and%(%)%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET relativePath = REPLACE(relativePath,'for',SPACE(1)) WHERE relativePath like '%(%)%and%(%)%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET relativePath = REPLACE(relativePath,'Aux-copy',SPACE(1))  where relativePath like '%(%)%and%(%)%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET relativePath = REPLACE(relativePath,'backup',SPACE(1))  where relativePath like '%(%)%and%(%)%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET relativePath = REPLACE(relativePath,'and',',')  where relativePath like '%(%)%and%(%)%'
	UPDATE #tmpAPP_AdvanceKeyInfo SET minValue = -2147483648 WHERE minValue > 2147483648
	UPDATE #tmpAPP_AdvanceKeyInfo SET maxValue = -2147483648 WHERE maxValue > 2147483648
		create TABLE #splitStr (id integer,path nvarchar(1024))
	declare @idcnt CURSOR
	declare @pathcnt CURSOR
	DECLARE @dataid integer
	SET @idcnt = CURSOR FOR SELECT id FROM #tmpAPP_AdvanceKeyInfo where subSystem like '%,%'
	OPEN @idcnt
	FETCH NEXT
		FROM @idcnt INTO @dataid
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DECLARE @datat nvarchar(max) = ISNULL((SELECT subSystem FROM #tmpAPP_AdvanceKeyInfo WHERE id = @dataid),'')
		INSERT #splitStr
		SELECT * FROM dbo.SplitString(@datat,',')
		--SET @datat = (SELECT TOP 1 path FROM #splitStr)
		SET @pathcnt = CURSOR FOR SELECT path from #splitStr
		OPEN @pathcnt
		FETCH NEXT
			FROM @pathcnt INTO @datat
		SET @datat = LTRIM(RTRIM(@datat))
		UPDATE #tmpAPP_AdvanceKeyInfo SET subSystem = @datat WHERE id = @dataid
		FETCH NEXT
			FROM @pathcnt INTO @datat
			WHILE @@FETCH_STATUS = 0
			BEGIN
				IF @datat IS NULL OR LEN(RTRIM(LTRIM(@datat))) = 0
				BEGIN
					FETCH NEXT
						FROM @pathcnt INTO @datat
					CONTINUE;
				END
				SET @datat = LTRIM(RTRIM(@datat))
				INSERT INTO #tmpAPP_AdvanceKeyInfo
				SELECT keyName,(CASE @datat WHEN 'Regsitry' THEN relativePath WHEN 'Global Param' THEN 'CommServDB.GxGlobalParam' WHEN 'Console' THEN 'CommServDB.Console' ELSE relativePath END),
					type,defaultValue,allowedValues,minValue,maxValue,windows,unix,osType,supportedPlatforms,@datat,keyDescription,additionalDocDescription,createdIn ,scope , validUntilRelease ,readOnly
						FROM #tmpAPP_AdvanceKeyInfo WHERE id = @dataid
				FETCH NEXT
					FROM @pathcnt INTO @datat
			END
			delete from #splitStr
			FETCH NEXT
				FROM @idcnt INTO @dataid
	END
	IF ( CURSOR_STATUS(N'global', N'@pathcnt') >= 0 /* cursor is open */
	OR CURSOR_STATUS(N'local', '@pathcnt') >= 0 )
	CLOSE @pathcnt
	IF ( CURSOR_STATUS('global','@pathcnt') = -1 /* cursor is closed */
	OR CURSOR_STATUS('local','@pathcnt') = -1 )
	DEALLOCATE @pathcnt
	IF ( CURSOR_STATUS(N'global', N'@idcnt') >= 0 /* cursor is open */
	OR CURSOR_STATUS(N'local', '@idcnt') >= 0 )
	CLOSE @idcnt
	IF ( CURSOR_STATUS('global','@idcnt') = -1 /* cursor is closed */
	OR CURSOR_STATUS('local','@idcnt') = -1 )
	DEALLOCATE @idcnt
	DROP TABLE #splitStr
	UPDATE #tmpAPP_AdvanceKeyInfo SET relativePath = 'CommServDB.GxGlobalParam' where subSystem like '%Global%Param%'
	DELETE  FROM #tmpAPP_AdvanceKeyInfo WHERE id NOT IN(	SELECT MAX(id)  FROM #tmpAPP_AdvanceKeyInfo GROUP BY keyName,relativePath)
	DECLARE @isdatapresent int = (SELECT count(*) FROM APP_AdvanceKeyInfo)
	IF @isdatapresent > 0
	BEGIN
		DELETE FROM APP_AdvanceKeyInfo
	END
	INSERT INTO APP_AdvanceKeyInfo
		SELECT DISTINCT keyName,relativePath,type,defaultValue,allowedValues,minValue,maxValue,ISNULL(osType,3),supportedPlatforms,subSystem,keyDescription,additionalDocDescription,CAST(createdIn as int),CAST(scope as int), CAST(validUntilRelease as int),CAST(readOnly as int), supportedVersionsInformation
			FROM #tmpAPP_AdvanceKeyInfo
				where LEN(keyName) < 128
	UPDATE  APP_AdvanceKeyInfo SET minValue = -2147483648 where minValue is NULL
	UPDATE  APP_AdvanceKeyInfo SET maxValue = -2147483648 where maxValue is NULL
COMMIT TRANSACTION
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = 1
	ROLLBACK TRANSACTION
END CATCH
SELECT @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'AppAddAdvanceKeyInfoList')
	delete from GxQscripts where name = 'AppAddAdvanceKeyInfoList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAddAdvanceKeyInfoList')
	delete from GXDBVersions where aliasname = 'AppAddAdvanceKeyInfoList'
GO

insert into GXDBVersions values(2, 'AppAddAdvanceKeyInfoList',  '00000000000000000000', 'AppAddAdvanceKeyInfoList', '00000000000000000000')
GO

