

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppActivateLaptop.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +================================================================================================+
--  |   Procedure:  ActivateLaptopClient()
--  |
--  | Description:  SP for Validating the activation and reassociating to the physical client
--  |
--  |       Input:  Physical client(laptop) ID, pseudo client id, user id
--  |      Output:  ErrorCode, ErrorString to determine status of the operation
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  snagendra  	To activate a laptop client
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppActivateLaptop')
BEGIN
	print '>>> Drop Stored Procedure: AppActivateLaptop <<<'
	drop procedure AppActivateLaptop
END
IF EXISTS (select * from GxQscripts where name='AppActivateLaptop')
	delete from GxQscripts where name = 'AppActivateLaptop'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppActivateLaptop')
	delete from GXDBVersions where aliasname = 'AppActivateLaptop'
GO
print '... Creating Procedure: AppActivateLaptop'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppActivateLaptop
  @userId INT,
  @physicalClientId INT,
  @pseudoClientId INT,
  @localeId INT,
  @planId INT,
  @isFromCPP INT,   
  @o_errorCode INT OUTPUT,
  @o_errorString NVARCHAR(MAX) OUTPUT
AS
  DECLARE @errorCode INT
  DECLARE @errorString NVARCHAR(MAX)
DECLARE @nowTime INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @oldPseudoclientId INT
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @errorCode = 0
SET @errorString = N''
BEGIN TRY
	DECLARE @profiles table (id INT)
	DECLARE @profileId INT
	DECLARE @schedulePolicyId INT = 0
	DECLARE @storagePolicyId INT = 0
	DECLARE @subclientPolicyId INT = 0
	DECLARE @pushDLPConfig INT = 0
	DECLARE @pushInstallArchiving INT = 0
	DECLARE @clientInstallPkgReq XML
	DECLARE @clientInstallPkgResp XML
	--DECLARE @planId INTEGER
	DECLARE @userCentric INTEGER
	DECLARE @workQOutPutTbl table (errCode INT,errString nvarchar(max))
    DECLARE @rcnt INTEGER
    Declare @providerId INT
    DECLARE @authCode NVARCHAR(64)
	DECLARE @authCompanyID INTEGER
	DECLARE @elasticStoragePolicyId INT = 0
	--Find if there is no plan
	IF ISNULL(@planId,0) = 0
	BEGIN
		IF @userId = 0
		BEGIN
				DECLARE @clientId INT = @physicalClientId
				-------------------------------------------------------------------------------------------------------------------------------------------
--- CODE BELOW HERE IS FROM AppGetPlanForAuthCode.spb  ----------
IF @clientId <> 0
BEGIN
SELECT @authCode=attrval FROM APP_ClientProp WITH (NOLOCK) WHERE attrname='Authorization Code'
		AND componentNameId=@clientId AND modified=0
END
IF (@authCode IS NOT NULL)
BEGIN
SELECT @authCompanyID=componentNameId FROM APP_CompanyProp WITH (NOLOCK) WHERE attrname='Authorization Code'
AND attrVal=@authCode AND cs_attrName=checksum('Authorization Code')
	-- At the time of install the auth code might have been valid, we can still use that company id
	IF @authCompanyID IS NULL
	BEGIN
		SELECT @authCompanyID=CAST(attrval as INT) FROM
APP_ClientProp WHERE attrname='Installation Company ID' and modified = 0
	END
	SELECT @planId = AP.id FROM APP_CompanyProp ACP WITH(NOLOCK)
		INNER JOIN App_Plan AP WITH(NOLOCK)
ON ACP.attrValInt=AP.id AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
		INNER JOIN APP_CompanyProp ACP1 WITH(NOLOCK)
ON ACP1.componentNameId=ACP.componentNameId AND ACP1.attrName='Always activate with default plan' AND ACP1.modified=0 AND ACP1.attrVal='1'
WHERE ACP.componentNameId=@authCompanyID AND ACP.attrName='Default Laptop Plan' AND ACP.modified=0 AND ACP.cs_attrName=checksum('Default Laptop Plan')
	IF ((@planId IS NULL) OR (@planId = 0))
	BEGIN
		-- Get Tenant Admin Id
		DECLARE @tenantAdminId_spb INT
		DECLARE @errorCode_spb INT
		DECLARE @errorMsg_spb NVARCHAR(1024)
		EXEC dbo.AppGetTenantAdminForCompany @authCompanyID, 0, @tenantAdminId_spb OUTPUT, @errorCode_spb OUTPUT, @errorMsg_spb OUTPUT
		IF (@errorCode_spb=0) AND (@tenantAdminId_spb > 0)
		BEGIN
			-- Get all plan for company
			IF OBJECT_ID('tempdb.dbo.#sec_tempGetPlans') IS NOT NULL
				DROP TABLE #sec_tempGetPlans
			CREATE TABLE #sec_tempGetPlans
			(
				planId INT
			)
EXEC sec_getNonIdaObjectsForThisUser @tenantAdminId_spb, 158,159,'#sec_tempGetPlans'
			DECLARE @laptopPlanId INT, @countLaptopPlan INT = 0
			SELECT @laptopPlanId=AP.id, @countLaptopPlan=COUNT(*) OVER ()  FROM #sec_tempGetPlans GP
			INNER JOIN APP_Plan AP WITH(NOLOCK)
ON AP.id=GP.planId AND AP.subType=33554439 AND (AP.flag & 0x00004 = 0) AND (AP.flag & 0x40000000 = 0)
			GROUP BY AP.id
			IF ((@countLaptopPlan = 1) AND (@laptopPlanId > 0))
			BEGIN
				DECLARE @rcnt_spb INT = 0
				DECLARE @nowTime_spb INT = dbo.getUnixTime(GETUTCDATE())
				--	-- Below is the summary of logic
				--	-- If there is only one laptop plan then use that plan to activate the laptops when the laptop is registered with tenant authcode.
				--	--	--Set the key for CVD to be able to auto add the first logged in user as owner or when the user logs in from edge monitor, the user can be added as owner of the laptop.
				--	--	--	-- If GxGlobalParam is set (for auto setup of default plan for client with authcode and it is pure Plan Mode)
				--	--		--	--	Do we set this one plan as default? - Yes
				--	--		--	--	Do we set the "Always activate with default plan" as ON? - Yes
				IF EXISTS (SELECT 1 FROM GxGlobalParam  WITH(NOLOCK) WHERE name='IsOnlyPlanModeEnforced' AND value='1')
				BEGIN
					-- Set Plan as default Plan
					-- Set Always activate with default plan for company
					UPDATE APP_CompanyProp SET attrval =  CAST(@laptopPlanId AS NVARCHAR(16))
WHERE attrname = 'Default Laptop Plan'
						AND componentNameId = @authCompanyID AND modified=0
AND cs_attrName=CHECKSUM('Default Laptop Plan')
					SET @rcnt_spb = @@ROWCOUNT
					IF (@rcnt_spb = 0)
					BEGIN
						INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@authCompanyID, 'Default Laptop Plan', 7,  @laptopPlanId, @nowTime_spb, 0)
					END
					SET @rcnt_spb = 0
					UPDATE APP_CompanyProp SET attrval =  '1'
WHERE attrname = 'Always activate with default plan'
						AND componentNameId = @authCompanyID AND modified=0
AND cs_attrName=CHECKSUM('Always activate with default plan')
					SET @rcnt_spb = @@ROWCOUNT
					IF (@rcnt_spb = 0)
					BEGIN
						INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@authCompanyID, 'Always activate with default plan', 7,  '1', @nowTime_spb, 0)
					END
				END
				-- All done
				-- SET Laptop Plan Id
				SET @planId = @laptopPlanId
			END
		END
	END
	IF OBJECT_ID('tempdb.dbo.#getPlans') IS NOT NULL DROP TABLE #getPlans
END
--- CODE ABOVE HERE IS FROM AppGetPlanForAuthCode.spb  ----------
				-------------------------------------------------------------------------------------------------------------------------------------------
				IF (@authCode IS NULL)
				BEGIN
					-- GENERATE ERROR
					SET @errorCode = 1
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3672 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
					GOTO GENERATE_OUTPUT
				END
				-- Valid auth code is provided, but no property set to activate with default plan. Hence require user information to activate.
				IF @planId IS NULL OR @planId = 0
				BEGIN
						-- GENERATE ERROR
						SET @errorCode = 1
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3670 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
						GOTO GENERATE_OUTPUT
				END
		END
		ELSE
		BEGIN
SELECT @authCode=attrval FROM APP_ClientProp WHERE attrname='Authorization Code' AND componentNameId=@pseudoClientId AND modified=0
			IF (@authCode IS NOT NULL)
			BEGIN
SELECT @authCompanyID=componentNameId FROM APP_CompanyProp WHERE attrname='Authorization Code' AND attrVal=@authCode
			END
			SET @providerId = dbo.AppGetOrganizationForUser(@userId)
			-- If authcode is present, then we have to only allow users which belong to that company(whose authcode is there) or user with admin rights at commcell level
			BEGIN
				DECLARE @isUserComcellAdmin INTEGER = 0
				-- IF auth code company and user company id are different, then check user rights for admin at comcell level
				IF @providerId <> @authCompanyID
				BEGIN
EXEC sec_checkPermissionOnEntity @userId, 1, @isUserComcellAdmin OUT,1,2
					-- If above check also fails, then don't allow activation
					IF (@isUserComcellAdmin = 0)
					BEGIN
						-- GENERATE ERROR
						SET @errorCode = 1
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3674 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
						GOTO GENERATE_OUTPUT
					END
				END
			END
			-------------------------------------------------------------------------------------------------------------------------------------------
--- CODE BELOW HERE IS FROM AppGetPlanForUser.spb  ----------
-- in order to use variables to be declared are : INPUT : @userId INT, OUTPUT @plandId INT, userCentric INT
-- also "SPBodies\AppPlanConstants.spb" should be included before using this snippet
-- Check If user preference for activation of laptop as user centric client is disabled
-- As per discussion with Bhavyan - We will refer only those user groups which are assigned to a plan to determine user activation type
-- Sequence - User->Global Level->Company Level(for Sp11 at advance settings)->User Group Level
-- Item higher in priority order is checked for for User Centric preference only.
-- If someone has "Device Centric" set at higher level in priority but still has user centric down the line, then we will use user centric
DECLARE @userOrgId INT = dbo.AppGetOrganizationForUser(@userId)
DECLARE @priTable AS TABLE (fIsUserCentric INT, PriorityLevel INT)
INSERT INTO @priTable
    SELECT UUP.attrVal, 1 from UMUsers UU WITH(NOLOCK) INNER JOIN UMUsersProp UUP WITH(NOLOCK) ON UU.id=UUP.componentNameId
WHERE UU.id = @userId AND (UUP.attrName = 'Prefer Machine Centric Client' AND UUP.attrType = 7)
	UNION ALL
SELECT value, 2 from GXGlobalParam WITH(NOLOCK) where name='Prefer Machine Centric Client' AND value=N'0'
	UNION ALL
SELECT CAST(attrval AS INT), 3 FROM App_CompanyProp WITH(NOLOCK) WHERE attrname='Prefer Machine Centric Client' AND componentNameId=@userOrgId AND attrval=N'0' AND  cs_attrName = checksum('Prefer Machine Centric Client')
	UNION ALL
    SELECT UGP.attrVal, 4  from UMUserGroup UUG WITH(NOLOCK)
		INNER JOIN UMGroupsProp UGP WITH(NOLOCK) ON UGP.componentNameId=UUG.groupId
INNER JOIN App_PlanProp APP WITH(NOLOCK) ON APP.attrVal=CAST(UUG.groupId AS NVARCHAR(64)) AND APP.attrName IN ('Assigned user group', 'Associated internal user group', 'Associated external user group')
WHERE UUG.userId = @userId AND (UGP.attrName = 'Prefer Machine Centric Client' AND UGP.attrType = 7 and UGP.attrVal='0')
DECLARE @fIsPreferenceMachineCentric INT = ISNULL((select TOP 1 fIsUserCentric  from @priTable order by PriorityLevel),1)
IF (@fIsPreferenceMachineCentric IS NOT NULL AND @fIsPreferenceMachineCentric = 1) OR (@fIsPreferenceMachineCentric IS NULL)
BEGIN
    SET @userCentric = 0
END ELSE BEGIN
    SET @userCentric = 1
END
-- check for direct plan association
SELECT @planId = CAST(attrVal AS INT) FROM UMUsersProp UUP WITH(NOLOCK)
	INNER JOIN App_Plan AP
ON UUP.attrVal=CAST(AP.id AS NVARCHAR(64)) AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
WHERE UUP.componentNameId = @userId AND UUP.attrName = 'Associated Plan' AND UUP.modified=0
-- if there was no direct association try to get plan associated with the group to which user belongs
IF @planId IS NULL OR @planId = 0
BEGIN
	-- For device centric user, all type of group are OK as default preference is - Device Centric
    SET @planId = (SELECT  TOP 1 AP.id
                    FROM App_Plan AP WITH(NOLOCK)
						INNER JOIN UMUserGroup UUG WITH(NOLOCK)
							ON UUG.userId=@userId
						INNER JOIN UMGroupsProp UGP WITH(NOLOCK)
ON UGP.componentNameId=UUG.groupId AND UGP.attrName = 'Associated Plan' AND UGP.modified=0 AND CAST(AP.id AS NVARCHAR(64))=UGP.attrVal
						INNER JOIN App_PlanProp APP WITH(NOLOCK)
ON APP.componentNameId=AP.id AND APP.attrName IN ('Associated internal user group', 'Associated external user group') AND APP.modified=0
WHERE ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0) AND APP.attrVal=CAST(UGP.componentNameId AS NVARCHAR(64)))
END
-- if user does not belong to any group and there was no direct plan association try to find organization to which user belongs
IF @planId IS NULL  OR @planId = 0 BEGIN
	-- To ensure we refer to the latest setting as per index in table (in case of multiple enteries)
    SELECT @planId =AP.id FROM APP_CompanyProp ACP WITH(NOLOCK)
		INNER JOIN App_Plan AP WITH(NOLOCK)
ON ACP.attrValInt=AP.id AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
WHERE ACP.componentNameId=@userOrgId AND ACP.attrName='Default Laptop Plan' AND ACP.cs_attrName=checksum('Default Laptop Plan') AND ACP.modified=0
    IF (@planId IS NOT NULL)  AND (@planId <> 0)
    BEGIN
        DECLARE @planUserGroupId INT = 0
SELECT @planUserGroupId = attrval from App_PlanProp WITH(NOLOCK) WHERE componentNameId=@planId AND attrName = 'Assigned user group' AND modified=0
        Merge UMUsersProp As UUP
        USING (SELECT @userId) as SRC(userId)
ON SRC.userId = UUP.componentNameId AND UUP.attrName = 'Associated Plan' AND UUP.modified=0
            WHEN MATCHED THEN
                UPDATE SET attrVal = @planId
            WHEN NOT MATCHED THEN
INSERT(componentNameId, attrName, attrVal, attrType, created, modified ) VALUES(@userId, 'Associated Plan', @planId, 7, dbo.GetUnixTime(GetDate()), 0);
		IF NOT EXISTS (SELECT 1 FROM UMUserGroup WHERE userId=@userId AND groupId=@planUserGroupId)
		BEGIN
			INSERT INTO UMUserGroup
				VALUES (@userId, @planUserGroupId, 0)
		END
    END
END
--- CODE ABOVE HERE IS FROM AppGetPlanForUser.spb  ----------
			-------------------------------------------------------------------------------------------------------------------------------------------
		END
	END
	IF @planId IS NULL OR @planId = 0
	BEGIN
		IF @physicalClientId <> @pseudoClientId
		BEGIN
			-- GENERATE ERROR
			SET @errorCode = 1
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2843 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		END
		ELSE
		BEGIN
			-- In case of device centric and no plan mapping, we have nothing to do here. Just mark activation complete.
			SET @errorCode = 0
			SET @errorString = ''
		END
		GOTO GENERATE_OUTPUT
	END
	ELSE
	BEGIN
		SET @profileId = @planId
	END
	-- Check to see if planid that is calculated is elastic plan and client does have geo tagging
EXEC dbo.PlanRuleEvaluateStoragePolicyForEntityV2 @profileId, @physicalClientId, 3, @userId, @localeId, 0, @elasticStoragePolicyId OUTPUT, @errorCode OUTPUT, @errorString OUTPUT
	-- This needs to be called here as we need to confirm if our operation will be successful or not.
	-- If not, then no point in executing rest of SP.
	IF (@errorCode <> 0) OR (@elasticStoragePolicyId = 0)
	BEGIN
		GOTO GENERATE_OUTPUT
	END
	-- If its deassociated then reassociate
	UPDATE app_clientprop
		SET attrval = @profileId
WHERE attrname = 'Associated Plan'
		AND componentNameId = @pseudoclientId
		AND modified = 0		-- Fix SaaS Deadlock issue with AppPruneGeoLocation SP.  Without modified = 0 it seeks / reads N Rows but with it seeks /reads 1 Row so avoids locking many rows
    SET @rcnt = @@ROWCOUNT
    IF (@rcnt = 0)
	BEGIN
		  INSERT INTO App_ClientProp VALUES
		  --(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
(@pseudoClientId, 'Associated Plan', 10, @profileId, @nowTime, 0, 0)
	END
	-- Determine the laptop type for device centric clients
	IF @pseudoClientId = @physicalClientId
	BEGIN
		DECLARE @clientInputs table
								( osId int,
								  apptype int,
								  laptopType int,
								  error int,
								  errorStr nvarchar(max))
		INSERT INTO @clientInputs
		EXEC AppGetUserCentricClientInputs @physicalClientId
		DECLARE @laptopType INT = (select laptopType FROM @clientInputs)
		UPDATE app_clientprop set attrval = @laptopType
WHERE attrname = 'Ida Type'
			and componentNameId = @physicalClientId
			AND modified = 0		-- Fix possible SaaS Deadlock issue with AppPruneGeoLocation SP.  Without modified = 0 it seeks / reads N Rows but with it seeks /reads 1 Row so avoids locking many rows
        IF @@ROWCOUNT = 0
		BEGIN
			  INSERT INTO App_ClientProp VALUES
			  --(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
(@physicalClientId, 'Ida Type' , 10, @laptopType, @nowTime, 0, 0)
		END
	END
DECLARE @oldLaptopId INT = ISNULL((select attrval from app_clientprop with (nolock) WHERE attrname = 'Physical Client Id'
	and componentNameId = @pseudoClientId and modified = 0),-1)
	-- Case where we are activating as a device centric preference
	IF @pseudoClientId <> @physicalClientId
	BEGIN
		-- If its deassociated then reassociate
		IF @oldLaptopId <> -1
		BEGIN
			UPDATE app_clientprop set attrval = @physicalClientId
WHERE attrname = 'Physical Client Id'
				and componentNameId = @pseudoclientId
				AND modified = 0		-- Fix possible SaaS Deadlock issue with AppPruneGeoLocation SP.  Without modified = 0 it seeks / reads N Rows but with it seeks /reads 1 Row so avoids locking many rows
		END
		ELSE
		BEGIN
			  INSERT INTO App_ClientProp VALUES
			  --(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
(@pseudoClientId, 'Physical Client Id', 10, @physicalClientId, @nowTime, 0, 0)
		END
UPDATE APP_CLIENT SET STATUS = STATUS & ~cast(0x00002 as int)
			WHERE id = @pseudoClientId
		UPDATE APP_ClientProp SET attrVal = '0' WHERE componentNameId = @pseudoclientId AND attrName = 'PlatformDeleted 4' and modified=0
		IF (@@ROWCOUNT = 0)
		BEGIN
			INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			VALUES(@pseudoclientId, 'PlatformDeleted 4', 2, '0', @nowTime, 0 ,0)
		END
		DELETE FROM APP_ClientProp where attrname = 'Physical Client Id on hold' and componentNameId = @pseudoclientId
	END
	-- Update the provider id as the user company id. If its a galaxy group, set the id to 0
    -- If this property is already present , then don't change it
IF NOT EXISTS(SELECT 1 FROM APP_ClientProp WITH (NOLOCK) WHERE attrname = 'Installation Company ID'
	AND componentNameId = @pseudoClientId AND modified = 0)
	BEGIN
		IF (@providerId IS NULL AND @userId<>0)
			SET @providerId = dbo.AppGetOrganizationForUser(@userId)
		IF @providerId IS NOT NULL
		BEGIN
		  INSERT INTO App_ClientProp VALUES
		  --(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
(@pseudoClientId, 'Installation Company ID', 10, @providerId, @nowTime, 0, 0)
EXEC sec_setCompanyIdForEntity 3, @pseudoClientId, @providerId
		END
	END
DECLARE @type INT  = ISNULL((select attrval from app_clientprop with (nolock) WHERE attrname = 'Ida Type'
	and componentNameId = @pseudoClientId and modified = 0),4)
SET @schedulePolicyId  = dbo.AppPlanGetEntityValue(@profileId, 'Schedule policy', default)
SET @storagePolicyId   = dbo.AppPlanGetEntityValue(@profileId, 'Storage policy',  default)
SET @subclientPolicyId = dbo.AppPlanGetEntityValue(@profileId, IIF(@type = 2, 'Subclient policy 2', IIF(@type=3, 'Subclient policy 3', 'Subclient policy 4')), default)
	--Set DLP properties on client if DLP feature is selected in Plan.
	IF EXISTS(	SELECT  1
                FROM    UMPermissions permission INNER JOIN
                        UMRolesPermissions roleToPermissionMap ON roleToPermissionMap.permissionId =  permission.id
WHERE       roleToPermissionMap.roleId = dbo.AppPlanGetEntityValue(@profileId, 'Feature',  default)
				        AND permission.permissionName = 'DLP'
    ) BEGIN
		IF EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = @pseudoclientId AND attrName = 'enableDLP' AND modified = 0)
			UPDATE APP_ClientProp SET attrVal = '1' WHERE componentNameId = @pseudoclientId AND attrName = 'enableDLP' AND attrVal != '1' AND modified = 0
		ELSE
			INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			VALUES(@pseudoclientId, 'enableDLP', 2, '1', @nowTime, 0 ,0)
		IF EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = @pseudoclientId AND attrName = 'dlpEnableAutomaticDecryption' AND modified = 0)
			UPDATE APP_ClientProp SET attrVal = '0' WHERE componentNameId = @pseudoclientId AND attrName = 'dlpEnableAutomaticDecryption' AND attrVal != '0' AND modified = 0
		ELSE
			INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			VALUES(@pseudoclientId, 'dlpEnableAutomaticDecryption', 2, '0', @nowTime, 0 ,0)
		IF EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = @pseudoclientId AND attrName = 'dlpEnableClientKeys' AND modified = 0)
			UPDATE APP_ClientProp SET attrVal = '1' WHERE componentNameId = @pseudoclientId AND attrName = 'dlpEnableClientKeys' AND attrVal != '1' AND modified = 0
		ELSE
			INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			VALUES(@pseudoclientId, 'dlpEnableClientKeys', 2, '1', @nowTime, 0 ,0)
		IF EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = @pseudoclientId AND attrName = 'dlpStolen' AND modified = 0)
			UPDATE APP_ClientProp SET attrVal = '0' WHERE componentNameId = @pseudoclientId AND attrName = 'dlpStolen' AND attrVal != '0' AND modified = 0
		ELSE
			INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			VALUES(@pseudoclientId, 'dlpStolen', 2, '0', @nowTime, 0 ,0)
		IF EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = @pseudoclientId AND attrName = 'dlpMinFileAgeMins' AND modified = 0)
			UPDATE APP_ClientProp SET attrVal = '5' WHERE componentNameId = @pseudoclientId AND attrName = 'dlpMinFileAgeMins' AND attrVal != '5'  AND modified = 0
		ELSE
			INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			VALUES(@pseudoclientId, 'dlpMinFileAgeMins', 10, '5', @nowTime, 0 ,0)
		IF EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = @pseudoclientId AND attrName = 'dlpScanIntervalMins' AND modified = 0)
			UPDATE APP_ClientProp SET attrVal = '15' WHERE componentNameId = @pseudoclientId AND attrName = 'dlpScanIntervalMins' AND attrVal != '15' AND modified = 0
		ELSE
			INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			VALUES(@pseudoclientId, 'dlpScanIntervalMins', 10, '15', @nowTime, 0 ,0)
		IF EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = @pseudoclientId AND attrName = 'dlpUnlockMethod' AND modified = 0)
			UPDATE APP_ClientProp SET attrVal = '0' WHERE componentNameId = @pseudoclientId AND attrName = 'dlpUnlockMethod' AND attrVal != '0' AND modified = 0
		ELSE
			INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			VALUES(@pseudoclientId, 'dlpUnlockMethod', 10, '0', @nowTime, 0 ,0)
		IF EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = @pseudoclientId AND attrName = 'dlpContents' AND modified = 0)
			UPDATE APP_ClientProp SET attrVal = ';' WHERE componentNameId = @pseudoclientId AND attrName = 'dlpContents' AND attrVal != ';' AND modified = 0
		ELSE
			INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			VALUES(@pseudoclientId, 'dlpContents', 1, ';', @nowTime, 0 ,0)
		IF EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = @pseudoclientId AND attrName = 'dlpFilters' AND modified = 0)
			UPDATE APP_ClientProp SET attrVal = '**\.edgedrive.cache;*.app;*.bat;*.conf;*.dll;*.dmg;*.exe;*.ini;*.lnk;*.plist;*.rc;*.tmp;.DS_Store;.localized;~$*;' WHERE componentNameId = @pseudoclientId AND attrName = 'dlpFilters' AND attrVal != '**\.edgedrive.cache;*.app;*.bat;*.conf;*.dll;*.dmg;*.exe;*.ini;*.lnk;*.plist;*.rc;*.tmp;.DS_Store;.localized;~$*;' AND modified = 0
		ELSE
			INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			VALUES(@pseudoclientId, 'dlpFilters', 1, '**\.edgedrive.cache;*.app;*.bat;*.conf;*.dll;*.dmg;*.exe;*.ini;*.lnk;*.plist;*.rc;*.tmp;.DS_Store;.localized;~$*;', @nowTime, 0 ,0)
		SET @pushDLPConfig = 1
	END
	--associate subclient policy to the default backupset
	DECLARE @currenttime INT = [dbo].getunixtime(GetUTCDate())
	DECLARE @backupsetid INT = 0
	DECLARE @scid INT = 0
	DECLARE @versionsNum INT = 0
	SELECT @backupsetid = APP.backupset, @scId = APP.id
	FROM APP_Application APP
	INNER JOIN APP_BackupSetName BS ON BS.id =  APP.backupset and (BS.status & 8) <> 0
	where clientId = @pseudoClientId and (subclientStatus & 8) <> 0
	-- Below 2 statements is due to the bug in AppAssocSubClientPolicy. It create 2 duplicate entry in db during re-association.
	UPDATE APP_SubClientProp
	SET modified = @currenttime
	WHERE componentNameId = @scId AND modified = 0 AND attrName='Associated subclient Policy'
	UPDATE APP_BackupSetProp
	SET modified = @currenttime
	WHERE componentNameId = @backupsetid AND modified = 0 AND attrName='Associated subclient Policy'
	DECLARE @tempRC table (rc INT)
	insert into @tempRC
	EXEC AppAssocSubClientPolicy @backupsetid,@subclientPolicyId,@currenttime
	IF (SELECT rc from @tempRC) <> 1
	BEGIN
		-- GENERATE ERROR
		SET @errorCode = 2
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2844 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		GOTO GENERATE_OUTPUT
	END
	-- BEGIN Enable Cloud Mode for Laptop plan
DECLARE @bCloudModeEnabled INT = dbo.AppPlanGetEntityValueV2(@planId, 'Cloud Mode Enabled', default)
	IF @bCloudModeEnabled = 1 OR @bCloudModeEnabled = 0
	BEGIN
		EXEC AppPlanSetCloudLaptop @planId, @userId, @pseudoClientId, @bCloudModeEnabled, @errorCode OUTPUT, @errorString OUTPUT
	END
	--END Enable Cloud Mode for Laptop plan
	--	-- Get StoragePolicy from the plan rules (if any) and update App_application table
		-- Update only if PlanRuleEvaluateStoragePolicyForEntityV2 returns other than plan's default storagePolicy.
	IF @elasticStoragePolicyId <> @storagePolicyId -- Not equal means it is elastic plan
	BEGIN
		UPDATE App_Application SET dataArchGrpId = @elasticStoragePolicyId, logArchGrpID = @elasticStoragePolicyId WHERE id = @scId AND dataArchGrpId <> @elasticStoragePolicyId
	END
-- Archiving Feature Push Install Software
	IF EXISTS(	SELECT  1
                FROM    UMPermissions permission INNER JOIN
                        UMRolesPermissions roleToPermissionMap ON roleToPermissionMap.permissionId =  permission.id
WHERE       roleToPermissionMap.roleId = dbo.AppPlanGetEntityValue(@profileId, 'Feature',  default)
				        AND permission.permissionName = 'Archiving'
    ) AND
( SELECT dbo.AppPlanGetEntityValueV2(@profileId, 'Forced Archiving', default)) = 1
	BEGIN
DECLARE @archivingPkgId INT = 753  /*WIN INSTALL PACKAGE ID*/
		DECLARE @i_osType INT = 1 /* 1-Windows, 2-UNIX*/
		DECLARE @pkgInstalled INT = 0
		IF EXISTS( SELECT 1 FROM simInstalledPackages
					WHERE simPackageID = @archivingPkgId AND ClientId = @physicalClientId ) OR dbo.scgGetClientOSType(@physicalClientId) != @i_osType
		BEGIN
			SET @pushInstallArchiving = 0
			DECLARE @workQueueParam NVARCHAR(MAX) =  CONVERT ( NVARCHAR(MAX), ( SELECT SC.id AS '@subclientID'
														FROM APP_Application SC
														WHERE SC.clientId = @physicalClientId
AND SC.subclientStatus & 0x00008 = 0x00008
AND SC.subclientStatus & 0x00010 != 0x00010 FOR XML PATH('TMMsg_SubclientChangeReq'), TYPE) )
			INSERT INTO @workQOutPutTbl
			EXEC AppWorkQueueSubmitRequest 7/*WORK_TOKEN_SUBCLIENT_CONTENT*/, 0, 0, @physicalClientId, 0, @workQueueParam
			SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
		END
		ELSE
		BEGIN
			SET @pushInstallArchiving = 1
			SET @clientInstallPkgReq = (SELECT 0 AS'@checkAndRemoveInstalledPackage',(
									SELECT @physicalClientId AS 'client/@clientId', @archivingPkgId AS 'packageInfoList/@packageId'
									FOR XML PATH('reqList'), TYPE)
									FOR XML PATH('JobManager_ClientPackageReqList'), TYPE)
		END
		UPDATE APP_SubClientProp SET modified = @nowTime
			WHERE componentNameId = @scId AND modified = 0
AND attrName IN ('Is Archive Retention Mode Enabled','User deleted stubs expiration days','Turbo Mode Enable Stubbing')
AND cs_attrName IN (CHECKSUM(N'Is Archive Retention Mode Enabled'), CHECKSUM(N'User deleted stubs expiration days'), CHECKSUM(N'Turbo Mode Enable Stubbing'))
		INSERT INTO APP_SubClientProp VALUES
( @scId, 'Is Archive Retention Mode Enabled' , 7, 1 , @nowTime, 0, 0),
( @scId, 'User deleted stubs expiration days', 7, 730 , @nowTime, 0, 0),
( @scId, 'Turbo Mode Enable Stubbing' , 2, 1 , @nowTime, 0, 0)
		--Updating Ida properties
		INSERT INTO APP_IDAProp
SELECT AG.id,'Enable Archive' , 2, 1 , @nowTime, 0, 0
				FROM APP_IDAName AG
				WHERE AG.appTypeId IN (
					select appTypeId from APP_AppTypeGroupAssoc where appGroupId IN (57, 34) /*APPGRP_WindowsFileSystemIDA, APPGRP_UnixFileSystem*/
				)
				AND AG.clientId = @physicalClientId
SELECT AG.id,'Use Archiver Driver' , 2, 1 , @nowTime, 0, 0
				FROM APP_IDAName AG
				WHERE AG.appTypeId IN (
					select appTypeId from APP_AppTypeGroupAssoc where appGroupId = 34 /*APPGRP_UnixFileSystem*/
				)
				AND AG.clientId = @physicalClientId
	END
DECLARE @clientGroupId INT = dbo.AppPlanGetEntityValueV2(@planId, 'Assigned client group', 2)
	IF @userId <> 0
	BEGIN
		DECLARE @is_clientLocked INT = ISNULL((SELECT CASE attrVal
WHEN  'a45fabb9712142ea42da80d2c0314cf1f871cea2571f6bda4152f645e2424b592f0ac7691aec175a'  THEN 1
                                                        ELSE 0
                                                                  END FROM APP_ClientProp WHERE componentNameId=@physicalClientId
AND attrName='7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807' and modified=0),0)
		-- if physical client has same owner set, Remove the current owner
		--if new or old style clear from both tables only for the physical client
		IF @pseudoClientId <> @physicalClientId
		BEGIN
			IF (dbo.isNewSecurity() = 0)
				DELETE FROM UMUserandGroupEntityAssociation
				WHERE objectid=@physicalClientId AND entityType = 2009
				and ((userId = @userid) OR (@is_clientLocked=0))
			ELSE
DELETE FROM UMOwners WHERE entityId=@physicalClientId AND entityType = 3
				and ((userOrGroupId = @userid) OR (@is_clientLocked=0)) AND isUser = 1
		END
		IF ((@clientGroupId IS NOT NULL) AND (@clientGroupId > 0))
		BEGIN
			-- Refresh to associate the client to the smart client group.
			EXEC AppSCGUpdateClient @userId, @pseudoClientId, @clientGroupId
EXEC sec_populateCache_OneEntity @userId, 3, @pseudoClientId, 0,0,0,0,1
		END
	END
	ELSE
	BEGIN
		IF ((@clientGroupId IS NOT NULL) AND (@clientGroupId > 0))
		BEGIN
			-- Refresh to associate the client to the smart client group.
			EXEC AppSCGUpdateClient 1, @pseudoClientId, @clientGroupId
		END
	END
	-- Adding this check so that two OSC Tokens don't get pushed in case of Archiving Feature enabled. JMPushPackages Code already pushes for this.
	IF @pushInstallArchiving = 0
	BEGIN
		--Push OSC token
		INSERT INTO @workQOutPutTbl
		EXEC AppWorkQueueSubmitRequest 4, 0, 0, @physicalClientId, 0, '' -- WORK_TOKEN_OSC
		SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
	END
	-- MR : 164299 - Push DLP workqueue if enabled via plan.
	IF @pushDLPConfig = 1
	BEGIN
		DELETE FROM @workQOutPutTbl
		INSERT INTO @workQOutPutTbl
		EXEC AppWorkQueueSubmitRequest 11, 0, 0, @physicalClientId, 0, '' -- WORK_TOKEN_DLP_PUSH_CONFIG
		SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
	END
	IF @pushInstallArchiving = 1
	BEGIN
		EXEC JMPushPackagesWithOutputArg @clientInstallPkgReq, @clientInstallPkgResp output
	END
	-- Adding Activation user property
	DECLARE @attributeVal NVARCHAR (2048)
SET @attributeVal = (SELECT attrVal from App_ClientProp where attrName = 'Activated User Id' AND componentNameId = @pseudoClientId and modified=0)
	IF @attributeVal IS NOT NULL
	BEGIN
		IF @attributeVal <> @userId
		BEGIN
			UPDATE App_ClientProp SET attrVal = @userId
WHERE attrName = 'Activated User Id' and componentNameId = @pseudoClientId and modified=0
		END
	END
	ELSE
	BEGIN
		INSERT INTO App_ClientProp VALUES
		--(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
(@pseudoClientId,'Activated User Id',10,@userId,@nowTime,0,0)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
            SET @errorCode = ERROR_NUMBER()
			SET @errorString = 'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
END  CATCH
GENERATE_OUTPUT:
	SET @o_errorCode  = @errorCode
	SET @o_errorString  = @errorString
	IF (@isFromCPP = 1)
	BEGIN
		SELECT @errorCode, @errorString
	END
GO

IF EXISTS (select * from GxQscripts where name = 'AppActivateLaptop')
	delete from GxQscripts where name = 'AppActivateLaptop'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppActivateLaptop')
	delete from GXDBVersions where aliasname = 'AppActivateLaptop'
GO

insert into GXDBVersions values(2, 'AppActivateLaptop',  '00000000000000000000', 'AppActivateLaptop', '00000000000000000000')
GO

