

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppACCreateOrganizationDefaultEntities.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppACCreateOrganizationDefaultEntities()
--  | Description:  Create default client group, smart client group for the company
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppACCreateOrganizationDefaultEntities.sp,v $ $Id: AppACCreateOrganizationDefaultEntities.sp,v 1.1.2.14 2020/05/05 17:35:22 jswaminathan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppACCreateOrganizationDefaultEntities')
BEGIN
	print '>>> Drop Stored Procedure: AppACCreateOrganizationDefaultEntities <<<'
	drop procedure AppACCreateOrganizationDefaultEntities
END
IF EXISTS (select * from GxQscripts where name='AppACCreateOrganizationDefaultEntities')
	delete from GxQscripts where name = 'AppACCreateOrganizationDefaultEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppACCreateOrganizationDefaultEntities')
	delete from GXDBVersions where aliasname = 'AppACCreateOrganizationDefaultEntities'
GO
print '... Creating Procedure: AppACCreateOrganizationDefaultEntities'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppACCreateOrganizationDefaultEntities
  @autherUserId INTEGER,
  @origCCId INT=0,
  @companyName nvarchar(max),
  @errorCode INT OUTPUT,
  @errorString NVARCHAR(MAX)				    OUTPUT
AS
SET NOCOUNT ON
DECLARE @nowTime integer
SET @nowTime =  dbo.GetUnixTime (GetUTCdate())
DECLARE @clientGroupName NVARCHAR(512)	= @companyName
DECLARE @clientGroupFlag int = 0x1000  |  1073741824
EXEC AppGetUniqueEntityName 28, @clientGroupName, @autherUserId, @clientGroupName OUTPUT
	DECLARE @scgDesc NVARCHAR(MAX) =  N'Clients belonging to ' + @companyName
	INSERT INTO [APP_ClientGroup]
				([name]
				,[description]
				,[flag]
				,[status]
				,[userId]
				,[refTime]
				,[modified]
				,[fwPorts]
				,[origCCId]
				,[GUID])
			VALUES
				(@clientGroupName
				,@scgDesc
				,@clientGroupFlag
				,0
				,@autherUserId
				,@nowTime
				,@nowTime
				,''
				,@origCCId
				,NEWID())
	DECLARE @companySCGId INT = SCOPE_IDENTITY()
	DECLARE @companyCGQuery NVARCHAR(MAX)
	DECLARE @companyRuleXml VARCHAR(MAX)
    DECLARE @companyAliasName nvarchar(255)
	--SCG_PKID_CLIENT_PROP=2=prodID / SCG_PKID_USER_CLIENT_OWNER=11=prodId
    -- SCG_PKID_COMPANY_INSTALLED_CLIENT_ASSOCIATIONS - 55
    -- SCG_PKID_COMPANY_CLIENT_ASSOCIATIONS - 44
	DECLARE @companyId int
    SELECT @companyId=id, @companyAliasName=domainName from UMDSProviders where hostName=@companyName
	SET @companyRuleXml = '<scgRule op="1"><rules><rule op="0"><rules><rule filterID="100" propID="44" propType="4" secValue="' + @companyAliasName + '" value="' + cast( @companyId as nvarchar(255)) + '"/></rules></rule></rules><rules><rule op="0"><rules><rule filterID="100" propID="55" propType="4" secValue="' + @companyAliasName + '" value="' + cast( @companyId as nvarchar(255)) + '"/></rules></rule></rules></scgRule>'
	DECLARE @scgExitCode INT = 0
	DECLARE @scgExitMsg VARCHAR(1024) = ''
	EXEC APPSCGV2GenerateQueryParams @companyRuleXml, @scgExitCode OUTPUT, @scgExitMsg OUTPUT, @companyCGQuery OUTPUT
	IF (@scgExitCode <> 0)
	BEGIN
		SET @errorCode = @scgExitCode
		SET @errorString = @scgExitMsg
		GOTO EXIT_ERROR
	END
	INSERT INTO APP_SCGRULE (scgId, ruleXml, ruleQuery, ownerId, created, modified)
					values
						(@companySCGId,
						@companyRuleXml,
						@companyCGQuery,
						1,
						0,
						'0')
	DECLARE @mspRoleId INT
SET @mspRoleId = (SELECT id FROM UMRoles WHERE flags & 16 <> 0)
	IF ((@companySCGId IS NOT NULL) AND (@mspRoleId IS NOT NULL))
	BEGIN
EXEC sec_setCreatorForEntity @autherUserId, @mspRoleId, '', @errorCode OUTPUT, @errorString OUTPUT, 28, @companySCGId
	END
IF NOT EXISTS(SELECT Id FROM App_CompanyProp WHERE componentNameId = @companyId AND attrName = 'Associated Smart Client Group'  AND modified = 0) --'Associated Smart Client Group'
	BEGIN
		INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@companyId, 'Associated Smart Client Group', 7, @companySCGId, @nowTime, 0)
EXEC sec_setCompanyIdForEntity 28, @companySCGId, @companyId
	END
EXIT_ERROR:
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppACCreateOrganizationDefaultEntities')
	delete from GxQscripts where name = 'AppACCreateOrganizationDefaultEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppACCreateOrganizationDefaultEntities')
	delete from GXDBVersions where aliasname = 'AppACCreateOrganizationDefaultEntities'
GO

insert into GXDBVersions values(2, 'AppACCreateOrganizationDefaultEntities',  '00010001000200140000', 'AppACCreateOrganizationDefaultEntities', '00010001000200140000')
GO

