

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppACAssociateUserToDefaultPlan.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppACAssociateUserToDefaultPlan()
--  | Description:  Allows for Add/Edit of company settings
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppACAssociateUserToDefaultPlan.sp,v $ $Id: AppACAssociateUserToDefaultPlan.sp,v 1.1.2.6 2018/03/27 08:41:55 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppACAssociateUserToDefaultPlan <<<'

IF EXISTS (select * from sysobjects where name='AppACAssociateUserToDefaultPlan')
	drop procedure AppACAssociateUserToDefaultPlan
IF EXISTS (select * from GxQscripts where name='AppACAssociateUserToDefaultPlan')
	delete from GxQscripts where name = 'AppACAssociateUserToDefaultPlan'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppACAssociateUserToDefaultPlan')
	delete from GXDBVersions where aliasname = 'AppACAssociateUserToDefaultPlan'
GO
print '... Creating Procedure: AppACAssociateUserToDefaultPlan'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppACAssociateUserToDefaultPlan
  @xmltext XML,
  @errorCode INT OUTPUT,
  @errorString NVARCHAR(MAX)				    OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	-- local variables
	DECLARE @currentTime int  = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @userPlan table(u_Id int , planId int default 0, organizationId int default 0, defaultPlanId int default 0, defaultPlanGroupId int default 0)
	INSERT INTO @userPlan (u_Id)
	(SELECT R.ref.value('@userId', 'INT')
		FROM @xmltext.nodes('Api_UpdatePlanUsers/users/user') R(ref))
	-- check for direct plan association
	UPDATE @userPlan set planId=CAST(attrVal AS INT)
FROM UMUsersProp WITH(NOLOCK) WHERE componentNameId = u_Id AND attrName = 'Associated Plan' AND modified=0
	--check user group level plan association
	UPDATE @userPlan set planId=CAST(componentNameId AS INT)
                       FROM    App_PlanProp  p
					   INNER JOIN UMUserGroup ug on P.attrVal=UG.groupId
WHERE  p.attrName IN ('Associated internal user group', 'Associated external user group') AND ug.userId=u_Id and planId=0
	--delete all that has plan associated
	DELETE FROM @userPlan WHERE planId>0
	UPDATE @userPlan SET organizationId = (select dbo.AppGetOrganizationForUser(u_Id))
	UPDATE @userPlan SET defaultPlanId = attrVal
	FROM APP_CompanyProp
WHERE componentNameId=organizationId AND attrName='Default Laptop Plan'
UPDATE @userPlan set defaultPlanGroupId = dbo.AppPlanGetEntityValue(defaultPlanId, 'Assigned user group', default)
	--Add user property - Associated plan
	INSERT INTO UMUsersProp(componentNameId, attrName, attrType, attrVal, created, modified)
SELECT  u_Id, 'Associated Plan', 7, defaultPlanId, @currentTime,0
        FROM    @userPlan
        WHERE   defaultPlanId > 0
	--Associate user to the plan user group
	INSERT INTO UMUserGroup (userId, groupId, flag)
	SELECT u_Id,defaultPlanGroupId , 0 from @userPlan where defaultPlanId>0
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode= ERROR_NUMBER()
		SET @errorString = ERROR_MESSAGE()
END CATCH
PROC_EXIT:
	SELECT @errorCode,@errorString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppACAssociateUserToDefaultPlan')
	delete from GxQscripts where name = 'AppACAssociateUserToDefaultPlan'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppACAssociateUserToDefaultPlan')
	delete from GXDBVersions where aliasname = 'AppACAssociateUserToDefaultPlan'
GO

insert into GXDBVersions values(2, 'AppACAssociateUserToDefaultPlan',  '00010001000200060000', 'AppACAssociateUserToDefaultPlan', '00010001000200060000')
GO

