

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AlrmGetAllAlarms.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AlrmGetAllAlarms.sp,v $ $Id: AlrmGetAllAlarms.sp,v 1.4.42.1 2018/03/27 08:59:21 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AlrmGetAllAlarms <<<'

IF EXISTS (select * from sysobjects where name='AlrmGetAllAlarms')
	drop procedure AlrmGetAllAlarms
IF EXISTS (select * from GxQscripts where name='AlrmGetAllAlarms')
	delete from GxQscripts where name = 'AlrmGetAllAlarms'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AlrmGetAllAlarms')
	delete from GXDBVersions where aliasname = 'AlrmGetAllAlarms'
GO
print '... Creating Procedure: AlrmGetAllAlarms'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AlrmGetAllAlarms
  @i_userId INT,
  @i_commCellGUID NVARCHAR(64) = NULL
AS
  DECLARE @o_alarmId INTEGER;
  DECLARE @o_reportName NVARCHAR(1024);
  DECLARE @o_alarmName NVARCHAR(1024);
  DECLARE @o_extendedProps XML;
  DECLARE @o_CommCellId INTEGER;
  DECLARE @o_flags INTEGER;
  DECLARE @o_email NVARCHAR(2048);
  DECLARE @o_userLogin NVARCHAR(1024);
BEGIN
SET NOCOUNT ON
	DECLARE @isUserAdmin int
	EXECUTE sec_isUserAdmin   @i_userid = @i_userId ,@o_isUserAdmin = @isUserAdmin  OUTPUT
	SELECT	AP.AlarmId, ISNULL(AP.reportName, 'Health Report') As "Report", ISNULL(AP.displayName, '') AS "Alarm Name", AP.extendedProps "Props", AP.CommCellGUID "CommCell GUID", CASE WHEN AP.flags & 1 = 0 THEN 'Yes' ELSE 'No' END AS "Status", AP.email AS "Email", U.login "Created By"
	FROM	CustomAlarmProps AP
			INNER JOIN UMUsers U
				ON AP.userId = U.id
	WHERE (@i_commCellGUID IS NULL OR @i_commCellGUID = AP.CommCellGUID)
		AND	(U.id = @i_userId OR ISNULL(@i_userId, 0) = 0 OR @isUserAdmin = 1)
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AlrmGetAllAlarms')
	delete from GxQscripts where name = 'AlrmGetAllAlarms'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AlrmGetAllAlarms')
	delete from GXDBVersions where aliasname = 'AlrmGetAllAlarms'
GO

insert into GXDBVersions values(2, 'AlrmGetAllAlarms',  '00010004004200010000', 'AlrmGetAllAlarms', '00010004004200010000')
GO

