

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AlrmAddFromTemplate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Vibhor Mishra
--	Date:   03/31/2017
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AlrmAddFromTemplate.sp,v $ $Id: AlrmAddFromTemplate.sp,v 1.1.2.10 2018/12/31 23:22:31 vmishra Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AlrmAddFromTemplate')
BEGIN
	print '>>> Drop Stored Procedure: AlrmAddFromTemplate <<<'
	drop procedure AlrmAddFromTemplate
END
IF EXISTS (select * from GxQscripts where name='AlrmAddFromTemplate')
	delete from GxQscripts where name = 'AlrmAddFromTemplate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AlrmAddFromTemplate')
	delete from GXDBVersions where aliasname = 'AlrmAddFromTemplate'
GO
print '... Creating Procedure: AlrmAddFromTemplate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AlrmAddFromTemplate
  @i_userId INT,
  @i_inXML XML=NULL
AS
  DECLARE @o_responseXML XML;
BEGIN
SET NOCOUNT ON
    DECLARE @o_errorCode INT = 0
    DECLARE @o_errorMessage NVARCHAR(1024) = ''
	DECLARE @o_errorResponse XML = NULL
	DECLARE @alarmPropsXML XML = NULL
	DECLARE @templateId INT = NULL
	DECLARE @commcellID VARCHAR(32) = NULL
	DECLARE @alarmReqXML XML  = NULL
	DECLARE @queryId INT = NULL
	DECLARE @email VARCHAR(MAX) = NULL
	DECLARE @username VARCHAR(MAX) = NULL
	DECLARE @alarmURL VARCHAR(MAX) = NULL
	DECLARE @reportGUID VARCHAR(MAX)
	DECLARE @alarmName VARCHAR(MAX)
	DECLARE @entityID	VARCHAR(32) = NULL
	DECLARE @entityName VARCHAR(MAX)
	DECLARE @reportId INT = -1
	DECLARE @reportURL nvarchar(max) = NULL
	DECLARE @scheduleInfo nvarchar(max) = NULL
	DECLARE @manageURL nvarchar(max) = NULL
	DECLARE @reportUniqId nvarchar(max) = NULL
	DECLARE @isCustomReport INT = 0
	DECLARE @flags INT = 0
	DECLARE @isWorldWide INT = 0
	DECLARE @isIndividual INT = 0
	DECLARE @isCCGroup INT = 0
	DECLARE @isCompany INT = 0
	DECLARE @webServerClientId INT = 0
	DECLARE @webServerClient varchar(max) = NULL
	DECLARE @i_reportURL nvarchar(max)
	SELECT @webServerClientId = X.n.value('@webServerClientId','INT'),
			@commcellID = X.n.value('(alarmProps/commcellInfo/@commCellId)[1]', 'VARCHAR(32)'),
			@templateId = X.n.value('(alarmProps/@templateId)[1]', 'INT'),
			@i_reportURL = X.n.value('(alarmProps/@reportURL)[1]', 'nvarchar(max)'),
			@entityID = (CASE WHEN ISNULL(X.n.value('@commUniId', 'INT'),0) > 0 THEN X.n.value('@commUniId', 'INT')
							  WHEN ISNULL(X.n.value('(alarmProps/@ccGroupId)[1]', 'INT'),0) > 0 THEN X.n.value('(alarmProps/@ccGroupId)[1]', 'INT')
							  WHEN ISNULL(X.n.value('(alarmProps/@companyId)[1]', 'INT'),0) > 0 THEN X.n.value('(alarmProps/@companyId)[1]', 'INT')
						END),
			@entityName = ISNULL(X.n.value('(alarmProps/commcellInfo/@commCellName)[1]','nvarchar(max)'), X.n.value('(alarmProps/@alarmName)[1]', 'nvarchar(max)'))
	FROM @i_inXML.nodes('CVGui_AlarmRequest') X(n)
	DECLARE @startingIndex INT =  charindex('//',@i_reportURL ,0) + 2
	DECLARE @endingIndex INT =  charindex('/',@i_reportURL ,@startingIndex)
	DECLARE @webserverClientName nvarchar(255) = substring(@i_reportURL ,0, @endingIndex)
	BEGIN TRY
		SELECT @flags = flags,
			   @alarmPropsXML = alarmProps,
			   @reportGUID=reportGUID
			FROM CustomAlarmTemplates
			WHERE templateId = @templateId
		IF @flags & 2 = 2
			SET @isWorldWide = 1
		ELSE IF @flags & 4 = 4
			SET @isIndividual = 1
		ELSE IF @flags & 8 = 8
			SET @isCCGroup = 1
		ELSE IF @flags & 16 = 16
			SET @isCompany = 1
		IF ISNULL(@reportGUID, '') <> ''
			SET @isCustomReport = 1
		IF EXISTS(SELECT * FROM CustomAlarmProps A
						INNER JOIN CustomAlarmTemplates T
							ON ISNULL(A.extendedProps.value('(alarmProps/@templateId)[1]', 'INT'), -1) = T.templateId AND A.userId = @i_userId AND T.templateId = @templateId
					WHERE ((@isIndividual = 1 AND (ISNULL(A.extendedProps.value('(alarmProps/commcellInfo/@commCellId)[1]', 'VARCHAR(32)'),'N/A') = @commcellID
													OR ISNULL(A.extendedProps.value('(alarmProps/@commUniId)[1]', 'VARCHAR(32)'),'N/A') = @entityID))
							OR (@isCCGroup = 1 AND ISNULL(A.extendedProps.value('(alarmProps/@ccGroupId)[1]', 'INT'), -1) = @entityID)
							OR (@isCompany = 1 AND ISNULL(A.extendedProps.value('(alarmProps/@companyId)[1]', 'INT'), -1) = @entityID)
							OR (@isWorldWide = 1 AND T.flags & 2 = 2)))
			RAISERROR('Alert already exist with this template.',16,1);
		SELECT @email= email, @username = name FROM UMUsers WHERE id = @i_userId
		SELECT @alarmURL = A.n.value('@alarmURL','nvarchar(max)'),
			   @reportURL = A.n.value('@reportURL','nvarchar(max)'), @scheduleInfo = A.n.value('@scheduleInfo','nvarchar(max)'),
			   @alarmName = A.n.value('@alarmName','nvarchar(max)'),
			   @manageURL = A.n.value('@manageURL','nvarchar(max)'),
			   @reportUniqId = A.n.value('@reportUniqId','nvarchar(max)')
		FROM @alarmPropsXML.nodes('alarmProps') A(n)
		-- Replace webserverclientName (webconsole hostname) in the following URL fields
		SET @alarmURL = REPLACE(@alarmURL, '$WEBCONSOLE_HOSTNAME$', @webserverClientName)
		SET @reportURL = REPLACE(@reportURL, '$WEBCONSOLE_HOSTNAME$', @webserverClientName)
		SET @manageURL = REPLACE(@manageURL, '$WEBCONSOLE_HOSTNAME$', @webserverClientName)
		--IF @isWorldWide = 0 AND @isCustomReport = 1
		--BEGIN
		--	DECLARE @ind INT=  CHARINDEX('componentName%3D',@alarmURL)
		--	DECLARE @len INT = CHARINDEX('%26',@alarmURL, @ind) - (@ind + LEN('componentName%3D'))
		--	SET @alarmURL = @alarmURL + '%26'+ SUBSTRING(@alarmURL,@ind+16,@len)+'.filter.commUniId%3D'+CAST(@entityID AS VARCHAR(32))
		--END
		IF @isWorldWide = 0 AND @isCustomReport = 0
		BEGIN
			SET @alarmURL = REPLACE(@alarmURL, '$ENTITY_ID$', @entityID)
			SET @reportURL = REPLACE(@reportURL, '$ENTITY_ID$', @entityID)
			SET @manageURL = REPLACE(@manageURL, '$ENTITY_ID$', @entityID)
			SET @reportUniqId = REPLACE(@reportUniqId, '$ENTITY_ID$', @entityID)
		END
		IF @isWorldWide = 0
		BEGIN
			IF @isIndividual = 1
			BEGIN
				DECLARE @hexCommcellID varchar(32)
				SET @hexCommcellID = dbo.ConvertBigIntToHexStr(@commcellID)
				SET @alarmName = REPLACE(@alarmName, '$ENTITY_NAME$', @entityName+ '('+@hexCommcellID+')')
				IF @alarmPropsXML.exist('(/alarmProps/commcellInfo)') = 1
				BEGIN
					SET @alarmPropsXML.modify('replace value of (/alarmProps/commcellInfo/@commCellId)[1] with sql:variable("@commcellID")')
					SET @alarmPropsXML.modify('replace value of (/alarmProps/commcellInfo/@commCellName)[1] with sql:variable("@entityName")')
					SET @alarmPropsXML.modify('insert attribute commUniId {sql:variable("@entityID")} as last into (/alarmProps)[1]')
				END
IF @templateId IN (5, 18) -- Individual commcell monitoring page templates
				BEGIN
					DECLARE @description varchar(max)
					SELECT @description = A.n.value('@description','nvarchar(max)')
					FROM @alarmPropsXML.nodes('alarmProps') A(n)
					SET @description = REPLACE(@description, '$HEX_COMMCELLID$', @hexCommcellID)
					SET @alarmURL = REPLACE(@alarmURL, '$HEX_COMMCELLID$', @hexCommcellID)
					SET @alarmPropsXML.modify('replace value of (/alarmProps/@description)[1] with sql:variable("@description")')
				END
			END
			ELSE
			BEGIN
				SET @alarmName = REPLACE(@alarmName, '$ENTITY_NAME$', @entityName)
				IF @isCCGroup = 1
					SET @alarmPropsXML.modify('replace value of (/alarmProps/@ccGroupId)[1] with sql:variable("@entityID")')
				IF @isCompany = 1
					SET @alarmPropsXML.modify('replace value of (/alarmProps/@companyId)[1] with sql:variable("@entityID")')
			END
			SET @alarmPropsXML.modify('replace value of (/alarmProps/@alarmName)[1] with sql:variable("@alarmName")')
		END
		IF @scheduleInfo IS NOT NULL
		BEGIN
			SET @scheduleInfo = REPLACE(@scheduleInfo, '$OWNER_NAME$', @username)
			SET @scheduleInfo = REPLACE(@scheduleInfo, '$REPORT_ID$', CAST(@reportId AS VARCHAR(32)))
			SET @scheduleInfo = REPLACE(@scheduleInfo, '$USER_ID$', CAST(@i_userId AS VARCHAR(32)))
			IF @entityID IS NOT NULL
				SET @scheduleInfo = REPLACE(@scheduleInfo, '$ENTITY_ID$', @entityID)
			SET @alarmPropsXML.modify('replace value of (/alarmProps/@scheduleInfo)[1] with sql:variable("@scheduleInfo")')
		END
		IF @isCustomReport = 1
		BEGIN
			SELECT @reportId = reportId from APP_Reports WHERE guid = @reportGUID
			SET @reportURL = REPLACE(@reportURL, '$REPORT_ID$', CAST(@reportId AS VARCHAR(32)))
			SET @alarmURL = REPLACE(@alarmURL, '$REPORT_ID$', CAST(@reportId AS VARCHAR(32)))
			SET @reportUniqId = CAST(@reportId AS VARCHAR(32))
		END
		SET @alarmPropsXML.modify('replace value of (/alarmProps/@manageURL)[1] with sql:variable("@manageURL")')
		SET @alarmPropsXML.modify('replace value of (/alarmProps/@alarmURL)[1] with sql:variable("@alarmURL")')
		SET @alarmPropsXML.modify('replace value of (/alarmProps/@reportURL)[1] with sql:variable("@reportURL")')
		SET @alarmPropsXML.modify('replace value of (/alarmProps/@email)[1] with sql:variable("@email")')
		SET @alarmPropsXML.modify('replace value of (/alarmProps/@userId)[1] with sql:variable("@i_userId")')
		SET @alarmPropsXML.modify('replace value of (/alarmProps/@reportUniqId)[1] with sql:variable("@reportUniqId")')
		SET @alarmReqXML = (SELECT  0 AS '@action',
				@webServerClientId AS '@webServerClientId',
				@alarmPropsXML
		FOR XML PATH('CVGui_AlarmRequest'))
		--SELECT @alarmReqXML
		DECLARE @spResult TABLE (responseXML XML)
		declare @var nvarchar(max)
		set @var = 'DEFAULT CUSTOM RULE FOR METRICS REPORT'
		select @queryId = QueryId from NTqueryList with (nolock) where convert(xml,NTQueryList.xmlInfo).exist('App_AdditionalQueryDetails/externalQueryEntity[@queryType=2]')=1 and convert(xml,NTQueryList.xmlInfo).exist('App_AdditionalQueryDetails/externalQueryEntity[upper-case(@externalQueryName)=sql:variable("@var")]')=1
		INSERT INTO @spResult
		EXEC AlrmAddEditAlarm @i_userId, @alarmReqXML, @queryId
		SELECT @o_errorResponse = responseXML.query('(CVGui_AlarmResponse/errorResponse)[1]')
		FROM @spResult
		SELECT @o_errorCode = responseXML.value('(CVGui_AlarmResponse/errorResponse/@errorCode)[1]','INT')
		FROM @spResult
		IF @o_errorCode = 0
		BEGIN
			declare @alarmId INT = (SELECT TOP 1 responseXML.value('(/CVGui_AlarmResponse/alarmProps/@alarmId)[1]','INT') FROM @spResult)
			set @alarmPropsXML.modify('insert attribute alarmId {sql:variable("@alarmId")} as last into (/alarmProps)[1]')
		END
		DECLARE @responseXML XML = (SELECT @alarmPropsXML, @o_errorResponse
									 FOR XML PATH('CVGui_AlarmResponse'))
		SELECT @responseXML as o_responseXML
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
        SET @o_errorMessage = ERROR_MESSAGE();
		SET @o_errorCode = 1
		SET @o_responseXML = (SELECT
            @o_errorCode AS 'errorResponse/@errorCode',
            @o_errorMessage AS 'errorResponse/@errorMessage'
		FOR XML PATH(''), ROOT('CVGui_AlarmResponse'))
		SELECT @o_responseXML as o_responseXML
	END CATCH
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AlrmAddFromTemplate')
	delete from GxQscripts where name = 'AlrmAddFromTemplate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AlrmAddFromTemplate')
	delete from GXDBVersions where aliasname = 'AlrmAddFromTemplate'
GO

insert into GXDBVersions values(2, 'AlrmAddFromTemplate',  '00010001000200100000', 'AlrmAddFromTemplate', '00010001000200100000')
GO

