

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AlrmAddEditAlarm.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AlrmAddEditAlarm.sp,v $ $Id: AlrmAddEditAlarm.sp,v 1.20.2.14 2019/09/12 21:47:10 vmishra Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AlrmAddEditAlarm')
BEGIN
	print '>>> Drop Stored Procedure: AlrmAddEditAlarm <<<'
	drop procedure AlrmAddEditAlarm
END
IF EXISTS (select * from GxQscripts where name='AlrmAddEditAlarm')
	delete from GxQscripts where name = 'AlrmAddEditAlarm'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AlrmAddEditAlarm')
	delete from GXDBVersions where aliasname = 'AlrmAddEditAlarm'
GO
print '... Creating Procedure: AlrmAddEditAlarm'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AlrmAddEditAlarm
  @i_userId INT,
  @i_inXML XML = NULL,
  @i_queryId INT
AS
  DECLARE @o_responseXML XML;
BEGIN
SET NOCOUNT ON
	DECLARE @i_action INT
	DECLARE @i_webServerClientId INT
	declare @customReportId int
	declare @locale int = 0 -- this protocol doesnt have locale yet. so set it as 0 for now.
	DECLARE @o_errorCode INT
	DECLARE @o_errorMessage NVARCHAR(1024)
	DECLARE @o_alarmsList XML = NULL
	Declare @alertSeverity int = 3 -- Default set it to information.
	declare @thisAlertId		integer = 0
	declare @templateId			integer = 0
	SELECT	@i_action = T.cc.value('@action', 'INT')
	FROM	@i_inXML.nodes('/CVGui_AlarmRequest') T(cc)
	SELECT	@i_webServerClientId = T.cc.value('@webServerClientId', 'INT')
	FROM	@i_inXML.nodes('/CVGui_AlarmRequest') T(cc)
	SELECT	@customReportId = T.cc.value('@customReportId', 'INT')
	FROM	@i_inXML.nodes('/CVGui_AlarmRequest') T(cc)
	SELECT	@alertSeverity = T.cc.value('@alertSeverity', 'INT')
	FROM	@i_inXML.nodes('/CVGui_AlarmRequest/alarmProps') T(cc)
	if @alertSeverity is null
	begin
		set @alertSeverity = 3
	end
	SELECT	@templateId = T.cc.value('@templateId', 'INT')
	FROM	@i_inXML.nodes('/CVGui_AlarmRequest/alarmProps') T(cc)
	DECLARE @textAlert int = 0
	DECLARE @alarmIdsTbl	TABLE (id INT)
	declare @notifMetricsRuleIds table
	(
		ntRuleId int,
		alarmId int
	)
	declare @notifTypesList table
	(
		notifType int,
		isText int
	)
	declare @emailIdList table
	(
		email nvarchar(max),
		recipientType int
	)
	if object_id('tempdb.dbo.#alertList') is not null
	BEGIN
		DROP TABLE #alertList
	END
	CREATE TABLE #alertList (NTnotificationId integer NOT NULL)
	declare @alarmWithNoPermName nvarchar(max) = ''
	declare @alarmIdWithNoPerm int = 0
	declare @isTileBasedAlert int = 0
	declare @tileIdForAlert int = 0
	IF (@i_action = 0 Or @i_action = 1)
	begin
		Insert into @notifTypesList
		select Tbl.Col.value('@val', 'int'),0 from
		@i_inXML.nodes('CVGui_AlarmRequest/alarmProps/notificationTypesSelected') as Tbl(Col)
		delete from @notifTypesList
		where notifType is null
		if (not exists(select 1 from @notifTypesList))
		begin
			SET @o_errorCode = 1
			SET @o_errorMessage = 'Please select atleast one notification type. '
			GOTO EXIT_PROC
		end
		Update @notifTypesList
		set isText = 1
		where notifType = 4 or notifType = 8 or notifType = 32768 or notifType = 1048576
		-- Remove attribute scheduleinfo.
	end
	-- fill tile alert attribute
	IF (@i_action = 0 Or @i_action = 1)
	begin
		SELECT	@isTileBasedAlert = IsNull(T.cc.value('@isTileAlert', 'INT'),0)
		FROM	@i_inXML.nodes('/CVGui_AlarmRequest/alarmProps') T(cc)
		SELECT	@tileIdForAlert = IsNull(T.cc.value('@tileID', 'INT'),0)
		FROM	@i_inXML.nodes('/CVGui_AlarmRequest/alarmProps') T(cc)
	end
	IF ((@i_action = 2) OR (@i_action = 3) OR (@i_action = 4) OR (@i_action = 7) OR (@i_action = 8) OR (@i_action = 6))
	begin
		Insert into @notifMetricsRuleIds
		select NTNotificationQueryMapping.ntnotificationId,
			IsNull(convert(xml,NTNotificationQueryMapping.xmlInfo).value('(CVGui_QueryAdditionalInfo/externalQueryInfo/@externalQueryId)[1]','int'),0)
		from NTNotificationQueryMapping with (nolock)
		inner join NTQueryList with (nolock) on
		NTNotificationQueryMapping.queryId = NTQueryList.queryId
		where convert(xml,NTQueryList.xmlInfo).exist('App_AdditionalQueryDetails/externalQueryEntity[@queryType=2]') = 1
	end
	IF @i_action IN (2, 3, 4, 7, 10)
		INSERT INTO @alarmIdsTbl
		SELECT	T.cc.value('@val', 'INT')
		FROM	@i_inXML.nodes('/CVGui_AlarmRequest/alarmIdList') T(cc)
	SET @o_errorCode = 0
	SET @o_errorMessage = N''
	DECLARE @i_type INT
	DECLARE @i_flags INT
	DECLARE @i_email NVARCHAR(2048)
	DECLARE @i_reportName NVARCHAR(256)
	DECLARE @i_displayName NVARCHAR(256)
	DECLARE @i_alarmProps XML
	DECLARE @i_snmpDescription NVARCHAR(max)
	set @i_snmpDescription = ''
	DECLARE @i_emailCc NVARCHAR(2048)
	DECLARE @i_emailBcc NVARCHAR(2048)
	DECLARE @commUniId INT
	DECLARE @userName NVARCHAR(1024) = ''
	DECLARE @i_alarmId INT --For Edit
	IF (@i_action = 0) -- Create
	BEGIN
		IF (@i_inXML IS NULL)
		BEGIN
			SET @o_ErrorCode = 1
			SET @o_errorMessage = 'Invalid arguments. Extended properties is not valid.'
		END
		ELSE
		BEGIN
			SELECT	@i_type = T.cc.value('@type', 'INT'),
					@i_flags = T.cc.value('@flags', 'INT'),
					@i_email = T.cc.value('@email', 'nvarchar(2048)'),
					@i_reportName = T.cc.value('@reportName', 'nvarchar(128)'),
					@i_displayName = T.cc.value('@alarmName', 'nvarchar(128)'),
					@i_snmpDescription = IsNull(T.cc.value('@SNMPDescription', 'nvarchar(max)'),''),
					@i_emailCc = T.cc.value('@ccEmail', 'nvarchar(2048)'),
					@i_emailBcc = T.cc.value('@bccEmail', 'nvarchar(2048)')
			FROM	@i_inXML.nodes('/CVGui_AlarmRequest/alarmProps') T(cc)
			SET @i_alarmProps = @i_inXML.query('CVGui_AlarmRequest/alarmProps')
			SET @i_alarmProps.modify('delete (/alarmProps/@scheduleInfo)[1]')
			SET @i_email = REPLACE(@i_email, ',', ';')
			SET @i_email = REPLACE(@i_email, ' ', ';')
			SET @i_emailCc = REPLACE(@i_emailCc, ',', ';')
			SET @i_emailCc = REPLACE(@i_emailCc, ' ', ';')
			SET @i_emailBcc = REPLACE(@i_emailBcc, ',', ';')
			SET @i_emailBcc = REPLACE(@i_emailBcc, ' ', ';')
			if (@i_email is not null and len(@i_email)>0)
			begin
				Insert into @emailIdList
				SELECT Data,0 FROM SplitString(@i_email, ';')
			end
			if (@i_emailCc is not null and len(@i_emailCc)>0)
			begin
				Insert into @emailIdList
				SELECT Data,1 FROM SplitString(@i_emailCc, ';')
			end
			if (@i_emailBcc is not null and len(@i_emailBcc)>0)
			begin
				Insert into @emailIdList
				SELECT Data,2 FROM SplitString(@i_emailBcc, ';')
			end
			delete from @emailIdList
			where email is null or len(email)=0
			INSERT INTO CustomAlarmProps (CustomReportId, CommCellId, type, flags, email, userId, reportName, displayName, extendedProps)
			VALUES (0, @i_webServerClientId, @i_type, 0, @i_email, @i_userId, @i_reportName, @i_displayName, @i_alarmProps)
			SELECT @i_alarmId = @@IDENTITY
			SELECT @userName = CASE WHEN ISNULL(Name, '') = '' THEN login ELSE Name END FROM UMUsers WHERE Id = @i_userId
			UPDATE CustomAlarmProps SET extendedProps.modify('insert attribute alarmId {sql:variable("@i_alarmId")} as last into (/alarmProps)[1]') WHERE AlarmId = @i_alarmId
			UPDATE CustomAlarmProps SET extendedProps.modify('insert attribute userName {sql:variable("@userName")} as last into (/alarmProps)[1]') WHERE AlarmId = @i_alarmId
			if @i_flags is null
			begin
				UPDATE CustomAlarmProps SET extendedProps.modify('insert attribute flags {sql:variable("@i_flags")} as last into (/alarmProps)[1]') WHERE AlarmId = @i_alarmId
			END
		END
	END
	ELSE IF (@i_action = 1) -- Edit
	BEGIN
		SELECT	@i_alarmId = T.cc.value('@alarmId', 'INT')
		FROM	@i_inXML.nodes('/CVGui_AlarmRequest/alarmProps') T(cc)
		declare @existingAlarmProps xml
		declare @ownerUserId int
		select @existingAlarmProps = extendedprops, @ownerUserId = userId
		from CustomAlarmProps
		where alarmId = @i_alarmId
		-- For modification, username, description/alarm criteria/column information are taken from original xml, if description/column details set on edit request, we need to fill that
		declare @alarmCondition nvarchar(max) = ''
		declare @alarmColList xml = ''
		set @userName = ''
		select @userName = T.cc.value('@userName', 'nvarchar(max)'),
			@alarmCondition = T.cc.value('@description', 'nvarchar(max)'),
			@alarmColList = T.cc.query('alarmColList')
		from @existingAlarmProps.nodes('alarmProps') T(cc)
		--check if description/columList set in edit alarm request
		declare @newAlarmCondition nvarchar(max) = ''
		declare @newAlarmColList xml = ''
		select
			@newAlarmCondition = T.cc.value('@description', 'nvarchar(max)'),
			@newAlarmColList = T.cc.query('alarmColList')
		from @i_inXML.nodes('CVGui_AlarmRequest/alarmProps') T(cc)
		SET @i_alarmProps = @i_inXML.query('CVGui_AlarmRequest/alarmProps')
		SET @i_alarmProps.modify('delete (/alarmProps/@scheduleInfo)[1]')
		SET @i_alarmProps.modify('delete (/alarmProps/@userName)[1]')
		SET @i_alarmProps.modify('insert (attribute userName {sql:variable("@userName")}) into (/alarmProps)[1]')
		if isnull(@newAlarmCondition,'') = ''
		begin
			SET @i_alarmProps.modify('delete (/alarmProps/@description)[1]')
			SET @i_alarmProps.modify('insert (attribute description {sql:variable("@alarmCondition")}) into (/alarmProps)[1]')
		end
		if @newAlarmColList is null or @newAlarmColList.exist('alarmColList') = 0
		begin
			SET @i_alarmProps.modify('delete /alarmProps/alarmColList/*[2]')
			SET @i_alarmProps.modify('insert sql:variable("@alarmColList") into (/alarmProps)[1]')
		end
		select @i_queryId = NTNotificationQueryMapping.QueryId , @thisAlertId = NTNotificationQueryMapping.NTNotificationId
		from NTNotificationQueryMapping
		inner join NTQueryList on NTNotificationQueryMapping.QueryId = NTQueryList.QueryId
		where IsNull(convert(xml,NTNotificationQueryMapping.xmlInfo).value('(CVGui_QueryAdditionalInfo/externalQueryInfo/@externalQueryId)[1]','int'),0) = @i_alarmId and
        IsNull(convert(xml,NTQueryList.xmlInfo).value('(App_AdditionalQueryDetails/externalQueryEntity/@queryType)[1]','int'),1)=2
		DECLARE @userHasRightToEdit INT = 0
EXEC sec_checkPermissionOnEntity @i_userId, 152, @userHasRightToEdit OUTPUT, 64, @thisAlertId
		SELECT	@i_type = T.cc.value('@type', 'INT'),
					@i_flags = T.cc.value('@flags', 'INT'),
					@i_email = T.cc.value('@email', 'nvarchar(2048)'),
					@i_reportName = T.cc.value('@reportName', 'nvarchar(128)'),
					@i_displayName = T.cc.value('@alarmName', 'nvarchar(128)'),
					@i_snmpDescription = IsNull(T.cc.value('@SNMPDescription', 'nvarchar(max)'),''),
					@i_emailCc = T.cc.value('@ccEmail', 'nvarchar(2048)'),
					@i_emailBcc = T.cc.value('@bccEmail', 'nvarchar(2048)')
			FROM	@i_inXML.nodes('/CVGui_AlarmRequest/alarmProps') T(cc)
		if (@userHasRightToEdit=0 AND @ownerUserId<> @i_userId)
		begin
set @o_errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
			SET @o_errorMessage = REPLACE(@o_errorMessage, '^1%s', ISNULL((SELECT login FROM UMUsers WHERE id = @i_userId),''))
SET @o_errorMessage = REPLACE(@o_errorMessage, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2815 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
			SET @o_errorMessage = REPLACE(@o_errorMessage, '^3%s', @i_displayName)
SET @o_errorMessage = REPLACE(@o_errorMessage, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2812 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
			goto EXIT_PROC
		end
		SET @i_email = REPLACE(@i_email, ',', ';')
		SET @i_email = REPLACE(@i_email, ' ', ';')
		SET @i_emailCc = REPLACE(@i_emailCc, ',', ';')
		SET @i_emailCc = REPLACE(@i_emailCc, ' ', ';')
		SET @i_emailBcc = REPLACE(@i_emailBcc, ',', ';')
		SET @i_emailBcc = REPLACE(@i_emailBcc, ' ', ';')
		if (@i_email is not null and len(@i_email)>0)
		begin
			Insert into @emailIdList
			SELECT Data,0 FROM SplitString(@i_email, ';')
		end
		if (@i_emailCc is not null and len(@i_emailCc)>0)
		begin
			Insert into @emailIdList
			SELECT Data,1 FROM SplitString(@i_emailCc, ';')
		end
		if (@i_emailBcc is not null and len(@i_emailBcc)>0)
		begin
			Insert into @emailIdList
			SELECT Data,2 FROM SplitString(@i_emailBcc, ';')
		end
		delete from @emailIdList
		where email is null or len(email)=0
		UPDATE	CustomAlarmProps SET type = @i_type, email = @i_email, extendedProps = @i_alarmProps, displayName = @i_displayName
		WHERE	AlarmId = @i_alarmId
	END
	ELSE IF (@i_action = 2) -- Disable
	BEGIN
		-- Check whether user has rights to disable metrics alert.
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 64, 152, '#alertList' -- ALERT_ENTITY					--CvEntities::EntityType_ALERT_ENTITY(64)
		Insert into #alertList
		select id from NTNotificationrule where notifOwner = @i_userId
		select @alarmIdWithNoPerm = notifMetricsRuleIds.alarmId from @notifMetricsRuleIds notifMetricsRuleIds
			inner join @alarmIdsTbl alarmIdsTbl
			on alarmIdsTbl.id = notifMetricsRuleIds.alarmId
			left join #alertList alertList
			on alertList.NTnotificationId = notifMetricsRuleIds.ntRuleId
			where alertList.NTnotificationId is NULL
		if @alarmIdWithNoPerm>0
		begin
			select @alarmWithNoPermName = extendedProps.value('(/alarmProps/@alarmName)[1]','nvarchar(max)')
			from CustomAlarmProps
			where AlarmId = @alarmIdWithNoPerm
set @o_errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
			SET @o_errorMessage = REPLACE(@o_errorMessage, '^1%s', ISNULL((SELECT login FROM UMUsers WHERE id = @i_userId),''))
SET @o_errorMessage = REPLACE(@o_errorMessage, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2815 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
			SET @o_errorMessage = REPLACE(@o_errorMessage, '^3%s', @alarmWithNoPermName)
SET @o_errorMessage = REPLACE(@o_errorMessage, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2812 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
			goto EXIT_PROC
		end
		UPDATE	CustomAlarmProps
		SET		flags = flags | 1
		FROM	CustomAlarmProps AP, @alarmIdsTbl A
		WHERE	AP.AlarmId = A.id
		SET @i_flags = 1
		UPDATE	CustomAlarmProps SET extendedProps.modify('replace value of (/alarmProps/@flags)[1] with sql:variable("@i_flags")')
		FROM	CustomAlarmProps AP, @alarmIdsTbl A
		WHERE	AP.AlarmId = A.id
		Update NTNotificationRule
set status = status | 1
		from NTNotificationRule inner join @notifMetricsRuleIds NotifMetricsIds on
		NotifMetricsIds.ntRuleId = NTNotificationRule.id
		inner join @alarmIdsTbl A on
		A.id = NotifMetricsIds.alarmId
	END
	ELSE IF (@i_action = 3) -- Delete
	BEGIN
		SET @commUniId = ISNULL(@i_inXML.value('(CVGui_AlarmRequest/@commUniId)[1]','INT'),0)
		IF (@commUniId > 0)
		BEGIN
			INSERT INTO @alarmIdsTbl(id)
			SELECT K.AlarmId
			FROM
			(SELECT CP.AlarmId, ISNULL(x.value('@reportUniqId', 'NVARCHAR(1024)'), '') AS uniqueIdStr FROM CustomAlarmProps CP
			CROSS APPLY CP.extendedProps.nodes('alarmProps') M(x)) K
			WHERE
			CASE WHEN PATINDEX('%commUniId=%', K.uniqueIdStr) = 0 THEN '' ELSE SUBSTRING(K.uniqueIdStr, (PATINDEX('%commUniId=%', K.uniqueIdStr) + 10), 10) END = @commUniId
		END
		Else
		begin
			-- Check whether user has rights to disable metrics alert.
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 64, 153, '#alertList' -- ALERT_ENTITY					--CvEntities::EntityType_ALERT_ENTITY(64)
			Insert into #alertList
			select id from NTNotificationrule where notifOwner = @i_userId
			select @alarmIdWithNoPerm = notifMetricsRuleIds.alarmId from @notifMetricsRuleIds notifMetricsRuleIds
				inner join @alarmIdsTbl alarmIdsTbl
				on alarmIdsTbl.id = notifMetricsRuleIds.alarmId
				left join #alertList alertList
				on alertList.NTnotificationId = notifMetricsRuleIds.ntRuleId
				where alertList.NTnotificationId is NULL
			if @alarmIdWithNoPerm>0
			begin
				select @alarmWithNoPermName = extendedProps.value('(/alarmProps/@alarmName)[1]','nvarchar(max)')
				from CustomAlarmProps
				where AlarmId = @alarmIdWithNoPerm
set @o_errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
				SET @o_errorMessage = REPLACE(@o_errorMessage, '^1%s', ISNULL((SELECT login FROM UMUsers WHERE id = @i_userId),''))
SET @o_errorMessage = REPLACE(@o_errorMessage, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2816 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
				SET @o_errorMessage = REPLACE(@o_errorMessage, '^3%s', @alarmWithNoPermName)
SET @o_errorMessage = REPLACE(@o_errorMessage, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2812 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
				goto EXIT_PROC
			end
		end
		DECLARE @alarmIdsTblVar	TABLE (id nvarchar(max))
		Insert into @alarmIdsTblVar
		select convert(nvarchar(max),id) from @alarmIdsTbl
		Update NTNotificationRule
set status = status | 2 , revision = 0
		from NTNotificationRule inner join @notifMetricsRuleIds NotifMetricsIds on
		NotifMetricsIds.ntRuleId = NTNotificationRule.id
		inner join @alarmIdsTbl A on
		A.id = NotifMetricsIds.alarmId
		-- Delete all schedules for such metrics alerts
		declare @schedulesForAlerts table
		(
			subTaskId int
		)
		Insert into @schedulesForAlerts
		selecT subtaskId from TM_SubTaskOptions with (nolock)
		where optionid=1672944078 --EXTERNALENTITY_QUERY_TYPE
		and value = '2'
		intersect
		selecT subtaskId from TM_SubTaskOptions with (nolock)
		inner join @alarmIdsTblVar alarmIdsTblVar
		on optionid=1546197960 --EXTERNALQUERYENTITY_EXTERNAL_QUERY_ID
		and TM_SubTaskOptions.value = alarmIdsTblVar.id
		-- Now mark all these schedules deleted
		Update TM_Task
		set deleted=1
		from TM_Task inner join TM_Subtask with (nolock)
		on TM_Task.taskId=TM_Subtask.taskId
		and TM_Subtask.operationType = 5014
		inner join @schedulesForAlerts schedulesForAlerts
		on schedulesForAlerts.subtaskid=TM_Subtask.subtaskId
	END
	ELSE IF (@i_action = 4) -- Enable
	BEGIN
		-- Check whether user has rights to disable metrics alert.
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 64, 152, '#alertList' -- ALERT_ENTITY					--CvEntities::EntityType_ALERT_ENTITY(64)
		Insert into #alertList
		select id from NTNotificationrule where notifOwner = @i_userId
		select @alarmIdWithNoPerm = notifMetricsRuleIds.alarmId from @notifMetricsRuleIds notifMetricsRuleIds
			inner join @alarmIdsTbl alarmIdsTbl
			on alarmIdsTbl.id = notifMetricsRuleIds.alarmId
			left join #alertList alertList
			on alertList.NTnotificationId = notifMetricsRuleIds.ntRuleId
			where alertList.NTnotificationId is NULL
		if @alarmIdWithNoPerm>0
		begin
			select @alarmWithNoPermName = extendedProps.value('(/alarmProps/@alarmName)[1]','nvarchar(max)')
			from CustomAlarmProps
			where AlarmId = @alarmIdWithNoPerm
set @o_errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
			SET @o_errorMessage = REPLACE(@o_errorMessage, '^1%s', ISNULL((SELECT login FROM UMUsers WHERE id = @i_userId),''))
SET @o_errorMessage = REPLACE(@o_errorMessage, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2815 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
			SET @o_errorMessage = REPLACE(@o_errorMessage, '^3%s', @alarmWithNoPermName)
SET @o_errorMessage = REPLACE(@o_errorMessage, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2812 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
			goto EXIT_PROC
		end
		UPDATE	CustomAlarmProps
		SET		flags = flags & (~1)
		FROM	CustomAlarmProps AP, @alarmIdsTbl A
		WHERE	AP.AlarmId = A.id
		SET @i_flags = 0
		UPDATE	CustomAlarmProps SET extendedProps.modify('replace value of (/alarmProps/@flags)[1] with sql:variable("@i_flags")')
		FROM	CustomAlarmProps AP, @alarmIdsTbl A
			WHERE	AP.AlarmId = A.id
		Update NTNotificationRule
set status = status - 1
		from NTNotificationRule inner join @notifMetricsRuleIds NotifMetricsIds on
		NotifMetricsIds.ntRuleId = NTNotificationRule.id
		inner join @alarmIdsTbl A on
		A.id = NotifMetricsIds.alarmId
where (NTNotificationRule.status & 1)>0
		END
	ELSE IF (@i_action = 6) -- Get List
		BEGIN
		SET @commUniId = ISNULL(@i_inXML.value('(CVGui_AlarmRequest/@commUniId)[1]','INT'),0)
		-- use the same logic to retrieve metrics alerts as galaxy alerts.
		EXEC sec_getNonIdaObjectsForThisUser @i_userId, 64, 0, '#alertList' -- ALERT_ENTITY					--CvEntities::EntityType_ALERT_ENTITY(64)
		declare @alarmIdsVisibleForUser table
		(
			alarmId int
		)
		Insert into @alarmIdsVisibleForUser
		select notifMetricsRuleIds.alarmId
		from #alertList alertList
		inner join @notifMetricsRuleIds notifMetricsRuleIds
		on alertList.NTnotificationId = notifMetricsRuleIds.ntRuleId
		union
		select AlarmId from CustomAlarmProps AP
		where AP.userId=@i_userId
		-- Find mapping between metrics alerts and their pattern.
		declare @schedulesForAlertsMapping table
		(
			subTaskId int,
			alarmId int,
			taskInfoXml xml
		)
		Insert into @schedulesForAlertsMapping
		selecT subtaskId,value,
			(
				select TM_pattern.description 'subTasks/pattern/@description'
				from TM_Patternassoc with (READUNCOMMITTED)
				inner join TM_pattern with (READUNCOMMITTED) on TM_Patternassoc.patternid = TM_pattern.patternId
				where TM_Patternassoc.subTaskId=TM_SubTaskOptions.subTaskId
				for xml path('taskDetails'), root('TMMsg_TaskDetailsList')
			)
		from TM_SubTaskOptions with (READUNCOMMITTED)
		where optionid=1546197960 --EXTERNALQUERYENTITY_EXTERNAL_QUERY_ID
		declare @customAlarmProps table
		(
			alarmId int,
			userId int,
			extendedProps xml,
			taskXml nvarchar(max)
		)
		Insert into @customAlarmProps
		select alarmId, userId, extendedProps, ''
		from customAlarmProps with (READUNCOMMITTED)
		update customAlarmProps
		set taskxml = convert(nvarchar(max),schedulesForAlertsMapping.taskInfoXml)
		from @customAlarmProps customAlarmProps inner join
		@schedulesForAlertsMapping schedulesForAlertsMapping on
		customAlarmProps.alarmId = schedulesForAlertsMapping.alarmId
		update customAlarmProps
		set extendedProps.modify('insert (attribute scheduleInfo {sql:column("taskXml")}) into (//alarmProps)[1]')
		from @customAlarmProps customAlarmProps
		where extendedProps.exist('alarmProps/@scheduleInfo')=0
		update @customAlarmProps
		set extendedProps.modify('replace value of (alarmProps/@scheduleInfo)[1] with sql:column("taskXml")')
		where extendedProps.exist('alarmProps/@scheduleInfo')=1
		set @o_alarmsList = (SELECT extendedProps.query('.')
		FROM	@customAlarmProps AP
				INNER JOIN UMUsers U
					ON AP.userId = U.id
				INNER JOIN @alarmIdsVisibleForUser alarmIdsVisibleForUser on
				alarmIdsVisibleForUser.alarmId=AP.alarmId
		WHERE U.enabled = 1 AND U.flags <> 0
			AND (@commUniId <= 0 OR (@commUniId > 0
				AND (select REPLACE(s.n.value('.','varchar(40)'),'commUniId=','') from
					(select CAST('<r>'+REPLACE(alarm.rptUniId,',','</r><r>')+'</r>' AS XML) attr from
						(select AP.extendedProps.value('(alarmProps/@reportUniqId)[1]','nvarchar(64)') rptUniId ) alarm) split CROSS APPLY split.attr.nodes('r') s(n)
							where s.n.value('.','varchar(40)') <> REPLACE(s.n.value('.','varchar(40)'),'commUniId=','')) = @commUniId))
		FOR XML PATH(''))
	END
	ELSE IF (@i_action = 7) -- Trigger immediately
	BEGIN
		Update NTNotificationQueryMapping
		set nextRunTime = '1900-12-31 23:59:59.000'
		from NTNotificationQueryMapping inner join @notifMetricsRuleIds NotifMetricsIds on
		NotifMetricsIds.ntRuleId = NTNotificationQueryMapping.NTNotificationId
		inner join @alarmIdsTbl A on
		A.id = NotifMetricsIds.alarmId
	END
	ELSE IF (@i_action = 8) -- Delete custom report
	BEGIN
		Insert into @alarmIdsTbl
		select distinct AlarmId
		from CustomAlarmProps
		where extendedProps.value('(alarmProps/@reportUniqId)[1]','nvarchar(max)')=convert(nvarchar(max),@customReportId)
		and extendedProps.value('(alarmProps/@reportEnum)[1]','nvarchar(max)')='CustomReports'
		DELETE	CustomAlarmProps
		FROM	CustomAlarmProps AP, @alarmIdsTbl A
		WHERE	AP.AlarmId = A.id
		Update NTNotificationRule
set status = status | 2 , revision = 0
		from NTNotificationRule inner join @notifMetricsRuleIds NotifMetricsIds on
		NotifMetricsIds.ntRuleId = NTNotificationRule.id
		inner join @alarmIdsTbl A on
		A.id = NotifMetricsIds.alarmId
		delete from @alarmIdsTblVar
		Insert into @alarmIdsTblVar
		select convert(nvarchar(max),id) from @alarmIdsTbl
		-- Delete all schedules for such metrics alerts
		declare @schedulesForMetricsAlertsOnCR table
		(
			subTaskId int
		)
		Insert into @schedulesForMetricsAlertsOnCR
		selecT subtaskId from TM_SubTaskOptions with (nolock)
		where optionid=1672944078 --EXTERNALENTITY_QUERY_TYPE
		and value = '2'
		intersect
		selecT subtaskId from TM_SubTaskOptions with (nolock)
		inner join @alarmIdsTblVar alarmIdsTblVar
		on optionid=1546197960 --EXTERNALQUERYENTITY_EXTERNAL_QUERY_ID
		and TM_SubTaskOptions.value = alarmIdsTblVar.id
		-- Now mark all these schedules deleted
		Update TM_Task
		set deleted=1
		from TM_Task inner join TM_Subtask with (nolock)
		on TM_Task.taskId=TM_Subtask.taskId
		and TM_Subtask.operationType = 5014
		inner join @schedulesForMetricsAlertsOnCR schedulesForAlerts
		on schedulesForAlerts.subtaskid=TM_Subtask.subtaskId
		-- Delete schedules for custom report also
		declare @schedulesForCustomReport table
		(
			subTaskId int
		)
		Insert into @schedulesForCustomReport
		select subtaskId from
		TM_Subtaskoptions with (nolock) where optionId=2039186688	--RPTCOMMONOPTIONS_REPORT_TYPE
		and value='8012' -- 'Web report'
		intersect
		select subtaskId from
		TM_Subtaskoptions with (nolock) where optionId=1604113012 -- WEBREPORTOPTION_REPORT_ID
		and value=convert(nvarchar(max),@customReportId)
		intersect
		select subtaskId from
		TM_Subtaskoptions with (nolock) where optionId=341006187 -- WEBREPORTOPTION_REPORT_TYPE
		and value='CustomReports'
		-- Now mark all these schedules deleted
		Update TM_Task
		set deleted=1
		from TM_Task inner join TM_Subtask with (nolock)
		on TM_Task.taskId=TM_Subtask.taskId
		inner join @schedulesForCustomReport schedulesForCustomReport
		on schedulesForCustomReport.subtaskid=TM_Subtask.subtaskId
	END
	ELSE IF (@i_action = 9) -- Delete commcell
	BEGIN
		SET @commUniId = ISNULL(@i_inXML.value('(CVGui_AlarmRequest/@commUniId)[1]','INT'),0)
		declare @commUniIdString nvarchar(max)
		set @commUniIdString = 'communiId='+convert(nvarchar(max),@commUniId)
		if (@commUniId>0)
		begin
				-- Delete schedules for custom report also
				declare @schedulesForCommcell table
				(
					subTaskId int
				)
				Insert into @schedulesForCommcell
				selecT subtaskId from TM_SubTaskOptions with (nolock)
				where optionid=1604113012
				and value like '%'+@commUniIdString
				-- Now mark all these schedules deleted
				Update TM_Task
				set deleted=1
				from TM_Task inner join TM_Subtask with (nolock)
				on TM_Task.taskId=TM_Subtask.taskId
				inner join @schedulesForCommcell schedulesForCommcell
				on schedulesForCommcell.subtaskid=TM_Subtask.subtaskId
		end
	END
	ELSE IF (@i_action = 10) -- Get_SPECIFIC
		BEGIN
		SET @commUniId = ISNULL(@i_inXML.value('(CVGui_AlarmRequest/@commUniId)[1]','INT'),0)
		set @o_alarmsList = (SELECT extendedProps.query('.')
		FROM	CustomAlarmProps AP
				INNER JOIN UMUsers U
					ON AP.userId = U.id
				INNER JOIN @alarmIdsTbl alarmIdsTbl
				on alarmIdsTbl.id = AP.AlarmId
		WHERE U.enabled = 1 AND U.flags <> 0
			AND (@commUniId <= 0 OR (@commUniId > 0
				AND (select REPLACE(s.n.value('.','varchar(40)'),'commUniId=','') from
					(select CAST('<r>'+REPLACE(alarm.rptUniId,',','</r><r>')+'</r>' AS XML) attr from
						(select AP.extendedProps.value('(alarmProps/@reportUniqId)[1]','nvarchar(64)') rptUniId ) alarm) split CROSS APPLY split.attr.nodes('r') s(n)
							where s.n.value('.','varchar(40)') <> REPLACE(s.n.value('.','varchar(40)'),'commUniId=','')) = @commUniId))
		FOR XML PATH(''))
	END
	ELSE
	BEGIN
		SET @o_errorCode = -1
		SET @o_errorMessage = 'Invalid operation type ' + CAST(@i_action AS NVARCHAR(4))
	END
END
IF (@i_action = 0 OR @i_action = 1) -- Create or Modify OP
begin
	declare @isHealthReport int
	set @isHealthReport = 0
	if (@i_reportName='Health Report')
	begin
		set @isHealthReport = 1
	end
	-- Now retrieve default messages for this query and insert it.
	declare @customQueryAdditionalInfo xml
	declare @customQueryDefaultHtmlTemplate nvarchar(max)
	declare @customQueryDefaultTextTemplate nvarchar(max)
	select @customQueryAdditionalInfo = xmlInfo from NTqueryList
	where queryId = @i_queryId
	-------------------------- FIXING MR 121815 --------------------------------------------------------
	--------------- Alert Email changes to include report and manage page URLs. ---------------------------
    ------------- And, adding criteria to health alert emails. -------------------------------------------
	--set @customQueryDefaultHtmlTemplate = IsNull(@customQueryAdditionalInfo.value('(App_AdditionalQueryDetails/@defaultHtmlTemplate)[1]','nvarchar(max)'),'')
	exec AlrmGetdefaultTemplateForAlert @i_queryId,@customQueryAdditionalInfo,@customQueryDefaultHtmlTemplate output,0
	 ---------------------------------------------------------------------------------------------------------------------
	if (len(@i_snmpDescription)=0)
	begin
		set @customQueryDefaultTextTemplate = IsNull(@customQueryAdditionalInfo.value('(App_AdditionalQueryDetails/@defaultTextTemplate)[1]','nvarchar(max)'),'')
	end
	else if @isHealthReport = 0
	begin
		set @customQueryDefaultTextTemplate = '<INDEX 0>'
	end
	else
	begin
		set @customQueryDefaultTextTemplate = @i_snmpDescription
		set @customQueryDefaultTextTemplate = replace(@customQueryDefaultTextTemplate,'##lt;','<')
		set @customQueryDefaultTextTemplate = replace(@customQueryDefaultTextTemplate,'##gt;','>')
		select @customQueryDefaultTextTemplate = replace(@customQueryDefaultTextTemplate,'$'+ltrim(rtrim(columnName))+'$',
			'<INDEX '+convert(nvarchar(max),NTQueryColumnList.columnIndex)+'>')
		from NTQueryColumnList
		where queryId=@i_queryId
		and columnType=0
	end
	-- Use this @i_alarmId and queryId to populate other relevant info
	DECLARE @xmlEntities		AS nvarchar(MAX)= '<?xml version="1.0" encoding="UTF-16" standalone="no" ?><CVGui_CommCellTreeNode xmlns:xsi="http:--www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="CVGui_CommCellTreeNodeType.xsd"><clients includeAll="0"/><clientGroups includeAll="0"/><libraries includeAll="0"/><mediaAgents includeAll="0"/><storagePolcies includeAll="0"/><trackingPolicies includeAll="0"/><trackingSchedules/><trackingJobs/></CVGui_CommCellTreeNode>'
	DECLARE @nowTime			as integer	= dbo.GetUnixTime (GetUTCdate())
	DECLARE	@emptyDateTime		AS datetime	= '1900-01-01 00:00:00.000'
	declare	@notifType			integer = 0
	select @notifType = @notifType | notifType
	from @notifTypesList
	declare @additionalInfoxml xml
	set @additionalInfoXml = (select @i_alarmId '@externalQueryId', 2 '@queryType'
		for xml path('externalQueryInfo'),root('CVGui_QueryAdditionalInfo'))
	IF (@i_action = 0)
	begin
		INSERT NTNotificationRule (	categoryId,				alertTypeId,
									notificationName,		revision,
									lastModified,			description,
									notifType,				notifOwner,
									locale,					status,
									ruleState,				ruleState2,
									lastTimeTriggered,		lastTimeTriggered2,
									lastTimeChecked,		hasAttachments,
									hasAttachments2,		xmlEntityList,
									origCCId,				GUID)
select						categoryId,				65,
									@i_displayName,			1,
									@nowTime,				'',
									@notifType,				@i_userId,
									0,						0,			-- 0 DefaultLocale US-English .. Create alerts in enabled state
									@alertSeverity,			@alertSeverity,
									@emptyDateTime,			@emptyDateTime,
									@emptyDateTime,			0,
									0,						@xmlEntities,
									2,				newid()
from NTAlerttype where id = 65
		SET @thisAlertId = @@Identity
		INSERT NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)
select 75,1,@thisAlertId,1025,0,0
		INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)
		VALUES (@thisAlertId, 1, null, null, 0)
		INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)
		VALUES (@thisAlertId, 2, null, null, 0)
		Insert into NTNotificationQueryMapping(QueryId,NTNotificationId,nextRunTime,lastRuntime,isScheduled,taskId,criteriaXml,xmlInfo,
			queryCriteriaString,queryParamDisplayString)
		select @i_queryId, @thisAlertId,
				DATEADD(second,120,getutcdate()),
				0,
				0,
				0,
			'','<?xml version="1.0" encoding="UTF-16" standalone="no" ?>'+convert(nvarchar(max),@additionalInfoXml),'',''
		from NTQueryList
		where queryId = @i_queryId
		Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
select @thisAlertId,'IsTileProp','7',@isTileBasedAlert,dbo.GetUnixTime(GETUTCDATE()),0
		union
select @thisAlertId,'TileID','7',@tileIdForAlert,dbo.GetUnixTime(GETUTCDATE()),0
	 end
	 else IF (@i_action = 1) --Edit alert also
	 begin
		Update NTNotificationRule
		set notificationName = @i_displayName,
		ruleState = @alertSeverity,
		ruleState2 = @alertSeverity,
		notifType = @notifType
		where id = @thisAlertId
		-- Get flags for Alarm @i_alarmId and update NTNotificationrule accordingly. Even though on edit, flags cant be changed currently.
		declare @customAlarmFlags int
		select @customAlarmFlags = flags from CustomAlarmProps
		where alarmId=@i_alarmId
		if ((@customAlarmFlags&1)>0)
		begin
			Update NTNotificationRule
set status = status | 1
			from NTNotificationRule
			where id=@thisAlertId
		end
		else
		begin
			Update NTNotificationRule
set status = status - 1
			from NTNotificationRule
where id=@thisAlertId and (NTNotificationRule.status & 1)>0
		end
		delete from NTmessageFormat
		where NTNotificationId=@thisAlertId
		delete from  NTnotificationNonGalaxyUsers
		where NTNotificationId=@thisAlertId
		delete from  NTNotificationUsers
		where NTNotificationId=@thisAlertId
		update NTNotificationQueryMapping
		set xmlInfo = '<?xml version="1.0" encoding="UTF-16" standalone="no" ?>'+convert(nvarchar(max),@additionalInfoXml)
		where NTNotificationId=@thisAlertId
	 end
		INSERT NTmessageFormat (NTnotificationID,messageType,escalationLevel,formatString,formattedMessage,
							SubjFieldStart,SubjFieldLen,MsgBodyStart,MsgBodyLen,mfOptions,
							baseDir,userName,password, rssID, messageFormatType, formatStringHtml)
		select @thisAlertId, notifType , 1,
					case when isText=1 then @customQueryDefaultTextTemplate
					else ''
					end,
						N'',
0, 0, 0, 0, 2,
						 '', '', '', '',
					case when isText=0 then 1
					else 0
					end ,
					case when isText=0 then @customQueryDefaultHtmlTemplate
					else ''
					end
		from @notifTypesList
		IF @templateId > 0
		BEGIN
			UPDATE NTmessageFormat
			SET formatString = 	@i_displayName + ': ' + (SELECT templateDesc FROM CustomAlarmTemplates WHERE templateId = @templateId)
			WHERE messageType = 1048576 AND NTnotificationID = @thisAlertId
		END
		Insert into NTnotificationNonGalaxyUsers(NTNotificationId,nonGalaxyUserName,escalationLevel,recipientType)
		select DISTINCT @thisAlertId,email,1, recipientType
		from @emailIdList
		-- Add only if email isnt present.
		if @i_userId > 0
		begin
			Insert into NTNotificationUsers(NtnotificationId,userId,escalationLevel)
			select @thisAlertId,@i_userId,1
		end
		set @o_alarmsList = (select @i_alarmId '@alarmId' for xml path('alarmProps'))
end
IF (@i_action = 2 OR @i_action = 3 OR @i_action = 4)
begin
	begin try
	begin tran
	DECLARE @opId	integer
  	DECLARE @opMsgId integer
  	DECLARE @opEvMsgId integer
  	DECLARE @paramData nvarchar(1024)
  	DECLARE @dataIsEvent integer
	DECLARE @paramMsgId integer
	declare @i_uid int
	declare @alertId int
	declare @alertName nvarchar(max)
	-- SET GUI AUDIT OPERATION
	IF (@i_action = 2)
	begin
SET @opMsgId = (493 | (CAST(POWER(2, 24) AS BIGINT) * 84))
	end
	else IF (@i_action = 3)
	begin
SET @opMsgId = (491 | (CAST(POWER(2, 24) AS BIGINT) * 84))
	end
	else IF (@i_action = 4)
	begin
SET @opMsgId = (492 | (CAST(POWER(2, 24) AS BIGINT) * 84))
	end
	set @i_uid = @i_userId
	EXEC EvGuiAuditSetOperation @opMsgId, @i_uid, @opEvMsgId OUTPUT, @opId OUTPUT
	SET @dataIsEvent = 0
SET @paramMsgId = (1207 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	IF ( CURSOR_STATUS('global', 'MetricsAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'MetricsAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN
		CLOSE MetricsAlertsCursor
	IF ( CURSOR_STATUS('global','MetricsAlertsCursor') = -1     OR CURSOR_STATUS('local','MetricsAlertsCursor') = -1 )
		DEALLOCATE MetricsAlertsCursor
	DECLARE MetricsAlertsCursor CURSOR FOR
	SELECT  id FROM @alarmIdsTbl
	OPEN MetricsAlertsCursor
	FETCH NEXT FROM MetricsAlertsCursor INTO @alertId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		set @alertName = ''
		set @existingAlarmProps = ''
		select @existingAlarmProps = extendedprops
		from CustomAlarmProps
		where alarmId = @alertId
		SELECT	@alertName = T.cc.value('@alarmName', 'nvarchar(max)')
		FROM @existingAlarmProps.nodes('/alarmProps') T(cc)
		if len(@alertName)=0
		begin
			FETCH NEXT FROM MetricsAlertsCursor INTO @alertId
		end
		EXEC EvGuiAuditSetParamData @opId, @alertName, @dataIsEvent
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_uid
		FETCH NEXT FROM MetricsAlertsCursor INTO @alertId
	end
	IF ( CURSOR_STATUS('global', 'MetricsAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'MetricsAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN
		CLOSE MetricsAlertsCursor
	IF ( CURSOR_STATUS('global','MetricsAlertsCursor') = -1     OR CURSOR_STATUS('local','MetricsAlertsCursor') = -1 )
		DEALLOCATE MetricsAlertsCursor
	IF (@i_action = 3)
	begin
		DELETE	CustomAlarmProps
		FROM	CustomAlarmProps AP, @alarmIdsTbl A
		WHERE	AP.AlarmId = A.id
	end
	Commit tran
	end try
	begin catch
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		rollback tran
	end catch
end
EXIT_PROC:
	set @o_responseXML = (SELECT	@o_alarmsList,
			@o_errorCode AS 'errorResponse/@errorCode',
			@o_errorMessage AS 'errorResponse/@errorMessage'
	FOR XML PATH(''), ROOT('CVGui_AlarmResponse'))
	select @o_responseXML as o_responseXML
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AlrmAddEditAlarm')
	delete from GxQscripts where name = 'AlrmAddEditAlarm'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AlrmAddEditAlarm')
	delete from GXDBVersions where aliasname = 'AlrmAddEditAlarm'
GO

insert into GXDBVersions values(2, 'AlrmAddEditAlarm',  '00010020000200140000', 'AlrmAddEditAlarm', '00010020000200140000')
GO

