

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AddToLoginFailedHistory.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AddToLoginFailedHistory.sp,v $ $Id: AddToLoginFailedHistory.sp,v 1.1.294.1 2018/03/20 00:51:44 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  br_ntFailedLoginAttempts()
--  |
--  | Description:  To Add Failed Login Attempt to UMLoginFailedHistory
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AddToLoginFailedHistory <<<'

IF EXISTS (select * from sysobjects where name='AddToLoginFailedHistory')
	drop procedure AddToLoginFailedHistory
IF EXISTS (select * from GxQscripts where name='AddToLoginFailedHistory')
	delete from GxQscripts where name = 'AddToLoginFailedHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AddToLoginFailedHistory')
	delete from GXDBVersions where aliasname = 'AddToLoginFailedHistory'
GO
print '... Creating Procedure: AddToLoginFailedHistory'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AddToLoginFailedHistory
  @clientName VARCHAR(1024),
  @loginName VARCHAR(1024)
AS
  DECLARE @grpId INTEGER
  DECLARE @counter INTEGER
DECLARE 	@FailedLoginTimeInterval  INTEGER
DECLARE	@str				  NVARCHAR(256)
DECLARE	@FirstFailedLoginTime	 INTEGER
DECLARE	@currentTime		 INTEGER
DECLARE	@flags			 INTEGER
DECLARE	@l_groupId		INTEGER
DECLARE	@l_counter		INTEGER
set @str = (SELECT VALUE FROM GXGlobaLParam WHERE name='FailedLoginTimeInterval')
set @FailedLoginTimeInterval 	= CAST(@str as int)
set @FailedLoginTimeInterval = @FailedLoginTimeInterval * 60;
set @currentTime = dbo.getunixtime(GETUTCDATE())
set @l_counter  = 1
set @flags 	  = 0
set @l_groupId  = 0
if EXISTS(SELECT * FROM UMLoginFailedHistory WHERE client=@clientName and flags=0)
BEGIN
	-- To Select The first FailedLoginTime for the highest groupId with flags = 0
	SELECT TOP(1) @FirstFailedLoginTime=FailedLoginTime,@l_groupId=groupId FROM UMLoginFailedHistory
		WHERE client=@clientName and flags = 0
		ORDER BY groupId DESC,FailedLoginTime
	if (  @currentTime < @FirstFailedLoginTime+@FailedLoginTimeInterval) -- The Attempt Falls in the interval
	BEGIN
		SELECT TOP(1) @l_counter=counter FROM UMLoginFailedHistory
			WHERE client=@clientName and flags = 0 and groupId = @l_groupId
			ORDER BY FailedLoginTime DESC
		set @l_counter	 = @l_counter + 1
		INSERT INTO UMLoginFailedHistory(client,login,flags,failedLoginTime,groupId,counter)
				VALUES(@clientName,@loginName,0,@currentTime,@l_groupId,@l_counter)
	END
	ELSE
	BEGIN		-- If the Attempts does not fall in the interval, Increment the groupId and add the new row with count 1
		SET	@l_groupId = @l_groupId + 1
		INSERT INTO UMLoginFailedHistory(client,login,flags,failedLoginTime,groupId,counter)
				VALUES(@clientName,@loginName,0,@currentTime,@l_groupId,@l_counter)
	END
END
ELSE
BEGIN  -- If there is a entry for the client use  highest GroupId + 1
	 -- If there is No Row for the client then insert a row with groupId=0
	set @l_groupId = 0
	if EXISTS(select * from UMLoginFailedHistory WHERE client=@clientName)
	BEGIN
		select top(1) @l_groupId=groupId from UMLoginFailedHistory where client = @clientName order by groupId DESC
		set @l_groupId = @l_groupId + 1
	END
	INSERT INTO UMLoginFailedHistory VALUES 	(@clientName,@loginName,@flags,@currentTime,@l_groupId,@l_counter)
END
select @l_groupId,@l_counter
GO

IF EXISTS (select * from GxQscripts where name = 'AddToLoginFailedHistory')
	delete from GxQscripts where name = 'AddToLoginFailedHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AddToLoginFailedHistory')
	delete from GXDBVersions where aliasname = 'AddToLoginFailedHistory'
GO

insert into GXDBVersions values(2, 'AddToLoginFailedHistory',  '00010001029400010000', 'AddToLoginFailedHistory', '00010001029400010000')
GO

