

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AddToBeCopiedAfilesByCopyInBatches.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AddToBeCopiedAfilesByCopyInBatches.sp,v $ $Id: AddToBeCopiedAfilesByCopyInBatches.sp,v 1.1.2.40 2020/06/21 01:34:31 chandru Exp $";
-- Change: Jan 24 2012
-- Added a new param i_FillDeletedAF to handle re-populating AFC table with deleted AFIDs upon change in combine streams configuration
-- on a copy. Additional notes below.
-- Change: March 12 2012
-- This stored procedure may skip a few archive files for de-dupe enabled copy. This reason should be communicated to the user whereever it makes sense.
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AddToBeCopiedAfilesByCopyInBatches')
BEGIN
	print '>>> Drop Stored Procedure: AddToBeCopiedAfilesByCopyInBatches <<<'
	drop procedure AddToBeCopiedAfilesByCopyInBatches
END
IF EXISTS (select * from GxQscripts where name='AddToBeCopiedAfilesByCopyInBatches')
	delete from GxQscripts where name = 'AddToBeCopiedAfilesByCopyInBatches'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AddToBeCopiedAfilesByCopyInBatches')
	delete from GXDBVersions where aliasname = 'AddToBeCopiedAfilesByCopyInBatches'
GO
print '... Creating Procedure: AddToBeCopiedAfilesByCopyInBatches'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AddToBeCopiedAfilesByCopyInBatches
  @i_adminJobId integer,
  @i_auxCopyId integer,
  @i_srcCopyId integer,
  @i_endDate integer,
  @i_isForNewData integer,
  @i_whichCommCell integer
AS
  DECLARE @retVal INTEGER;
  DECLARE @errOpId INTEGER;	
  DECLARE @retStr NVARCHAR(1024);
  DECLARE @commCellId INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- MR 90535 CCM DATA LOSS
DECLARE @PickedCommCellID INTEGER
SET @PickedCommCellID = 0
DECLARE @numberOfCommCells INTEGER
SET @numberOfCommCells = 0
DECLARE @GlobalDedupPolicyName VARCHAR(1024);
DECLARE @useLogicalSize	int = 0
DECLARE @i_dummyParam integer
SET @i_dummyParam	=	1
IF object_id('tempdb.dbo.#ToBeAgedAFC') IS NOT null DROP TABLE #ToBeAgedAFC
IF object_id('tempdb.dbo.#tempJobs') IS NOT null DROP TABLE #tempJobs
IF object_id('tempdb.dbo.#tempAfiles') IS NOT null DROP TABLE #tempAfiles
IF object_id('tempdb.dbo.#tempMMDeletedAfiles') IS NOT null DROP TABLE #tempMMDeletedAfiles
IF object_id('tempdb.dbo.#muxJobs') IS NOT null DROP TABLE #muxJobs
IF object_id('tempdb.dbo.#tempIncompleteJobs') IS NOT null DROP TABLE #tempIncompleteJobs
CREATE TABLE #ToBeAgedAFC (
	archFileId INT, commCellId INT, archCopyId INT, fileType INT,
	PRIMARY KEY (archFileId, commCellId, archCopyId))
CREATE TABLE #tempJobs (
	jobId int, dataType int, commCellId int, appType int, appId int
)
CREATE TABLE #tempIncompleteJobs (
	jobId int, dataType int, commCellId int, appType int, appId int
)
CREATE TABLE #tempAfiles (
	archFileId int, commCellId int, fileType int, jobId int, appId int, archFileFlags int, flags int, passPhraseProtected bit, SIDBStoreId int, primary key(archFileId, commCellId)
)
CREATE TABLE #tempMMDeletedAfiles (
	archFileId int, commCellId int
)
CREATE INDEX Idx_tempMMDeletedAfiles_1 ON #tempMMDeletedAfiles (archFileId, commCellId)
CREATE TABLE #muxJobs (
	jobId int, commCellId int
)
IF object_id('tempdb.dbo.#AddAFilesResultOpTbl') IS NOT null DROP TABLE #AddAFilesResultOpTbl
CREATE TABLE #AddAFilesResultOpTbl (
			retVal INT, errOpId INT, errString NVARCHAR(1024), commCellId INT)
if object_id('tempdb.dbo.#archCopyToAppId') is not null DROP TABLE #archCopyToAppId
CREATE TABLE #archCopyToAppId (
copyId			INTEGER,
AppId				INTEGER
)
CREATE CLUSTERED INDEX idx_archCopyToAppId ON #archCopyToAppId (copyId,AppId)
DECLARE @tblDestCopyStoreList TABLE
(
	SIDBStoreId		integer,
	flags				integer,
	PRIMARY KEY(SIDBStoreId)
)
IF object_id('tempdb.dbo.#tempJobsToProcess') IS NOT null DROP TABLE #tempJobsToProcess
CREATE TABLE #tempJobsToProcess (archCopyId INTEGER, jobId INTEGER, commCellId INTEGER PRIMARY KEY(archCopyId, jobId, CommCellId))
IF object_id('tempdb.dbo.#tempAfiles_encDetails') IS NOT null DROP TABLE #tempAfiles_encDetails
CREATE TABLE #tempAfiles_encDetails (
	archFileId int, commCellId int, fileType int, jobId int, appId int, archFileFlags int, flags int, passPhraseProtected bit, SIDBStoreId int, encRSA tinyint, encKeyType tinyint, encKey varchar(1024), rowNumber INT, encKeyId INT,	primary key(archFileId, commCellId, rowNumber)
)
DECLARE	@now			INTEGER
DECLARE @max_stream		INTEGER
DECLARE @l_maxStreamForSnapCopy		INTEGER = 0
DECLARE @l_archGroupId	INTEGER
DECLARE @l_copyFlags	INTEGER
DECLARE @l_copyDedupeFlags	INTEGER
DECLARE @l_isSnapCopy	INTEGER
DECLARE @l_isMirrorCopy	INTEGER
DECLARE @l_encKeyLen	INTEGER = 0
DECLARE @l_copyExtendedFlags INTEGER = 0
SET		@now = dbo.GetUnixTime(GetUTCDate())
DECLARE @magneticBytes BIGINT = 0
DECLARE @l_jobType INTEGER = dbo.GetJobTypeForJobID(@i_adminJobId)
DECLARE @l_copyType INTEGER = 0
DECLARE @max_destDriveCount INTEGER
DECLARE @maxJobs INT = 5000
DECLARE @hasCompletedJobs INT = 0
DECLARE @hasMoreBatchesToRun INT = 1
DECLARE @insertedJobs TABLE (jobId bigint,commcellId int, appId int)
DECLARE @l_ignoreDVFailedJobs INTEGER = 0
DECLARE @l_totalJobsToProcess INTEGER = 1000
DECLARE @l_jobsFromTime INTEGER = 0
DECLARE @l_jobsToTime INTEGER = 0
DECLARE @l_copyStartTime INTEGER = 0
DECLARE @l_copyEndTime	INTEGER = 0
SELECT	@l_ignoreDVFailedJobs = (CASE WHEN optionId = 2064661278  THEN CAST(value AS INT) ELSE @l_ignoreDVFailedJobs END),
@l_totalJobsToProcess = (CASE WHEN optionId = 1654993746 THEN CAST(value AS INT) ELSE @l_totalJobsToProcess END),
@l_jobsFromTime = (CASE WHEN optionId = 1802027523  THEN CAST(value AS INT) ELSE @l_jobsFromTime END),
@l_jobsToTime = (CASE WHEN optionId = 458275378 THEN CAST(value AS INT) ELSE @l_jobsToTime END)
FROM	dbo.GetAllJobOptions(@i_adminJobId)
WHERE	optionId IN (2064661278, 1654993746, 1802027523, 458275378)
DECLARE @SkipTransactionalLogs INT = 0
SET @SkipTransactionalLogs = (SELECT value FROM MMConfigs WHERE name = 'MMCONFIG_SKIP_AUXCOPY_TRANSACTIONAL_LOGS')
SELECT	@l_archGroupId	= archGroupId,
		@l_copyFlags	= flags,
		@l_copyDedupeFlags	= dedupeFlags,
		@max_stream		= maxStreamNum,
		@l_isSnapCopy	= isSnapCopy,
		@l_isMirrorCopy	= isMirrorCopy,
		@l_encKeyLen	= encKeyLen,
		@l_copyExtendedFlags = extendedFlags,
		@l_copyType		= type,
		@l_copyStartTime = startTime,
		@l_copyEndTime	 = endTime
FROM	archGroupCopy WITH (NOLOCK)
WHERE	id = @i_auxCopyId
INSERT INTO @tblDestCopyStoreList
SELECT	SIDBStoreId, flags
FROM	archCopySIDBStore
WHERE	copyId = @i_auxCopyId
AND (flags & 4) > 0
--Set the default passthrough if no encryption flags are set
IF @l_copyFlags & (1048576 | 8388608 | 2097152 | 4194304) = 0
SET @l_copyFlags |= 1048576
SELECT @maxJobs = value
FROM MMConfigs
WHERE name = 'MMS2_CONFIG_MAX_NUMBER_OF_JOBS_PER_BATCH'
if @@ROWCOUNT = 0 OR @maxJobs = 0
SET @maxJobs = 5000
IF	(@l_copyFlags & 4) = 0
	SELECT	@max_stream = maxStreams
	FROM	archGroup WITH (NOLOCK)
	WHERE	id = @l_archGroupId
IF ( @l_copyFlags & 512 > 0)
		SET @max_destDriveCount = ISNULL((
				select COUNT(DISTINCT c.driveId) as driveCount
				from MMDataPath a WITH (NOLOCK)
				INNER JOIN  MMDriveController b WITH (NOLOCK) ON a.DrivePoolId = b.DrivePoolId
				INNER JOIN  MMDrive c WITH (NOLOCK) ON b.DriveId = c.DriveId
				AND b.DriveControllerEnabled = 1
				AND a.CopyId = @i_auxCopyId) , 0)
ELSE
	SET @max_destDriveCount = ISNULL((
		select MAX(driveCount) from (
			select a.DrivePoolId, COUNT(DISTINCT c.driveId) as driveCount
			from MMDataPath a WITH (NOLOCK)
			INNER JOIN  MMDriveController b WITH (NOLOCK) ON a.DrivePoolId = b.DrivePoolId
			INNER JOIN  MMDrive c WITH (NOLOCK) ON b.DriveId = c.DriveId
			and b.DriveControllerEnabled = 1
			and a.CopyId = @i_auxCopyId
			group by a.DrivePoolId
		) as copyDrive), 0)
IF @max_stream > @max_destDriveCount AND @max_destDriveCount > 0
	SET @max_stream = @max_destDriveCount
IF (@l_isSnapCopy = 1)
BEGIN
	IF (@max_stream = 1)
		SET @l_maxStreamForSnapCopy = @max_stream + 1
	ELSE
		SET @l_maxStreamForSnapCopy = @max_stream
END
IF	@l_copyDedupeFlags & 262144 > 0
BEGIN
	SELECT TOP 1 @PickedCommCellID = SG.CommCellId
	FROM	@tblDestCopyStoreList CS,
			IdxSIDBStore S WITH(READUNCOMMITTED),
			IdxSIDBGroup SG WITH(READUNCOMMITTED)
	WHERE	CS.SIDBStoreId = S.SIDBStoreId
			AND S.SIDBGroupId = SG.SIDBGroupId
	-- By now, we should have PickedCommCellID
	IF @@ROWCOUNT = 0
	BEGIN
		INSERT INTO #AddAFilesResultOpTbl
SELECT 130, 0, NULL, 0
		GOTO CX_EXIT;
	END
END
IF (@l_totalJobsToProcess > 0 AND @l_jobType = 104)
BEGIN
	DECLARE @xmlJobsList XML = NULL
	SELECT	@xmlJobsList = CAST(attributeValue AS XML)
	FROM	JMJobOptions
	WHERE	jobId = @i_adminJobId
			AND CommCellId = 2
AND attributeId = 70
	IF (@xmlJobsList IS NOT NULL)
	BEGIN
		INSERT INTO #tempJobsToProcess
		SELECT	Jobs.Node.value('@cp', 'INTEGER') archCopyIdId,
				Jobs.Node.value('@j', 'INTEGER') jobId,
				Jobs.Node.value('@c', 'INTEGER') CommCellId
		FROM	@xmlJobsList.nodes('//JobIds/I') Jobs(Node)
	END
	if (@l_jobsToTime > @i_endDate AND @i_endDate <> 0)
		SET @l_jobsToTime = @i_endDate
END
SELECT @hasMoreBatchesToRun = hasMoreBatchesToRun
FROM archAddToBeCopiedAfilesBatchDetails b WHERE  b.archGroupID = @l_archGroupId
	AND b.destCopyId = @i_auxCopyId AND b.AuxCopyJobId = @i_adminJobId
IF @@ROWCOUNT = 0 -- batchDetails not available for this job, that means this proc is called first time for this job
BEGIN
 DELETE FROM archAddToBeCopiedAfilesBatchDetails
 WHERE archGroupID = @l_archGroupId AND destCopyID = @i_auxCopyId
 AND AuxCopyjobId <> @i_adminJobId
 --insert for non existing one
 INSERT INTO archAddToBeCopiedAfilesBatchDetails
 select @l_archGroupId, @i_auxCopyId, @i_adminJobId, 0, 0, 1
IF @l_copyDedupeFlags & 262144> 0 AND EXISTS (select 1 from MMConfigs WHERE NAME = 'MMCONFIG_AUXCOPY_COPY_FIRST_FULL_FOR_NEW_SUBCLIENT' AND VALUE = 1) -- This is the first iteration and a destination is a dedupe copy with first full for new sc option set
 BEGIN
	INSERT INTO #tempJobs
	SELECT jobId, dataType, commCellId, appTypeId, appId
	FROM (SELECT jds.jobId, jds.dataType, jds.commCellId, aa.appTypeId, jds.appId,
CASE WHEN @i_whichCommCell = 1 THEN DENSE_RANK() OVER( PARTITION BY JDS.appID ORDER BY JDS.commCellId,JDS.jobId ASC)
		ELSE DENSE_RANK() OVER( PARTITION BY JDS.appID ORDER BY JDS.commCellId DESC, JDS.jobId ASC) END AS rank#
		FROM (JMJobDataStats jds WITH (NOLOCK) INNER JOIN JMBkpStats jbs WITH (NOLOCK) ON jbs.jobId = jds.jobId
		AND jbs.commCellId = jds.commCellId
		AND (@l_jobsToTime = 0 OR (JBS.servEndDate BETWEEN @l_jobsFromTime AND @l_jobsToTime))
		AND JBS.bkpLevel  in (1, 64, 128, 1024, 32768) INNER JOIN APP_Application aa WITH (NOLOCK) ON aa.id = JBS.appId ) INNER JOIN
		(SELECT DISTINCT a.appId
		FROM (SELECT DISTINCT appId FROM JMJobDataStats jds1 WITH (NOLOCK)
		WHERE archGrpCopyId = @i_auxCopyId
		AND jds1.status IN (101, 102, 103)
AND (disabled & (1 + 256)) = 0) a LEFT OUTER JOIN (JMJobDataStats jds WITH (NOLOCK) INNER JOIN JMBkpStats jbs WITH (NOLOCK) ON jbs.jobId = jds.jobId
		AND jbs.commCellId = jds.commCellId
		AND JBS.bkpLevel  in (1, 64, 128, 1024, 32768)) ON jds.appID = a.appID AND jds.archGrpCopyId = @i_auxCopyId
		AND JDS.status = 100
		WHERE jds.jobID IS NULL) t
		ON t.appId = jbs.appId
		WHERE JDS.archGrpCopyId = @i_auxCopyId
		AND JDS.status IN (101, 102, 103)
		AND (@pickedcommcellid = 0 or JDS.commCellId = @pickedcommcellid)
AND (@i_whichCommCell <> 3 OR JDS.commCellId = 2)
	) i
	WHERE rank# = 1
	SET @hasCompletedJobs =  @@ROWCOUNT
	INSERT INTO #tempJobs
	SELECT jobId, dataType, commCellId, appTypeId, appId
	FROM (SELECT jds.jobId, jds.dataType, jds.commCellId, aa.appTypeId, jds.appId,
CASE WHEN @i_whichCommCell = 1 THEN DENSE_RANK() OVER( PARTITION BY JDS.appID ORDER BY JDS.commCellId,JDS.jobId ASC)
		ELSE DENSE_RANK() OVER( PARTITION BY JDS.appID ORDER BY JDS.commCellId DESC, JDS.jobId ASC) END AS rank#
		FROM (JMJobDataStats jds WITH (NOLOCK) INNER JOIN JMAdminJobStatsTable jbs WITH (NOLOCK) ON jbs.jobId = jds.jobId
		AND jbs.commCellId = jds.commCellId
		AND (@l_jobsToTime = 0 OR (JBS.servEnd BETWEEN @l_jobsFromTime AND @l_jobsToTime))
		AND JBS.ER_BkpLevel  in (1, 64, 128, 1024, 32768) INNER JOIN APP_Application aa WITH (NOLOCK) ON aa.id = JBS.appId ) INNER JOIN
		(SELECT DISTINCT a.appId
		FROM (SELECT DISTINCT appId FROM JMJobDataStats jds1 WITH (NOLOCK)
		WHERE archGrpCopyId = @i_auxCopyId
		AND jds1.status IN (101, 102, 103)
AND (disabled & (1 + 256)) = 0) a LEFT OUTER JOIN (JMJobDataStats jds WITH (NOLOCK) INNER JOIN JMAdminJobStatsTable jbs WITH (NOLOCK) ON jbs.jobId = jds.jobId
		AND jbs.commCellId = jds.commCellId
		AND JBS.ER_BkpLevel  in (1, 64, 128, 1024, 32768)) ON jds.appID = a.appID AND jds.archGrpCopyId = @i_auxCopyId
		AND JDS.status = 100
		WHERE jds.jobID IS NULL) t
		ON t.appId = jbs.appId
		WHERE JDS.archGrpCopyId = @i_auxCopyId
		AND JDS.status IN (101, 102, 103)
		AND (@pickedcommcellid = 0 or JDS.commCellId = @pickedcommcellid)
AND (@i_whichCommCell <> 3 OR JDS.commCellId = 2)
	) i
	WHERE rank# = 1
	SET @hasCompletedJobs =  @hasCompletedJobs + @@ROWCOUNT
	IF (@hasCompletedJobs > 0) -- run more batches
	BEGIN
		INSERT INTO #AddAFilesResultOpTbl
SELECT 203, 0, 0, 0
	END
 END
END
IF @hasCompletedJobs = 0 AND @hasMoreBatchesToRun = 1 -- start this batching only when we are done with first jobs on dedupe copies and we have more batchesToRun
BEGIN
	IF (@l_totalJobsToProcess > 0 AND @l_jobType = 104)
	BEGIN
		DECLARE @currentPopulatedJobCount INTEGER = 0
		SET @currentPopulatedJobCount = ISNULL((SELECT COUNT(*) FROM #tempJobsToProcess WHERE archCopyId = @i_auxCopyId), 0)
		IF ( @currentPopulatedJobCount >=  @l_totalJobsToProcess)
		BEGIN
			INSERT INTO #AddAFilesResultOpTbl
SELECT 204, 0, NULL, @l_totalJobsToProcess
			GOTO CX_EXIT
		END
	END
	SELECT @commCellId = CASE WHEN @PickedCommCellID > 0 then @PickedCommCellID
WHEN @i_whichCommCell = 1 THEN MIN(JDS.commCellId)
WHEN @i_whichCommCell = 2 THEN MAX(JDS.commCellId)
			ELSE 2 END
	FROM	JMJobDataStats JDS WITH (NOLOCK)
	WHERE	JDS.archGrpCopyId = @i_auxCopyId
			AND status IN (101, 102, 103)
AND (disabled & (1 + 256)) = 0
			--AND (b.MaxJobId = 0 OR jds.jobID > b.MaxJobId)
--AND (@i_whichCommCell <> 3 OR JDS.commCellId = 2)
	IF object_id('tempdb.dbo.#tempJobsRanked') IS NOT null DROP TABLE #tempJobsRanked
	CREATE TABLE #tempJobsRanked (
		jobId int, dataType int, commCellId int, rank# int
	)
	INSERT INTO #tempJobsRanked
	SELECT	JDS.jobId, JDS.dataType, JDS.commCellId,
	DENSE_RANK() OVER(ORDER BY JDS.commCellId, JDS.jobId ASC) AS rank#
	FROM	JMBkpStats JBS WITH (NOLOCK) JOIN JMJobDataStats JDS WITH (NOLOCK) ON JBS.jobId = JDS.jobID AND JBS.commCellId = JDS.commCellId JOIN archAddToBeCopiedAfilesBatchDetails b WITH (NOLOCK)
			ON b.archGroupID = JDS.archGrpId AND JDS.archGrpCopyId = b.destCopyId AND b.AuxCopyjobId = @i_adminJobId
	WHERE	JDS.archGrpCopyId = @i_auxCopyId
			AND jds.status IN (101, 102, 103)
AND (disabled & (1 + 256)) = 0
			AND (b.MaxJobId = 0 OR jds.jobID > b.MaxJobId)
			AND (@commCellId = 0 OR JDS.commCellId = @commCellId)
			AND (@l_jobsToTime = 0 OR (JBS.servEndDate BETWEEN @l_jobsFromTime AND @l_jobsToTime))
	INSERT INTO #tempJobsRanked
	SELECT	JDS.jobId, JDS.dataType, JDS.commCellId,
	DENSE_RANK() OVER(ORDER BY JDS.commCellId, JDS.jobId ASC) AS rank#
	FROM	JMAdminJobStatsTable JAS WITH (NOLOCK) JOIN JMJobDataStats JDS WITH (NOLOCK) ON JAS.jobId = JDS.jobID AND JAS.commCellId = JDS.commCellId JOIN archAddToBeCopiedAfilesBatchDetails b WITH (NOLOCK)
			ON b.archGroupID = JDS.archGrpId AND JDS.archGrpCopyId = b.destCopyId AND b.AuxCopyjobId = @i_adminJobId
	WHERE	JDS.archGrpCopyId = @i_auxCopyId
			AND jds.status IN (101, 102, 103)
AND (disabled & (1 + 256)) = 0
			AND (b.MaxJobId = 0 OR jds.jobID > b.MaxJobId)
			AND (@commCellId = 0 OR JDS.commCellId = @commCellId)
			AND (@l_jobsToTime = 0 OR (JAS.servEnd BETWEEN @l_jobsFromTime AND @l_jobsToTime))
	if(@pickedcommcellid > 0)
	BEGIN
		/*INSERT INTO #AddAFilesResultOpTbl
SELECT DISTINCT 1,4,CONVERT(VARCHAR(32),B.jobId), B.commCellId
		FROM   #tempAfiles B, archGroupCopy AGC WITH (NOLOCK)
		WHERE   B.commCellId <> @PickedCommCellID AND AGC.id = @i_auxCopyId*/
		DELETE #tempJobsRanked
OUTPUT 1,4,CONVERT(VARCHAR(32),DELETED.jobId), DELETED.commCellId INTO #AddAFilesResultOpTbl -- should insert only first execution though, would need fix
		WHERE commCellId <> @PickedCommCellID
		IF @@ROWCOUNT > 0
		BEGIN
			--- re-adjust the ranks
			UPDATE #tempJobsRanked
			SET rank# = DENSE_RANK() OVER( ORDER BY JDS.commCellId, JDS.jobId ASC)
		END
	END
		INSERT INTO #tempJobs
		OUTPUT inserted.jobId,inserted.commCellId, inserted.appId INTO @insertedJobs
		SELECT	b.jobId, b.dataType, b.commCellId, c.appTypeId, b.appId
		FROM	#tempJobsRanked a,
				JMJobDataStats b WITH (NOLOCK),
				APP_Application c WITH (NOLOCK)
		WHERE	c.id = b.appId
			AND b.jobId = a.jobId
			AND b.archGrpCopyId = @i_srcCopyId
			AND b.dataType = a.dataType
			AND b.commCellId = a.commCellId
			AND b.status = 100
AND (b.disabled & (1 + 256)) = 0
			AND rank# <= @maxJobs
			AND (@l_totalJobsToProcess = 0 OR ((rank# + @currentPopulatedJobCount) <= @l_totalJobsToProcess))
		IF (@l_totalJobsToProcess > 0 AND @l_jobType = 104)
		BEGIN
			INSERT INTO #tempJobsToProcess
				SELECT	@i_auxCopyId, JobID, CommCellId
				FROM
					(SELECT	DISTINCT JobId, CommCellId
					FROM	#tempJobs
					EXCEPT
					SELECT	JobId, CommCellId
					FROM	#tempJobsToProcess
					WHERE	archCopyId = @i_auxCopyId) T
				ORDER BY JobId, CommCellId
			IF EXISTS (SELECT 1 FROM	#tempJobsToProcess)
			BEGIN
				SET @xmlJobsList =	(SELECT	JobId AS '@j', CommCellID AS '@c', archCopyId AS '@cp'
									FROM	#tempJobsToProcess
									ORDER BY archCopyId, JobId, CommCellId
									FOR XML PATH('I'), ROOT('JobIds'))
				IF (NOT EXISTS (SELECT	1
							FROM	JMJobOptions
							WHERE	jobId = @i_adminJobId
									AND CommCellId = 2
AND attributeId = 70))
				BEGIN
					INSERT INTO JMJobOptions
SELECT	DISTINCT @i_adminJobId, 2, 70, 'Jobs List', 0, CAST(@xmlJobsList AS VARCHAR(MAX))
					INSERT INTO JMJobOptions
SELECT	DISTINCT @i_adminJobId, 2, 69, 'Resubmit job on completion', (CASE WHEN EXISTS (SELECT archCopyId, COUNT(*) FROM #tempJobsToProcess GROUP BY archCopyId HAVING @l_totalJobsToProcess <= COUNT(*))  THEN 1 ELSE 0 END) , ''
				END
				ELSE
				BEGIN
					UPDATE	JMJobOptions
					SET		attributeValue =  CAST(@xmlJobsList AS VARCHAR(MAX))
					WHERE	jobId = @i_adminJobId
							AND commCellId = 2
AND attributeId = 70
					UPDATE	JMJobOptions
					SET		attributeValueInt =  (CASE WHEN EXISTS (SELECT archCopyId, COUNT(*) FROM #tempJobsToProcess GROUP BY archCopyId HAVING @l_totalJobsToProcess <= COUNT(*)) THEN 1 ELSE 0 END)
					WHERE	jobId = @i_adminJobId
							AND commCellId = 2
AND attributeId = 69
				END
			END
		END
		--update for existing entries
		UPDATE archAddToBeCopiedAfilesBatchDetails
		SET maxJobId =  a.maxJobId,commCellId = a.commCellId
		FROM ( SELECT TOP(1) ISNULL(JobID,0) maxJobId,ISNULL(commceLLid,0) CommCellId
				FROM  @insertedJobs
				ORDER BY commCellId,jobID desc ) a,
			archAddToBeCopiedAfilesBatchDetails b
		WHERE  b.archGroupID = @l_archGroupId
		AND b.destCopyId = @i_auxCopyId AND b.AuxCopyJobId = @i_adminJobId
		SET @hasCompletedJobs =  @@ROWCOUNT
		IF (@hasCompletedJobs > 0) AND EXISTS (SELECT 1 FROM #tempJobsRanked WHERE rank# > @maxJobs)
		BEGIN
			INSERT INTO #AddAFilesResultOpTbl
SELECT 203, 0, 0, 0
		END
		ELSE
			UPDATE archAddToBeCopiedAfilesBatchDetails
			SET hasMoreBatchesToRun = 0
			WHERE  archGroupID = @l_archGroupId
			AND destCopyId = @i_auxCopyId AND AuxCopyJobId = @i_adminJobId
	IF object_id('tempdb.dbo.#tempJobsRanked') IS NOT null DROP TABLE #tempJobsRanked
END
-- Fast copy changes:
-- check if granular  picking of data for AuxCopy is enabled and(if it's a reinit only?)
-- pick valid archFiles which do not have JMJobDataStats entry on the destination and is not aged or disable etc etc :: jds.status = 100 OR jds.disabled & (8192 + 256  + 1 ) > 0
-- skip if end date set.
IF @i_endDate = 0 AND @l_copyExtendedFlags & 32768 > 0 AND @l_jobType = 104
AND @l_copyType = 1
	AND @hasCompletedJobs = 0
	AND @l_copyStartTime <= @now -- if copy's Start time is less than or equal to now then only we pick the running jobs.
	AND @l_copyEndTime > @now  -- if copy's end time is greater than now then only we pick the running jobs.
BEGIN
	IF EXISTS(SELECT 1 FROM archCopyToApp WITH (READUNCOMMITTED) where copyID = @i_auxCopyId AND assocType <> 2)
	BEGIN
		INSERT INTO #archCopyToAppId
		SELECT DISTINCT @i_auxCopyId , applicationId
		FROM JMBkpJobInfo  WITH (READUNCOMMITTED)
		EXEC archGetArchCopyToAppAssociations @i_auxCopyId
		INSERT INTO #tempIncompleteJobs
		SELECT DISTINCT AF.jobId,AF.fileType,AF.commCellId,APP.appTypeId, APP.id
		FROM archFile AF WITH (READUNCOMMITTED),JMJobInfo JI  WITH (READUNCOMMITTED),
				APP_Application APP  WITH (READUNCOMMITTED) JOIN #archCopyToAppId ACA WITH (NOLOCK)
					ON ACA.copyID = @i_auxCopyId AND ACA.appID = App.id
		WHERE APP.id = AF.appId
			AND AF.jobId = JI.jobId AND AF.commCellId = JI.commCellId
			AND JI.state NOT IN (4,9,10,11)
AND (@SkipTransactionalLogs = 0 OR AF.fileType != 4 OR APP.appTypeId != 81)
	END
	ELSE
	BEGIN
	INSERT INTO #tempIncompleteJobs
		SELECT DISTINCT AF.jobId,AF.fileType,AF.commCellId,APP.appTypeId , APP.id
		FROM archFile AF WITH (READUNCOMMITTED), archFileCopy AFC  WITH (READUNCOMMITTED), APP_Application APP  WITH (READUNCOMMITTED),JMJobInfo JI  WITH (READUNCOMMITTED)
		WHERE AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId
			AND APP.id = AF.appId
			AND AF.jobId = JI.jobId AND AF.commCellId = JI.commCellId
			AND JI.state NOT IN (4,9,10,11)
AND (@SkipTransactionalLogs = 0 OR AF.fileType != 4 OR APP.appTypeId != 81)
	END
	IF OBJECT_ID('tempdb..#tmpAppIdList') IS NOT NULL
		DROP TABLE #tmpAppIdList
	CREATE TABLE #tmpAppIdList(appId int, unSupportedAlways int, unSupportedOnSelAlways int, unSupportedDB int, isCWEjobValid int, Primary Key(appId))
	INSERT INTO #tmpAppIdList
	SELECT DISTINCT t.appId, 0, 0, 0, 0
	FROM #tempIncompleteJobs t
	--Set unsupported flag
	EXEC ArchIsAuxiliaryCopySupportedForSubclient 0
	DELETE #tempIncompleteJobs
	FROM #tempIncompleteJobs t, #tmpAppIdList AT
	WHERE AT.AppId = t.appId
	AND AT.unSupportedAlways = 1
	--need to update the max job value again for fast copy?
	UPDATE archAddToBeCopiedAfilesBatchDetails
	SET maxJobId =  0
	WHERE  archGroupID = @l_archGroupId
	AND destCopyId = @i_auxCopyId AND AuxCopyJobId = @i_adminJobId
END
IF @i_endDate <> 0
   DELETE #tempJobs FROM #tempJobs a, JMBkpStats b WITH (NOLOCK)
   WHERE  a.jobId = b.jobId AND a.commCellId = b.commCellId AND servEndDate > @i_endDate
INSERT INTO #tempAfiles
SELECT	a.id AS archFileId, a.commCellId, a.fileType, a.jobId, a.appId, a.flags,
(case when b.appType in (24, 48) then 8 else 0 end), 0, 0
FROM   archFile a WITH (NOLOCK), #tempJobs b
WHERE  a.jobId = b.jobId AND a.commCellId = b.commCellId AND a.fileType = b.dataType
	AND	(a.isValid = 1 OR
		 a.isValid = 0 AND b.appType NOT IN (
2,
3,
4,
5,
9,
13,
15,
16,
22,
23,
26,
27,
28,
30,
31,
32,
37,
47,
49,
50,
53,
61,
62,
1000,
79,
135,
80,
103,
128))
-- skip edge client archFiles as the archFiles gets reused there.
INSERT INTO #tempAfiles
SELECT	a.id AS archFileId, a.commCellId, a.fileType, a.jobId, a.appId, a.flags,
(case when b.appType in (24, 48) then 8 else 0 end), 0, 0
FROM   archFile a WITH (NOLOCK), #tempIncompleteJobs b, archFileCopy AFC  WITH (READUNCOMMITTED) LEFT OUTER JOIN #tempAfiles t ON t.archFileID = AFC.archFileId AND t.commCellId = AFC.commCellId
WHERE  a.jobId = b.jobId AND a.commCellId = b.commCellId AND a.fileType = b.dataType
AND	a.flags & (32768|2097152) = 0
	AND	(a.isValid = 1 OR
		 a.isValid = 0 AND b.appType NOT IN (
2,
3,
4,
5,
9,
13,
15,
16,
22,
23,
26,
27,
28,
30,
31,
32,
37,
47,
49,
50,
53,
61,
62,
1000,
79,
135,
80,
103,
128))
	AND a.id = AFC.archFileId AND a.commCellId = AFC.commCellId
	AND AFC.archCopyId = @i_srcCopyId -- source
	AND AFC.mediaType = 10001
	AND AFC.physicalSize > 0 AND AFC.streamNum > 0
	AND t.archFileId IS NULL
/* MR:214061
IF (EXISTS (SELECT	*
			FROM	#tempAfiles
WHERE	(archFileFlags & (32768|2097152)) > 0))
BEGIN
	UPDATE	DEST
	SET		isValid = 0
	FROM	archFileCopy DEST, archFileCopy SRC
	WHERE	DEST.archFileId = SRC.archFileId
			AND DEST.CommCellId = SRC.CommCellId
			AND DEST.archCopyId = @i_auxCopyId
			AND SRC.archCopyId = @i_srcCopyId
			AND DEST.physicalSize < SRC.physicalSize
			AND DEST.isValid = 1
END
*/
--
--Skip clients which has force encryption enabled when dest copy is set to store plain text
--
IF @l_copyFlags & (2097152 | 4194304) > 0
BEGIN
	IF OBJECT_ID('tempdb..#lt_AppsToSkip') IS NOT NULL DROP TABLE #lt_AppsToSkip
CREATE TABLE #lt_AppsToSkip (appId int, clientId int, clientName nvarchar(255))
	INSERT INTO #lt_AppsToSkip
	SELECT  TAF.appId, CN.id, CN.displayName
	FROM	(SELECT DISTINCT appId FROM #tempAfiles) AS TAF,
			App_Application App WITH(READUNCOMMITTED),
			App_Client CN WITH(READUNCOMMITTED),
			App_ClientProp CP WITH(READUNCOMMITTED)
	WHERE	TAF.appId = App.id
			AND App.clientId = CN.id
			AND CN.id = CP.componentNameId
AND CP.attrName = '0b8ce11514ade27eadf6c6d3ebe1675aae74eb277faf2ad5388e6ea348006cfcb024ab416eaa8d88'
AND CP.attrVal <> '6f78d80ca483bdf7c408231619954beb40477536adeef5bfb7266ed3abbbedb5a12cc8ffa63b36945be43d7da560184c'
			AND CP.modified = 0
	IF @@ROWCOUNT > 0
	BEGIN
		INSERT INTO #AddAFilesResultOpTbl
SELECT 	DISTINCT 1,8, clientName, 2
		FROM	#lt_AppsToSkip
		-- Hold on copy until encryption settings are corrected
		DELETE 	AFC
		FROM	#tempAfiles AFC, #lt_AppsToSkip TAF
		WHERE	AFC.appId = TAF.appId
	END
END
UPDATE	TAF
SET		SIDBStoreId = S.SIDBStoreId
FROM	#tempAfiles	TAF, archSubclientCopyDDBMap S
WHERE	TAF.appId = S.appId
		AND S.copyId = @i_auxCopyId
IF @l_copyDedupeFlags & 262144 > 0 AND EXISTS ( SELECT 1 FROM #tempAfiles WHERE SIDBStoreId = 0)
BEGIN
	IF OBJECT_ID('tempdb..#lt_archCreateCopySubClientDDBMApOutput') IS NOT NULL DROP TABLE #lt_archCreateCopySubClientDDBMApOutput
	CREATE TABLE #lt_archCreateCopySubClientDDBMApOutput (xmlOutput XML)
	IF object_id('tempdb.dbo.#inputApps') is not null DROP TABLE #inputApps
		CREATE TABLE #inputApps -- only populate appID and copyID if this table is being created in the caller
		(
			appId	 INT,
			copyId	 INT,
			appTypeId	INT,
			instanceId	INT,
			clientId  INT,
			clientstatus INT,
			releaseId INT,
			servicePack INT
		)
	INSERT INTO #inputApps(appId, copyId)
	SELECT DISTINCT appId, @i_auxCopyId  FROM #tempAfiles 	WHERE sidbStoreId = 0
	exec archCreateCopySubClientDDBMAp '', 1 /*isAuxCopy*/
	IF OBJECT_ID('tempdb..#lt_archCreateCopySubClientDDBMApOutput') IS NOT NULL DROP TABLE #lt_archCreateCopySubClientDDBMApOutput
	UPDATE	TAF
	SET		SIDBStoreId = S.SIDBStoreId
	FROM	#tempAfiles	TAF, archSubclientCopyDDBMap S WITH (READUNCOMMITTED)
	WHERE	TAF.appId = S.appId
			AND S.copyId = @i_auxCopyId AND TAF.SIDBStoreId = 0
END
IF (@l_isSnapCopy = 1 AND ((@l_copyExtendedFlags & 256) = 256) )
BEGIN
	-- Change the stream number for the none snap data archive files on replica snap copy to 1
	UPDATE	archFileCopy
	SET		StreamNum = 1
	FROM    archFileCopy A WITH (NOLOCK), #tempAfiles B
	WHERE	A.archFileId = B.archFileId
			AND A.commCellId = B.commCellId
			AND A.archCopyId = @i_auxCopyId
			AND A.isValid = 0
			AND A.physicalSize = 0
			AND A.streamNum != 1
AND (B.archFileFlags & 2) = 0
	SET @retVal = 0
	-- Remove the partially copied none snap data archive files on replica snap copy on stream number other than 1
	INSERT	INTO #ToBeAgedAFC
	SELECT	A.archFileId, A.commCellId, A.archCopyId, B.fileType
	FROM    archFileCopy A WITH (NOLOCK), #tempAfiles B
	WHERE	A.archFileId = B.archFileId
			AND A.commCellId = B.commCellId
			AND A.archCopyId = @i_auxCopyId
			AND A.isValid = 0
			AND A.physicalSize > 0
			AND A.streamNum != 1
AND (B.archFileFlags & 2) = 0
	IF EXISTS (SELECT * FROM #ToBeAgedAFC)
	BEGIN
EXEC @retVal = archFileSetAgedViaTable 68719476736, @now
		IF (@retVal = 0)
			EXEC @retVal = archFileDeleteViaTable @i_dummyParam, @magneticBytes OUTPUT
	END
END
IF (@l_isSnapCopy = 1 AND ((@l_copyExtendedFlags & 256) <> 256) )
BEGIN
	DELETE FROM #ToBeAgedAFC
	SET @retVal = 0
	INSERT	INTO #ToBeAgedAFC
	SELECT	DEST.archFileId, DEST.commCellId, DEST.archCopyId, TMP.fileType
	FROM    #tempAfiles TMP INNER JOIN archFileCopy DEST(NOLOCK)
				ON  DEST.archCopyId = @i_auxCopyId
				AND DEST.archFileId = TMP.archFileId
				AND DEST.commCellId = TMP.commCellId
			LEFT OUTER JOIN	archFileCopy SRC(NOLOCK)
				ON SRC.archFileId = TMP.archFileId
				AND SRC.commCellId = TMP.commCellId
				AND SRC.archCopyId = @i_srcCopyId
WHERE	DEST.isValid = 0 AND (SRC.archFileId IS NULL OR SRC.flags & 256 = 256)
AND (TMP.archFileFlags & 2) = 2
	IF EXISTS (SELECT * FROM #ToBeAgedAFC)
	BEGIN
EXEC @retVal = archFileSetAgedViaTable 17179869184, @now
		IF (@retVal = 0)
			EXEC @retVal = archFileDeleteViaTable @i_dummyParam, @magneticBytes OUTPUT
	END
END
IF	(SELECT	COUNT(DISTINCT PT.CopyId)
	FROM	MMDrivePool PL WITH (NOLOCK), MMDataPath PT WITH (NOLOCK)
	WHERE	PL.DrivePoolId = PT.DrivePoolId AND PT.CopyId IN (@i_srcCopyId, @i_auxCopyId) AND PL.DrivePoolType = 3) = 1
BEGIN
		SET	@useLogicalSize = 1
END
IF EXISTS (SELECT 1 FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'MMS2_CONFIG_ENABLE_AUTO_RECOPY_ON_ERROR' AND Value > 0)
	AND EXISTS(	SELECT	1
			FROM	#tempAfiles T, archFileCopy Src WITH (READUNCOMMITTED), archFileCopy Dest WITH (READUNCOMMITTED)
			WHERE	T.archFileId = Src.archFileId
					AND T.CommCellId = Src.CommCellId
					AND Src.archCopyId = @i_srcCopyId
					AND Src.archFileId = Dest.archFileId
					AND Src.commcellId = Dest.commCellId
					AND Dest.archCopyId = @i_auxCopyId
					AND ((@useLogicalSize =  0 AND Src.physicalSize < Dest.physicalSize) OR
						 (@useLogicalSize =  1 AND Src.logicalSize < Dest.logicalSize)))
BEGIN
	DELETE FROM #ToBeAgedAFC
	SET @retVal = 0
	-- Remove the partially copied none snap data archive files on replica snap copy on stream number other than 1
	INSERT	INTO #ToBeAgedAFC
	SELECT	Dest.archFileId, Dest.commCellId, Dest.archCopyId, T.fileType
	FROM    #tempAfiles T, archFileCopy Src WITH (READUNCOMMITTED), archFileCopy Dest WITH (READUNCOMMITTED)
			WHERE	T.archFileId = Src.archFileId
					AND T.CommCellId = Src.CommCellId
					AND Src.archCopyId = @i_srcCopyId
					AND Src.archFileId = Dest.archFileId
					AND Src.commcellId = Dest.commCellId
					AND Dest.archCopyId = @i_auxCopyId
					AND ((@useLogicalSize =  0 AND Src.physicalSize < Dest.physicalSize) OR
						 (@useLogicalSize =  1 AND Src.logicalSize < Dest.logicalSize))
	IF EXISTS (SELECT * FROM #ToBeAgedAFC)
	BEGIN
EXEC @retVal = archFileSetAgedViaTable 68719476736, @now
		IF (@retVal = 0)
			EXEC @retVal = archFileDeleteViaTable @i_dummyParam, @magneticBytes OUTPUT
	END
END
--If encKeys on source copy are protected with user pass phrase then we ignore dest copy encryption settings and copy data as is
--So we should preserve source copy encryption keys on dest copy regardless of options selected on dest copy.
UPDATE 	TAF
SET 	passPhraseProtected = 1
FROM	#tempAfiles TAF,
		App_Application App WITH(READUNCOMMITTED), App_ClientProp CP WITH(READUNCOMMITTED)
WHERE	TAF.appId = App.id
		AND App.clientId = CP.componentNameId
		AND CP.attrName = N'Encrypt: restoreAccess'
		AND CP.attrVal = '1'  /*ENC_RESTORE_PASSPHRASE*/
		AND CP.modified = 0
DECLARE @l_isMirrorAndLogicalRep bit = (case when EXISTS( SELECT 1 FROM ArchGroupControlHost WHERE ArchGroupId = @l_archGroupId AND SMReplicationProtocolType = 1)
										AND @l_isMirrorCopy = 1 then 1 else 0 end)
IF OBJECT_ID('tempdb.dbo.#tempArchFileSIDBKeys') IS NOT NULL DROP TABLE #tempArchFileSIDBKeys
CREATE TABLE #tempArchFileSIDBKeys
(
	archFileId 		INT,
	commCellId 		INT,
	encRSA 			INT,
	encKeyType 		INT,
encKey 			VARCHAR(1024),
	RowNumber 		INT,
	encKeyId		INT,
	primary key(archFileId, commCellId, RowNumber)
)
IF @l_copyDedupeFlags & 262144 > 0
BEGIN
	INSERT INTO #tempArchFileSIDBKeys
	SELECT 	K.archFileId, K.commCellId, ISNULL(keys.encRSA, K.encRSA), ISNULL(keys.encKeyType, K.encKeyType), ISNULL(keys.encKey, K.encKey),
			ROW_NUMBER() OVER (PARTITION BY K.archFileId, K.commCellId, T.SIDBStoreId ORDER BY K.archCopyId DESC) AS RowNumber,
			ISNULL(keys.encKeyId, K.encKeyId)
	FROM 	archFileSIDBKeys K WITH (NOLOCK) LEFT JOIN archEncKeys keys WITH (NOLOCK) ON K.encKeyId = keys.encKeyId
			INNER JOIN #tempAfiles T ON K.archFileId = T.archFileId AND K.CommCellid = T.CommCellid AND K.SIDBStoreId = T.SIDBStoreId
END
-- Readjust the stream numbers and encKeys for uncopied archive Files
IF @i_isForNewData = 0
BEGIN
	UPDATE	Dest
SET		StreamNum =  (case when @l_isMirrorAndLogicalRep = 1 then (case when (AF.Flags & 2) = 0 then 1 else (2) end)
when @l_isSnapCopy > 0 then (case when (AF.Flags & 2) = 0 then 1 else (2 + (AF.appId - 1)%@l_maxStreamForSnapCopy) end)
							else (1 + (Src.streamNum - 1)%@max_stream) end),
encRSA = (case when (@l_copyFlags & 1048576) > 0 OR TAF.passPhraseProtected = 1 OR (ISNULL(Afk.encRSA, Src.encRSA) & 16) > 0
							then (case when Afk.encRSA is null
then (case when (Src.encRSA & 2) > 0
then ((Src.encRSA & ~2) | 4)
													else Src.encRSA end)
										else Afk.encRSA end)
else ISNULL(Afk.encRSA, (case when (@l_copyFlags & 8388608) > 0 then Dest.encRSA else 0 end)) end),
encKeyType = (case when (@l_copyFlags & 1048576) > 0 OR TAF.passPhraseProtected = 1 OR (ISNULL(Afk.encRSA, Src.encRSA) & 16) > 0 then ISNULL(Afk.encKeyType, Src.encKeyType)
else ISNULL(Afk.encKeyType, (case when (@l_copyFlags & 8388608) > 0 then Dest.encKeyType else 0 end)) end),
encKey = (case when (@l_copyFlags & 1048576) > 0 OR TAF.passPhraseProtected = 1 OR (ISNULL(Afk.encRSA, Src.encRSA) & 16) > 0 then ISNULL(Afk.encKey, Src.encKey)
else ISNULL(Afk.encKey, (case when (@l_copyFlags & 8388608) > 0 then Dest.encKey else '' end)) end),
flags = (case when (@l_copyFlags & 1048576) > 0 AND TAF.passPhraseProtected <> 1 AND (ISNULL(Afk.encRSA, Src.encRSA) & 16) = 0 AND Src.encKeyType > 0 then Dest.flags & ~4096 else Dest.flags end),
encKeyId = (case when (@l_copyFlags & 1048576) > 0 OR TAF.passPhraseProtected = 1 OR (ISNULL(Afk.encRSA, Src.encRSA) & 16) > 0 then ISNULL(Afk.encKeyId, Src.encKeyId)
else ISNULL(Afk.encKeyId, (case when (@l_copyFlags & 8388608) > 0 then Dest.encKeyId else 0 end)) end)
	FROM	#tempAfiles TAF
			INNER JOIN archFileCopy Dest WITH (NOLOCK) ON TAF.archFileId = Dest.archFileId AND TAF.CommCellId = Dest.CommCellId AND Dest.archCopyId = @i_auxCopyId
			INNER JOIN archFileCopy Src WITH (NOLOCK) ON Dest.archFileId = Src.archFileId AND Dest.CommCellId = Src.CommCellId AND Src.archCopyId =  @i_srcCopyId
			INNER JOIN archFile AF WITH (NOLOCK) ON Dest.archFileId = AF.id AND Dest.CommCellId = AF.CommCellId
			LEFT OUTER JOIN #tempArchFileSIDBKeys Afk ON TAF.archFileId = Afk.archFileId AND TAF.commCellId = Afk.commCellId AND Afk.RowNumber = 1
WHERE	(Dest.Flags & 256) = 0
			AND Dest.isValid = 0
			AND
			(
				(
					--Uncopied AF
					Dest.physicalSize = 0
					AND Dest.logicalSize = 0
					AND Dest.lastChunkNumber = 0
				)
				OR
				(
					--Partially copied AF
((@l_copyFlags & 1048576) > 0 OR TAF.passPhraseProtected = 1 OR (ISNULL(Afk.encRSA, Src.encRSA) & 16) > 0)
					AND Src.encKeyType > 0 AND Dest.encKeyType = 0
					AND Dest.lastChunkNumber > 0
				)
			)
END
ELSE IF @l_jobType = 13 /*AUXCOPY*/
BEGIN
	UPDATE	Dest
SET		StreamNum =  (case when @l_isMirrorAndLogicalRep = 1 then (case when (AF.Flags & 2) = 0 then 1 else (2) end)
when @l_isSnapCopy > 0 then (case when (AF.Flags & 2) = 0 then 1 else (2 + (AF.appId - 1)%@l_maxStreamForSnapCopy) end)
							else (1 + (Src.streamNum - 1)%@max_stream) end),
encRSA = (case when (@l_copyFlags & 1048576) > 0 OR TAF.passPhraseProtected = 1 OR (ISNULL(Afk.encRSA, Src.encRSA) & 16) > 0
							then (case when Afk.encRSA is null
then (case when (Src.encRSA & 2) > 0
then ((Src.encRSA & ~2) | 4)
													else Src.encRSA end)
										else Afk.encRSA end)
else ISNULL(Afk.encRSA, (case when (@l_copyFlags & 8388608) > 0 then Dest.encRSA else 0 end)) end),
encKeyType = (case when (@l_copyFlags & 1048576) > 0 OR TAF.passPhraseProtected = 1 OR (ISNULL(Afk.encRSA, Src.encRSA) & 16) > 0 then ISNULL(Afk.encKeyType, Src.encKeyType)
else ISNULL(Afk.encKeyType, (case when (@l_copyFlags & 8388608) > 0 then Dest.encKeyType else 0 end)) end),
encKey = (case when (@l_copyFlags & 1048576) > 0 OR TAF.passPhraseProtected = 1 OR (ISNULL(Afk.encRSA, Src.encRSA) & 16) > 0 then ISNULL(Afk.encKey, Src.encKey)
else ISNULL(Afk.encKey, (case when (@l_copyFlags & 8388608) > 0 then Dest.encKey else '' end)) end),
flags = (case when (@l_copyFlags & 1048576) > 0 AND TAF.passPhraseProtected <> 1 AND (ISNULL(Afk.encRSA, Src.encRSA) & 16) = 0 AND Src.encKeyType > 0 then Dest.flags & ~4096 else Dest.flags end),
encKeyId = (case when (@l_copyFlags & 1048576) > 0 OR TAF.passPhraseProtected = 1 OR (ISNULL(Afk.encRSA, Src.encRSA) & 16) > 0 then ISNULL(Afk.encKeyId, Src.encKeyId)
else ISNULL(Afk.encKeyId, (case when (@l_copyFlags & 8388608) > 0 then Dest.encKeyId else 0 end)) end)
	FROM	#tempAfiles TAF
			INNER JOIN archFileCopy Dest WITH (NOLOCK) ON TAF.archFileId = Dest.archFileId AND TAF.CommCellId = Dest.CommCellId AND Dest.archCopyId = @i_auxCopyId
			INNER JOIN archFileCopy Src WITH (NOLOCK) ON Dest.archFileId = Src.archFileId AND Dest.CommCellId = Src.CommCellId AND Src.archCopyId =  @i_srcCopyId
			INNER JOIN archFile AF WITH (NOLOCK) ON Dest.archFileId = AF.id AND Dest.CommCellId = AF.CommCellId
			LEFT OUTER JOIN #tempArchFileSIDBKeys Afk ON TAF.archFileId = Afk.archFileId AND TAF.commCellId = Afk.commCellId AND Afk.RowNumber = 1
			LEFT OUTER JOIN archChunkToCopy ACC WITH (READUNCOMMITTED)
				ON ACC.adminJobId = @i_adminJobId AND ACC.archFileId = Dest.archFileId AND ACC.CommCellid = Dest.CommCellId AND ACC.destCopyId = Dest.archCopyId
			LEFT OUTER JOIN archChunkToCopyHistory ACCH WITH (READUNCOMMITTED)
				ON ACCH.adminJobId = @i_adminJobId AND ACCH.archFileId = Dest.archFileId AND ACCH.CommCellid = Dest.CommCellId AND ACCH.destCopyId = Dest.archCopyId
WHERE	(Dest.Flags & 256) = 0
			AND Dest.isValid = 0
			AND
			(
				(
					--Uncopied AF
					Dest.physicalSize = 0
					AND Dest.logicalSize = 0
					AND Dest.lastChunkNumber = 0
				)
				OR
				(
					--Partially copied AF
((@l_copyFlags & 1048576) > 0 OR TAF.passPhraseProtected = 1 OR (ISNULL(Afk.encRSA, Src.encRSA) & 16) > 0)
					AND Src.encKeyType > 0 AND Dest.encKeyType = 0
					AND Dest.lastChunkNumber > 0
				)
			)
			AND ACC.archFileId IS NULL
			AND ACCH.archFileId IS NULL
END
ELSE IF @l_jobType = 104 /*AUXCOPY2*/
BEGIN
	UPDATE	Dest
SET		StreamNum =  (case when @l_isMirrorAndLogicalRep = 1 then (case when (AF.Flags & 2) = 0 then 1 else (2) end)
when @l_isSnapCopy > 0 then (case when (AF.Flags & 2) = 0 then 1 else (2 + (AF.appId - 1)%@l_maxStreamForSnapCopy) end)
							else (1 + (Src.streamNum - 1)%@max_stream) end),
encRSA = (case when (@l_copyFlags & 1048576) > 0 OR TAF.passPhraseProtected = 1 OR (ISNULL(Afk.encRSA, Src.encRSA) & 16) > 0
							then (case when Afk.encRSA is null
then (case when (Src.encRSA & 2) > 0
then ((Src.encRSA & ~2) | 4)
													else Src.encRSA end)
										else Afk.encRSA end)
else ISNULL(Afk.encRSA, (case when (@l_copyFlags & 8388608) > 0 then Dest.encRSA else 0 end)) end),
encKeyType = (case when (@l_copyFlags & 1048576) > 0 OR TAF.passPhraseProtected = 1 OR (ISNULL(Afk.encRSA, Src.encRSA) & 16) > 0 then ISNULL(Afk.encKeyType, Src.encKeyType)
else ISNULL(Afk.encKeyType, (case when (@l_copyFlags & 8388608) > 0 then Dest.encKeyType else 0 end)) end),
encKey = (case when (@l_copyFlags & 1048576) > 0 OR TAF.passPhraseProtected = 1 OR (ISNULL(Afk.encRSA, Src.encRSA) & 16) > 0 then ISNULL(Afk.encKey, Src.encKey)
else ISNULL(Afk.encKey, (case when (@l_copyFlags & 8388608) > 0 then Dest.encKey else '' end)) end),
flags = (case when (@l_copyFlags & 1048576) > 0 AND TAF.passPhraseProtected <> 1 AND (ISNULL(Afk.encRSA, Src.encRSA) & 16) = 0 AND Src.encKeyType > 0 then Dest.flags & ~4096 else Dest.flags end),
encKeyId = (case when (@l_copyFlags & 1048576) > 0 OR TAF.passPhraseProtected = 1 OR (ISNULL(Afk.encRSA, Src.encRSA) & 16) > 0 then ISNULL(Afk.encKeyId, Src.encKeyId)
else ISNULL(Afk.encKeyId, (case when (@l_copyFlags & 8388608) > 0 then Dest.encKeyId else 0 end)) end)
	FROM	#tempAfiles TAF
			INNER JOIN archFileCopy Dest WITH (NOLOCK) ON TAF.archFileId = Dest.archFileId AND TAF.CommCellId = Dest.CommCellId AND Dest.archCopyId = @i_auxCopyId
			INNER JOIN archFileCopy Src WITH (NOLOCK) ON Dest.archFileId = Src.archFileId AND Dest.CommCellId = Src.CommCellId AND Src.archCopyId =  @i_srcCopyId
			INNER JOIN archFile AF WITH (NOLOCK) ON Dest.archFileId = AF.id AND Dest.CommCellId = AF.CommCellId
			LEFT OUTER JOIN #tempArchFileSIDBKeys Afk ON TAF.archFileId = Afk.archFileId AND TAF.commCellId = Afk.commCellId AND Afk.RowNumber = 1
			LEFT OUTER JOIN archChunkToReplicate ACR WITH (READUNCOMMITTED)
				ON ACR.adminJobId = @i_adminJobId AND ACR.archFileId = Dest.archFileId AND ACR.CommCellid = Dest.CommCellId AND ACR.destCopyId = Dest.archCopyId
WHERE	(Dest.Flags & 256) = 0
			AND Dest.isValid = 0
			AND
			(
				(
					--Uncopied AF
					Dest.physicalSize = 0
					AND Dest.logicalSize = 0
					AND Dest.lastChunkNumber = 0
				)
				OR
				(
					--Partially copied AF
((@l_copyFlags & 1048576) > 0 OR TAF.passPhraseProtected = 1 OR (ISNULL(Afk.encRSA, Src.encRSA) & 16) > 0)
					AND Src.encKeyType > 0 AND Dest.encKeyType = 0
					AND Dest.lastChunkNumber > 0
				)
			)
			AND ACR.archFileId IS NULL
END
DELETE #tempAfiles
FROM   archFileCopy A WITH (NOLOCK), #tempAfiles B
WHERE  A.archFileId = B.archFileId AND A.commCellId = B.commCellId AND A.archCopyId = @i_auxCopyId
INSERT INTO #AddAFilesResultOpTbl
SELECT DISTINCT 1,6,CONVERT(VARCHAR(32),AFC.jobId),AFC.commCellId
FROM	#tempAfiles AFC LEFT JOIN JMJobDataStats J WITH (NOLOCK)
	ON	J.jobId = AFC.jobId AND J.commCellId = AFC.commCellId
	AND J.archGrpCopyId = @i_srcCopyId AND J.dataType = AFC.fileType
AND J.status = 100 AND J.disabled & (1 + 256) = 0
	AND (@l_ignoreDVFailedJobs = 0 OR J.archCheckStatus != 6/*ACS_FAILED */)
WHERE	J.jobId IS NULL
	AND AFC.jobId not in (select jobID FROM #tempIncompleteJobs)
-- Hold on recopy until the old chunks have been deleted
DELETE #tempAfiles
FROM	#tempAfiles AFC LEFT JOIN JMJobDataStats J WITH (NOLOCK)
	ON	J.jobId = AFC.jobId AND J.commCellId = AFC.commCellId
	AND J.archGrpCopyId = @i_srcCopyId AND J.dataType = AFC.fileType
AND J.status = 100 AND J.disabled & (1 + 256) = 0
	AND (@l_ignoreDVFailedJobs = 0 OR J.archCheckStatus != 6/*ACS_FAILED */)
WHERE	J.jobId IS NULL
	AND AFC.jobId not in (select jobID FROM #tempIncompleteJobs)
IF NOT EXISTS (SELECT * FROM #tempAfiles )
BEGIN
 	-- This is not an error. If source copy has no jobs, we get here.
  	   GOTO CX_EXIT;
END
IF	@l_copyDedupeFlags & 262144 > 0
BEGIN
	UPDATE	A
SET		Status = A.Status | 2
	OUTPUT INSERTED.archFileId, INSERTED.CommCellId INTO #tempMMDeletedAfiles
	FROM   MMDeletedAF A, #tempAfiles B, IdxSIDBStore C WITH (NOLOCK)
	WHERE  A.archFileId = B.archFileId
	AND A.CommCellId = B.CommCellId
	AND A.SIDBStoreId = B.SIDBStoreId
	AND C.SIDBStoreId = A.SIDBStoreId
AND (C.flags & 2097152) = 0
	INSERT INTO #AddAFilesResultOpTbl
SELECT DISTINCT 1,1,CONVERT(VARCHAR(32),B.jobId),B.commCellId
	FROM   #tempMMDeletedAfiles A, #tempAfiles B
	WHERE  A.archFileId = B.archFileId
	AND A.CommCellId = B.CommCellId
	-- Hold on recopy until the old chunks have been deleted
	DELETE B
	FROM   #tempMMDeletedAfiles A, #tempAfiles B
	WHERE  A.archFileId = B.archFileId
	AND A.CommCellId = B.CommCellId
	INSERT INTO #AddAFilesResultOpTbl
SELECT DISTINCT 1,3,CONVERT(VARCHAR(32),B.jobId), B.commCellId
	FROM   MMTempDeletedAF A WITH (NOLOCK), #tempAfiles B, IdxSIDBStore C WITH (NOLOCK)
	WHERE  A.archFileId = B.archFileId
	AND  A.CommCellId = B.CommCellId
	AND A.SIDBStoreId = B.SIDBStoreId
	AND C.SIDBStoreId = A.SIDBStoreId
AND (C.flags & 2097152) = 0
	-- Hold on recopy until the DDB backup runs
	DELETE #tempAfiles
	FROM   MMTempDeletedAF A WITH (NOLOCK), #tempAfiles B, IdxSIDBStore C WITH (NOLOCK)
	WHERE  A.archFileId = B.archFileId
	AND  A.CommCellId = B.CommCellId
	AND A.SIDBStoreId = B.SIDBStoreId
	AND C.SIDBStoreId = A.SIDBStoreId
AND (C.flags & 2097152) = 0
END
IF	@l_copyDedupeFlags & 262144 > 0
	AND NOT EXISTS(SELECT * from MMConfigs WHERE name = 'MMS2_CONFIG_AUXCOPY_BY_ARCHIVE_FILE_ORDER' AND value > 0)
BEGIN
	-- Do not copy multiplexed jobs
	INSERT	INTO #muxJobs
	SELECT	DISTINCT B.jobId, B.commCellId
	FROM	archFileCopy A WITH (NOLOCK), #tempAfiles B
	WHERE	A.archFileId = B.archFileId AND A.commCellId = B.commCellId AND A.archCopyId = @i_srcCopyId
AND (A.flags & 64) <> 0
	-- 2014/09/08 : Removing GAT lookup which was causing data truncation error.
	-- We do not need to look into GAT to identify concatenated vs. multiplexed jobs anymore. Since V10 we support copying muxed jobs to dedupe copies with the above MM Config param set.
	IF EXISTS (SELECT * FROM #muxJobs)
	BEGIN
	INSERT INTO #AddAFilesResultOpTbl
SELECT DISTINCT 1,2,CONVERT(VARCHAR(1024),B.jobId), B.commCellId
			FROM	#tempAfiles A, #muxJobs B
			WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId
	END
	DELETE	#tempAfiles
	FROM	#tempAfiles A, #muxJobs B
	WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId
END
SET @retVal = @@ERROR
IF	@retVal = 0
BEGIN
	IF	@l_isSnapCopy > 0
	BEGIN
		-- For LREP Storage Policy and Mirror destination, we want to use on stream for all snaps.
		IF	EXISTS( SELECT * FROM ArchGroupControlHost WHERE ArchGroupId = @l_archGroupId AND SMReplicationProtocolType = 1) AND
			@l_isMirrorCopy = 1
		BEGIN
			INSERT	INTO archFileCopy
			SELECT	A.archFileId, A.commCellId, @i_auxCopyId,
(case when A.flags & (32 + 128) = 0 then B.flags else B.flags | 32 end),
(case when (B.archFileFlags & 2) = 0 and A.physicalSize = 0 then A.isValid else 0 end),
(case when (B.archFileFlags & 2) = 0 then 1 else (2) end),
					0, 0, 0, 0, A.encRSA, A.encKeyType, A.encKey, @now, 0, 0, A.encKeyId, -1
			FROM	archFileCopy A, #tempAfiles B
			WHERE	A.archFileId = B.archFileId AND A.commCellId = B.commCellId AND A.archCopyId = @i_srcCopyId
		END
		ELSE
		BEGIN
			INSERT INTO archFileCopy
			SELECT	A.archFileId, A.commCellId, @i_auxCopyId,
(case when A.flags & (32 + 128) = 0 then B.flags else B.flags | 32 end),
(case when (B.archFileFlags & 2) = 0 and A.physicalSize = 0 then A.isValid else 0 end),
(case when (B.archFileFlags & 2) = 0 then 1 else (2 + (B.appId - 1)%@l_maxStreamForSnapCopy) end),
					0, 0, 0, 0, A.encRSA, A.encKeyType, A.encKey, @now, 0, 0, A.encKeyId, -1
			FROM	archFileCopy A, #tempAfiles B
			WHERE	A.archFileId = B.archFileId AND A.commCellId = B.commCellId AND A.archCopyId = @i_srcCopyId
		END
		INSERT INTO #AddAFilesResultOpTbl VALUES(0,0,'',0)
	END
	ELSE
IF	@l_copyDedupeFlags & 262144 > 0
	BEGIN
		/*
		 * If destination copy has sealed stores then
		 * Reuse same key across all stores of a copy, for gdsp reuse same key across all copies of a store also.
		 * 1. If a store is sealed and archFile gets recopied with active store then reuse key from sealed store.
		 * 2. For GDSP if a copy is deleted and created a new copy then reuse key from deleted copy.
		 * If found entry in archFileSIDBKeys for above cases and there is no row with current active store
		 * then insert row for current active store so that archFileCopy table gets populated properly in below insert.
		 */
		DECLARE @l_KeyCopyId INT = @i_auxCopyId
IF (@l_copyDedupeFlags & 134217728) > 0
		BEGIN
			SELECT	@l_KeyCopyId = AG.defaultCopy
			FROM	archCopyToGlobalPolicy GP, archGroup AG
			WHERE	GP.copyId = @i_auxCopyId
					AND GP.globalPolicyId = AG.id
AND ((AG.flags & 256) > 0)
		END
		INSERT INTO archFileSIDBKeys
		SELECT 	B.archFileId, B.commCellId, @i_auxCopyId,
				case when B.encKeyId > 0 then 0 else B.encKeyType end,
				case when B.encKeyId > 0 then '' else B.encKey end,
				B.afSIDBStoreId,
				B.encRSA,
				B.encKeyId
		FROM	(SELECT K.*, T.SIDBStoreId afSIDBStoreId, ROW_NUMBER() OVER (PARTITION BY K.archFileId, K.commCellId ORDER BY K.SIDBStoreId DESC, K.archCopyId DESC) AS RowNumber
				 FROM 	archFileSIDBKeys K
						INNER JOIN #tempAfiles T ON K.archFileId = T.archFileId AND K.commCellId = T.commCellId
						INNER JOIN archCopySIDBStore S WITH (NOLOCK) ON K.SIDBStoreId = S.SIDBStoreId AND S.copyId = @l_KeyCopyId
						LEFT OUTER JOIN archFileSIDBKeys SK ON T.archFileId = SK.archFileId AND T.commCellId = SK.commCellId AND SK.archCopyId = @i_auxCopyId AND SK.SIDBStoreId = T.SIDBStoreId
				 WHERE 	SK.archFileId IS NULL
				) B
		WHERE	B.RowNumber = 1
		-- Use Picked CommCellID to choose only those jobs with this CommCellID.
		/*
		 * Prasad Nara March 21, 2018
		 *
		 * Copy keys from source when
		 * 1. DestCopy is set to "Preserve encryption mode as in source"  OR
		 * 2. Passphrase is enabled on client.
		 *	  We can't decrypt or re-encrypt data since keys are encrypted using the user passphrase which won't be available at the time of auxcopy.  OR
		 * 3. Source encKey is encrypted using company RSA.
		 *	  Company level KeyManagementServer is set then we shouldn't decrypt or re-encrypt data.
		 *
		 * If we copy keys from source and source encKey is encrypted using copy RSA then we need to adjust the key.
		 * Decrypt using source copy RSA and encrypt back using dest copy RSA.
		 * if no key is copied for no encryption or passphrase or company RSA then set a flag CVA_AFC_COMPUTED_DEST_ENC_KEY to skip calling key adjustment code.
		 */
		INSERT INTO #tempAfiles_encDetails
		SELECT DISTINCT T.*, ISNULL(keys.encRSA, K.encRSA), ISNULL(keys.encKeyType, K.encKeyType), ISNULL(keys.encKey, K.encKey), ROW_NUMBER() OVER (PARTITION BY T.archFileId, T.commCellId, T.SIDBStoreId ORDER BY K.archCopyId DESC) AS RowNumber, K.encKeyId
				FROM	#tempAfiles T LEFT OUTER JOIN archFileSIDBKeys K WITH (NOLOCK)
					ON	K.archFileId = T.archFileId AND K.commCellId = T.commCellId AND K.SIDBStoreId = T.SIDBStoreId
					LEFT OUTER JOIN archEncKeys keys WITH (NOLOCK) ON K.encKeyId = keys.encKeyId
		INSERT INTO archFileCopy
		SELECT	A.archFileId, A.commCellId, @i_auxCopyId,
(case when A.flags & (32 + 128) = 0 then B.flags else B.flags | 32 end)
| (case when (@l_copyFlags & 1048576) > 0 AND B.passPhraseProtected <> 1 AND (ISNULL(B.encRSA, A.encRSA) & 16) = 0 AND A.encKeyType > 0 then 0 else 4096 end),
(case when (B.archFileFlags & 2) = 0 and A.physicalSize = 0 then A.isValid else 0 end),
				(1 + (A.streamNum - 1)%@max_stream),
				0, 0, 0, 0,
(case when (@l_copyFlags & 1048576) > 0 OR B.passPhraseProtected = 1 OR (ISNULL(B.encRSA, A.encRSA) & 16) > 0 then
(case when B.encRSA is null then (case when (A.encRSA & 2) > 0 then ((A.encRSA & ~2) | 4) else A.encRSA end) else B.encRSA end) else ISNULL(B.encRSA, 0) end),
(case when (@l_copyFlags & 1048576) > 0 OR B.passPhraseProtected = 1 OR (ISNULL(B.encRSA, A.encRSA) & 16) > 0 then ISNULL(B.encKeyType, A.encKeyType) else ISNULL(B.encKeyType, 0) end),
(case when (@l_copyFlags & 1048576) > 0 OR B.passPhraseProtected = 1 OR (ISNULL(B.encRSA, A.encRSA) & 16) > 0 then ISNULL(B.encKey, A.encKey) else ISNULL(B.encKey, '') end),
				@now, 0, 0,
(case when (@l_copyFlags & 1048576) > 0 OR B.passPhraseProtected = 1 OR (ISNULL(B.encRSA, A.encRSA) & 16) > 0 then ISNULL(B.encKeyId, A.encKeyId) else ISNULL(B.encKeyId, 0) end), -1
		FROM	archFileCopy A, #tempAfiles_encDetails B
		WHERE	A.archFileId = B.archFileId AND A.commCellId = B.commCellId AND A.archCopyId = @i_srcCopyId AND RowNumber = 1 AND A.commCellId = @PickedCommCellID
		-- Insert @PickedCommCellID to log in auxcopyreserve to tell the user that jobs from this CC were picked for auxcopy.
		INSERT INTO #AddAFilesResultOpTbl VALUES(0,0,'',@PickedCommCellID)
		-- Populate keys in archFileSIDBKeys when no key adjustment is needed
		INSERT INTO archFileSIDBKeys
		SELECT	DISTINCT T.archFileId, T.commCellId, T.archCopyId,
				case when T.encKeyId > 0 then 0 else T.encKeyType end,
				case when T.encKeyId > 0 then '' else T.encKey end,
				T.SIDBStoreId,
				T.encRSA,
				T.encKeyId
		FROM	(
					SELECT	A.archFileId, A.commCellId, A.archCopyId, A.encKeyType, A.encKey, A.encRSA, B.SIDBStoreId, A.encKeyId
					FROM	archFileCopy A, #tempAfiles B
					WHERE	A.archFileId = B.archFileId AND A.commCellId = B.commCellId AND A.archCopyId = @i_auxCopyId
AND (A.encRSA & (4 | 1)) = 0 AND A.encKeyType > 0
				) T LEFT OUTER JOIN archFileSIDBKeys K
			ON	K.archFileId = T.archFileId AND K.commCellId = T.commCellId AND K.SIDBStoreId = T.SIDBStoreId
		WHERE	K.archFileId Is Null
		-- If the recopy option was selected then we should delete the rows from archFileSubStore otherwise primary and secondary obj count will get duplicated
		-- Since the recopy is not populating MMDeletedAF table with original archive file id, we are not removing the row.
		-- DELETE FROM archFileSubStore
		-- FROM	archFileSubStore SS, #tempAfiles AF
		-- WHERE	SS.archFileId = AF.archFileId
		-- 		AND SS.CommCellId = AF.CommCellId
		-- 		AND SS.SIDBStoreId = @l_SIDBStoreId
		DELETE FROM	#tempAfiles
		FROM	#tempAfiles T LEFT OUTER JOIN archFileCopy AFC
			ON	T.archFileId = AFC.archFileId
				AND T.CommCellId = AFC.CommCellId
				AND AFC.archCopyId = @i_auxCopyId
		WHERE AFC.archFileID IS NULL
		INSERT	INTO archFileCopyDedup(archFileId, commCellId, archCopyId, SIDBStoreId,
										primaryObjects, secondaryObjects, primaryObjSize, secondaryObjSize,
										primaryMetaDataSize, secondaryMetaDataSize, transDataSize, savedDataSize)
		SELECT  T.archFileId, T.CommCellId, @i_auxCopyId, T.SIDBStoreId,
				0, 0, 0, 0,
				0, 0, 0, 0
		FROM	#tempAfiles T
		INSERT INTO archFileSubStore(archFileId, commCellId, SIDBStoreId, SIDBSubStoreId, primaryObjects, secondaryObjects)
		SELECT	T.archFileId, T.CommCellId, S.SIDBStoreId, S.SubStoreId, 0, 0
		FROM	IdxSIDBSubStore S WITH (NOLOCK) INNER JOIN #tempAfiles T ON S.SIDBStoreId = T.SIDBStoreId
					LEFT OUTER JOIN archFileSubStore AFS ON T.archFileId = AFS.archFileId AND T.CommCellId = AFS.CommCellId AND AFS.SIDBStoreId = S.SIDBStoreId AND AFS.SIDBSubStoreId = S.SubStoreId
		WHERE	AFS.archFileId IS NULL
		-- MR 90535 CCM DATA LOSS
		-- Need to add skipped jobs into #AddAFilesResultOpTbl.
		-- error code #define CVA_AUXCOPY_DBIF_NOCOPY_CCM_DEDUPECOPY			4
		-- Add skipped jobs into #AddAFilesResultOpTbl
		INSERT INTO #AddAFilesResultOpTbl
SELECT DISTINCT 1,4,CONVERT(VARCHAR(32),B.jobId), B.commCellId
		FROM   #tempAfiles B, archGroupCopy AGC WITH (NOLOCK)
		WHERE   B.commCellId <> @PickedCommCellID AND AGC.id = @i_auxCopyId
	END
	ELSE
	BEGIN
		INSERT INTO archFileCopy
		SELECT	A.archFileId, A.commCellId, @i_auxCopyId,
(case when A.flags & (32 + 128) = 0 then B.flags else B.flags | 32 end)
| (case when (@l_copyFlags & 1048576) > 0 AND B.passPhraseProtected <> 1 AND (A.encRSA & 16) = 0 AND A.encKeyType > 0 then 0 else 4096 end),
(case when (B.archFileFlags & 2) = 0 and A.physicalSize = 0 then A.isValid else 0 end),
				(1 + (A.streamNum - 1)%@max_stream),
				0, 0, 0, 0,
(case when (@l_copyFlags & 1048576) > 0 OR B.passPhraseProtected = 1 OR (A.encRSA & 16) > 0 then
(case when (A.encRSA & 2) > 0 then ((A.encRSA & ~2) | 4) else A.encRSA end) else 0 end),
(case when (@l_copyFlags & 1048576) > 0 OR B.passPhraseProtected = 1 OR (A.encRSA & 16) > 0 then A.encKeyType else 0 end),
(case when (@l_copyFlags & 1048576) > 0 OR B.passPhraseProtected = 1 OR (A.encRSA & 16) > 0 then A.encKey else '' end),
				@now, 0, 0,
(case when (@l_copyFlags & 1048576) > 0 OR B.passPhraseProtected = 1 OR (A.encRSA & 16) > 0 then A.encKeyId else 0 end), -1
		FROM	archFileCopy A, #tempAfiles B
		WHERE	A.archFileId = B.archFileId AND A.commCellId = B.commCellId AND A.archCopyId = @i_srcCopyId
		INSERT INTO #AddAFilesResultOpTbl VALUES(0,0,'',0)
	END
IF ((@l_copyExtendedFlags & 1024) = 0)
	BEGIN
			-- if re-encrypt is enabled then set the flag as AFs will get enc anyway.
IF ((@l_copyFlags & 8388608) > 0)
			BEGIN
				UPDATE archGroupCopy
SET extendedFlags |= 1024
				WHERE	((id = @i_auxCopyId) OR (id IN (SELECT copyId FROM archCopySIDBStore S, @tblDestCopyStoreList TS WHERE S.SIDBStoreId = TS.SIDBStoreId)))
				-- If re-encrypt option, then also we need to set the flag on all the copies of the store.
			END
			ELSE
			BEGIN
				DECLARE @isEncAFExist INT = 0
IF (@l_copyDedupeFlags & 262144 > 0)
				BEGIN
					IF EXISTS (SELECT 1 FROM archFileSIDBKeys C WITH (READUNCOMMITTED), @tblDestCopyStoreList TS WHERE C.SIDBStoreId = TS.SIDBStoreId)
						SET @isEncAFExist = 1
					-- For the first auxcopy AFSIDBKeys may not be populated for passthru (due to key adjustment changes), so also check in AFC table.
					ELSE IF EXISTS (SELECT 1 FROM archFileCopy AFC WITH (READUNCOMMITTED) WHERE AFC.archCopyId = @i_auxCopyId AND AFC.encKeyType > 0)
						SET @isEncAFExist = 1
				END
				ELSE IF EXISTS (SELECT 1 FROM archFileCopy AFC WITH (READUNCOMMITTED) WHERE AFC.archCopyId = @i_auxCopyId AND AFC.encKeyType > 0)
					SET @isEncAFExist = 1
				UPDATE archGroupCopy
SET extendedFlags |= 1024
				WHERE (@isEncAFExist > 0)
				    AND ((id = @i_auxCopyId) OR (id IN (SELECT copyId FROM archCopySIDBStore S, @tblDestCopyStoreList TS WHERE S.SIDBStoreId = TS.SIDBStoreId)))
AND extendedFlags & 1024 = 0
			END
	END
	DECLARE @VolFlagsV2IndexingEnabled BIGINT = 536870912 /*CVSM_VOLUMEFLAGS_VM_LEVEL_SNAP*/ + 4294967296 /*CVSM_VOLUMEFLAGS_VSA_V2_SNAP*/
	UPDATE	AFC
	SET		AFC.isValid = 1, AFC.modifiedTime = @now
	FROM	archFileCopy AFC, #tempAfiles B, SMVolume SMV WITH (READUNCOMMITTED)
	WHERE	AFC.archFileId = B.archFileId AND AFC.commCellId = B.commCellId AND AFC.archCopyId = @i_auxCopyId
			AND AFC.isValid = 0
AND (B.archFileFlags & 2) > 0 AND B.fileType = 1
			AND B.jobId = SMV.MasterJobId AND B.CommCellId = SMV.CommCellId
			AND (SMV.VolumeFlags & @VolFlagsV2IndexingEnabled) = @VolFlagsV2IndexingEnabled
	SET	@retVal = @@ERROR
END
CX_EXIT:
IF object_id('tempdb.dbo.#muxJobs') IS NOT null DROP TABLE #muxJobs
IF object_id('tempdb.dbo.#tempJobs') IS NOT null DROP TABLE #tempJobs
IF object_id('tempdb.dbo.#tempIncompleteJobs') IS NOT null DROP TABLE #tempIncompleteJobs
IF object_id('tempdb.dbo.#tempAfiles') IS NOT null DROP TABLE #tempAfiles
IF object_id('tempdb.dbo.#tempMMDeletedAfiles') IS NOT null DROP TABLE #tempMMDeletedAfiles
IF object_id('tempdb.dbo.#ToBeAgedAFC') IS NOT null DROP TABLE #ToBeAgedAFC
IF OBJECT_ID('tempdb..#tmpAppIdList') IS NOT NULL DROP TABLE #tmpAppIdList
IF object_id('tempdb.dbo.#tempAfiles_encDetails') IS NOT null DROP TABLE #tempAfiles_encDetails
if object_id('tempdb.dbo.#archCopyToAppId') is not null DROP TABLE #archCopyToAppId
--SELECT   @retVal
SELECT * FROM #AddAFilesResultOpTbl
ORDER BY retVal
IF object_id('tempdb.dbo.#AddAFilesResultOpTbl') IS NOT null DROP TABLE #AddAFilesResultOpTbl
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'AddToBeCopiedAfilesByCopyInBatches')
	delete from GxQscripts where name = 'AddToBeCopiedAfilesByCopyInBatches'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AddToBeCopiedAfilesByCopyInBatches')
	delete from GXDBVersions where aliasname = 'AddToBeCopiedAfilesByCopyInBatches'
GO

insert into GXDBVersions values(2, 'AddToBeCopiedAfilesByCopyInBatches',  '00010001000200400000', 'AddToBeCopiedAfilesByCopyInBatches', '00010001000200400000')
GO

