

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APP_DetectHighTempDBUsageSPID.sp] ---------- 

-- ----------------------------------------------------------------------
--
--  Copyright (c) CommVault Systems
--  All Rights Reserved
--
--  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems
--  The copyright notice above does not evidence any
--  actual or intended publication of such source code.
--
--  File name   : APP_DetectHighTempDBUsageSPID.sp
--
--  Description : Checks and reports high tempdb usage.
--
--  Input : net_hostname
--  output: SPIDs, Process ID, Process name, DB Name tempdb alloc pages
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='APP_DetectHighTempDBUsageSPID')
BEGIN
	print '>>> Drop Stored Procedure: APP_DetectHighTempDBUsageSPID <<<'
	drop procedure APP_DetectHighTempDBUsageSPID
END
IF EXISTS (select * from GxQscripts where name='APP_DetectHighTempDBUsageSPID')
	delete from GxQscripts where name = 'APP_DetectHighTempDBUsageSPID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APP_DetectHighTempDBUsageSPID')
	delete from GXDBVersions where aliasname = 'APP_DetectHighTempDBUsageSPID'
GO
print '... Creating Procedure: APP_DetectHighTempDBUsageSPID'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure APP_DetectHighTempDBUsageSPID
  @net_hostName VARCHAR(1024)
AS
  DECLARE @spid INT
  DECLARE @hostprocess INT
  DECLARE @program_name VARCHAR(255)
  DECLARE @dbname VARCHAR(255)
  DECLARE @tempDbAllocsPages INT
-- tunables
DECLARE @tempDbThresholdForCorrectiveAction		INT		= 85 -- DEFAULT
DECLARE @maxTempDbSizeMB						FLOAT	= NULL
DECLARE @currentTempDbSizeMB					FLOAT	= NULL
DECLARE	@logSpaceUsedSizeMB						FLOAT	= NULL
DECLARE @currentToMaxRatio						FLOAT	= NULL
DECLARE @machineName							VARCHAR(120)
DECLARE @displayXMLOutput						INT     = 1
DECLARE @XMLData								XML = NULL
-- Table variables
DECLARE @tempDbDetails TABLE (
  physical_name		VARCHAR(1024),
  driveName			VARCHAR(10),
  sizePages			INT,
  max_size_pages	INT,
  growth			INT,
  actualMaxSizeMB	INT
);
DECLARE @driveDetails TABLE (
  driveName				varchar(20),
  totalSpaceMB			INT,
  TempDbAllowedSpaceMB	INT
);
-- Populate the Disk Usage Details
INSERT into @driveDetails SELECT distinct(volume_mount_point),
total_bytes / 1048576 AS Free_in_MB,
0
FROM
  sys.master_files AS f
  CROSS APPLY
  sys.dm_os_volume_stats(f.database_id, f.file_id);
-- Populate the tempdb files details
INSERT into @tempDbDetails
SELECT physical_name,
		SUBSTRING(physical_name, 1, 3),
		size,
		max_size,
		growth,
		0
FROM
  tempdb.sys.database_files;
-- Get the actual max sizes of each tempdb file
UPDATE
  T2
SET
  T2.actualMaxSizeMB =	CASE
						WHEN T2.growth = 0 THEN T2.sizePages / 128
						WHEN T2.growth <> 0 THEN	CASE
													WHEN T2.max_size_pages <> -1 THEN T2.max_size_pages / 128
													WHEN T2.max_size_pages = -1 THEN T1.totalSpaceMB
													END
						END
FROM
  @driveDetails T1
  INNER JOIN @tempDbDetails T2 ON T1.driveName = T2.driveName;
-- Get the disk space to be considered and if greater than update it also
UPDATE
  @driveDetails
SET
  TempDbAllowedSpaceMB = B.maxn
FROM
  @driveDetails A
  INNER JOIN (
    SELECT
      SUM(actualMaxSizeMB) maxn,
      driveName
    FROM
      @tempDbDetails
    GROUP BY
      driveName
  ) B ON B.driveName = A.driveName
-- Update if the requirement is greater than the disk space
UPDATE
  @driveDetails
SET
  TempDbAllowedSpaceMB = CASE
						WHEN TempDbAllowedSpaceMB > totalSpaceMB THEN totalSpaceMB
						ELSE TempDbAllowedSpaceMB
						END;
-- Get the max tempdb size as sum of TempDbAllowedSpaceMB
-- Similarly get current tempdb size that has been used
SET
  @maxTempDbSizeMB = (
    select
      SUM(TempDbAllowedSpaceMB)
    from
      @driveDetails
  );
SET
  @logSpaceUsedSizeMB = (
    SELECT
      cntr_value
    from
      sys.dm_os_performance_counters
    where
      counter_name = 'Log File(s) Used Size (KB)'
      and instance_name = 'tempdb'
  )/ 1024;
SET
  @currentTempDbSizeMB = (
    SELECT
      (
        SUM(allocated_extent_page_count)/ 128
      ) AS [Used Space (MB) ]
    FROM
      tempdb.sys.dm_db_file_space_usage --database_id '2' represents tempdb
    WHERE
      database_id = 2
  ) + @logSpaceUsedSizeMB;
-- get the machine name
SET
  @machineName = (
    select
      name
    from
      APP_CLIENT WITH (NOLOCK)
    where
      net_hostname = @net_hostName
  );
SET @currentToMaxRatio = (@currentTempDbSizeMB/@maxTempDbSizeMB) * 100
-- get the threshold
SELECT
  @tempDbThresholdForCorrectiveAction = CAST(value AS INT)
FROM
  gxglobalparam with(NOLOCK)
WHERE
  name = 'TempDbThresholdForCorrectiveAction'
  and modified = 0
-- check for incorrect values
if @tempDbThresholdForCorrectiveAction > 100 OR @tempDbThresholdForCorrectiveAction < 1
Begin
	set @tempDbThresholdForCorrectiveAction = 85 -- set to 85% if entered value is more than 100% or less than 1%
End
if @currentToMaxRatio >= @tempDbThresholdForCorrectiveAction
	BEGIN
		exec SQLActiveTempDbLogGrowthXML 1,
		@i_outputXML = @XMLData OUT DECLARE @tempDbGrowthTable TABLE (
		  spid INT,
		  dbName VARCHAR(255),
		  hostname VARCHAR(255),
		  pgmName VARCHAR(255),
		  TempDbLogSpaceKb INT,
		  tempDbAllocsPages INT
		)
		INSERT INTO @tempDbGrowthTable
		SELECT
		  Tbl.Col.value('@spid', 'INT'),
		  Tbl.Col.value('@dbName', 'VARCHAR(255)'),
		  Tbl.Col.value('@hostname', 'VARCHAR(255)'),
		  Tbl.Col.value('@pgmName', 'VARCHAR(255)'),
		  Tbl.Col.value('@TempDbLogSpaceKb', 'INT'),
		  Tbl.Col.value('@tempDbAllocsPages', 'INT')
		FROM
		  @XMLData.nodes('/ActiveSPIDs/SPID') Tbl(Col)
		SELECT
		  A.spid,
		  A.hostprocess,
		  B.pgmName,
		  B.dbName as dbname,
		  ISNULL(B.tempDbAllocsPages, 0) as tempDbAllocsPages
		FROM
		  sys.sysprocesses as A
		  INNER JOIN @tempDbGrowthTable as B on A.spid = B.spid
		WHERE
		  A.hostname = @machineName
		  and (
			B.TempDbLogSpaceKb != 0
			or B.tempDbAllocsPages != 0
		  )
	End
GO

IF EXISTS (select * from GxQscripts where name = 'APP_DetectHighTempDBUsageSPID')
	delete from GxQscripts where name = 'APP_DetectHighTempDBUsageSPID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APP_DetectHighTempDBUsageSPID')
	delete from GXDBVersions where aliasname = 'APP_DetectHighTempDBUsageSPID'
GO

insert into GXDBVersions values(2, 'APP_DetectHighTempDBUsageSPID',  '00000000000000000000', 'APP_DetectHighTempDBUsageSPID', '00000000000000000000')
GO

