

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APP_CheckForDuplicateEntityProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--  Copyright (c) CommVault Systems
--  All Rights Reserved
--
--  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems
--  The copyright notice above does not evidence any
--  actual or intended publication of such source code.
--
--  File name   : APP_CheckForDuplicateEntityProp.sp
--
--  Description : Check for duplicate Entity properties
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='APP_CheckForDuplicateEntityProp')
BEGIN
	print '>>> Drop Stored Procedure: APP_CheckForDuplicateEntityProp <<<'
	drop procedure APP_CheckForDuplicateEntityProp
END
IF EXISTS (select * from GxQscripts where name='APP_CheckForDuplicateEntityProp')
	delete from GxQscripts where name = 'APP_CheckForDuplicateEntityProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APP_CheckForDuplicateEntityProp')
	delete from GXDBVersions where aliasname = 'APP_CheckForDuplicateEntityProp'
GO
print '... Creating Procedure: APP_CheckForDuplicateEntityProp'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure APP_CheckForDuplicateEntityProp
AS
	-- Clean APP_ClientProp table
	DELETE FROM CP
	FROM APP_ClientProp AS CP
		   INNER JOIN (
						 SELECT
							   componentNameId,
							   attrName, attrVal,
							   MAX(id) AS MaxId
						 FROM APP_ClientProp WITH(READUNCOMMITTED)
						 WHERE modified = 0
						 GROUP BY
							   componentNameId,
							   attrName,
							   attrVal
						 HAVING
							   COUNT(id) > 1
		   ) t ON
				  CP.componentNameId = t.ComponentNameId
				  AND CP.attrName = t.attrName
				  AND CP.attrVal = t.attrVal
				  AND CP.modified = 0
	WHERE
		   CP.id <> t.MaxId
	-- Clean APP_InstanceProp table
	DELETE FROM IP
	FROM APP_InstanceProp AS IP
		   INNER JOIN (
						 SELECT
							   componentNameId,
							   attrName,attrVal,
							   MAX(id) AS MaxId
						 FROM APP_InstanceProp WITH(READUNCOMMITTED)
						 WHERE modified = 0
						 GROUP BY
							   componentNameId,
							   attrName,
							   attrVal
						 HAVING
							   COUNT(id) > 1
		   ) t ON
				  IP.componentNameId = t.ComponentNameId
				  AND IP.attrName = t.attrName
				  AND IP.attrVal = t.attrVal
				  AND IP.modified = 0
	WHERE
		   IP.id <> t.MaxId
	-- Clean APP_IdaProp table
	DELETE FROM IDP
	FROM APP_IdaProp AS IDP
		   INNER JOIN (
						 SELECT
							   componentNameId,
							   attrName,attrVal,
							   MAX(id) AS MaxId
						 FROM APP_IdaProp WITH(READUNCOMMITTED)
						 WHERE modified = 0
						 GROUP BY
							   componentNameId,
							   attrName,
                               attrVal
						 HAVING
							   COUNT(id) > 1
		   ) t ON
				  IDP.componentNameId = t.ComponentNameId
				  AND IDP.attrName = t.attrName
				  AND IDP.attrVal = t.attrVal
				  AND IDP.modified = 0
	WHERE
		   IDP.id <> t.MaxId
	-- Clean APP_BackupSetProp table
	DELETE FROM BSP
	FROM APP_BackupSetProp AS BSP
		   INNER JOIN (
						 SELECT
							   componentNameId,
							   attrName,attrVal,
							   MAX(id) AS MaxId
						 FROM APP_BackupSetProp WITH(READUNCOMMITTED)
						 WHERE modified = 0
						 GROUP BY
							   componentNameId,
							   attrName,
                               attrVal
						 HAVING
							   COUNT(id) > 1
		   ) t ON
				  BSP.componentNameId = t.ComponentNameId
				  AND BSP.attrName = t.attrName
				  AND BSP.attrVal = t.attrVal
				  AND BSP.modified = 0
	WHERE
		   BSP.id <> t.MaxId
GO

IF EXISTS (select * from GxQscripts where name = 'APP_CheckForDuplicateEntityProp')
	delete from GxQscripts where name = 'APP_CheckForDuplicateEntityProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APP_CheckForDuplicateEntityProp')
	delete from GXDBVersions where aliasname = 'APP_CheckForDuplicateEntityProp'
GO

insert into GXDBVersions values(2, 'APP_CheckForDuplicateEntityProp',  '00000000000000000000', 'APP_CheckForDuplicateEntityProp', '00000000000000000000')
GO

