

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPStoreDataInterfacePairs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPStoreDataInterfacePairs')
BEGIN
	print '>>> Drop Stored Procedure: APPStoreDataInterfacePairs <<<'
	drop procedure APPStoreDataInterfacePairs
END
IF EXISTS (select * from GxQscripts where name='APPStoreDataInterfacePairs')
	delete from GxQscripts where name = 'APPStoreDataInterfacePairs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPStoreDataInterfacePairs')
	delete from GXDBVersions where aliasname = 'APPStoreDataInterfacePairs'
GO
print '... Creating Procedure: APPStoreDataInterfacePairs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPStoreDataInterfacePairs
  @i_xml varchar(max),
  @i_commcellId integer
AS
  DECLARE @sourceClientId int
  DECLARE @sourceClientName varchar(MAX)
  DECLARE @sourceClientInterface varchar(64)
  DECLARE @destClientId int
  DECLARE @destClientName varchar(MAX)
  DECLARE @destClientInterface varchar(64)
  DECLARE @active int
set nocount on
/* Sample input XML
<App_CreateOrUpdateDataInterfacePairsReq>
     <dataInterfacePairs>
	   <DestInterface clientInterface="3.3.3.3">
	        <client _type_="3" clientId="2"/>
	   </DestInterface>
	   <SourceInterface clientInterface="rnannurilinuxvm">
	      <client _type_="3" clientId="3"/>
		</SourceInterface>
		</dataInterfacePairs>
 </App_CreateOrUpdateDataInterfacePairsReq>
*/
declare @doc int
declare @error integer
exec sp_xml_preparedocument @doc output, @i_xml
set @error = @@error
if @error <> 0 goto finish
declare @InterfacePairTable table
(
	sourceClientId int,
	sourceClientName varchar(MAX),
sourceClientInterface varchar(64),
	destClientId int,
	destClientName varchar(MAX),
destClientInterface varchar(64),
	active int,
	addOrUpdate int DEFAULT 0
)
declare @i_xmlString XML = @i_xml
insert @InterfacePairTable ( sourceClientId, sourceClientInterface, destClientId, destClientInterface, active)
select ISNULL (ref.value('(SourceInterface/client/@clientId)[1]', 'INT'), 0),
       ISNULL (ref.value('(SourceInterface/@clientInterface)[1]', 'NVARCHAR(MAX)'),''),
	   ISNULL (ref.value('(DestInterface/client/@clientId)[1]', 'INT'),0),
	   ISNULL (ref.value('(DestInterface/@clientInterface)[1]', 'NVARCHAR(MAX)'),''),
	   ISNULL (ref.value('(@active)[1]', 'INT'),0)
from @i_xmlString.nodes ('App_CreateOrUpdateDataInterfacePairsReq/dataInterfacePairs')  R(ref)
set @error = @@error
if @error <> 0 goto finish
/* Delete all entries which have default values, as these are not valid entries*/
delete @InterfacePairTable
where sourceClientId = 0 OR destClientId = 0 OR RTrim(LTrim(destClientInterface))=''  OR RTrim(LTrim(sourceClientInterface))=''
/* Delete all duplicate entries which exists in archpipeline table*/
delete @InterfacePairTable from @InterfacePairTable ip
where exists
(
	select Id from archPipeLine
	where
	(
		srcClientId = ip.sourceClientId and destClientId= ip.destClientId and RTrim(LTrim(srcInterface)) = RTrim(LTrim(ip.sourceClientInterface)) and RTrim(LTrim(destInterface)) = RTrim(LTrim(ip.destClientInterface))
	)
)
or
(
	ip.sourceClientId = ip.destClientId
)
set @error = @@error
if @error <> 0 goto finish
update @InterfacePairTable  set addOrUpdate=1
from archPipeline as arch, @InterfacePairTable ip
where arch.srcClientId = ip.sourceClientId  and arch.destClientId = ip.destClientId
DECLARE @update INTEGER = @@ROWCOUNT
update @InterfacePairTable set  sourceClientName = ac.name
from APP_Client (NOLOCK) AS ac
where sourceClientId = ac.id
UPDATE  @InterfacePairTable
SET destClientName = ac.name
FROM APP_Client (NOLOCK) AS ac
WHERE destClientId = ac.id
update archPipeline set srcInterface = ip.sourceClientInterface ,destInterface = ip.destClientInterface,isActive = ip.active
from @InterfacePairTable ip,archPipeline arch
where arch.srcClientId = ip.sourceClientId and arch.destClientId = ip.destClientId and ip.addOrUpdate = 1
set @error = @@error
if @error <> 0 goto finish
DECLARE @archPipelineId INTEGER = 0
DECLARE @requestType INTEGER = 0
insert into archPipeline (srcClientId, srcInterface, destClientId, destInterface, isActive, srcIp, destIP, useCount_h, useCount_l,srcGroupId, destGroupId)
select p.sourceClientId, p.sourceClientInterface, p.destClientId, p.destClientInterface, p.Active, '', '', 0, 0,0,0  from @InterfacePairTable p where addOrUpdate = 0
IF @@ROWCOUNT<>0
	SET @archPipelineId = SCOPE_IDENTITY()
/*
*	When archPipeline table is modified, we also need to handle entries in archPipelineFirewall table so that commvault network configuration is updated.
*	For this xml is constructed similar to the following xml :
*
*	<App_WildcardDIPWorkqueueParams requestType="1" archpipelineID="1">
*		<newDIP srcInterface="172*" destInterface="172.16.26.53" srcType="2" destType="0" isActive="1">
*			<srcClientGroup clientGroupId="5"/>
*			<destClient clientId="2"/>
*		</newDIP>
*	</App_WildcardDIPWorkqueueParams>
*/
DECLARE @srcClientIdForXML INTEGER = 0
DECLARE @destClientIdForXML INTEGER = 0
SELECT @srcClientIdForXML = sourceClientId, @destClientIdForXML = destClientId
FROM @InterfacePairTable
DECLARE @updateArchPipelineFirewallXML XML = (
												SELECT sourceClientInterface AS srcInterface, destClientInterface AS destInterface, active AS isActive
												, 0 AS srcType, 0 AS destType, 0 AS flags
												FROM @InterfacePairTable newDIP
												FOR XML AUTO, ROOT ('App_WildcardDIPWorkqueueParams')
											)
IF @updateArchPipelineFirewallXML IS NULL
	GOTO finish
SET @updateArchPipelineFirewallXML.modify('
											insert <srcClient clientId="{sql:variable("@srcClientIdForXML")}"/>
											into (/App_WildcardDIPWorkqueueParams[1]/newDIP[1])[1]
										  ')
SET @updateArchPipelineFirewallXML.modify('
											insert <destClient clientId="{sql:variable("@destClientIdForXML")}"/>
											into (/App_WildcardDIPWorkqueueParams[1]/newDIP[1])[1]
										  ')
IF @update<>0
BEGIN
	-- Update
	SET @requestType = 3
	SELECT @archPipelineId = APL.id
	FROM archPipeline APL, @InterfacePairTable IP
	WHERE APL.srcClientId=IP.sourceClientId AND APL.destClientId=IP.destClientId AND IP.addOrUpdate=1
END
ELSE
BEGIN
	--Insert
	SET @requestType = 1
END
SET @updateArchPipelineFirewallXML.modify('
											insert (attribute archpipelineID {sql:variable("@archPipelineId")})
											into (/App_WildcardDIPWorkqueueParams)[1]
										  ')
SET @updateArchPipelineFirewallXML.modify('
											insert (attribute requestType {sql:variable("@requestType")})
											into (/App_WildcardDIPWorkqueueParams)[1]
										')
DECLARE @TemporaryResult TABLE (errorCode INTEGER, errorMessage NVARCHAR(MAX))
INSERT INTO @TemporaryResult
EXEC AppProcessDIPs @updateArchPipelineFirewallXML, @requestType
set @error = @@error
finish:
if @error <> 0 delete from @InterfacePairTable
if @doc <> 0 exec sp_xml_removedocument @doc
select sourceClientId,sourceClientName,sourceClientInterface,destClientId,destClientName,destClientInterface,active from @InterfacePairTable
GO

IF EXISTS (select * from GxQscripts where name = 'APPStoreDataInterfacePairs')
	delete from GxQscripts where name = 'APPStoreDataInterfacePairs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPStoreDataInterfacePairs')
	delete from GXDBVersions where aliasname = 'APPStoreDataInterfacePairs'
GO

insert into GXDBVersions values(2, 'APPStoreDataInterfacePairs',  '00000000000000000000', 'APPStoreDataInterfacePairs', '00000000000000000000')
GO

