

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPSetTPPMForClient.sp] ---------- 

-- ==================================================================================================================
--  Author:         	Pushpendra Singh
--  Create date:        08/29/2018
--  Description:        To provide the way to allow TPPM port Mapping for a client
--
--  Input : :      clientId, port number
--  Output : :
-- ====================================================================================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPSetTPPMForClient <<<'

IF EXISTS (select * from sysobjects where name='APPSetTPPMForClient')
	drop procedure APPSetTPPMForClient
IF EXISTS (select * from GxQscripts where name='APPSetTPPMForClient')
	delete from GxQscripts where name = 'APPSetTPPMForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPSetTPPMForClient')
	delete from GXDBVersions where aliasname = 'APPSetTPPMForClient'
GO
print '... Creating Procedure: APPSetTPPMForClient'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure APPSetTPPMForClient
  @clientId integer,
  @toPortNo integer,
  @fromPortNo integer = 0,
  @tppmType integer  =  8,
  @entityType integer = 3
AS
  DECLARE @errorCode INTEGER
  DECLARE @errorString NVARCHAR(MAX)
SET @errorCode = 0
SET @errorString = N''
BEGIN TRY
    IF NOT EXISTS (SELECT 1 FROM APP_FirewallTPPM (NOLOCK) WHERE fromEntityId = @clientId AND toEntityId = @clientId AND toPortNumber= @toPortNo)
            INSERT INTO  APP_FirewallTPPM (tppmType, fromEntityType, fromEntityId, fromPortNumber, toEntityType, toEntityId, toPortNumber, status, tppmParams)
                 VALUES (@tppmType, @entityType, @clientId, @fromPortNo, @entityType, @clientId, @toPortNo, 1, '')
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
      SET @errorCode = ERROR_NUMBER()
      SET @errorString = 'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
END  CATCH
   SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'APPSetTPPMForClient')
	delete from GxQscripts where name = 'APPSetTPPMForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPSetTPPMForClient')
	delete from GXDBVersions where aliasname = 'APPSetTPPMForClient'
GO

insert into GXDBVersions values(2, 'APPSetTPPMForClient',  '00000000000000000000', 'APPSetTPPMForClient', '00000000000000000000')
GO

