

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPSetSubscriptionbasedAlerts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPSetSubscriptionbasedAlerts.sp,v $ $Id: APPSetSubscriptionbasedAlerts.sp,v 1.2.88.10 2019/09/12 21:47:22 vmishra Exp $";
--	+===================================================================+
--	| APPSetSubscriptionbasedAlerts - Set Subscriptionbased Alerts							|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPSetSubscriptionbasedAlerts')
BEGIN
	print '>>> Drop Stored Procedure: APPSetSubscriptionbasedAlerts <<<'
	drop procedure APPSetSubscriptionbasedAlerts
END
IF EXISTS (select * from GxQscripts where name='APPSetSubscriptionbasedAlerts')
	delete from GxQscripts where name = 'APPSetSubscriptionbasedAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPSetSubscriptionbasedAlerts')
	delete from GXDBVersions where aliasname = 'APPSetSubscriptionbasedAlerts'
GO
print '... Creating Procedure: APPSetSubscriptionbasedAlerts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPSetSubscriptionbasedAlerts
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @in_xml XML ,
  @out_Xml XML OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
----------------------------------------------------------
DECLARE @errorCode INT
DECLARE @errorMessage VARCHAR(MAX)
----------------------------------------------------------
--- HERE IS WHERE WE WILL EXTRACT THE XML TO:          ---
----------------------------------------------------------
DECLARE @userId						integer = 0
DECLARE @localeId					integer = 0
DECLARE @userGUID					VARCHAR(64)
DECLARE @clientId					integer = 0
DECLARE @overrideLocalSubscription	integer = 0
DECLARE @escalationLevel			integer = 1 -- For Web console
DECLARE @opMsgId					integer
DECLARE @opEvMsgId					integer
DECLARE @opId						integer
DECLARE @paramMsgId					integer
DECLARE	@entityType1				integer = 0
DECLARE	@entityId1					integer = 0
DECLARE	@entityType2				integer = 0
DECLARE	@entityId2					integer = 0
DECLARE	@entityType3				integer = 0
DECLARE	@entityId3					integer = 0
DECLARE	@entityType4				integer = 0
DECLARE	@entityId4					integer = 0
DECLARE	@entityType5				integer = 0
DECLARE	@entityId5					integer = 0
DECLARE @entityString				nvarchar(maX)=''
DECLARE @entity						xml
DECLARE @entityHierarchy			xml
DECLARE @auditChanges				integer = 0
DECLARE @SMSNotificationFlag		integer = NULL
DECLARE @changeInSMSNotifFlag		integer = 0
-----------------------------------------------
--- EXTRACT FROM THE XML                    ---
-----------------------------------------------
	SET @localeId = ISNULL (( SELECT ref.value('@localeId', 'INT')
						FROM @in_Xml.nodes ('CVGui_SetSubscriptionbasedAlertsReq/processinginstructioninfo/locale') R(ref)), 0)
	SET @userGUID = ISNULL (( SELECT ref.value('@userGUID', 'VARCHAR(64)')
                    FROM @in_Xml.nodes ('CVGui_SetSubscriptionbasedAlertsReq/processinginstructioninfo/user') R(ref)), null)
	if (@userGUID IS NOT NULL)
		SET @userId = ISNULL ((SELECT top 1 id FROM UMUsers WHERE userGuid = @userGUID), 0)
    SET @userId = ISNULL (( SELECT ref.value('@userId', 'INT')
                    FROM @in_Xml.nodes ('CVGui_SetSubscriptionbasedAlertsReq/processinginstructioninfo/user') R(ref)), @userId)
    SET @clientId = ISNULL (( SELECT ref.value('@clientId', 'INT')
                    FROM @in_Xml.nodes ('CVGui_SetSubscriptionbasedAlertsReq/client') R(ref)), 0)
    SET @overrideLocalSubscription = ISNULL (( SELECT ref.value('@overrideLocalSubscription', 'INT')
                    FROM @in_Xml.nodes ('CVGui_SetSubscriptionbasedAlertsReq') R(ref)), 0)
	SET @entity		= @in_Xml.query('CVGui_SetSubscriptionbasedAlertsReq/entity')
	SET @SMSNotificationFlag = ( SELECT ref.value('@IsSMSNotificationEnabled', 'INT')
                    FROM @in_Xml.nodes ('CVGui_SetSubscriptionbasedAlertsReq') R(ref))
	IF ISNULL((SELECT attrVal FROM UMUsersProp WHERE componentNameId = @userId AND modified = 0 AND attrName = 'SMS Alerts Enabled'),0) <> @SMSNotificationFlag
	BEGIN
		SET @changeInSMSNotifFlag = 1
		IF EXISTS(SELECT * FROM UMUsersProp WHERE componentNameId = @userId AND modified = 0 AND attrName = 'SMS Alerts Enabled')
		BEGIN
			UPDATE UMUsersProp
			SET attrVal = @SMSNotificationFlag
			WHERE componentNameId = @userId AND modified = 0 AND attrName = 'SMS Alerts Enabled'
		END
		ELSE
		BEGIN
			INSERT INTO UMUsersProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@userId, 'SMS Alerts Enabled',7, @SMSNotificationFlag, dbo.GetUnixTimeBig(GETDATE()), 0)
		END
	END
	-- Convert entity node to CvEntities_GenericEntity
	SET @entityString = convert(nvarchar(max),@entity)
	SET @entityString = replace(@entityString,'<entity>','<CvEntities_GenericEntity>')
	SET @entityString = replace(@entityString,'</entity>','</CvEntities_GenericEntity>')
	SET @entityString = replace(@entityString,'<entity ','<CvEntities_GenericEntity ')
	SET @entity		  = @entityString
	SET @entityHierarchy = dbo.getEntityTypeHirearchyXMLFromGenericEntityXML(@entity)
	SELECT @entityType1 = IsNull(ref.value('@entityType1', 'int'),0),
		@entityId1 = IsNull(ref.value('@entityId1','int'),0),
		@entityType2 = IsNull(ref.value('@entityType2','int'),0),
		@entityId2 = IsNull(ref.value('@entityId2','int'),0),
		@entityType3 = IsNull(ref.value('@entityType3','int'),0),
		@entityId3 = IsNull(ref.value('@entityId3','int'),0),
		@entityType4 = IsNull(ref.value('@entityType4','int'),0),
		@entityId4 = IsNull(ref.value('@entityId4','int'),0),
		@entityType5 = IsNull(ref.value('@entityType5','int'),0),
		@entityId5 = IsNull(ref.value('@entityId5','int'),0)
		From @entityHierarchy.nodes('entityAssociated') R ( ref )
	if (@clientId<>0)
	begin
		SET @entityType1 = 3
		SET @entityId1 = @clientId
	end
	else if (@entityType1 = 3 AND @entityType2=0 AND @entityType3=0 AND @entityType4=0 AND @entityType5=0)
	begin
		set @clientId = @entityId1
	end
	--if @entityType1 = 0
	--begin
	--	set @entityType1 = 3 -- Set it to client by default. if its not set.
	--end
--Input
--SELECT	@localeId localeId
--		, @userGUID userGUID, @userId userId
--		, @clientId clientId
--		, @overrideLocalSubscription overrideLocalSubscription
DECLARE @NTAlertSubScriptionsTemp TABLE
								(
									  alertId	int
									, flags		int
								)
INSERT INTO @NTAlertSubScriptionsTemp
SELECT		ISNULL(ref.value('alert[1]/@alertId', 'INT'), 0) ntRuleId
,	(CASE WHEN (ISNULL(ref.value('@enabled', 'INT'), 0)) <> 0 THEN 1 ELSE 0 END)
	FROM @in_Xml.nodes ('CVGui_SetSubscriptionbasedAlertsReq/subscriptionList') R(ref)
declare @planId int = 0
set @planId = dbo.AppGetPlanForUser(@userId)
DECLARE @constAttrType_Alert                INT = 262
DECLARE @constAttrName_Alert                NVARCHAR(32) = N'Alert'
-- Check via global param whether new security key is enabled or not. If not enabled, retain original behaviour. Else check for security
if exists(select 1 from Gxglobalparam where name='bEnableSecurityForSubscriptionAlerts' and value='true' and modified=0)
	OR @planId>0
begin
	if object_id('tempdb.dbo.#alertList') is not null
	BEGIN
		DROP TABLE #alertList
	END
	CREATE TABLE #alertList (NTnotificationId integer NOT NULL)
EXEC sec_getNonIdaObjectsForThisUser @userId, 64, 154, '#alertList'
	if (@planId>0)
	begin
		declare @AlertsForPlan table
		(
			alertId int
		)
		INSERT INTO @AlertsForPlan
SELECT  DISTINCT CONVERT (INT, RTRIM(LTRIM(SUBSTRING(attrName, LEN('Alert') + 1, 32))))
            FROM    App_PlanProp WITH (READUNCOMMITTED)
WHERE   attrName LIKE 'Alert' + '%' AND componentNameId = @planId
UNION   SELECT _ID FROM dbo.SplitIDString(dbo.AppPlanGetEntityValue(@planId, 'Alert', default))
		 Insert into #alertList
		 select distinct alertId from @AlertsForPlan
		 where alertId not in
		 (
			select NTnotificationId from #alertList
		 )
	end
	declare @alertIdWithSecError int
	set @alertIdWithSecError = 0
	-- In case user is trying to subscribe to an alert which he doesnt have to rights to, we throw error
	select @alertIdWithSecError=NTAlertSubScriptionsTemp.alertId from @NTAlertSubScriptionsTemp NTAlertSubScriptionsTemp left join #alertList alertList
		on NTAlertSubScriptionsTemp.alertId = alertList.NTnotificationId
		where alertList.NTnotificationId is NULL
	if @alertIdWithSecError>0
	begin
		set @errorCode = 1
		set @errorMessage = ''
		DECLARE @alertName nvarchar(max)
		select @alertName = notificationName
		from NTnotificationrule where id=@alertIdWithSecError
SET @errorCode = (1220 | (CAST(POWER(2, 24) AS BIGINT) * 74))
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (1220 | (CAST(POWER(2, 24) AS BIGINT) * 74)) and localeid = @localeId)
		SET @errorMessage = REPLACE(@errorMessage, '^1%s', @alertName)
		SET @out_Xml = (
			SELECT @errorCode AS '@errorCode', @errorMessage AS '@errorMessage'
			FOR XML PATH('CVGui_SetSubscriptionbasedAlertsResp')
		)
		return
	end
end
SET @opMsgId = (378 | (CAST(POWER(2, 24) AS BIGINT) * 84))
IF @entityId1 = 0 AND @overrideLocalSubscription <> 0
begin
	-- Do it for alerts which user can see in front end.
	DELETE NTAlertSubScriptions FROM NTAlertSubScriptions INNER JOIN NTNotificationRule ON NTNotificationRule.id = NTAlertSubScriptions.ntRuleId
	AND userId = @userId AND entityId1 <> 0 AND escalationLevel = @escalationLevel
AND (NTNotificationRule.status & 262144)=0 -- Dont do it for hidden alerts.
SET @paramMsgId = (1030 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	-- Now if local subscription is being overriden, then lets audit it.
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @userId, 13 , @userId, @opEvMsgId OUTPUT, @opId OUTPUT
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
end
DECLARE @NTAlertSubScriptionChangesTemp TABLE
(
		alertId	int,
		oldFlags int,
		newFlags int
)
if (@clientId>0 AND @entityId2=0) OR @changeInSMSNotifFlag > 0
begin
	set @auditChanges=1
end
-- Lets have the result once before the updation and once after.
Insert into @NTAlertSubScriptionChangesTemp(alertId,oldFlags,newFlags)
select ntRuleId,flags,NULL from NTAlertSubscriptions
WHERE userId = @userId AND escalationLevel = @escalationLevel
AND entityId1 = @entityId1 AND entityType1 = @entityType1
AND entityId2 = @entityId2 AND entityType2 = @entityType2
AND entityId3 = @entityId3 AND entityType3 = @entityType3
AND entityId4 = @entityId4 AND entityType4 = @entityType4
AND entityId5 = @entityId5 AND entityType5 = @entityType5
UPDATE temp
SET temp.flags = (temp.flags | (~ 1 &  db.flags))
FROM NTAlertSubScriptions db , @NTAlertSubScriptionsTemp temp
WHERE db.userId = @userId AND db.escalationLevel = @escalationLevel AND db.ntRuleId = temp.alertId
AND db.entityId1 = @entityId1 AND db.entityType1 = @entityType1
AND db.entityId2 = @entityId2 AND db.entityType2 = @entityType2
AND db.entityId3 = @entityId3 AND db.entityType3 = @entityType3
AND db.entityId4 = @entityId4 AND db.entityType4 = @entityType4
AND db.entityId5 = @entityId5 AND db.entityType5 = @entityType5
-- We only want to overwrite entries for alerts which can be seen by user currently
-- Suppose an alert is disabled or has its subscription flag removed, then it wont be visible to end user
-- Then his earlier preferences on this alert shldnt be lost.
DELETE FROM NTAlertSubScriptions WHERE userId = @userId AND escalationLevel = @escalationLevel
and ntRuleId in
(
	select alertId from @NTAlertSubScriptionsTemp
)
AND entityId1 = @entityId1 AND entityType1 = @entityType1
AND entityId2 = @entityId2 AND entityType2 = @entityType2
AND entityId3 = @entityId3 AND entityType3 = @entityType3
AND entityId4 = @entityId4 AND entityType4 = @entityType4
AND entityId5 = @entityId5 AND entityType5 = @entityType5
INSERT INTO NTAlertSubScriptions (ntRuleId, userId, escalationLevel, flags, entityId1,entityType1,entityId2,entityType2,
	entityId3,entityType3,entityId4,entityType4,entityId5,entityType5 )
SELECT		alertId ntRuleId
		,	@userId userId
		,	@escalationLevel escalationLevel
		,	flags flags
		,	@entityId1
		,	@entityType1
		,	@entityId2
		,	@entityType2
		,	@entityId3
		,	@entityType3
		,	@entityId4
		,	@entityType4
		,	@entityId5
		,	@entityType5
	FROM @NTAlertSubScriptionsTemp
Merge @NTAlertSubScriptionChangesTemp as Temp
using (select NTRuleId,flags from NTAlertSubscriptions
	WHERE userId = @userId AND escalationLevel = @escalationLevel
	AND entityId1 = @entityId1 AND entityType1 = @entityType1
	AND entityId2 = @entityId2 AND entityType2 = @entityType2
	AND entityId3 = @entityId3 AND entityType3 = @entityType3
	AND entityId4 = @entityId4 AND entityType4 = @entityType4
	AND entityId5 = @entityId5 AND entityType5 = @entityType5
) as currentData
on currentData.nTRuleId = Temp.alertId
WHEN NOT MATCHED THEN
	Insert(alertId,oldFlags,newFlags)
	values(currentData.nTRuleId,null,currentData.flags)
WHEN MATCHED THEN
	Update SET Temp.newFlags = currentData.flags;
	delete from @NTAlertSubScriptionChangesTemp
	where newFlags is null and oldFlags is NULL
	if @auditChanges=1
	begin
		if exists(select 1 from @NTAlertSubScriptionChangesTemp
			where newFlags is null Or oldFlags is null or newFlags!=oldFlags)
		begin
SET @paramMsgId = (1030 | (CAST(POWER(2, 24) AS BIGINT) * 85))
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @userId, 13 , @userId, @opEvMsgId OUTPUT, @opId OUTPUT
			declare @cursoralertName nvarchar(max)
			declare @cursorOldFlags int
			declare @cursorNewFlags int
			declare @isLocal	bit
			declare @isSelected bit
			set @isSelected = 0
			set @isLocal = 1
			if @clientId = 0
			begin
				set @isLocal = 0
			end
			declare cur_changed CURSOR LOCAL for
			select notificationName, oldFlags, newFlags from @NTAlertSubScriptionChangesTemp ChangesTemp
			inner join NTNotificationRule on
			NTNotificationRule.id = ChangesTemp.alertId
			where newFlags is null Or oldFlags is null or newFlags!=oldFlags
			open cur_changed
			fetch next from cur_changed into @cursoralertName, @cursorOldFlags,@cursorNewFlags
			WHILE @@FETCH_STATUS = 0
			BEGIN
				set @isSelected = @cursorNewFlags
				if (@isSelected = 1)
				begin
					if (@isLocal = 1)
					begin
SET @paramMsgId = (1031 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					end
					else
					begin
SET @paramMsgId = (1033 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					end
				end
				else
				begin
					if (@isLocal = 1)
					begin
SET @paramMsgId = (1032 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					end
					else
					begin
SET @paramMsgId = (1034 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					end
				end
				EXEC EvGuiAuditSetParamData @opId, @cursoralertName, 0
				if (@isLocal = 1)
				begin
					declare @clientName nvarchar(max)
					select @clientName = name from App_Client where id = @clientId
					if @clientName is NULL
						set @clientName = ''
					EXEC EvGuiAuditSetParamData @opId, @clientName, 0
				end
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
    			fetch next from cur_changed into @cursoralertName, @cursorOldFlags,@cursorNewFlags
			END
			close cur_changed
			deallocate cur_changed
		end
		IF @changeInSMSNotifFlag = 1
		BEGIN
			if (@SMSNotificationFlag  = 1)
			begin
SET @paramMsgId = (1762 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			end
			else
			begin
SET @paramMsgId = (1763 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			end
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @userId, 13 , @userId, @opEvMsgId OUTPUT, @opId OUTPUT
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
	end
	SET @out_Xml = (
		SELECT @errorCode AS '@errorCode', @errorMessage AS '@errorMessage'
		FOR XML PATH('CVGui_SetSubscriptionbasedAlertsResp')
	)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPSetSubscriptionbasedAlerts')
	delete from GxQscripts where name = 'APPSetSubscriptionbasedAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPSetSubscriptionbasedAlerts')
	delete from GXDBVersions where aliasname = 'APPSetSubscriptionbasedAlerts'
GO

insert into GXDBVersions values(2, 'APPSetSubscriptionbasedAlerts',  '00010002008800100000', 'APPSetSubscriptionbasedAlerts', '00010002008800100000')
GO

