

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPSetOneTouchOwner.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPSetOneTouchOwner.sp,v $ $Id: APPSetOneTouchOwner.sp,v 1.7.32.7 2020/05/16 00:49:38 alakra Exp $";
--    +===================================================================+
--    | APPSetOneTocuchOwner - For OneTouch set the owner for the new client                                |
--    +===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPSetOneTouchOwner')
BEGIN
	print '>>> Drop Stored Procedure: APPSetOneTouchOwner <<<'
	drop procedure APPSetOneTouchOwner
END
IF EXISTS (select * from GxQscripts where name='APPSetOneTouchOwner')
	delete from GxQscripts where name = 'APPSetOneTouchOwner'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPSetOneTouchOwner')
	delete from GXDBVersions where aliasname = 'APPSetOneTouchOwner'
GO
print '... Creating Procedure: APPSetOneTouchOwner'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPSetOneTouchOwner
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS                                         ---
  @userName nvarchar(255),
  @oldClientId integer,
  @newClientId integer
-----------------------------------------------------------
AS
  DECLARE @o_errorCode integer
  DECLARE @o_errorString char(255)
SET NOCOUNT ON
SET @o_errorCode = 0
SET @o_errorString = ''
DECLARE @userId int = 0
DECLARE @capabilities bigint
DECLARE @includeUsersFlags int = -1;
SET @includeUsersFlags = ( CAST (0x001 AS INT) )
BEGIN TRY
      SET @userId = ISNULL((SELECT id FROM UMUsers WHERE login=@userName AND flags & @includeUsersFlags <> 0), 0)
      IF @userId=0
      BEGIN
            SET @o_errorCode = 1
            SET @o_errorString = 'User not found.'
      END
      IF NOT EXISTS(SELECT * FROM APP_Client WHERE id=@oldClientId)
      BEGIN
            SET @o_errorCode = 2
            SET @o_errorString = 'Original clientId not found.'
      END
      IF NOT EXISTS(SELECT * FROM APP_Client WHERE id=@newClientId)
      BEGIN
            SET @o_errorCode = 3
            SET @o_errorString = 'New clientId not found.'
      END
IF(@o_errorCode=0)
BEGIN
	IF(dbo.isNewSecurity()<>1)
	BEGIN
SELECT @capabilities=capabilities FROM UMUserandGroupEntityAssociation where userId=@userId and objectId=@oldClientId and entityType=2009
		IF @capabilities IS NOT NULL AND
NOT EXISTS(SELECT 1 FROM UMUserandGroupEntityAssociation WHERE userId=@userId AND groupId=0 AND providerId=0 AND capabilities=@capabilities AND entityType= 2009 AND objectId=@newClientId AND  ownerUserId=@userId)
		BEGIN
			  INSERT INTO UMUserandGroupEntityAssociation (userId, groupId, providerId, capabilities, entityType, objectId, ownerUserId)
VALUES(@userId,0,0,@capabilities,2009,@newClientId,@userId)
		END
	END
	ELSE
	BEGIN
		--Clone owners
		INSERT INTO UMOwners (entityType, entityId, userOrGroupId, isUser, authorId)
			SELECT entityType, @newClientId, userOrGroupId, isUser, authorId
			FROM UMOwners New (NOLOCK)
			WHERE entityType = 3 AND entityId = @oldClientId
			AND NOT EXISTS (SELECT 1 FROM UMOwners Old (NOLOCK)
							WHERE Old.entityType = New.entityType AND Old.entityId = @newClientId AND Old.userOrGroupId = New.userOrGroupId AND Old.isUser = New.isUser)
		--Clone owner permissions. According to 1-touch team (Sridhar Rangu and Sri Karthik Bhagi) we need to copy client group owner permissions from source client to destination client.
		DECLARE @sourceClientPermissionsTable TABLE(categoryId INT, permissionId INT)
		INSERT INTO @sourceClientPermissionsTable (categoryId, permissionId)
			SELECT RPE.categoryId, RPE.permissionId
			FROM UMOwnerRoles R (NOLOCK) INNER JOIN UMRolesWithPermissionsExpanded RPE (NOLOCK)
			ON R.roleId = RPE.roleId
			WHERE R.entityType = 3 AND R.entityId = @oldClientId
			UNION
			SELECT DISTINCT RPE.categoryId, RPE.permissionId
			FROM UMOwnerRoles R (NOLOCK) INNER JOIN UMRolesWithPermissionsExpanded RPE (NOLOCK)
			ON R.roleId = RPE.roleId
			WHERE R.entityType = 28 AND R.entityId IN (SELECT clientGroupId FROM APP_ClientGroupAssoc (NOLOCK) WHERE clientId = @oldClientId)
		DECLARE @ownerXML XML = (SELECT
									(SELECT
										(SELECT 2 AS '@categoriesPermissionOperationType',				--2 stands for Add
											(SELECT categoryId AS '@categoryId',
													permissionId AS '@permissionId',
													'122' AS '@_type_'
											FROM @sourceClientPermissionsTable
											FOR XML PATH('categoriesPermissionList'), TYPE)
										FOR XML PATH ('categoryPermission'), TYPE)
									FOR XML PATH ('ownerAssociations'), TYPE)
								FOR XML PATH (''), ROOT('App_SecurityAssociationForEntityList')
								)
		EXEC sec_populateOwnersTable @ownerXML, 1, 0, 0, 3, @newClientId, 0, @o_errorCode OUTPUT, @o_errorString OUTPUT
	END
	DECLARE @installationUserID INT = 0, @installationCompanyID INT = 0, @currentUnixTime INT = 0
SELECT @installationUserID = attrVal FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @oldClientId AND attrName = 'Installation User ID' AND modified = 0
SELECT @installationCompanyID = attrVal FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @oldClientId AND attrName = 'Installation Company ID' AND modified = 0
	SET @currentUnixTime = dbo.GetUnixTime(GETUTCDATE())
	IF @installationUserID > 0
	BEGIN
		DECLARE @installationUserIDStr nvarchar(64) = 0
		SET @installationUserIDStr = CONVERT(nvarchar, @installationUserID)
IF NOT EXISTS (SELECT 1 FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @newClientId AND attrName = 'Installation User ID' AND modified = 0)
			INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
SELECT @newClientId, 'Installation User ID', 7, @installationUserID, @currentUnixTime, 0, 0
ELSE IF NOT EXISTS (SELECT 1 FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @newClientId AND attrName = 'Installation User ID' AND attrVal = @installationUserIDStr AND modified = 0)
UPDATE APP_ClientProp SET attrVal = @installationUserID, created = @currentUnixTime WHERE componentNameId = @newClientId AND attrName = 'Installation User ID' AND modified = 0
	END
	IF @installationCompanyID > 0
	BEGIN
		DECLARE @installationCompanyIDStr nvarchar(64) = 0
		SET @installationCompanyIDStr = CONVERT(nvarchar, @installationCompanyID)
IF NOT EXISTS (SELECT 1 FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @newClientId AND attrName = 'Installation Company ID' AND modified = 0)
			INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
SELECT @newClientId, 'Installation Company ID', 7, @installationCompanyID, @currentUnixTime, 0, 0
ELSE IF NOT EXISTS (SELECT 1 FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @newClientId AND attrName = 'Installation Company ID' AND attrVal = @installationCompanyIDStr AND modified = 0)
UPDATE APP_ClientProp SET attrVal = @installationCompanyID, created = @currentUnixTime WHERE componentNameId = @newClientId AND attrName = 'Installation Company ID' AND modified = 0
EXEC sec_setCompanyIdForEntity 3, @newClientId, @installationCompanyID
		DECLARE @associatedSCG INT = 0
SELECT @associatedSCG = attrValInt FROM App_CompanyProp WITH(NOLOCK) WHERE componentNameId = @installationCompanyID AND attrName='Associated Smart Client Group' AND modified = 0
		IF @associatedSCG > 0
			EXEC AppSCGRefresh @userId, @associatedSCG
	END
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
      SET @o_errorCode = ERROR_NUMBER()
      SET @o_errorString = ERROR_MESSAGE();
END CATCH
SELECT @o_errorCode,@o_errorString
RETURN @o_errorCode
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPSetOneTouchOwner')
	delete from GxQscripts where name = 'APPSetOneTouchOwner'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPSetOneTouchOwner')
	delete from GXDBVersions where aliasname = 'APPSetOneTouchOwner'
GO

insert into GXDBVersions values(2, 'APPSetOneTouchOwner',  '00010007003200070000', 'APPSetOneTouchOwner', '00010007003200070000')
GO

