

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPSetLaptopClientProps.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPSetLaptopClientProps.sp,v $ $Id: APPSetLaptopClientProps.sp,v 1.27.34.4 2018/03/22 01:34:03 jiechen Exp $";
--	+===================================================================+
--	| APPSetLaptopClientProps - 				|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPSetLaptopClientProps <<<'

IF EXISTS (select * from sysobjects where name='APPSetLaptopClientProps')
	drop procedure APPSetLaptopClientProps
IF EXISTS (select * from GxQscripts where name='APPSetLaptopClientProps')
	delete from GxQscripts where name = 'APPSetLaptopClientProps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPSetLaptopClientProps')
	delete from GXDBVersions where aliasname = 'APPSetLaptopClientProps'
GO
print '... Creating Procedure: APPSetLaptopClientProps'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPSetLaptopClientProps
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @xmlString XML OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
-----------------------------------------------------------
--- LOCALS                                              ---
-----------------------------------------------------------
DECLARE	@function       AS varchar(80)				= 'APPSetLaptopClientProps'
DECLARE @errorCode		AS integer					= 0								-- BE OPTIMISTIC
DECLARE @errorString	AS varchar(2048)			= ''
DECLARE @brAlertTrace	AS varchar(256)				= (select value from gxglobalParam Where name = 'bralertTrace')
DECLARE @dateTime		AS DATETIME					= getDate()
DECLARE @ATTR_NAME		AS nvarchar(80)				= N'Associated subclient Policy'
DECLARE @nowTime        AS integer					= dbo.GetUnixTime (GetUTCdate())
DECLARE	@enableDPAlerts	AS integer					-- FROM XML:
DECLARE	@enableDRAlerts	AS integer					-- FROM XML:
DECLARE	@decoupleFromSCP  AS integer				= 0  -- FROM XML
DECLARE	@localeId		AS integer					= 0	-- Placeholder
DECLARE	@modifiedCnt	AS integer					= 0 -- How many alerts were modified
DECLARE @DECOUPLE_SCP_CONTENT_ATTR_NAME
						AS Nvarchar(80)	= N'Decouple SCP Content'
---------------------------------------------------
--- FOR GUI AUDIT TRAIL						-------
---------------------------------------------------
	DECLARE @opMsgId INTEGER
--
	DECLARE @opEvMsgId			INTEGER
	DECLARE @opId 				INTEGER
	DECLARE @paramMsgId			INTEGER
	DECLARE @paramData 			NVARCHAR(MAX)
	DECLARE @dataIsEvent		INTEGER
---------------------------------------------------
DECLARE @contentAdded table (
		contentType			int Not Null,
fileName			nvarchar(1024),
		chksum				integer
)
DECLARE @contentDeleted table (
		contentType			int Not Null,
fileName			nvarchar(1024),
		chksum				integer
)
DECLARE @INSERT_PROP_RESULTS table (			-- THIS TABLE WILL BE USED TO CAPTURE THE RESULT SETS FROM THE
	errorCode 			integer,				-- .. VARIOUS "AppInsertXProp" stored procedures
	hasChanged			integer,
	propId				integer,
	errorString			varchar(1024)
)
--  DECLARE @jobIdTbl table( jobId INT );    NO LONGER DO RUNNING JOBS CHECK!
-----------------------------------------------------------
if @brAlertTrace <> 0
BEGIN
	DECLARE @input varchar(MAX) = CONVERT(varchar(MAX), @xmlString)
	exec br_ntTrace '.. APPSetLaptopClientProps', 0, @dateTime, 0, 0, @input
END
BEGIN TRY
----------------------------------------------------------
---
----------------------------------------------------------
DECLARE @iDoc					integer
DECLARE @userId					integer
DECLARE @clientId				integer
DECLARE	@backupsetId			integer
DECLARE @subclientId			integer
DECLARE @appTypeId				integer					-- Only needed for Audit Trail
DECLARE @assocBackupsetId		integer
DECLARE @assocSubClientId 		integer
DECLARE @oldDecoupleFromSCP		integer
DECLARE @OLDCONTENT 			NVARCHAR(MAX)			-- For Audit Trail
DECLARE @NEWCONTENT				NVARCHAR(MAX)			-- "     "     "     "
-----------------------------------------------
--- EXTRACT FROM THE XML					---
-----------------------------------------------
	SET @userId			= ISNULL (( SELECT ref.value('@userId', 'NVARCHAR(36)')
							FROM @xmlString.nodes ('App_LapTopSetClientPropsReq/user') R(ref)), 0)
	SET @clientId		= ISNULL (( SELECT ref.value('@clientId', 'NVARCHAR(36)')
							FROM @xmlString.nodes ('App_LapTopSetClientPropsReq/entity') R(ref)), 0)
	SET @enableDPAlerts	= ISNULL (( SELECT ref.value('@enable_DP_AlertNotifications', 'NVARCHAR(36)')
							FROM @xmlString.nodes ('App_LapTopSetClientPropsReq') R(ref)), 0)
	SET @enableDRAlerts	= ISNULL (( SELECT ref.value('@enable_DR_AlertNotifications', 'NVARCHAR(36)')
							FROM @xmlString.nodes ('App_LapTopSetClientPropsReq') R(ref)), 0)
	SET @decoupleFromSCP	= ISNULL (( SELECT ref.value('@isDecoupledContent', 'NVARCHAR(36)')
							FROM @xmlString.nodes ('App_LapTopSetClientPropsReq') R(ref)), 0)
	----------------------
	-- DERIVE SOME DATA --
	----------------------
	SET @backupsetId		= ISNULL (( SELECT ref.value('@backupsetId', 'NVARCHAR(36)')
							FROM @xmlString.nodes ('App_LapTopSetClientPropsReq/entity') R(ref)), 0)
	SET @subclientId		= ISNULL (( SELECT ref.value('@subclientId', 'NVARCHAR(36)')
							FROM @xmlString.nodes ('App_LapTopSetClientPropsReq/entity') R(ref)), 0)
	SET @appTypeId			= ISNULL((Select top 1 apptypeId from app_application Where id = @subClientId), 0)
	SET @assocBackupsetId 	= ISNULL((Select attrVal from app_backupsetProp where componentNameId = @backupsetId
										and attrName = @ATTR_NAME AND modified = 0), 0)
	SET @assocSubClientId 	= ISNULL((Select attrVal from app_subClientProp where componentNameId = @subclientId
										and attrName = @ATTR_NAME AND modified = 0 AND cs_attrName = checksum(@ATTR_NAME)), 0)
	SET @oldDecoupleFromSCP	= ISNULL((Select attrVal from app_subClientProp where componentNameId = @subclientId
										and attrName = @DECOUPLE_SCP_CONTENT_ATTR_NAME AND modified = 0 AND cs_attrName = checksum(@DECOUPLE_SCP_CONTENT_ATTR_NAME)), @decoupleFromSCP)
	DELETE @INSERT_PROP_RESULTS
	INSERT  @INSERT_PROP_RESULTS	EXEC AppInsertSubClientProp	@subclientId, 1, @nowTime, @DECOUPLE_SCP_CONTENT_ATTR_NAME, 1, @decoupleFromSCP
	SET @errorCode   = ISNULL((Select errorCode   from @INSERT_PROP_RESULTS), 0)
	SET @errorString = ISNULL((Select errorString from @INSERT_PROP_RESULTS), '')
	IF @errorCode <> 0				-- ANY ERROR IS AN ABORT!
		GOTO EXIT_PROC
/*   NO LONGER DO RUNNING JOBS CHECK!!!!!!!!!!!!!!!!!!!!!!
	-------------------------------------------
	--- MAKE SURE NO JOBS ARE RUNNING 1ST!	---
	-------------------------------------------
	INSERT INTO @jobIdTbl
	SELECT jobId FROM JMRstJobInfo WHERE bkpSetID = @backupsetId
	UNION
	SELECT jobId FROM JMBkpJobInfo WHERE applicationId IN (SELECT id FROM APP_Application WHERE backupSet = @backupsetId)
	IF EXISTS( SELECT jobId FROM @jobIdTbl)
	BEGIN
		SET @errorCode = -2
		SET @errorString = N'Unable to modify content. Jobs are still in progress'
		GOTO EXIT_PROC
	END
*/
	INSERT @contentDeleted (contentType, fileName, chksum)
	SELECT ref.value('@valueType', 'INT'), dbo.DecodeInvalidXMLChar(ref.value('@value', 'NVARCHAR(1024)')), 0
					FROM @xmlString.nodes ('App_LapTopSetClientPropsReq/contentsDeleted/content') R(ref)
	INSERT @contentAdded (contentType, fileName, chksum)
	SELECT ref.value('@valueType', 'INT'), dbo.DecodeInvalidXMLChar(ref.value('@value', 'NVARCHAR(1024)')), 0
					FROM @xmlString.nodes ('App_LapTopSetClientPropsReq/contentsAdded/content') R(ref)
------------------------------
--	NOW DO SOME WORK:		--
------------------------------
	UPDATE @contentDeleted SET chksum = checksum(fileName)
	UPDATE @contentAdded   SET chksum = checksum(fileName)
	SET @OldContent = (							-- FOR GUI AUDIT TRAIL (MIMIC C++ Audit Message)
	SELECT STUFF((
		SELECT ' '+ filename+ ';'
		FROM dbo.APP_ScFilterFile
		where componentNameId = @subClientId and modified = 0 order by fileName
		FOR XML PATH('')
		), 1, 1, ''
	  ) As concatenated_string)
	  SET @OldContent=SUBSTRING(@OldContent, 0, LEN(@OldContent))        -- Lob off the trailing ';'
	IF (@decoupleFromSCP <> 0)
	BEGIN
		--remove ecxeptions while decoupling
		UPDATE APP_ScFilterFile
		 SET modified = @nowTime
		 FROM  APP_ScFilterFile SCF
		 WHERE SCF.componentNameId = @subClientId
		   AND SCF.type    		= 2
		   AND SCF.modified = 0
	END
	ELSE IF (@decoupleFromSCP <> @oldDecoupleFromSCP)
	BEGIN
		--remove ecxeptions while decoupling
		UPDATE APP_ScFilterFile
		 SET modified = @nowTime
		 FROM  APP_ScFilterFile SCF
		 WHERE SCF.componentNameId = @subClientId
		   AND SCF.type    		= 1
		   AND SCF.modified = 0
	END
	UPDATE APP_ScFilterFile											-- NOT "CCP" Compatible, as written
	 SET modified = @nowTime
	 FROM  APP_ScFilterFile AS SCF, @contentDeleted AS CD
	 WHERE SCF.componentNameId = @subClientId
	   AND SCF.cs_fileName	= CD.chksum
	   AND SCF.fileName 	= CD.fileName
	   AND SCF.type    		= CD.contentType
	   AND SCF.modified = 0
	DELETE @contentAdded
		FROM   @contentAdded AS CA,  APP_ScFilterFile AS SCF
		 WHERE SCF.componentNameId = @subClientId
		   AND SCF.cs_fileName	= CA.chksum
		   AND SCF.fileName 	= CA.fileName
		   AND SCF.type    		= CA.contentType
   		   AND SCF.modified     = @nowtime
	INSERT APP_ScFilterFile (componentNameId, type, fileName, created, modified, ccpId)
		SELECT @subClientId, contentType, fileName, @nowTime, 0, 0
			FROM @contentAdded
	SET @NewContent = (							-- FOR GUI AUDIT TRAIL (MIMIC C++ Audit Message)
	SELECT STUFF((
		SELECT ' '+ filename+ ';'
		FROM dbo.APP_ScFilterFile
		where componentNameId = @subClientId and modified = 0 order by fileName
		FOR XML PATH('')
		), 1, 1, ''
	  ) As concatenated_string)
	  SET @NewContent=SUBSTRING(@NewContent, 0, LEN(@NewContent))        -- Lob off the trailing ';'
--
------------------------------------------------------------------
--	DETERMINE IF THERE ARE ANY LAPTOP ENABLED ALERTS AND IF SO,	--
--	SEE IF USER IS ELECTING IN/OUT OF RECEIVING THEM			--
------------------------------------------------------------------
--
DECLARE @alertId		int
DECLARE @alertTypeId	int
DECLARE @wasModified	int
DECLARE	alertIdCursor CURSOR
	FOR
	SELECT DISTINCT id, alertTypeId											-- For now, very simple rule.  Look for ALL the laptop alerts
		FROM NTNotificationRule									-- .. should just be (2), DP & DR
WHERE (status & 128) <> 0				--'NT_STATUS_LAPTOP_ALERT'
--
	OPEN alertIdCursor
	FETCH NEXT from alertIdCursor INTO @alertId, @alertTypeId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		-- NOTE: Now Have separate DP/DR "Enables", but the code below right now is NOT aware
		SET @wasModified = 0
IF @alertTypeId = 3  --'NT_ALERTTYPE_DATA_PROT'
			EXEC br_ntAlertEntitiesAppIdUpdate @alertId, @subClientId, @localeId, @enableDPAlerts, @wasModified OUTPUT, @errorCode output, @errorString output
ELSE IF @alertTypeId = 4  --'NT_ALERTTYPE_DATA_RECOV'
			EXEC br_ntAlertEntitiesAppIdUpdate @alertId, @subClientId, @localeId, @enableDRAlerts, @wasModified OUTPUT, @errorCode output, @errorString output
			IF @errorCode <> 0
		BEGIN
			CLOSE		alertIdCursor
			DEALLOCATE	alertIdCursor
			GoTo 		EXIT_PROC
		END
--
		IF @wasModified <> 0
			SET @modifiedCnt = @modifiedCnt +1
--
		FETCH NEXT from alertIdCursor INTO @alertId,  @alertTypeId
	END
	CLOSE		alertIdCursor
	DEALLOCATE	alertIdCursor
--
--	---------------------------------------------------
--	DO GUI AUDIT TRAIL FOR SUBCLIENT CONTENT CHANGE  --
--	---------------------------------------------------
SET @opMsgId = (277 | (CAST(POWER(2, 24) AS BIGINT) * 84))
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @userId, 7 , @subClientId, @opEvMsgId OUTPUT, @opId OUTPUT
	SET @dataIsEvent = 0
--
SET @paramMsgId  = (202 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			SET @paramData   = ISNULL((Select name from app_client where id = @clientId), 'No Client Name')
			EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
--
SET @paramMsgId  = (206 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			SET @paramData   = ISNULL((Select name from app_idaType where type = @appTypeId), 'No Ida Name')
			EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
--
SET @paramMsgId  = (208 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			SET @paramData   = ISNULL((Select name from app_backupsetName where id = @backupsetId), 'No Backupset Name')
			EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
--
SET @paramMsgId  = (211 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			SET @paramData   = ISNULL((Select subClientName from app_application where id = @subClientId), 'No Subclient Name')
			EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
--
	IF @oldContent <> @newContent
	BEGIN
SET @paramMsgId  = (776 | (CAST(POWER(2, 24) AS BIGINT) * 83))
			EXEC EvGuiAuditSetParamData @opId, @oldContent, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @newContent, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
	END
--
	IF @modifiedCnt <> 0						-- DID USER ELECT IN/OUT OF RECEIVING ALERTS (& DID THIS CHANGE)?
		BEGIN
			IF @enableDPAlerts <> 0
SET @paramMsgId  = (942 | (CAST(POWER(2, 24) AS BIGINT) * 74))				--'ALERT_LAPTOP_ENABLED'
			ELSE
SET @paramMsgId  = (943 | (CAST(POWER(2, 24) AS BIGINT) * 74))			--'ALERT_LAPTOP_ENABLED'
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
	DECLARE @clientStatus INT = 0
	SET @clientStatus = ISNULL((SELECT TOP 1 status  FROM App_Client WHERE id = @clientId), 0)
IF ISNULL(@oldContent,'') <> ISNULL(@newContent,'') AND (@clientStatus & 0x1000  = 0x1000 ) --'CV_STATUS_PERSONAL_WKSTN
	BEGIN
			DECLARE @DB_WORK_TOKEN_SUBCLIENT_CONTENT  int = 7 --'WORK_TOKEN_SUBCLIENT_CONTENT --'EvExternal/WorkQueueDefines.h
			DECLARE @subclientChangeReq NVARCHAR(MAX)
			SET @subclientChangeReq = CONVERT(NVARCHAR(MAX), (SELECT @subclientId AS '@subclientID' FOR XML PATH('TMMsg_SubclientChangeReq'), TYPE))
			DECLARE @WorkQueueSubmitResult TABLE
			(
				errorCode INT,
				errorCodeStr NVARCHAR(MAX)
			)
			INSERT @WorkQueueSubmitResult
				EXEC AppWorkQueueSubmitRequest @DB_WORK_TOKEN_SUBCLIENT_CONTENT, 0, 0, @clientId, 0, @subclientChangeReq
			SELECT TOP 1 @errorCode = errorCode, @errorString = errorCodeStr  FROM @WorkQueueSubmitResult
	END
END TRY
--=====================================================================
--==============  COME HERE IF THERE WAS A PROBLEM!     ===============
--=====================================================================
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode	 = ERROR_NUMBER()
	SET @errorString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
EXIT_PROC:
--=====================================================================
-- ============  ALWAYS RETURN GENERIC RESPONSE			===============
--=====================================================================
	SET @xmlString = ( SELECT @errorCode '@errorCode', @errorString '@errorMessage'
	FOR XML PATH('App_GenericResp'))
--------------------------------------------
-- SOME CODE, FOR STANDALONE DEBUGGING  ----
--------------------------------------------
/*
SET NOCOUNT ON
IF EXISTS (Select * from sysObjects where name = 'APPSetLaptopClientProps')
	Drop proc APPSetLaptopClientProps
GO
DECLARE @xml XML
DECLARE @xmltext nvarchar(max)='
<App_LapTopSetClientPropsReq enable_DP_AlertNotifications="1" enable_DR_AlertNotifications="0">
<user _type_="13" userId="1"/><client _type_="3" clientId="5" clientName="jewelfish_cn"/>
<contentsDeleted><content createTime="1318443692" modifyTime="0" value="c:\Data\Path01" valueType="18"/>
<content createTime="1318443692" modifyTime="0" value="c:\Data\Path02" valueType="18"/>
</contentsDeleted><contentsAdded><content createTime="1318443692" modifyTime="0" value="c:\Data\Path03" valueType="18"/>
<content createTime="1318443692" modifyTime="0" value="c:\Data\Path04" valueType="18"/></contentsAdded>
</App_LapTopSetClientPropsReq>'
SET @xml = @xmltext
exec APPSetLaptopClientProps @xml output
select @xml
select id, notificationName, status, xmlEntityList from ntnotificationRule where (status & 128) <> 0 -- Laptop Alert
*/
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPSetLaptopClientProps')
	delete from GxQscripts where name = 'APPSetLaptopClientProps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPSetLaptopClientProps')
	delete from GXDBVersions where aliasname = 'APPSetLaptopClientProps'
GO

insert into GXDBVersions values(2, 'APPSetLaptopClientProps',  '00010027003400040000', 'APPSetLaptopClientProps', '00010027003400040000')
GO

