

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPSetEntitySecurityXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPSetEntitySecurityXML.sp,v $ $Id: APPSetEntitySecurityXML.sp,v 1.3.60.2 2018/03/27 08:52:19 jiechen Exp $";
--	+===================================================================+
--	| APPSetEntitySecurityXML - PRIMARY ENTRY POINT FOR ALL CCP OPS			|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPSetEntitySecurityXML <<<'

IF EXISTS (select * from sysobjects where name='APPSetEntitySecurityXML')
	drop procedure APPSetEntitySecurityXML
IF EXISTS (select * from GxQscripts where name='APPSetEntitySecurityXML')
	delete from GxQscripts where name = 'APPSetEntitySecurityXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPSetEntitySecurityXML')
	delete from GXDBVersions where aliasname = 'APPSetEntitySecurityXML'
GO
print '... Creating Procedure: APPSetEntitySecurityXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPSetEntitySecurityXML
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
-----------------------------------------------------------
  @ownerID int,
  @xmlText XML,
  @idType int,
  @idValue int
-----------------------------------------------------------
AS
SET NOCOUNT ON
DECLARE	@function        AS varchar(80)                = 'APPSetEntitySecurityXML'
DECLARE @errorCode		 AS integer					   = 0
DECLARE @errorString	 AS varchar(2048)			   = ''
DECLARE @dateTime		AS DATETIME = getDate()
DECLARE @associatedUserGroupsOperationType  int
--Message EntitySecurity
--{
--	list<UserGroupEntity>	associatedUserGroups
--	ListOperationType		associatedUserGroupsOperationType
--	list<string>			clientOwners
--	ListOperationType		clientOwnersOperationType
--	OwnerCapabilities		ownerCapabilities
--}
--enum ListOperationType
--{
--	NONE=0,
--	OVERWRITE=1,
--	ADD=2,
--	DELETE=3,
--	CLEAR=4
--}
if (@idValue=0)
	return
declare @GUIUserGroupList table
(
	userGroupId int
)
SET @associatedUserGroupsOperationType =  ISNULL((SELECT  ref.value('@associatedUserGroupsOperationType', 'int') AS associatedUserGroupsOperationType
	FROM    @xmlText.nodes('App_EntitySecurity') R ( ref )),0)
if @associatedUserGroupsOperationType = 0
begin
	goto ALL_DONE
end
Insert into @GUIUserGroupList
select IsNull(Tbl.Col.value('@userGroupId','int'),0)
from @xmlText.nodes('/App_EntitySecurity/associatedUserGroups') as Tbl(Col)
delete from @GUIUserGroupList
where userGroupId is null or userGroupId = 0
BEGIN TRY
----------------------------------------------------------
---	HERE IS WHERE WE WILL EXTRACT THE XML TO:		   ---
----------------------------------------------------------
	if (@associatedUserGroupsOperationType=1 or @associatedUserGroupsOperationType=3 or @associatedUserGroupsOperationType=4)
	begin
		delete from UMGroupAssociation
		where type1=@idType and id1 = @idValue
	end
	if (@associatedUserGroupsOperationType=2 OR @associatedUserGroupsOperationType=1)
	begin
		Insert into	UMGroupAssociation(groupId,type1,id1,type2,id2,type3,id3,type4,id4,flag)
		select distinct userGroupId,@idType,@idValue,0,0,0,0,0,0,0
		from  @GUIUserGroupList
		where userGroupId not in
		(
			select DBGroupList.GroupId
			from UMGroupAssociation DBGroupList
			where type1=@idType and id1 = @idValue
		)
	end
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode	 = 1
	SET @errorString = 'Problems Executing [' + @function +'] Error Message [' + ERROR_MESSAGE() + '].'
END CATCH
--------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
ALL_DONE:
SELECT  @errorCode as '@errorCode',
    @errorString as '@errorString'
for xml path('App_GenericEntityResponse')
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPSetEntitySecurityXML')
	delete from GxQscripts where name = 'APPSetEntitySecurityXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPSetEntitySecurityXML')
	delete from GXDBVersions where aliasname = 'APPSetEntitySecurityXML'
GO

insert into GXDBVersions values(2, 'APPSetEntitySecurityXML',  '00010003006000020000', 'APPSetEntitySecurityXML', '00010003006000020000')
GO

