

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPSetAgentProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPSetAgentProperties.sp,v $ $Id: APPSetAgentProperties.sp,v 1.15.208.5 2020/08/12 20:57:38 abhinawkumar Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPSetAgentProperties')
BEGIN
	print '>>> Drop Stored Procedure: APPSetAgentProperties <<<'
	drop procedure APPSetAgentProperties
END
IF EXISTS (select * from GxQscripts where name='APPSetAgentProperties')
	delete from GxQscripts where name = 'APPSetAgentProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPSetAgentProperties')
	delete from GXDBVersions where aliasname = 'APPSetAgentProperties'
GO
print '... Creating Procedure: APPSetAgentProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPSetAgentProperties
  @var XML	
AS
DECLARE @agentXML	XML
DECLARE @agentPropXML	XML
DECLARE @agentExtPropXML	XML
DECLARE @activityControlXML	XML
DECLARE @idaEntityXML	XML
DECLARE @opWindowRuleXML	XML
DECLARE @AgentCount int
DECLARE @ActivityControlCount int
DECLARE @appTypeId	INT
DECLARE @clientId	INT
DECLARE @opType INT
DECLARE @opCount INT
DECLARE @ruleId	INT
DECLARE @appId	INT
DECLARE @sqlUAXML XML
DECLARE @sqlUPXML XML
SET @AgentCount = @var.value('count(//agents)','int')
IF @AgentCount IS null
	SET @AgentCount = 0
print @AgentCount
DECLARE @i int
SET @i = 1
WHILE (@i <= @AgentCount)
BEGIN
	SET @agentXML=@var.query('(//agents)[sql:variable("@i")]')
	SET @agentPropXML=@var.query('(//./AgentProperties)[sql:variable("@i")]')
	SET @idaEntityXML=@var.query('(//./idaEntity)[sql:variable("@i")]')
	SET @appTypeId =  @idaEntityXML.value('(//./idaEntity/@applicationId)[1]','int')
	SET @clientId = @idaEntityXML.value('(//./idaEntity/@clientId)[1]','int')
	DECLARE @attrVal NVARCHAR(MAX)
	DECLARE @attrName NVARCHAR(MAX)
	DECLARE @isEnabled INT
	DECLARE @attrInt	INT
	DECLARE @id int
	DECLARE @CompId	INT
	SET @id = (SELECT id
			FROM APP_IDAName
			WHERE clientId = @clientId
			AND appTypeId = @appTypeId)
	SET @CompId = (SELECT TOP 1 instance
			FROM APP_Application
			WHERE clientId = @clientId
			AND appTypeId = @appTypeId)
	IF 1 = (@agentPropXML.exist('(//./AgentProperties/@enableOCSOnBackupAgent)[1]'))
	BEGIN
		SET @attrVal = (CASE @agentPropXML.value('(//./AgentProperties/@enableOCSOnBackupAgent)[1]','nvarchar(max)')
						WHEN '1' THEN '1'
						ELSE '0' END)
		IF EXISTS (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'Enable OCS')
		BEGIN
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'Enable OCS')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE()) WHERE componentNameId = @id AND modified = 0 AND attrName = 'Enable OCS'
				INSERT INTO APP_IDAProp values (@id,'Enable OCS',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		ELSE
		BEGIN
		       INSERT INTO APP_IDAProp values (@id,'Enable OCS',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
		END
	END
	IF 1 = (@agentPropXML.exist('(//./AgentProperties/@createIndexOnFull)[1]'))
	BEGIN
		SET @attrVal = (CASE @agentPropXML.value('(//./AgentProperties/@createIndexOnFull)[1]','nvarchar(max)')
						WHEN '1' THEN '1'
						ELSE '0' END)
		IF EXISTS (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'create new index')
		BEGIN
			IF @attrVal <>(SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'create new index')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE()) WHERE componentNameId = @id AND modified = 0 AND attrName = 'create new index'
				INSERT INTO APP_IDAProp values (@id,'create new index',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		ELSE
		BEGIN
		    INSERT INTO APP_IDAProp values (@id,'create new index',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
		END
	END
	IF 1 = (@agentPropXML.exist('(//./AgentProperties/@createIndexOnFail)[1]'))
	BEGIN
		SET @attrVal = (CASE @agentPropXML.value('(//./AgentProperties/@createIndexOnFail)[1]','nvarchar(max)')
						WHEN '1' THEN '1'
						ELSE '0' END)
		IF EXISTS (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'new index if fail')
		BEGIN
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'new index if fail')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE()) WHERE componentNameId = @id AND modified = 0 AND attrName = 'new index if fail'
				INSERT INTO APP_IDAProp values (@id,'new index if fail',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		ELSE
		BEGIN
		    INSERT INTO APP_IDAProp values (@id,'new index if fail',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
		END
	END
	IF 1 = (@agentPropXML.exist('(//./AgentProperties/@userDescription)[1]'))
	BEGIN
		SET @attrVal = @agentPropXML.value('(//./AgentProperties/@userDescription)[1]','nvarchar(max)')
		IF EXISTS (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'IDA Description')
		BEGIN
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'IDA Description')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE()) WHERE componentNameId = @id AND modified = 0 AND attrName = 'IDA Description'
				INSERT INTO APP_IDAProp values (@id,'IDA Description',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		ELSE
		BEGIN
		    INSERT INTO APP_IDAProp values (@id,'IDA Description',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
		END
	END
	IF 1 = (@agentPropXML.exist('(//./AgentProperties/@isSRMEnabled)[1]'))
	BEGIN
		SET @attrVal = (CASE @agentPropXML.value('(//./AgentProperties/@isSRMEnabled)[1]','nvarchar(max)')
						WHEN '1' THEN '1'
						ELSE '0' END)
		IF EXISTS (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'Enable Agent for SRM')
		BEGIN
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'Enable Agent for SRM')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE()) WHERE componentNameId = @id AND modified = 0 AND attrName = 'Enable Agent for SRM'
				INSERT INTO APP_IDAProp values (@id,'Enable Agent for SRM',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		ELSE
		BEGIN
		    INSERT INTO APP_IDAProp values (@id,'Enable Agent for SRM',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
		END
	END
	--Check if requireMore config is actually required or not
	--IF 1 = (@agentPropXML.exist('(//./AgentProperties/@requiresMoreConfig)[1]'))
	--BEGIN
	--	SET @attrVal = (CASE @agentPropXML.value('(//./AgentProperties/@requiresMoreConfig)[1]','nvarchar(max)')
	--					WHEN '1' THEN '1'
	--					ELSE '0' END)
	--	IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'Enable Agent for SRM')
	--	BEGIN
	--		UPDATE APP_IDAProp
	--			SET modified  = dbo.GetUnixTime(GETDATE()) WHERE componentNameId = @id AND modified = 0 AND attrName = 'Enable Agent for SRM'
	--		INSERT INTO APP_IDAProp values (@id,'Enable Agent for SRM',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
	--	END
	--END
	IF 1 = (@agentPropXML.exist('(//./AgentProperties/@appPriority)[1]'))
	BEGIN
		SET @attrVal = @agentPropXML.value('(//./AgentProperties/@appPriority)[1]','nvarchar(max)')
		IF @attrVal <> (SELECT priority	FROM APP_IDAType WHERE type = @appTypeId)
		BEGIN
			UPDATE APP_IDAType
				SET priority  = @attrVal WHERE type = @appTypeId
		END
	END
	--IF 1 = (@agentPropXML.exist('(//./AgentProperties/@isNDMPRestore)[1]'))
	--BEGIN
	--	SET @attrVal = (CASE @agentPropXML.value('(//./AgentProperties/@isNDMPRestore)[1]','nvarchar(max)')
	--					WHEN '1' THEN '1'
	--					ELSE '0' END)
	--	IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'Enable Agent for SRM')
	--	BEGIN
	--		UPDATE APP_IDAProp
	--			SET modified  = dbo.GetUnixTime(GETDATE()) WHERE componentNameId = @id AND modified = 0 AND attrName = 'Enable Agent for SRM'
	--		INSERT INTO APP_IDAProp values (@id,'Enable Agent for SRM',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
	--	END
	--END
	IF 1 = (@agentPropXML.exist('(//./AgentProperties/@maxSimultaneousStubRecoveries)[1]'))
	BEGIN
		SET @attrVal = @agentPropXML.value('(//./AgentProperties/@maxSimultaneousStubRecoveries)[1]','nvarchar(max)')
		IF EXISTS 	(SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'DM Max Simultaneous Data Recovery')
		BEGIN
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'DM Max Simultaneous Data Recovery')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE()) WHERE componentNameId = @id AND modified = 0 AND attrName = 'DM Max Simultaneous Data Recovery'
				INSERT INTO APP_IDAProp values (@id,'DM Max Simultaneous Data Recovery',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		ELSE
		BEGIN
		   INSERT INTO APP_IDAProp values (@id,'DM Max Simultaneous Data Recovery',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
		END
	END
	IF 1 = (@agentPropXML.exist('(//./AgentProperties/@timeBetweenRecalls)[1]'))
	BEGIN
		SET @attrVal = @agentPropXML.value('(//./AgentProperties/@timeBetweenRecalls)[1]','nvarchar(max)')
		IF EXISTS 	(SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'DM Time Btw Recall')
		BEGIN
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'DM Time Btw Recall')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE()) WHERE componentNameId = @id AND modified = 0 AND attrName = 'DM Time Btw Recall'
				INSERT INTO APP_IDAProp values (@id,'DM Time Btw Recall',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		ELSE
		BEGIN
		    INSERT INTO APP_IDAProp values (@id,'DM Time Btw Recall',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
		END
	END
	IF 1 = (@agentPropXML.exist('(//./AgentProperties/@timeToWaitAfterMax)[1]'))
	BEGIN
		SET @attrVal = @agentPropXML.value('(//./AgentProperties/@timeToWaitAfterMax)[1]','nvarchar(max)')
		IF EXISTS (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'DM Time to wait after max')
		BEGIN
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'DM Time to wait after max')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE()) WHERE componentNameId = @id AND modified = 0 AND attrName = 'DM Time to wait after max'
				INSERT INTO APP_IDAProp values (@id,'DM Time to wait after max',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		ELSE
		BEGIN
		   INSERT INTO APP_IDAProp values (@id,'DM Time to wait after max',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
		END
	END
	IF 1 = (@agentPropXML.exist('(//./AgentProperties/@timeToWaitAfterMax)[1]'))
	BEGIN
		SET @attrVal = @agentPropXML.value('(//./AgentProperties/@timeToWaitAfterMax)[1]','nvarchar(max)')
		IF EXISTS (SELECT @attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'DM Time to wait after max')
		BEGIN
			IF @attrVal <> (SELECT @attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'DM Time to wait after max')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE()) WHERE componentNameId = @id AND modified = 0 AND attrName = 'DM Time to wait after max'
				INSERT INTO APP_IDAProp values (@id,'DM Time to wait after max',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		ELSE
		BEGIN
		   INSERT INTO APP_IDAProp values (@id,'DM Time to wait after max',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
		END
	END
	IF 1 = (@agentPropXML.exist('(//./AgentProperties/@qsnapMaxCacheSize)[1]'))
	BEGIN
		SET @attrVal = @agentPropXML.value('(//./AgentProperties/@qsnapMaxCacheSize)[1]','nvarchar(max)')
		IF EXISTS 	(SELECT @attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'Max cache size')
		BEGIN
			IF @attrVal <> (SELECT @attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'Max cache size')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE()) WHERE componentNameId = @id AND modified = 0 AND attrName = 'Max cache size'
				INSERT INTO APP_IDAProp values (@id,'Max cache size',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		ELSE
		BEGIN
		    INSERT INTO APP_IDAProp values (@id,'Max cache size',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
		END
	END
	IF 1 = (@agentPropXML.exist('(//./AgentProperties/@qsnapMinCacheSize)[1]'))
	BEGIN
		SET @attrVal = @agentPropXML.value('(//./AgentProperties/@qsnapMinCacheSize)[1]','nvarchar(max)')
		IF EXISTS  (SELECT @attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'Min cache size')
		BEGIN
			IF @attrVal <> (SELECT @attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'Min cache size')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE()) WHERE componentNameId = @id AND modified = 0 AND attrName = 'Min cache size'
				INSERT INTO APP_IDAProp values (@id,'Min cache size',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		ELSE
		BEGIN
		   INSERT INTO APP_IDAProp values (@id,'Min cache size',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
		END
	END
	IF 1 = (@agentPropXML.exist('(//./AgentProperties/@agentArchivePropertiesFlag)[1]'))
	BEGIN
		SET @attrVal = (CASE @agentPropXML.value('(//./AgentProperties/@agentArchivePropertiesFlag)[1]','nvarchar(max)')
						WHEN '1' THEN '1'
						ELSE '0' END)
		IF EXISTS (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'Enable Archive')
		BEGIN
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id AND modified = 0 AND attrName = 'Enable Archive')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE()) WHERE componentNameId = @id AND modified = 0 AND attrName = 'Enable Archive'
				INSERT INTO APP_IDAProp values (@id,'Enable Archive',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		ELSE
		BEGIN
		     INSERT INTO APP_IDAProp values (@id,'Enable Archive',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
		END
	END
	IF 1 = (@agentPropXML.exist('(//./AgentProperties/@appTypePathnameOrder)[1]'))
	BEGIN
		SET @attrVal = @agentPropXML.value('(//./AgentProperties/@appTypePathnameOrder)[1]','nvarchar(max)')
		IF @attrVal <> (SELECT dirOrder FROM APP_IDAType WHERE type = @appTypeId)
		BEGIN
			UPDATE APP_IDAType
				SET dirOrder  = @attrVal WHERE type = @appTypeId
		END
	END
	IF 1 = (@agentPropXML.exist('(//./AgentProperties/@appTypePathnameSeperator)[1]'))
	BEGIN
		SET @attrVal = @agentPropXML.value('(//./AgentProperties/@appTypePathnameSeperator)[1]','nvarchar(max)')
		IF @attrVal <> (SELECT dirDelim FROM APP_IDAType WHERE type = @appTypeId)
		BEGIN
			UPDATE APP_IDAType
				SET dirDelim  = @attrVal WHERE type = @appTypeId
		END
	END
	IF 1 = (@agentPropXML.exist('(//./AgentProperties/@appTypepathnameCaseSensitive)[1]'))
	BEGIN
		SET @attrVal = @agentPropXML.value('(//./AgentProperties/@appTypepathnameCaseSensitive)[1]','nvarchar(max)')
		IF @attrVal <> (SELECT caseSensitivity FROM APP_IDAType WHERE type = @appTypeId)
		BEGIN
			UPDATE APP_IDAType
				SET caseSensitivity  = @attrVal WHERE type = @appTypeId
		END
	END
	------------------------------------------
	--------- SET ACTIVITY CONTROL -----------
	------------------------------------------
	SET @ActivityControlCount = @agentXML.value('count(//./activityControl/acObjects)','int')
	IF @ActivityControlCount IS null
		SET @ActivityControlCount = 0
	DECLARE @j int
	SET @j = 1
	WHILE (@j <= @ActivityControlCount)
	BEGIN
		SET @activityControlXML=@agentXML.query('(//./activityControl/acObjects)[sql:variable("@j")]')
		IF 1 = (@activityControlXML.exist('(//./acObjects/@activityType)[1]'))
		BEGIN
			SET @opType = (CASE @activityControlXML.value('(//./acObjects/@activityType)[1]','INT')
							WHEN 1 THEN 4
							WHEN 2 THEN 5
							ELSE 19 END)
			IF 1 = (@activityControlXML.exist('(//./acObjects/@enabled)[1]'))
			BEGIN
				SET @isEnabled = (CASE @activityControlXML.value('(//./acObjects/@enabled)[1]','INT')
								  WHEN 0 THEN 2
								  ELSE 1 END)
				-- SET ACTIVITY TYPE
				IF @isEnabled <> (SELECT action FROM JMJobAction
									WHERE clientId = @clientId
									AND appType = @appTypeId
									AND opType = @opType)
				BEGIN
					UPDATE JMJobAction
						SET action  = @isEnabled WHERE clientId = @clientId
									AND appType = @appTypeId
									AND opType = @opType
				END
				IF 1 = (@activityControlXML.exist('(//./acObjects/@reEnableTime)[1]'))
				BEGIN
					SET @attrInt = @activityControlXML.value('(//./acObjects/@reEnableTime)[1]','INT')
					IF @attrInt <> (SELECT enableTime FROM JMJobAction
									WHERE clientId = @clientId
									AND appType = @appTypeId
									AND opType = @opType)
					BEGIN
						UPDATE JMJobAction
							SET enableTime  = @attrInt WHERE clientId = @clientId
									AND appType = @appTypeId
									AND opType = @opType
					END
				END
				IF 1 = (@activityControlXML.exist('(//./acObjects/@reenableTimeZone)[1]'))
				BEGIN
					SET @attrInt = @activityControlXML.value('(//./acObjects/@reenableTimeZone)[1]','INT')
					IF @attrInt <> (SELECT enableTimeZone FROM JMJobAction
									WHERE clientId = @clientId
									AND appType = @appTypeId
									AND opType = @opType)
					BEGIN
						UPDATE JMJobAction
							SET enableTimeZone  = @attrInt WHERE clientId = @clientId
									AND appType = @appTypeId
									AND opType = @opType
					END
				END
			END
		END
		SET @j = @j + 1
	END
	------------------------------------------------
	--------- SET OPERATION WINDOW RULES -----------
	------------------------------------------------
	DECLARE @OpWindowCount INT
	SET @OpWindowCount = @var.value('count(//./Agents/opWindowRule)','int')
	IF @OpWindowCount IS null
		SET @OpWindowCount = 0
	SET @opCount = 1
	WHILE (@opCount <= @OpWindowCount)
	BEGIN
		SET @opWindowRuleXML = @var.query('(//Agents/opWindowRule)[sql:variable("@opCount")]')
		IF 1 = (@opWindowRuleXML.exist('(//./opWindowRule/@ruleId)[1]'))
		BEGIN
			-- MODIFY EXISTING RULE
			SET @ruleId = @opWindowRuleXML.value('(//./opWindowRule/@ruleId)[1]','INT')
			IF 1 = (@opWindowRuleXML.exist('(//./opWindowRule/@opType)[1]'))
			BEGIN
				SET @attrInt = @opWindowRuleXML.value('(//./opWindowRule/@opType)[1]','INT')
				IF @attrInt <> (SELECT opType FROM APP_OpWindowRule
								WHERE appTypeId = @appTypeId AND clientId = @clientId
								AND id = @ruleId)
				BEGIN
					UPDATE APP_OpWindowRule
						SET optype  = @attrInt WHERE appTypeId = @appTypeId AND clientId = @clientId
								AND id = @ruleId
				END
			END
			IF 1 = (@opWindowRuleXML.exist('(//./opWindowRule/@daysOfWeek)[1]'))
			BEGIN
				SET @attrInt = @opWindowRuleXML.value('(//./opWindowRule/@daysOfWeek)[1]','INT')
				IF @attrInt <> (SELECT daysOfWeek FROM APP_OpWindowRule
								WHERE appTypeId = @appTypeId AND clientId = @clientId
								AND id = @ruleId)
				BEGIN
					UPDATE APP_OpWindowRule
						SET daysOfWeek  = @attrInt WHERE appTypeId = @appTypeId AND clientId = @clientId
								AND id = @ruleId
				END
			END
			IF 1 = (@opWindowRuleXML.exist('(//./opWindowRule/@startTime)[1]'))
			BEGIN
				SET @attrInt = @opWindowRuleXML.value('(//./opWindowRule/@startTime)[1]','INT')
				IF @attrInt <> (SELECT startTime FROM APP_OpWindowRule
								WHERE appTypeId = @appTypeId AND clientId = @clientId
								AND id = @ruleId)
				BEGIN
					UPDATE APP_OpWindowRule
						SET startTime  = @attrInt WHERE appTypeId = @appTypeId AND clientId = @clientId
								AND id = @ruleId
				END
			END
			IF 1 = (@opWindowRuleXML.exist('(//./opWindowRule/@endTime)[1]'))
			BEGIN
				SET @attrInt = @opWindowRuleXML.value('(//./opWindowRule/@endTime)[1]','INT')
				IF @attrInt <> (SELECT endTime FROM APP_OpWindowRule
								WHERE appTypeId = @appTypeId AND clientId = @clientId
								AND id = @ruleId)
				BEGIN
					UPDATE APP_OpWindowRule
						SET endTime  = @attrInt WHERE appTypeId = @appTypeId AND clientId = @clientId
								AND id = @ruleId
				END
			END
			IF 1 = (@opWindowRuleXML.exist('(//./opWindowRule/@enable)[1]'))
			BEGIN
				SET @attrInt = @opWindowRuleXML.value('(//./opWindowRule/@enable)[1]','INT')
				IF @attrInt <> (SELECT enable FROM APP_OpWindowRule
								WHERE appTypeId = @appTypeId AND clientId = @clientId
								AND id = @ruleId)
				BEGIN
					UPDATE APP_OpWindowRule
						SET enable  = @attrInt WHERE appTypeId = @appTypeId AND clientId = @clientId
								AND id = @ruleId
				END
			END
			IF 1 = (@opWindowRuleXML.exist('(//./opWindowRule/@description)[1]'))
			BEGIN
				SET @attrVal = @opWindowRuleXML.value('(//./opWindowRule/@description)[1]','NVARCHAR(MAX)')
				UPDATE APP_OpWindowRule
					SET description  = @attrVal WHERE appTypeId = @appTypeId AND clientId = @clientId
							AND id = @ruleId
			END
			IF 1 = (@opWindowRuleXML.exist('(//./opWindowRule/@utilization)[1]'))
			BEGIN
				SET @attrInt = @opWindowRuleXML.value('(//./opWindowRule/@utilization)[1]','INT')
				IF @attrInt <> (SELECT utilization FROM APP_OpWindowRule
								WHERE appTypeId = @appTypeId AND clientId = @clientId
								AND id = @ruleId)
				BEGIN
					UPDATE APP_OpWindowRule
						SET utilization  = @attrInt WHERE appTypeId = @appTypeId AND clientId = @clientId
								AND id = @ruleId
				END
			END
			IF 1 = (@opWindowRuleXML.exist('(//./opWindowRule/@startDate)[1]'))
			BEGIN
				SET @attrInt = @opWindowRuleXML.value('(//./opWindowRule/@startDate)[1]','INT')
				IF @attrInt <> (SELECT startDate FROM APP_OpWindowRule
								WHERE appTypeId = @appTypeId AND clientId = @clientId
								AND id = @ruleId)
				BEGIN
					UPDATE APP_OpWindowRule
						SET startDate  = @attrInt WHERE appTypeId = @appTypeId AND clientId = @clientId
								AND id = @ruleId
				END
			END
			IF 1 = (@opWindowRuleXML.exist('(//./opWindowRule/@endDate)[1]'))
			BEGIN
				SET @attrInt = @opWindowRuleXML.value('(//./opWindowRule/@endDate)[1]','INT')
				IF @attrInt <> (SELECT endDate FROM APP_OpWindowRule
								WHERE appTypeId = @appTypeId AND clientId = @clientId
								AND id = @ruleId)
				BEGIN
					UPDATE APP_OpWindowRule
						SET endDate  = @attrInt WHERE appTypeId = @appTypeId AND clientId = @clientId
								AND id = @ruleId
				END
			END
		END
		ELSE
			-- NEW OPERATION RULE IS SET
			BEGIN
				INSERT INTO APP_OpWindowRule VALUES (
					ISNULL((Select MAX(id) from APP_OpWindowRule),0) + 1,
					@clientId,
					@appTypeId,
					@opWindowRuleXML.value('(//./opWindowRule/@opType)[1]','INT'),
					@opWindowRuleXML.value('(//./opWindowRule/@daysOfWeek)[1]','INT'),
					@opWindowRuleXML.value('(//./opWindowRule/@startTime)[1]','INT'),
					@opWindowRuleXML.value('(//./opWindowRule/@endTime)[1]','INT'),
					@opWindowRuleXML.value('(//./opWindowRule/@enable)[1]','INT'),
					@opWindowRuleXML.value('(//./opWindowRule/@description)[1]','NVARCHAR(MAX)'),
					@opWindowRuleXML.value('(//./opWindowRule/@utilization)[1]','INT'),
					@opWindowRuleXML.value('(//./opWindowRule/@clientGroupId)[1]','INT'),
					0,0,0, -- instanceId,backupsetId,sunclientId is set to zero since rule is at agent level
					@opWindowRuleXML.value('(//./opWindowRule/@startDate)[1]','INT'),
					@opWindowRuleXML.value('(//./opWindowRule/@endDate)[1]','INT'),
					0, -- schedulePolicy Id
					32, --All Weeks
					0
					)
			END
			SET @opCount = @opCount + 1
	END
	---------------------------------------------------
	--------- SET AGENT SPECIFIC PROPERTIES -----------
	---------------------------------------------------
IF	@appTypeId = 13
	BEGIN
		SET @agentExtPropXML=@agentXML.query('(//./NASProperties)[1]')
		IF 1 = (@agentExtPropXML.exist('(//./NASProperties/@username)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./NASProperties/@username)[1]','NVARCHAR(MAX)')
			UPDATE MMNDMPHostInfo
				SET Login  = @attrVal WHERE clientId = @clientId
		END
		IF 1 = (@agentExtPropXML.exist('(//./NASProperties/@password)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./NASProperties/@password)[1]','NVARCHAR(MAX)')
			UPDATE MMNDMPHostInfo
				SET Password  = @attrVal WHERE clientId = @clientId
		END
		IF 1 = (@agentExtPropXML.exist('(//./NASProperties/@ListenPort)[1]'))
		BEGIN
			SET @attrInt = @agentExtPropXML.value('(//./NASProperties/@ListenPort)[1]','INT')
			UPDATE MMNDMPHostInfo
				SET ListenPort  = @attrInt WHERE clientId = @clientId
		END
	END
IF @appTypeId = 86 OR @appTypeId = 12
	BEGIN
		SET @agentExtPropXML=@agentXML.query('(//./netwareProperties)[1]')
		IF 1 = (@agentExtPropXML.exist('(//./netwareProperties/@username)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./netwareProperties/@username)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'fs user id')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'fs user id'
				INSERT INTO APP_IDAProp values (@id,'fs user id',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
	END
IF @appTypeId = 10
	BEGIN
		SET @agentExtPropXML=@agentXML.query('(//./ndsProperties)[1]')
		IF 1 = (@agentExtPropXML.exist('(//./ndsProperties/@username)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./ndsProperties/@username)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'fs user id')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'fs user id'
				INSERT INTO APP_IDAProp values (@id,'fs user id',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./ndsProperties/@NDSTreeName)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./ndsProperties/@NDSTreeName)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'treename')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'treename'
				INSERT INTO APP_IDAProp values (@id,'treename',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
	END
IF @appTypeId = 73
	BEGIN
		SET @agentExtPropXML=@agentXML.query('(//./ntapDMProperties)[1]')
		IF 1 = (@agentExtPropXML.exist('(//./ntapDMProperties/@SiteAccount)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./ntapDMProperties/@SiteAccount)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'NTAP DM user name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'NTAP DM user name'
				INSERT INTO APP_IDAProp values (@id,'NTAP DM user name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./ntapDMProperties/@SiteAccountServer)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./ntapDMProperties/@SiteAccountServer)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'NTAP DM filer name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'NTAP DM filer name'
				INSERT INTO APP_IDAProp values (@id,'NTAP DM filer name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./ntapDMProperties/@StubLocation)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./ntapDMProperties/@StubLocation)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'NTAP DM stub location')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'NTAP DM stub location'
				INSERT INTO APP_IDAProp values (@id,'NTAP DM stub location',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./ntapDMProperties/@password)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./ntapDMProperties/@password)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'NTAP DM password')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'NTAP DM password'
				INSERT INTO APP_IDAProp values (@id,'NTAP DM password',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
	END
IF @appTypeId = 58
	BEGIN
		SET @agentExtPropXML=@agentXML.query('(//./fsdmProperties)[1]')
		IF 1 = (@agentExtPropXML.exist('(//./fsdmProperties/@ADServerName)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./fsdmProperties/@ADServerName)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'AD Server Name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'AD Server Name'
				INSERT INTO APP_IDAProp values (@id,'AD Server Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./fsdmProperties/@ADUsername)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./fsdmProperties/@ADUsername)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'AD User Name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'AD User Name'
				INSERT INTO APP_IDAProp values (@id,'AD User Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./fsdmProperties/@proxyFileExpiration)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./fsdmProperties/@proxyFileExpiration)[1]','NVARCHAR(MAX)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Proxy File Expiration')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Proxy File Expiration'
				INSERT INTO APP_IDAProp values (@id,'Proxy File Expiration',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./fsdmProperties/@proxyFilePruneInterval)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./fsdmProperties/@proxyFilePruneInterval)[1]','NVARCHAR(MAX)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Proxy File Prune Interval')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Proxy File Prune Interval'
				INSERT INTO APP_IDAProp values (@id,'Proxy File Prune Interval',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./fsdmProperties/@isEnableNFSShareForEMC)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./fsdmProperties/@isEnableNFSShareForEMC)[1]','NVARCHAR(MAX)')
							WHEN '1' THEN '1'
							ELSE '0' END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Enable NFS Share for EMC')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Enable NFS Share for EMC'
				INSERT INTO APP_IDAProp values (@id,'Enable NFS Share for EMC',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./fsdmProperties/@proxyUsername)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./fsdmProperties/@proxyUsername)[1]','NVARCHAR(MAX)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'FSDM User Name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'FSDM User Name'
				INSERT INTO APP_IDAProp values (@id,'FSDM User Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./fsdmProperties/@isEndUserEraseEnabled)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./fsdmProperties/@isEndUserEraseEnabled)[1]','NVARCHAR(MAX)')
							WHEN '1' THEN '1'
							ELSE '0' END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'FSDM Enable End User Erase')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'FSDM Enable End User Erase'
				INSERT INTO APP_IDAProp values (@id,'FSDM Enable End User Erase',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./fsdmProperties/@EndUserFolderList)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./fsdmProperties/@EndUserFolderList)[1]','NVARCHAR(MAX)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'FSDM End User Erase Folder List')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'FSDM End User Erase Folder List'
				INSERT INTO APP_IDAProp values (@id,'FSDM End User Erase Folder List',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
	END
IF @appTypeId = 85
	BEGIN
		SET @agentExtPropXML=@agentXML.query('(//./dataclassificationProperties)[1]')
		IF 1 = (@agentExtPropXML.exist('(//./dataclassificationProperties/@ADServerName)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./dataclassificationProperties/@ADServerName)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'AD Server Name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'AD Server Name'
				INSERT INTO APP_IDAProp values (@id,'AD Server Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./dataclassificationProperties/@ADUsername)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./dataclassificationProperties/@ADUsername)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'AD User Name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'AD User Name'
				INSERT INTO APP_IDAProp values (@id,'AD User Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./dataclassificationProperties/@MetaDataFileLocation)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./dataclassificationProperties/@MetaDataFileLocation)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Data Class Meta Data Location')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Data Class Meta Data Location'
				INSERT INTO APP_IDAProp values (@id,'Data Class Meta Data Location',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./dataclassificationProperties/@isDataClassificationEnabled)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./dataclassificationProperties/@isDataClassificationEnabled)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '0' END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Data Class Enabled')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Data Class Enabled'
				INSERT INTO APP_IDAProp values (@id,'Data Class Enabled',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./dataclassificationProperties/@isOnline)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./dataclassificationProperties/@isOnline)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '0' END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Data Class Online')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Data Class Online'
				INSERT INTO APP_IDAProp values (@id,'Data Class Online',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./dataclassificationProperties/@clientPriority)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./dataclassificationProperties/@clientPriority)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Data Class Client Priority')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Data Class Client Priority'
				INSERT INTO APP_IDAProp values (@id,'Data Class Client Priority',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./dataclassificationProperties/@InactivityPeriod)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./dataclassificationProperties/@InactivityPeriod)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Data Class Inactive Period')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Data Class Inactive Period'
				INSERT INTO APP_IDAProp values (@id,'Data Class Inactive Period',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./dataclassificationProperties/@updateInterval)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./dataclassificationProperties/@updateInterval)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Data Class Update Interval')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Data Class Update Interval'
				INSERT INTO APP_IDAProp values (@id,'Data Class Update Interval',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./dataclassificationProperties/@DataClassificationTagList)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./dataclassificationProperties/@DataClassificationTagList)[1]','nvarchar(max)')
			SET @attrInt = ISNULL((@agentExtPropXML.value('(//./dataclassificationProperties/@InstanceId)[1]','INT')),1)
			IF @attrVal <> CAST((SELECT attrVal FROM APP_ExtendedProperties WHERE clientId = @clientId
							AND modified = 0 AND attrName = 'Data Classifier Tag Name' AND appTypeId = @apptypeId
							AND instance = @attrInt) AS NVARCHAR(MAX))
			BEGIN
				UPDATE APP_ExtendedProperties
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE modified = 0 AND attrName = 'Data Classifier Tag Name'
						AND instance = @attrInt AND appTypeId = @apptypeId
				INSERT INTO APP_ExtendedProperties values (@clientId,@appTypeId,@attrInt,0,0,1,
							'Data Classifier Tag Name',@attrVal,'',dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
	END
IF @appTypeId = 83
	BEGIN
		SET @agentExtPropXML=@agentXML.query('(//./netwareDMProperties)[1]')
		IF 1 = (@agentExtPropXML.exist('(//./netwareDMProperties/@username)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./netwareDMProperties/@username)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'fs user id')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'fs user id'
				INSERT INTO APP_IDAProp values (@id,'fs user id',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./netwareDMProperties/@password)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./netwareDMProperties/@password)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'fs user password')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'fs user password'
				INSERT INTO APP_IDAProp values (@id,'fs user password',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
	END
IF	@appTypeId = 11 OR
@appTypeId = 91	OR
@appTypeId = 93
	BEGIN
		SET @agentExtPropXML=@agentXML.query('(//./win2KProperties)[1]')
		IF 1 = (@agentExtPropXML.exist('(//./win2KProperties/@OWAURLList)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./win2KProperties/@OWAURLList)[1]','nvarchar(max)')
			SET @attrInt = ISNULL((@agentExtPropXML.value('(//./win2KProperties/@InstanceId)[1]','INT')),1)
			IF @attrVal <> CAST((SELECT attrVal FROM APP_ExtendedProperties WHERE clientId = @clientId
							AND instance = @attrInt AND modified = 0
							AND attrName = 'OWA URL list' and appTypeId = @apptypeId)
							 AS NVARCHAR(MAX))
			BEGIN
				UPDATE APP_ExtendedProperties
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE modified = 0 AND attrName = 'OWA URL list'
						AND instance = @attrInt AND appTypeId = @apptypeId
				INSERT INTO APP_ExtendedProperties values (@clientId,@appTypeId,@attrInt,0,0,1,
							'OWA URL list',@attrVal,'',dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./win2KProperties/@OnlineCILocationShareName)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./win2KProperties/@OnlineCILocationShareName)[1]','nvarchar(max)')
			SET @attrInt = ISNULL((@agentExtPropXML.value('(//./win2KProperties/@InstanceId)[1]','INT')),1)
			IF @attrVal <> CAST((SELECT attrVal FROM APP_ExtendedProperties WHERE clientId = @clientId
							AND instance = @attrInt AND modified = 0
							AND attrName = 'Context Indexing List' and appTypeId = @apptypeId)
							AS NVARCHAR(MAX))
			BEGIN
				UPDATE APP_ExtendedProperties
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE modified = 0 AND attrName = 'Context Indexing List'
						AND instance = @attrInt AND appTypeId = @apptypeId
				INSERT INTO APP_ExtendedProperties values (@clientId,@appTypeId,@attrInt,0,0,1,
							'Context Indexing List',@attrVal,'',dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
	END
IF	@appTypeId = 50 OR
@appTypeId = 47
	BEGIN
		SET @agentExtPropXML=@agentXML.query('(//./replicationCredentials)[1]')
		SET @attrVal = ISNULL((@agentExtPropXML.value('(//./replicationCredentials/@Username)[1]','nvarchar(max)')),N'')
		SET @attrVal += ISNULL((@agentExtPropXML.value('(//./replicationCredentials/@password)[1]','nvarchar(max)')),N'')
		SET @attrVal += ISNULL((@agentExtPropXML.value('(//./replicationCredentials/@Servername)[1]','nvarchar(max)')),N'')
		SET @attrName = ISNULL((@agentExtPropXML.value('(//./replicationCredentials/@appName)[1]','nvarchar(max)')),N'')
		SET @attrName += CHAR(0x15)
		SET @attrName += 'credentials'
		IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
						AND modified = 0 AND attrName = @attrName)
		BEGIN
			UPDATE APP_IDAProp
				SET modified  = dbo.GetUnixTime(GETDATE())
					WHERE componentNameId = @id AND modified = 0 AND attrName = @attrName
			INSERT INTO APP_IDAProp values (@id,@attrName,1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
		END
	END
IF	@appTypeId = 7 OR
@appTypeId = 52 OR
@appTypeId = 60 OR
@appTypeId = 90
	BEGIN
		SET @agentExtPropXML=@agentXML.query('(//./LNDocProperties)[1]')
		IF 1 = (@agentExtPropXML.exist('(//./LNDocProperties/@RestoreToRecoveredItems)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./LNDocProperties/@RestoreToRecoveredItems)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'LMDM Restore to Revocered Items Folder')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'LMDM Restore to Revocered Items Folder'
				INSERT INTO APP_IDAProp values (@id,'LMDM Restore to Revocered Items Folder',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
	END
IF	@appTypeId = 41
	BEGIN
		SET @agentExtPropXML=@agentXML.query('(//./granularADProperties)[1]')
		IF 1 = (@agentExtPropXML.exist('(//./granularADProperties/@username)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./granularADProperties/@username)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'AD User Name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'AD User Name'
				INSERT INTO APP_IDAProp values (@id,'AD User Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./granularADProperties/@password)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./granularADProperties/@password)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'AD User Password')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'AD User Password'
				INSERT INTO APP_IDAProp values (@id,'AD User Password',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
	END
IF 	@appTypeId = 84 OR
@appTypeId = 107
	BEGIN
		SET @agentExtPropXML=@agentXML.query('(//./FLRProperties)[1]')
		IF 1 = (@agentExtPropXML.exist('(//./FLRProperties/@Username)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./FLRProperties/@Username)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'FLR Dest User Name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'FLR Dest User Name'
				INSERT INTO APP_IDAProp values (@id,'FLR Dest User Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./FLRProperties/@FileLogPath)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./FLRProperties/@FileLogPath)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'FLR Log Filepath')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'FLR Log Filepath'
				INSERT INTO APP_IDAProp values (@id,'FLR Log Filepath',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./FLRProperties/@LogVolThrottlePercent)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./FLRProperties/@LogVolThrottlePercent)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'FLR Dest Log Volume Throttle PerCent')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'FLR Dest Log Volume Throttle PerCent'
				INSERT INTO APP_IDAProp values (@id,'FLR Dest Log Volume Throttle PerCent',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./FLRProperties/@LogVolStopLogsPercent)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./FLRProperties/@LogVolStopLogsPercent)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'FLR Dest Log Volume Stop Logs PerCent')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'FLR Dest Log Volume Stop Logs PerCent'
				INSERT INTO APP_IDAProp values (@id,'FLR Dest Log Volume Stop Logs PerCent',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		--Check if replication option is indeed in IDA_Prop??
		IF 1 = (@agentExtPropXML.exist('(//./FLRProperties/@FLRReplicationOptions)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./FLRProperties/@FLRReplicationOptions)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'FLR Replication Options')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'FLR Replication Options'
				INSERT INTO APP_IDAProp values (@id,'FLR Replication Options',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./FLRProperties/@SrcLogVolAbortPercent)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./FLRProperties/@SrcLogVolAbortPercent)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'FLR Src  Log Volume Abort PerCent')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'FLR Src  Log Volume Abort PerCent'
				INSERT INTO APP_IDAProp values (@id,'FLR Src  Log Volume Abort PerCent',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./FLRProperties/@FLRDefualtOSPriority)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./FLRProperties/@FLRDefualtOSPriority)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'FLR Default OS Priority')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'FLR Default OS Priority'
				INSERT INTO APP_IDAProp values (@id,'FLR Default OS Priority',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./FLRProperties/@FLRLogFlushWaitTime)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./FLRProperties/@FLRLogFlushWaitTime)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'FLR Logfile Flush Wait Time Minutes')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'FLR Logfile Flush Wait Time Minutes'
				INSERT INTO APP_IDAProp values (@id,'FLR Logfile Flush Wait Time Minutes',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./FLRProperties/@FLRTransferRate)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./FLRProperties/@FLRTransferRate)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'FLR Xfer Rate MB per Sec')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'FLR Xfer Rate MB per Sec'
				INSERT INTO APP_IDAProp values (@id,'FLR Xfer Rate MB per Sec',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./FLRProperties/@FLRONTAPUsername)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./FLRProperties/@FLRONTAPUsername)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'FLR ONTAP User Name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'FLR ONTAP User Name'
				INSERT INTO APP_IDAProp values (@id,'FLR ONTAP User Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
	END
IF 	@appTypeId = 46 OR
@appTypeId = 78 OR
@appTypeId = 89
	BEGIN
		SET @agentExtPropXML=@agentXML.query('(//./sharePointProp)[1]')
		IF 1 = (@agentExtPropXML.exist('(//./sharePointProp/@sqlUserName)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./sharePointProp/@sqlUserName)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'SharePoint Remote SQL user name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'SharePoint Remote SQL user name'
				INSERT INTO APP_IDAProp values (@id,'SharePoint Remote SQL user name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./sharePointProp/@Username)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./sharePointProp/@Username)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'User Name')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'User Name'
				INSERT INTO APP_InstanceProp values (@CompId,'User Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./sharePointProp/@ServerName)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./sharePointProp/@ServerName)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Server Name')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Server Name'
				INSERT INTO APP_InstanceProp values (@CompId,'Server Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./sharePointProp/@ReleaseTopologyLock)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./sharePointProp/@ReleaseTopologyLock)[1]','nvarchar(max)')
							WHEN '1' THEN 1
							ELSE	0 END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Release Topology lock')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Release Topology lock'
				INSERT INTO APP_IDAProp values (@id,'Release Topology lock',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./sharePointProp/@RestorePath)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./sharePointProp/@RestorePath)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'SharePoint Remote Index Backup Restore Path')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'SharePoint Remote Index Backup Restore Path'
				INSERT INTO APP_IDAProp values (@id,'SharePoint Remote Index Backup Restore Path',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./sharePointProp/@isRemoteSQLServer)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./sharePointProp/@isRemoteSQLServer)[1]','nvarchar(max)')
							WHEN '1' THEN 1
							ELSE	0 END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'SharePoint Is Remote SQL server')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'SharePoint Is Remote SQL server'
				INSERT INTO APP_IDAProp values (@id,'SharePoint Is Remote SQL server',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./sharePointProp/@password)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./sharePointProp/@password)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'SharePoint Remote SQL password')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'SharePoint Remote SQL password'
				INSERT INTO APP_IDAProp values (@id,'SharePoint Remote SQL password',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
	END
IF	@appTypeId = 82 OR
@appTypeId = 35 OR
@appTypeId = 44 OR
@appTypeId = 55
	BEGIN
		SET @agentExtPropXML=@agentXML.query('(//./exchangePublicFolderProp)[1]')
		IF 1 = (@agentExtPropXML.exist('(//./exchangePublicFolderProp/@UserName)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./exchangePublicFolderProp/@UserName)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'User Name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'User Name'
				INSERT INTO APP_IDAProp values (@id,'User Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangePublicFolderProp/@ServerName)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./exchangePublicFolderProp/@ServerName)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Server Name')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Server Name'
				INSERT INTO APP_InstanceProp values (@CompId,'Server Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangePublicFolderProp/@ProfileName)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./exchangePublicFolderProp/@ProfileName)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Profile Name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Profile Name'
				INSERT INTO APP_IDAProp values (@id,'Profile Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangePublicFolderProp/@MailboxName)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./exchangePublicFolderProp/@MailboxName)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Mailbox Name')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Mailbox Name'
				INSERT INTO APP_InstanceProp values (@CompId,'Mailbox Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangePublicFolderProp/@BackupDeleted)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./exchangePublicFolderProp/@BackupDeleted)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE	'0' END)
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Backup deleted item retention')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Backup deleted item retention'
				INSERT INTO APP_InstanceProp values (@CompId,'Backup deleted item retention',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangePublicFolderProp/@UseCSVDEDiscovery)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./exchangePublicFolderProp/@UseCSVDEDiscovery)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Use CSVDE for AD mailbox discovery')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Use CSVDE for AD mailbox discovery'
				INSERT INTO APP_InstanceProp values (@CompId,'Use CSVDE for AD mailbox discovery',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangePublicFolderProp/@BackupHiddenMailBox)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./exchangePublicFolderProp/@BackupHiddenMailBox)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '0' END)
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Backup hidden mailbox')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Backup hidden mailbox'
				INSERT INTO APP_InstanceProp values (@CompId,'Backup hidden mailbox',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
	END
IF	@appTypeId = 45 OR
@appTypeId = 56 OR
@appTypeId = 57
	BEGIN
		SET @agentExtPropXML=@agentXML.query('(//./dataMigratorProp)[1]')
		IF 1 = (@agentExtPropXML.exist('(//./dataMigratorProp/@UserName)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./dataMigratorProp/@UserName)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'User Name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'User Name'
				INSERT INTO APP_IDAProp values (@id,'User Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./dataMigratorProp/@ServerName)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./dataMigratorProp/@ServerName)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Server Name')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Server Name'
				INSERT INTO APP_InstanceProp values (@CompId,'Server Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./dataMigratorProp/@ProfileName)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./dataMigratorProp/@ProfileName)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Profile Name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Profile Name'
				INSERT INTO APP_IDAProp values (@id,'Profile Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./dataMigratorProp/@MailboxName)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./dataMigratorProp/@MailboxName)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Mailbox Name')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Mailbox Name'
				INSERT INTO APP_InstanceProp values (@CompId,'Mailbox Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./dataMigratorProp/@BackupDeleted)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./dataMigratorProp/@BackupDeleted)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE	'0' END)
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Backup deleted item retention')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Backup deleted item retention'
				INSERT INTO APP_InstanceProp values (@CompId,'Backup deleted item retention',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./dataMigratorProp/@UseCSVDEDiscovery)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./dataMigratorProp/@UseCSVDEDiscovery)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Use CSVDE for AD mailbox discovery')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Use CSVDE for AD mailbox discovery'
				INSERT INTO APP_InstanceProp values (@CompId,'Use CSVDE for AD mailbox discovery',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./dataMigratorProp/@BackupHiddenMailBox)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./dataMigratorProp/@BackupHiddenMailBox)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '0' END)
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Backup hidden mailbox')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Backup hidden mailbox'
				INSERT INTO APP_InstanceProp values (@CompId,'Backup hidden mailbox',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./dataMigratorProp/@JournalThreshold)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./dataMigratorProp/@JournalThreshold)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE	'0' END)
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Journal Threshold')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Journal Threshold'
				INSERT INTO APP_InstanceProp values (@CompId,'Journal Threshold',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./dataMigratorProp/@ADServerList)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./dataMigratorProp/@ADServerList)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Associated AD Server List')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Associated AD Server List'
				INSERT INTO APP_InstanceProp values (@CompId,'Associated AD Server List',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./dataMigratorProp/@isForceRecallOutlookAddin)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./dataMigratorProp/@isForceRecallOutlookAddin)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '0' END)
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Force Recall for Outlook Addin User')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Force Recall for Outlook Addin User'
				INSERT INTO APP_InstanceProp values (@CompId,'Force Recall for Outlook Addin User',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./dataMigratorProp/@isForceRecallOWAUser)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./dataMigratorProp/@isForceRecallOWAUser)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '0' END)
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Force Recall for OWA User')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Force Recall for OWA User'
				INSERT INTO APP_InstanceProp values (@CompId,'Force Recall for OWA User',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./dataMigratorProp/@isAutoDiscoveryEnabled)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./dataMigratorProp/@isAutoDiscoveryEnabled)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '2' END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Auto Discovery Enabled')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @Id AND modified = 0 AND attrName = 'Auto Discovery Enabled'
				INSERT INTO APP_IDAProp values (@id,'Auto Discovery Enabled',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./dataMigratorProp/@canManageContentAutomatically)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./dataMigratorProp/@canManageContentAutomatically)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '2' END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Manage content automatically')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @Id AND modified = 0 AND attrName = 'Manage content automatically'
				INSERT INTO APP_IDAProp values (@id,'Manage content automatically',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./dataMigratorProp/@isOptimizeDataForSearchEnabled)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./dataMigratorProp/@isOptimizeDataForSearchEnabled)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '2' END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Optimized Data for Search')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @Id AND modified = 0 AND attrName = 'Optimized Data for Search'
				INSERT INTO APP_IDAProp values (@id,'Optimized Data for Search',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./dataMigratorProp/@AgentVersion)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./dataMigratorProp/@AgentVersion)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '2' END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'IDA Version')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @Id AND modified = 0 AND attrName = 'IDA Version'
				INSERT INTO APP_IDAProp values (@id,'IDA Version',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
	END
IF	@appTypeId = 67 OR
@appTypeId = 68
	BEGIN
		SET @agentExtPropXML=@agentXML.query('(//./exchangeArchiverProp)[1]')
		IF 1 = (@agentExtPropXML.exist('(//./exchangeArchiverProp/@UserName)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./exchangeArchiverProp/@UserName)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'User Name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'User Name'
				INSERT INTO APP_IDAProp values (@id,'User Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeArchiverProp/@ServerName)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./exchangeArchiverProp/@ServerName)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Server Name')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Server Name'
				INSERT INTO APP_InstanceProp values (@CompId,'Server Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeArchiverProp/@ProfileName)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./exchangeArchiverProp/@ProfileName)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Profile Name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Profile Name'
				INSERT INTO APP_IDAProp values (@id,'Profile Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeArchiverProp/@MailboxName)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./exchangeArchiverProp/@MailboxName)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Mailbox Name')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Mailbox Name'
				INSERT INTO APP_InstanceProp values (@CompId,'Mailbox Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeArchiverProp/@BackupDeleted)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./exchangeArchiverProp/@BackupDeleted)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE	'0' END)
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Backup deleted item retention')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Backup deleted item retention'
				INSERT INTO APP_InstanceProp values (@CompId,'Backup deleted item retention',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeArchiverProp/@UseCSVDEDiscovery)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./exchangeArchiverProp/@UseCSVDEDiscovery)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Use CSVDE for AD mailbox discovery')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Use CSVDE for AD mailbox discovery'
				INSERT INTO APP_InstanceProp values (@CompId,'Use CSVDE for AD mailbox discovery',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeArchiverProp/@BackupHiddenMailBox)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./exchangeArchiverProp/@BackupHiddenMailBox)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '0' END)
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Backup hidden mailbox')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Backup hidden mailbox'
				INSERT INTO APP_InstanceProp values (@CompId,'Backup hidden mailbox',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeArchiverProp/@JournalThreshold)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./exchangeArchiverProp/@JournalThreshold)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE	'0' END)
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Journal Threshold')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Journal Threshold'
				INSERT INTO APP_InstanceProp values (@CompId,'Journal Threshold',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeArchiverProp/@ADServerList)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./exchangeArchiverProp/@ADServerList)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Associated AD Server List')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Associated AD Server List'
				INSERT INTO APP_InstanceProp values (@CompId,'Associated AD Server List',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeArchiverProp/@canManageContentAutomatically)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./exchangeArchiverProp/@canManageContentAutomatically)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '2' END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Manage content automatically')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @Id AND modified = 0 AND attrName = 'Manage content automatically'
				INSERT INTO APP_IDAProp values (@id,'Manage content automatically',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeArchiverProp/@isOptimizeDataForSearchEnabled)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./exchangeArchiverProp/@isOptimizeDataForSearchEnabled)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '2' END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Optimized Data for Search')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @Id AND modified = 0 AND attrName = 'Optimized Data for Search'
				INSERT INTO APP_IDAProp values (@id,'Optimized Data for Search',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeArchiverProp/@isHostedExchange)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./exchangeArchiverProp/@isHostedExchange)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '2' END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Hosted exchange')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @Id AND modified = 0 AND attrName = 'Hosted exchange'
				INSERT INTO APP_IDAProp values (@id,'Hosted exchange',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeArchiverProp/@IDAVersion)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./exchangeArchiverProp/@IDAVersion)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '2' END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'IDA Version')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @Id AND modified = 0 AND attrName = 'IDA Version'
				INSERT INTO APP_IDAProp values (@id,'IDA Version',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
	END
IF	@appTypeId = 8 OR
@appTypeId = 14 OR
@appTypeId = 54 OR
@appTypeId = 105
	BEGIN
		SET @agentExtPropXML=@agentXML.query('(//./exchangeMBProp)[1]')
		IF 1 = (@agentExtPropXML.exist('(//./exchangeMBProp/@UserName)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./exchangeMBProp/@UserName)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'User Name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'User Name'
				INSERT INTO APP_IDAProp values (@id,'User Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeMBProp/@ServerName)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./exchangeMBProp/@ServerName)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Server Name')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Server Name'
				INSERT INTO APP_InstanceProp values (@CompId,'Server Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeMBProp/@ProfileName)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./exchangeMBProp/@ProfileName)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Profile Name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Profile Name'
				INSERT INTO APP_IDAProp values (@id,'Profile Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeMBProp/@MailboxName)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./exchangeMBProp/@MailboxName)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Mailbox Name')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Mailbox Name'
				INSERT INTO APP_InstanceProp values (@CompId,'Mailbox Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeMBProp/@BackupDeleted)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./exchangeMBProp/@BackupDeleted)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE	'0' END)
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Backup deleted item retention')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Backup deleted item retention'
				INSERT INTO APP_InstanceProp values (@CompId,'Backup deleted item retention',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeMBProp/@UseCSVDEDiscovery)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./exchangeMBProp/@UseCSVDEDiscovery)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Use CSVDE for AD mailbox discovery')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Use CSVDE for AD mailbox discovery'
				INSERT INTO APP_InstanceProp values (@CompId,'Use CSVDE for AD mailbox discovery',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeMBProp/@BackupHiddenMailBox)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./exchangeMBProp/@BackupHiddenMailBox)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '0' END)
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Backup hidden mailbox')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Backup hidden mailbox'
				INSERT INTO APP_InstanceProp values (@CompId,'Backup hidden mailbox',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeMBProp/@JournalThreshold)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./exchangeMBProp/@JournalThreshold)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE	'0' END)
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Journal Threshold')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Journal Threshold'
				INSERT INTO APP_InstanceProp values (@CompId,'Journal Threshold',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeMBProp/@ADServerList)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./exchangeMBProp/@ADServerList)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Associated AD Server List')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Associated AD Server List'
				INSERT INTO APP_InstanceProp values (@CompId,'Associated AD Server List',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeMBProp/@canManageContentAutomatically)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./exchangeMBProp/@canManageContentAutomatically)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '2' END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Manage content automatically')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @Id AND modified = 0 AND attrName = 'Manage content automatically'
				INSERT INTO APP_IDAProp values (@id,'Manage content automatically',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeMBProp/@isOptimizeDataForSearchEnabled)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./exchangeMBProp/@isOptimizeDataForSearchEnabled)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '2' END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Optimized Data for Search')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @Id AND modified = 0 AND attrName = 'Optimized Data for Search'
				INSERT INTO APP_IDAProp values (@id,'Optimized Data for Search',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeMBProp/@isHostedExchange)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./exchangeMBProp/@isHostedExchange)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '2' END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Hosted exchange')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @Id AND modified = 0 AND attrName = 'Hosted exchange'
				INSERT INTO APP_IDAProp values (@id,'Hosted exchange',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeMBProp/@IDAVersion)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./exchangeMBProp/@IDAVersion)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '2' END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'IDA Version')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @Id AND modified = 0 AND attrName = 'IDA Version'
				INSERT INTO APP_IDAProp values (@id,'IDA Version',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeMBProp/@OnlineCILocShare)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./exchangeMBProp/@OnlineCILocShare)[1]','nvarchar(max)')
			SET @attrInt = ISNULL((@agentExtPropXML.value('(//./exchangeMBProp/@InstanceId)[1]','INT')),1)
			IF @attrVal <> CAST((SELECT attrVal FROM APP_ExtendedProperties WHERE clientId = @clientId
 									AND appTypeId = @appTypeId AND attrName = 'Context Indexing List' AND modified = 0)
 									 AS NVARCHAR(MAX))
			BEGIN
				UPDATE APP_ExtendedProperties
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE clientId = @clientId	AND appTypeId = @appTypeId AND attrName = 'Context Indexing List' AND modified = 0
				INSERT INTO APP_ExtendedProperties values (@clientId,@appTypeId,@attrInt,0,0,1,
							'Context Indexing List',@attrVal,'',dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeMBProp/@CIOWAUrlList)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./exchangeMBProp/@CIOWAUrlList)[1]','nvarchar(max)')
			SET @attrInt = ISNULL((@agentExtPropXML.value('(//./exchangeMBProp/@InstanceId)[1]','INT')),1)
			IF @attrVal <> CAST((SELECT attrVal FROM APP_ExtendedProperties WHERE clientId = @clientId
 									AND appTypeId = @appTypeId AND attrName = 'OWA URL list' AND modified = 0)
 									 AS NVARCHAR(MAX))
			BEGIN
				UPDATE APP_ExtendedProperties
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE clientId = @clientId	AND appTypeId = @appTypeId AND attrName = 'OWA URL list' AND modified = 0
				INSERT INTO APP_ExtendedProperties values (@clientId,@appTypeId,@attrInt,0,0,1,
							'OWA URL list',@attrVal,'',dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
	END
IF	@appTypeId = 71
	BEGIN
		SET @agentExtPropXML=@agentXML.query('(//./netwareGroupWise)[1]')
		IF 1 = (@agentExtPropXML.exist('(//./netwareGroupWise/@Username)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./netwareDMProperties/@Username)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'fs user id')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'fs user id'
				INSERT INTO APP_IDAProp values (@id,'fs user id',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
	END
IF	@appTypeId = 27 OR
@appTypeId = 31
	BEGIN
		SET @agentExtPropXML=@agentXML.query('(//./fastraxForExchProp)[1]')
		IF 1 = (@agentExtPropXML.exist('(//./fastraxForExchProp/@Username)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./fastraxForExchProp/@Username)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'User Name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'User Name'
				INSERT INTO APP_IDAProp values (@id,'User Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./fastraxForExchProp/@ServerName)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./fastraxForExchProp/@ServerName)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Server Name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Server Name'
				INSERT INTO APP_IDAProp values (@id,'Server Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./fastraxForExchProp/@backupLevel)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./fastraxForExchProp/@backupLevel)[1]','nvarchar(max)')
			SET @attrInt = ISNULL((@agentExtPropXML.value('(//./fastraxForExchProp/@InstanceId)[1]','INT')),1)
			SET @appId = ISNULL((SELECT TOP 1 id
						FROM APP_APPLICATION
						WHERE	backupSet = (SELECT TOP 1 backupSet
									FROM APP_Application
									WHERE instance = @attrInt
									AND appTypeId = @appTypeId)
AND ((subclientStatus & 0x00004) <> 0x00004)),
						0)
			IF @attrVal <> (SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @appId
							AND modified = 0 AND attrName = 'Backup Level')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Backup Level'
				INSERT INTO APP_SubclientProp values (@appId,'Backup Level',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
	END
IF	@appTypeId = 32
	BEGIN
		SET @agentExtPropXML=@agentXML.query('(//./sharepointDBProp)[1]')
		IF 1 = (@agentExtPropXML.exist('(//./sharepointDBProp/@Username)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./sharepointDBProp/@Username)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'User Name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'User Name'
				INSERT INTO APP_IDAProp values (@id,'User Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./sharepointDBProp/@ServerName)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./sharepointDBProp/@ServerName)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Server Name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Server Name'
				INSERT INTO APP_IDAProp values (@id,'Server Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./sharepointDBProp/@backupLevel)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./sharepointDBProp/@backupLevel)[1]','nvarchar(max)')
			SET @attrInt = ISNULL((@agentExtPropXML.value('(//./sharepointDBProp/@InstanceId)[1]','INT')),1)
			SET @appId = ISNULL((SELECT TOP 1 id
						FROM APP_APPLICATION
						WHERE	backupSet = (SELECT TOP 1 backupSet
									FROM APP_Application
									WHERE instance = @attrInt
									AND appTypeId = @appTypeId)
AND ((subclientStatus & 0x00004) <> 0x00004)),
						0)
			IF @attrVal <> (SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @appId
							AND modified = 0 AND attrName = 'Backup Level')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Backup Level'
				INSERT INTO APP_SubclientProp values (@appId,'Backup Level',10,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
	END
IF	@appTypeId = 22 OR
@apptypeId = 80
	BEGIN
		IF 1 = (@agentExtPropXML.exist('(//./oracle8prop/@isAutoDiscoveredEnabled)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./oracle8prop/@isAutoDiscoveredEnabled)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '0' END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Server Name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Server Name'
				INSERT INTO APP_IDAProp values (@id,'Server Name',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
	END
IF	@appTypeId = 81
	BEGIN
	SET @agentExtPropXML=@agentXML.query('(//./sql61Prop)[1]')
	    IF 1 = (@agentExtPropXML.exist('(//./overrideHigherLevelSettings)[1]'))
	    BEGIN
			SET @sqlUAXML=@agentExtPropXML.query('(//./overrideHigherLevelSettings)[1]')
			IF 1 = (@sqlUAXML.exist('(//./overrideHigherLevelSettings/@overrideGlobalAuthentication)[1]'))
			BEGIN
				SET @attrVal = (CASE @sqlUAXML.value('(//./overrideHigherLevelSettings/@overrideGlobalAuthentication)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '0' END)
			    IF EXISTS (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'MSSQL Override Global Authentication')
			    BEGIN
					IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
								AND modified = 0 AND attrName = 'MSSQL Override Global Authentication')
					BEGIN
						UPDATE APP_IDAProp
						SET modified  = dbo.GetUnixTime(GETDATE())
							WHERE componentNameId = @id AND modified = 0 AND attrName = 'MSSQL Override Global Authentication'
						INSERT INTO APP_IDAProp values (@id,'MSSQL Override Global Authentication',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
	    			END
	    	    END
                ELSE
			         INSERT INTO APP_IDAProp values (@id,'MSSQL Override Global Authentication',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
			IF 1 = (@sqlUAXML.exist('(//./overrideHigherLevelSettings/@useLocalSystemAccount)[1]'))
			BEGIN
				SET @attrVal = (CASE @sqlUAXML.value('(//./overrideHigherLevelSettings/@useLocalSystemAccount)[1]','nvarchar(max)')
								WHEN '1' THEN '1'
								ELSE '0' END)
				IF EXISTS (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
								AND modified = 0 AND attrName = 'MSSQL Use Windows Authentication')
                BEGIN
					IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
									AND modified = 0 AND attrName = 'MSSQL Use Windows Authentication')
					BEGIN
						UPDATE APP_IDAProp
							SET modified  = dbo.GetUnixTime(GETDATE())
								WHERE componentNameId = @id AND modified = 0 AND attrName = 'MSSQL Use Windows Authentication'
						INSERT INTO APP_IDAProp values (@id,'MSSQL Use Windows Authentication',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
					END
				END
				ELSE
				     INSERT INTO APP_IDAProp values (@id,'MSSQL Use Windows Authentication',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
			IF 1 = (@sqlUAXML.exist('(//./userAccount)[1]'))
	            BEGIN
			     SET @sqlUPXML=@sqlUAXML.query('(//./userAccount)[1]')
			     IF 1 = (@sqlUPXML.exist('(//./userAccount/@userName)[1]'))
	                BEGIN
				    SET @attrVal = @sqlUPXML.value('(//./userAccount/@userName)[1]','nvarchar(max)')
				    IF EXISTS  (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
								AND modified = 0 AND attrName = 'MSSQL username')
	                      BEGIN
						IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
									AND modified = 0 AND attrName = 'MSSQL username')
						BEGIN
						   UPDATE APP_IDAProp
					    		SET modified  = dbo.GetUnixTime(GETDATE())
						     		WHERE componentNameId = @id AND modified = 0 AND attrName = 'MSSQL username'
						   INSERT INTO APP_IDAProp values (@id,'MSSQL username',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
					     END
				    END
				    ELSE
				       INSERT INTO APP_IDAProp values (@id,'MSSQL username',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			     END
			     IF 1 = (@sqlUPXML.exist('(//./userAccount/@password)[1]'))
			     BEGIN
                    SET @attrVal = @sqlUPXML.value('(//./userAccount/@password)[1]','nvarchar(max)')
                    IF EXISTS (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
						AND modified = 0 AND attrName = 'MSSQL password')
			  BEGIN
		               IF @attrVal <> (SELECT dbo.pswConvertV5ToV3(attrVal) FROM APP_IDAProp WHERE componentNameId = @id
			 			AND modified = 0 AND attrName = 'MSSQL password')
			         BEGIN
			       	       UPDATE APP_IDAProp
						        SET modified  = dbo.GetUnixTime(GETDATE())
						        	WHERE componentNameId = @id AND modified = 0 AND attrName = 'MSSQL password'
					     INSERT INTO APP_IDAProp values (@id,'MSSQL password',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
				   END
			  END
			  ELSE
			            INSERT INTO APP_IDAProp values (@id,'MSSQL password',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
		         END
	        END
	    END
--		IF 1 = (@agentExtPropXML.exist('(//./sql61Prop/@password)[1]'))
--		BEGIN
--			SET @attrVal = @agentExtPropXML.value('(//./sql61Prop/@password)[1]','nvarchar(max)')
--
--			IF @attrVal <> (SELECT dbo.pswConvertV5ToV3(attrVal) FROM APP_IDAProp WHERE componentNameId = @id
--							AND modified = 0 AND attrName = 'MSSQL password')
--			BEGIN
--				UPDATE APP_IDAProp
--					SET modified  = dbo.GetUnixTime(GETDATE())
--						WHERE componentNameId = @id AND modified = 0 AND attrName = 'MSSQL password'
--				INSERT INTO APP_IDAProp values (@id,'MSSQL password',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
--			END
--		END
		IF 1 = (@agentExtPropXML.exist('(//./sql61Prop/@isAutoDiscoverSQLInstances)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./sql61Prop/@isAutoDiscoverSQLInstances)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '0' END)
			IF EXISTS (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Auto discover SQL Instance')
			BEGIN
				IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
								AND modified = 0 AND attrName = 'Auto discover SQL Instance')
				BEGIN
					UPDATE APP_IDAProp
						SET modified  = dbo.GetUnixTime(GETDATE())
							WHERE componentNameId = @id AND modified = 0 AND attrName = 'Auto discover SQL Instance'
					INSERT INTO APP_IDAProp values (@id,'Auto discover SQL Instance',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
				END
			END
			ELSE
			    INSERT INTO APP_IDAProp values (@id,'Auto discover SQL Instance',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
		END
		IF 1 = (@agentExtPropXML.exist('(//./sql61Prop/@canManageContentAutomaticallyFlag)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./sql61Prop/@canManageContentAutomaticallyFlag)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '0' END)
			IF EXISTS (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Manage content automatically')
                  BEGIN
				IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
								AND modified = 0 AND attrName = 'Manage content automatically')
				BEGIN
					UPDATE APP_IDAProp
						SET modified  = dbo.GetUnixTime(GETDATE())
							WHERE componentNameId = @id AND modified = 0 AND attrName = 'Manage content automatically'
					INSERT INTO APP_IDAProp values (@id,'Manage content automatically',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
				END
			END
			ELSE
			    INSERT INTO APP_IDAProp values (@id,'Manage content automatically',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
		END
	END
IF	@appTypeId = 9 OR
@appTypeId = 15 OR
@appTypeId = 53 OR
@appTypeId = 69
	BEGIN
		SET @agentExtPropXML=@agentXML.query('(//./exchangeDBProp)[1]')
		IF 1 = (@agentExtPropXML.exist('(//./exchangeDBProp/@isBackupFromReplica)[1]'))
		BEGIN
			SET @attrVal = (CASE @agentExtPropXML.value('(//./exchangeDBProp/@isBackupFromReplica)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '0' END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Backup From Replica')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Backup From Replica'
				INSERT INTO APP_IDAProp values (@id,'Backup From Replica',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeDBProp/@isContinueFromReplicaAfterFallover)[1]'))
			BEGIN
			SET @attrVal =  (CASE @agentExtPropXML.value('(//./exchangeDBProp/@isContinueFromReplicaAfterFallover)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '0' END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Continue Backups From Replica After Failover')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Continue Backups From Replica After Failover'
				INSERT INTO APP_IDAProp values (@id,'Continue Backups From Replica After Failover',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeDBProp/@isOptimizeDataForSearchEnabled)[1]'))
			BEGIN
			SET @attrVal =  (CASE @agentExtPropXML.value('(//./exchangeDBProp/@isOptimizeDataForSearchEnabled)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '0' END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Copy Backup Enabled')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Copy Backup Enabled'
				INSERT INTO APP_IDAProp values (@id,'Copy Backup Enabled',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeDBProp/@IDAVersion)[1]'))
			BEGIN
			SET @attrVal =  @agentExtPropXML.value('(//./exchangeDBProp/@IDAVersion)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'IDA Version')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'IDA Version'
				INSERT INTO APP_IDAProp values (@id,'IDA Version',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeDBProp/@DagName)[1]'))
			BEGIN
			SET @attrVal =  @agentExtPropXML.value('(//./exchangeDBProp/@DagName)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'DAG Name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'DAG Name'
				INSERT INTO APP_IDAProp values (@id,'DAG Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeDBProp/@generateExchActivityLog)[1]'))
			BEGIN
			SET @attrVal =  (CASE @agentExtPropXML.value('(//./exchangeDBProp/@generateExchActivityLog)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '0' END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Generate Exchange Activity Log')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Generate Exchange Activity Log'
				INSERT INTO APP_IDAProp values (@id,'Generate Exchange Activity Log',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeDBProp/@exchMBLogLocation)[1]'))
			BEGIN
			SET @attrVal =  @agentExtPropXML.value('(//./exchangeDBProp/@exchMBLogLocation)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Exchange Mailbox Log Locatiion')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Exchange Mailbox Log Locatiion'
				INSERT INTO APP_IDAProp values (@id,'Exchange Mailbox Log Locatiion',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeDBProp/@manageContentAutomatically)[1]'))
			BEGIN
			SET @attrVal =  (CASE @agentExtPropXML.value('(//./exchangeDBProp/@manageContentAutomatically)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '0' END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Manage content automatically')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Manage content automatically'
				INSERT INTO APP_IDAProp values (@id,'Manage content automatically',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeDBProp/@exchJournalLogUsername)[1]'))
			BEGIN
			SET @attrVal =  @agentExtPropXML.value('(//./exchangeDBProp/@exchJournalLogUsername)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Exchange change journal log username')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Exchange change journal log username'
				INSERT INTO APP_IDAProp values (@id,'Exchange change journal log username',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeDBProp/@remoteIndexBackupRestorePath)[1]'))
			BEGIN
			SET @attrVal =  @agentExtPropXML.value('(//./exchangeDBProp/@remoteIndexBackupRestorePath)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'SharePoint Remote Index Backup Restore Path')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'SharePoint Remote Index Backup Restore Path'
				INSERT INTO APP_IDAProp values (@id,'SharePoint Remote Index Backup Restore Path',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeDBProp/@releaseTopologyLock)[1]'))
			BEGIN
			SET @attrVal =  (CASE @agentExtPropXML.value('(//./exchangeDBProp/@releaseTopologyLock)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '0' END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'Release Topology lock')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'Release Topology lock'
				INSERT INTO APP_IDAProp values (@id,'Release Topology lock',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeDBProp/@isRemoteSQLServer)[1]'))
			BEGIN
			SET @attrVal =  (CASE @agentExtPropXML.value('(//./exchangeDBProp/@isRemoteSQLServer)[1]','nvarchar(max)')
							WHEN '1' THEN '1'
							ELSE '0' END)
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'SharePoint Is Remote SQL server')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'SharePoint Is Remote SQL server'
				INSERT INTO APP_IDAProp values (@id,'SharePoint Is Remote SQL server',2,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeDBProp/@RemoteSQLServerUsername)[1]'))
			BEGIN
			SET @attrVal =  @agentExtPropXML.value('(//./exchangeDBProp/@RemoteSQLServerUsername)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @id
							AND modified = 0 AND attrName = 'SharePoint Remote SQL user name')
			BEGIN
				UPDATE APP_IDAProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @id AND modified = 0 AND attrName = 'SharePoint Remote SQL user name'
				INSERT INTO APP_IDAProp values (@id,'SharePoint Remote SQL user name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeDBProp/@Username)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./exchangeDBProp/@Username)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'User Name')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'User Name'
				INSERT INTO APP_InstanceProp values (@CompId,'User Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeDBProp/@ExchDBThrottling)[1]'))
		BEGIN
			SET @attrInt = @agentExtPropXML.value('(//./exchangeDBProp/@ExchDBThrottling)[1]','INT')
			IF @attrInt <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Exchange DB Throttling Parameter')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Exchange DB Throttling Parameter'
				INSERT INTO APP_InstanceProp values (@CompId,'Exchange DB Throttling Parameter',10,@attrInt,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
		IF 1 = (@agentExtPropXML.exist('(//./exchangeDBProp/@ServerName)[1]'))
		BEGIN
			SET @attrVal = @agentExtPropXML.value('(//./exchangeDBProp/@ServerName)[1]','nvarchar(max)')
			IF @attrVal <> (SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @CompId
							AND modified = 0 AND attrName = 'Server Name')
			BEGIN
				UPDATE APP_InstanceProp
					SET modified  = dbo.GetUnixTime(GETDATE())
						WHERE componentNameId = @CompId AND modified = 0 AND attrName = 'Server Name'
				INSERT INTO APP_InstanceProp values (@CompId,'Server Name',1,@attrVal,dbo.GetUnixTime(GETDATE()),0,0)
			END
		END
	END
	SET @i = @i + 1
END

IF EXISTS (select * from GxQscripts where name = 'APPSetAgentProperties')
	delete from GxQscripts where name = 'APPSetAgentProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPSetAgentProperties')
	delete from GXDBVersions where aliasname = 'APPSetAgentProperties'
GO

insert into GXDBVersions values(2, 'APPSetAgentProperties',  '00010015020800050000', 'APPSetAgentProperties', '00010015020800050000')
GO

