

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPSetActivityControlSubClientProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPSetActivityControlSubClientProp')
BEGIN
	print '>>> Drop Stored Procedure: APPSetActivityControlSubClientProp <<<'
	drop procedure APPSetActivityControlSubClientProp
END
IF EXISTS (select * from GxQscripts where name='APPSetActivityControlSubClientProp')
	delete from GxQscripts where name = 'APPSetActivityControlSubClientProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPSetActivityControlSubClientProp')
	delete from GXDBVersions where aliasname = 'APPSetActivityControlSubClientProp'
GO
print '... Creating Procedure: APPSetActivityControlSubClientProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPSetActivityControlSubClientProp
  @operationType INT,
  @actionVal INT,
  @applicationID INT,
  @reenableTimeZone INT,
  @reEnableTime INT,
  @localeId INT
AS
DECLARE @tzStdName NVARCHAR(512) = ''
DECLARE @tzReEnableTime INT = 0
DECLARE @errorCode		 AS integer					   = 0
DECLARE @errorString	 AS varchar(2048)			   = ''
DECLARE @utcTimeNow int = dbo.getunixtime(getutcdate())
DECLARE @xmlForOscWQ XML = NULL
DECLARE @workQueueOutput XML
--Since now we're using utc time for GET/SET but the SET logic considers as local time and tzreEnableTime as utc , we can assign tzreEnableTime = reEnableTime and reEnableTime = 0
SET @tzReEnableTime = @reEnableTime
SET	@reEnableTime = 0
--------------------------------------------------------------------------------------------------------------
--		Following code is needed to adjust reEnableTime passed from the GUI from a local UNC time to a
--		Universal (Greenwich) UNC Time that is used internally.
--------------------------------------------------------------------------------------------------------------
		IF @reenableTimeZone <> 0 AND @reEnableTime <> 0
		BEGIN
			SET	@tzStdName = ISNULL((Select TimeZoneStdName from SchedTimeZone where TimeZoneID = @reenableTimeZone), '')
			SET @tzReEnableTime = dbo.getunixtime(dbo.LocalToUTCTime(dbo.getdatetime(@reEnableTime), @tzStdName))
		END
		IF @reenableTimeZone <> 0 AND @tzReEnableTime <> 0
		BEGIN
			SET	@tzStdName = ISNULL((Select TimeZoneStdName from SchedTimeZone where TimeZoneID = @reenableTimeZone), '')
			SET @reEnableTime = dbo.getunixtime(dbo.UTCToLocalTime(dbo.getdatetime(@tzReEnableTime), @tzStdName))
		END
            --Vaidate if the time selected is greater than current time
		IF(@tzReEnableTime <> 0 AND @tzReEnableTime < @utcTimeNow)
		BEGIN
SET @errorCode =  (3445 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3445 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
			goto EXIT_ON_ERROR
		END
--------------------------------------------------------------------------------------------------------------
	IF EXISTS (Select 1 FROM JMJobAction WITH (NOLOCK) WHERE clientId = 1 AND mediaAgentID = 1 AND opType = @operationType AND appId = @applicationID)
					BEGIN
				--IF @actionVal = 1
				--	BEGIN
						UPDATE JMJobAction WITH (ROWLOCK)
						SET action = @actionVal,
						enableTimeZone = @reenableTimeZone,
						enableTime = @reEnableTime,
						UNCenableTime = @tzReEnableTime
						WHERE clientId = 1 AND mediaAgentID = 1 AND optype = @operationType AND appId = @applicationID
				--	END
				--ELSE IF @actionVal = 0
				--	BEGIN
				--		DELETE JMJobAction WITH (ROWLOCK)
				--		WHERE clientId = 1 AND mediaAgentID = 1 AND optype = @operationType AND appId = @applicationID
				--	END
		END
	ELSE
		BEGIN
			--IF @actionVal = 1
			--	BEGIN
					INSERT JMJobAction (clientId, mediaAgentID, appType, opType, action, appId, clientGroupId, enableTimeZone, enableTime, UNCenableTime, instanceID)
					VALUES (1, 1, 0, @operationType, @actionVal, @applicationID, 0, @reenableTimeZone, @reEnableTime, @tzReEnableTime, 1)
					UPDATE JMJobAction WITH (ROWLOCK)
					SET action = @actionVal
					WHERE clientId = 1 AND mediaAgentID = 1 AND appType=0 AND optype = @operationType AND appId = @applicationID
			--	END
		END
		-- For 1 Min RPO feature we need to send work tokens to all those clients which get affected by enabling or disabling backup/All activity as client is unaware of the same
		IF @operationType = 4 /*BACKUP*/
		BEGIN
			DECLARE @oscClientId int = ISNULL((SELECT TOP 1 APP.clientId
												FROM APP_Application APP WITH(NOLOCK)
												WHERE APP.id = @applicationID),0)
			IF @oscClientId > 0
			BEGIN
				SET @xmlForOscWQ = ( SELECT 61/*WORK_TOKEN_BACKUP_ACTIVITY_CHANGED*/ '@workToken',  -- OSC Work token
							(
								(
									SELECT @oscClientId '@clientId'
									FOR XML PATH('entityList'),TYPE
								)
							)
							FOR XML PATH('App_SubmitWorkQueueReq')
						)
				EXEC AppWorkQueueSubmitRequestXMLOUTPUT @xmlForOscWQ, @workQueueOutput output
				SELECT @errorCode = ISNULL(attr.value('@errorCode', 'INT'),0),
						@errorString = ISNULL(attr.value('@errorMessage', 'NVARCHAR(1024)'),'')
				FROM @workQueueOutput.nodes('App_GenericResp') tci(attr)
				IF @errorCode <> 0
					GOTO EXIT_ON_ERROR
			END
		END
		EXIT_ON_ERROR:
SELECT  1                    as TAG,
        NULL                 as Parent,
    @errorCode               as [CVGui_GenericResp!1!errorCode],
    @errorString             as [CVGui_GenericResp!1!errorMessage]
    FOR XML EXPLICIT
GO

IF EXISTS (select * from GxQscripts where name = 'APPSetActivityControlSubClientProp')
	delete from GxQscripts where name = 'APPSetActivityControlSubClientProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPSetActivityControlSubClientProp')
	delete from GXDBVersions where aliasname = 'APPSetActivityControlSubClientProp'
GO

insert into GXDBVersions values(2, 'APPSetActivityControlSubClientProp',  '00000000000000000000', 'APPSetActivityControlSubClientProp', '00000000000000000000')
GO

