

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPSetActivityControl.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPSetActivityControl.sp,v $ $Id: APPSetActivityControl.sp,v 1.17.2.19 2020/12/15 06:57:05 alakra Exp $";
--	+===================================================================+
--	| APPSetActivityControl - PRIMARY ENTRY POINT FOR ALL CCP OPS			|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='APPSetActivityControl')
BEGIN
	print '>>> Drop Stored Procedure: APPSetActivityControl <<<'
	drop procedure APPSetActivityControl
END
IF EXISTS (select * from GxQscripts where name='APPSetActivityControl')
	delete from GxQscripts where name = 'APPSetActivityControl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPSetActivityControl')
	delete from GXDBVersions where aliasname = 'APPSetActivityControl'
GO
print '... Creating Procedure: APPSetActivityControl'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure APPSetActivityControl
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
-----------------------------------------------------------
  @ownerID int,
  @xmlString varchar(MAX)
-----------------------------------------------------------
AS
SET NOCOUNT ON
DECLARE	@function        AS varchar(80)                = 'APPSetActivityControl'
DECLARE @errorCode		 AS integer					   = 0
DECLARE @errorString	 AS varchar(2048)			   = ''
DECLARE @brAlertTrace	 AS varchar(256)               = (select value from gxglobalParam Where name = 'bralertTrace')
DECLARE @dateTime		AS DATETIME = getDate()
if @brAlertTrace <> 0
	exec br_ntTrace '.. APPSetActivityControl', 0, @dateTime, 0, 0, @xmlString
BEGIN TRY
----------------------------------------------------------
---	HERE IS WHERE WE WILL EXTRACT THE XML TO:		   ---
----------------------------------------------------------
DECLARE	@commcellId			integer
DECLARE @clientId			integer
DECLARE @appTypeId			integer
DECLARE @clientGroupId		integer
DECLARE @mediaAgentId		AS INTEGER = 1			-- Not currently providing "wake up" enable for MAs
DECLARE @appId			AS INTEGER
DECLARE @drSubclientId		integer
DECLARE @instanceID			INTEGER
DECLARE @drInstanceID			INTEGER
DECLARE @defaultCSID		as integer = 2
DECLARE @xmlForOscWQ XML = NULL
DECLARE @workQueueOutput XML
-- Following for AcObjects:
DECLARE @activityType		integer
DECLARE @enabled			integer
DECLARE @reenableTimeZone	integer
DECLARE @reEnableTime		integer
DECLARE @noSchedEnable		integer
DECLARE @opType				integer		-- Determined by input activity Type
DECLARE @reason				nvarchar(1024)	= ''
DECLARE @companyId			integer
----------------------------------------------------------
---  Following used to determine Timezone adjustments	--
----------------------------------------------------------
DECLARE @tzStdName 		varchar(255)
DECLARE @tzReEnableTime	integer
----------------------------------------------------------
-- FOR SECURITY:
DECLARE @iType	   		as	integer = 0
DECLARE @iId			as 	integer = 0
DECLARE @localeID  		as	integer = 0			-- REALLY NEEDS TO BE PASSED FROM CALLER!
DEClARE @iCapability	as	integer = 2			-- Agent Management (same for all?)
DECLARE @oldReq			as integer = 0
-----------------------------------------------
--- EXTRACT FROM THE XML					---
-----------------------------------------------
	DECLARE @Inputxml XML = CAST(@xmlString as XML)
	-- Evaluate the Default DR Subclient Id
	set @drSubclientId      =  ISNULL((select top 1 id from APP_Application
where appTypeId= 1000),1)
	set @drInstanceID      =  ISNULL((select top 1 instance from APP_Application
where appTypeId= 1000),1)
	IF (@Inputxml.exist('App_EntityActivityControl') = 1)
	BEGIN
		SET @commCellId		=  ISNULL( @Inputxml.value('(//App_EntityActivityControl/entity/@commCellId)[1]', 'INT'), 0)
		SET @clientId		=  ISNULL( @Inputxml.value('(//App_EntityActivityControl/entity/@clientId)[1]', 'INT'), 1)  -- 1 is 'all clients' in jmJobActionTable
		SET @appTypeId		=  ISNULL( @Inputxml.value('(//App_EntityActivityControl/entity/@applicationId)[1]', 'INT'), 0)
		SET @clientGroupId		=  ISNULL( @Inputxml.value('(//App_EntityActivityControl/entity/@clientGroupId)[1]', 'INT'), 0)
		SET @appId		=  ISNULL( @Inputxml.value('(//App_EntityActivityControl/entity/@appId)[1]', 'INT'), @drSubclientId) -- 1 is default app id in JmJobActionTable
		SET @instanceID		=  ISNULL( @Inputxml.value('(//App_EntityActivityControl/entity/@instanceId)[1]', 'INT'), @drInstanceID) -- 1 is default instanceID in JmJobActionTable
		SET @localeId		=  ISNULL( @Inputxml.value('(//App_EntityActivityControl/processinginstructioninfo/locale/@localeId)[1]', 'INT'), 0)
	END
	ELSE
	BEGIN
		SET @commCellId		=  ISNULL( @Inputxml.value('(//App_ActivityControlAdvancedReq/entity/@commCellId)[1]', 'INT'), 0)
		SET @clientId		=  ISNULL( @Inputxml.value('(//App_ActivityControlAdvancedReq/entity/@clientId)[1]', 'INT'), 1)  -- 1 is 'all clients' in jmJobActionTable
		SET @appTypeId		=  ISNULL( @Inputxml.value('(//App_ActivityControlAdvancedReq/entity/@applicationId)[1]', 'INT'), 0)
		SET @clientGroupId		=  ISNULL( @Inputxml.value('(//App_ActivityControlAdvancedReq/entity/@clientGroupId)[1]', 'INT'), 0)
		SET @appId		=  ISNULL( @Inputxml.value('(//App_ActivityControlAdvancedReq/entity/@appId)[1]', 'INT'), @drSubclientId) -- 1 is default app id in JmJobActionTable
		SET @instanceID		=  ISNULL( @Inputxml.value('(//App_ActivityControlAdvancedReq/entity/@instanceId)[1]', 'INT'), @drInstanceID) -- 1 is default instanceID in JmJobActionTable
		SET @localeId		=  ISNULL( @Inputxml.value('(//App_ActivityControlAdvancedReq/processinginstructioninfo/locale/@localeId)[1]', 'INT'), 0)
		SET @oldReq = 1
	END
	IF @commcellId = 0						-- Per Anil P., 9.0 GUI may still send 0 for commcellId, so we need to "fix it" here
		SET @commcellId = @defaultCSID
--First Check if there are any changes made in Activity Control before security check
	IF OBJECT_ID('tempdb.dbo.#tempActivityControl') IS NOT NULL
		DROP TABLE #tempActivityControl
	create table #tempActivityControl (		 activityType		integer ,-- './@activityType',
			 [enabled]			integer ,-- './@enabled',
			 reenableTimeZone	integer ,-- './@reenableTimeZone',
			 reEnableTime		integer ,-- './@reEnableTime',
			 noSchedEnable		integer ,-- './@noSchedEnable'
			 utcTime			integer ,
			 reason				nvarchar(1024) default ''
	);
	IF OBJECT_ID('tempdb.dbo.#DumpingClients') IS NOT NULL
		DROP TABLE #DumpingClients
	CREATE TABLE #DumpingClients (
		clientId INT
	);
	IF @oldReq = 1
	BEGIN
		INSERT INTO #tempActivityControl (activityType,[enabled],reenableTimeZone,reEnableTime,noSchedEnable,utcTime)
		SELECT  r.ref.value('@activityType','INT'),
				r.ref.value('@enabled','INT'),
				r.ref.value('@reenableTimeZone','INT') ,
				r.ref.value('@reEnableTime','INT'),
				r.ref.value('@noSchedEnable','INT') ,
				ISNULL(r.ref.value('@utcTime','INT'),0)
		FROM @Inputxml.nodes('App_ActivityControlAdvancedReq/acObjects') R ( ref )
	END
	ELSE
	BEGIN
		INSERT INTO #tempActivityControl
		SELECT  r.ref.value('@activityType','INT'),
			CASE(r.ref.value('@enableActivityType','INT')) when 0 then 1 when 1 then 0 end,
			ISNULL(u.ref2.value('@TimeZoneID','INT'),0) ,
			0,
			(case ISNULL(r.ref.value('@enableAfterADelay','INT'),0)
					when 0 then 1
					when 1 then 0
					end) ,
			ISNULL(u.ref2.value('@time','INT'),0),
			ISNULL(r.ref.value('@reason','NVARCHAR(1024)'),'')
		FROM @Inputxml.nodes('App_EntityActivityControl/activityControlOptions') R ( ref )
        OUTER APPLY ref.nodes('dateTime') U(ref2)
	END
	--select * from #tempActivityControl
	--Get old details from JMJobAction for comparison
	IF OBJECT_ID('tempdb.dbo.#tempActivityControlOld') IS NOT NULL
		DROP TABLE #tempActivityControlOld
	create table #tempActivityControlOld (		 activityType		integer ,-- './@activityType',
			 [enabled]			integer ,-- './@enabled',
			 reenableTimeZone	integer ,-- './@reenableTimeZone',
			 reEnableTime		integer ,-- './@reEnableTime',
			 noSchedEnable		integer ,-- './@noSchedEnable'
			 utcTime			integer ,
			 reason				nvarchar(1024)
	);
	INSERT INTO #tempActivityControlOld
		SELECT
        (CASE JM.opType
          WHEN     4 then    1  -- Backup
          WHEN     5 then    2  -- Restore
          WHEN    13 then    4  -- Aux Copy
          WHEN    11 then    8  -- DR Backup
          WHEN    10 then   16  -- Archive Prune
          WHEN     9 then   32  -- Media Recycle
          WHEN    14 then   64  -- Synthetic Full
          WHEN     1 then  128  -- All Activity
          WHEN    28 then  256  -- Schedule
          WHEN    57 then  512  -- ContentIndexin (online?)
          WHEN    53 then 1024  -- ContentIndexing Offline
          WHEN   100 then 2048  -- DDB Activity
          WHEN   31  then 8192  -- Data Verification
          ELSE JM.opType * -1
          END),
         (CASE JM.action
          when 2 then 0
          else 1
         END),
		 (CASE WHEN JM.enableTime <> 0
			THEN JM.enableTimeZone
			END),
		 (CASE WHEN JM.enableTime <> 0
			THEN JM.enableTime
			END),
        (case JM.enableTime
            when 0 then 1
            else 0
            End),
		0,
		JM.reason
    FROM JMJobAction as JM WITH (NOLOCK)
    WHERE JM.clientId = @clientId
          AND JM.mediaAgentID   = @mediaAgentId
          AND JM.appType        = @appTypeId
          AND JM.clientGroupId = @clientGroupId
          AND JM.appId = @appId
          AND JM.instanceID = @instanceID
	IF NOT EXISTS (SELECT 1 FROM #tempActivityControlOld WHERE activityType = 1)
	BEGIN
		INSERT INTO #tempActivityControlOld
			SELECT 1, 0, NULL, NULL, 1, 0, ''
	END
	IF NOT EXISTS (SELECT 1 FROM #tempActivityControlOld WHERE activityType = 2)
	BEGIN
		INSERT INTO #tempActivityControlOld
			SELECT 2, 0, NULL, NULL, 1, 0, ''
	END
	IF (@clientId > 1 OR @clientGroupId > 0 ) and @appTypeId = 0 and @mediaAgentId = 1 and NOT EXISTS (SELECT 1 FROM #tempActivityControlOld WHERE activityType = 16)
	BEGIN
		INSERT INTO #tempActivityControlOld
			SELECT 16, 0, NULL, NULL, 1, 0, ''
	END
	--select * from #tempActivityControlOld
	IF NOT EXISTS (SELECT * FROM #tempActivityControl EXCEPT SELECT * FROM #tempActivityControlOld)
	BEGIN
		GOTO ALL_DONE	--If there are no changes in Activity Control then do not perform security check and return success.
	END
--  --------------------------  NOW DO SECURITY CHECK:  -----------------------------
	if @appTypeId <> 0
	BEGIN
		SET @iType = 2230	--APP_TYPE_ITEM
		SET @iId   = ISNULL((Select TOP 1 id from app_idaName where clientId = @clientId and appTypeId = @appTypeId),0)
	END
	ELSE IF @clientGroupId <> 0
	BEGIN
		SET @iType = 2572	-- SERVER_GROUP_NAME_ITEM
		SET @iId   = @clientGroupId
		-- Actual check is below in loop
	END
	ELSE IF @ClientId <> 0 and @clientID<>1
	BEGIN
		SET @iType = 2009	-- CLIENT_ITEM
		SET @iId   = @clientID
	END
	ELSE IF @instanceID <> 0 and @instanceID <> @drInstanceID
	BEGIN
		SET @iType = 2011	-- INSTANCE_ITEM
		SET @iId   = @instanceID
	END
	ELSE
	BEGIN
		SET @iType = 2018	-- COMM_CELL_ITEM
		SET @iId   = @commcellId
	END
	exec br_NTPermCheck  @ownerID, @localeId, @iCapability, @iType, @iId, @errorCode OUTPUT, @errorString OUTPUT
	IF @errorCode <> 0
		GOTO ALL_DONE
--	--------------------------  Security Check Complete   ----------------------------
    DECLARE @utcTimeNow int = dbo.getunixtime(getutcdate())
	--	LOOP FOR ALL INPUT:
	DECLARE WORKLIST CURSOR LOCAL STATIC READ_ONLY FOR
	SELECT activityType, [enabled], reenableTimeZone, reEnableTime,noSchedEnable,utcTime,reason from 	#tempActivityControl
	OPEN WORKLIST
	FETCH NEXT FROM WORKLIST INTO @activityType, @enabled, @reenableTimeZone, @reEnableTime, @noSchedEnable,@tzReEnableTime,@reason
	WHILE @@FETCH_STATUS = 0
	BEGIN
--------------------------------------------------------------------------------------------------------------
--		Following code is needed to adjust reEnableTime passed from the GUI from a local UNC time to a
--		Universal (Greenwich) UNC Time that is used internally.
--------------------------------------------------------------------------------------------------------------
		IF @reenableTimeZone <> 0 AND @reEnableTime <> 0
		BEGIN
			SET	@tzStdName = ISNULL((Select TimeZoneStdName from SchedTimeZone where TimeZoneID = @reenableTimeZone), '')
			SET @tzReEnableTime = dbo.getunixtime(dbo.LocalToUTCTime(dbo.getdatetime(@reEnableTime), @tzStdName))
		END
		IF @reenableTimeZone <> 0 AND @tzReEnableTime <> 0
			BEGIN
				SET	@tzStdName = ISNULL((Select TimeZoneStdName from SchedTimeZone where TimeZoneID = @reenableTimeZone), '')
				SET @reEnableTime = dbo.getunixtime(dbo.UTCToLocalTime(dbo.getdatetime(@tzReEnableTime), @tzStdName))
			END
            --Vaidate if the time selected is greater than current time
			--@enable = 0: Enable Activity
			--@enable = 1: Disable Activity
			--Error out if user is trying to diable the activity with enable after a delay AND the delay time is less than now time.
		IF(@tzReEnableTime <> 0 AND @tzReEnableTime < @utcTimeNow AND @enabled = 1)
		BEGIN
SET @errorCode =  (3445 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3445 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
			goto EXIT_ON_ERROR
		END
--------------------------------------------------------------------------------------------------------------
		IF (@noSchedEnable = 1 OR @enabled = 0)	-- TURN OFF SCHEDULE WAKEUP, also resetting the enable times when enabling the activity.
		BEGIN
			SET @reEnableTime = 0
			SET @reEnableTimeZone = 0
			SET @tzReEnableTime = 0				-- Defect 54082
		END
		IF @enabled = 0							-- TRANSLATE BOOLEAN INTO VALUES ACTUALLY STORED  TABLE
			SET @enabled = 2					-- .. Per Anil, "enabled" is for control, which is opposite of feature enable!
		else
			SET @enabled = 1
		SET @opType =
			CASE @activityType
			  -- Following Added for but not exclusive to Client Level:
			  WHEN    1	 then  4	-- Backup
			  WHEN    2	 then  5	-- Restore
			  WHEN    4	 then 13	-- Aux Copy
			  WHEN    8  then 11	-- DR Backup
			  WHEN   16  then 10	-- Archive Prune
			  WHEN   32  then  9	-- Media Recycle
			  WHEN   64  then 14	-- Synthetic Full
			  WHEN  128	 then  1	-- All Activity
			  WHEN  256	 then  28	-- Schedule
			  WHEN  512	 then 57	-- ContentIndexin (online?)
			  WHEN 1024	 then 53	-- ContentIndexing Offline
			  WHEN 2048	 then 100	-- DDB Activity
			  WHEN 8192  then 31    -- Data verification
			  ELSE @activityType * -1
			END
--		-------------------------------------------------------------------
--		---	 SEE IF ROW ALREADY EXISTS IN JNJOBACTION TABLE				---
--		-------------------------------------------------------------------
		IF EXISTS (Select * FROM JMJobAction WHERE clientId = @clientId AND mediaAgentID = @mediaAgentId AND
								appType=@appTypeId AND opType = @opType AND clientGroupId = @clientGroupId AND appId = @appId AND instanceID =  @instanceID)
		BEGIN
			IF @enabled = 2 AND
				( @clientGroupId <> 0			-- FOR CLIENT GROUP, ONLY "DISABLED" ENTRIES ARE MAINTAINED  TABLE!
				Or @appId != @drSubclientId		-- Even for Subclient Id (Not default DR Subclient) ONLY "DISABLED" ENTRIES ARE MAINTAINED  TABLE!
				OR @instanceID != @drInstanceID)
			BEGIN
				-- Prevent users belonging to a deactivated company (including MSP admin) from enabling either backup(@opType = 4) or restore(@opType = 5) activity
				-- as per the options set during deactivation
SET @companyId = ISNULL((SELECT componentNameId from App_CompanyProp WITH (NOLOCK) WHERE attrName = 'Associated Smart Client Group'
AND attrValInt = @clientGroupId AND modified = 0 AND cs_attrName = CHECKSUM('Associated Smart Client Group')),0)
				IF EXISTS(SELECT 1 from UMDSProviders WITH (NOLOCK) WHERE id = @companyId AND
((flags & 0x0010) = 0x0010) ) AND
((@opType = 4 AND EXISTS(SELECT 1 FROM App_Companyprop WITH(NOLOCK) WHERE attrName = 'Disable Backup' AND componentNameId = @companyId AND attrVal = '1'))
OR (@opType =5 AND EXISTS(SELECT 1 FROM App_Companyprop WITH(NOLOCK) WHERE attrName = 'Disable Restore' AND componentNameId = @companyId AND attrVal = '1')))
				BEGIN
SET @errorCode = (4709 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (4709 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
					GOTO EXIT_ON_ERROR
				END
				DeLeTe JMJobAction
					WHERE clientId = @clientId AND mediaAgentID = @mediaAgentId AND
								appType=@appTypeId AND opType = @opType AND clientGroupId = @clientGroupId
								AND appId = @appId AND instanceID =  @instanceID
				GOTO NEXT_ITEM
			END
	--		----------------------------------------------------------------------
	--		-- NOT CLIENTGROUP, SO RULES ARE THE SAME FOR REMAINING ENTITIES:	--
	--		----------------------------------------------------------------------
			UPDATE JMJobAction
				SET action = @enabled,
				    enableTimeZone = @reEnableTimeZone,
					enableTime     = @reEnableTime,
					UNCenableTime  = @tzReEnableTime,
					reason		   = @reason
				WHERE clientId = @clientId AND mediaAgentID = @mediaAgentId AND
						appType=@appTypeId AND optype = @opType AND clientGroupId = @clientGroupId
						AND appId = @appId AND instanceID =  @instanceID
				GOTO NEXT_ITEM
		END
--		-------------------------------------------------------------------
--		---		NO ENTRY FOR CURRENT WORKLIST ITEM EXISTS, SO ADD IT 	---
--		-------------------------------------------------------------------
		IF @enabled = 2 And
			(@clientGroupId <> 0 Or @appId	!= @drSubclientId OR @instanceID != @drInstanceID)	-- ENABLED OPTION ISN'T STORED IN JMJOBACTION TABLE, ONLY DISABLED!
			GOTO NEXT_ITEM
		INSERT JMJobAction (clientId, mediaAgentID, appType, opType, action, appId, clientGroupId, enableTimeZone, enableTime, UNCenableTime,instanceID,reason)
			VALUES (@clientId, @mediaAgentId, @appTypeId, @opType, @enabled, @appId, @clientGroupId, @reEnableTimeZone, @reEnableTime, @tzReEnableTime, @instanceID,@reason)
NEXT_ITEM:
		FETCH NEXT FROM WORKLIST INTO @activityType, @enabled, @reenableTimeZone, @reEnableTime, @noSchedEnable,@tzReEnableTime,@reason
	END
	CLOSE       WORKLIST
	DEALLOCATE  WORKLIST
	-- For 1 Min RPO feature we need to send work tokens to all those clients which get affected by enabling or disabling backup/All activity as client is unaware of the same
	IF EXISTS(
		SELECT activityType, [enabled], reenableTimeZone, reEnableTime,noSchedEnable,utcTime,reason FROM #tempActivityControl WHERE activityType IN (1, 128) -- BACKUP AND ALL ACTIVITY
		EXCEPT
		SELECT activityType, [enabled], reenableTimeZone, reEnableTime,noSchedEnable,utcTime,reason FROM #tempActivityControlOld WHERE activityType IN (1, 128) -- BACKUP AND ALL ACTIVITY
	)
	BEGIN
		IF @commcellId = 0
		BEGIN
			DECLARE @whereClause1 NVARCHAR(MAX) = ''
			DECLARE @wcAND NVARCHAR(10) = ' AND '
			IF @clientGroupId = 0
				SET @whereClause1 = ''
			ELSE
				SET @whereClause1 = ' ACGA.clientGroupId = '+CAST(@clientGroupId AS NVARCHAR(12))
			IF @clientId <> 1
			BEGIN
				IF @whereClause1 <> ''
					SET @whereClause1 += @wcAND
				SET @whereClause1 += 'APP.clientId = '+CAST(@clientId AS NVARCHAR(12))
			END
			IF @instanceID <> @drInstanceID
			BEGIN
				IF @whereClause1 <> ''
					SET @whereClause1 += @wcAND
				SET @whereClause1 += 'APP.instance = '+CAST(@instanceID AS NVARCHAR(12))
			END
			IF @whereClause1 = ''
				SET @whereClause1 = ' 1 = 1 '
			DECLARE @sqlCmd NVARCHAR(MAX) = ''
			SET @sqlCmd='
				INSERT INTO #DumpingClients
				SELECT DISTINCT APP.clientId FROM APP_Application APP WITH(NOLOCK)
				LEFT JOIN APP_ClientGroupAssoc ACGA ON ACGA.clientId = APP.clientId
				WHERE '+@whereClause1
			EXEC(@sqlCmd)
		END
		ELSE
		BEGIN
			INSERT INTO #DumpingClients
			SELECT DISTINCT APP.clientId FROM APP_Application APP WITH(NOLOCK)
			INNER JOIN APP_SubclientToMountpathMapping SMM WITH(NOLOCK) ON APP.id = SMM.subClientId
		END
		SET @xmlForOscWQ = ( SELECT 61/*WORK_TOKEN_BACKUP_ACTIVITY_CHANGED*/ '@workToken',  -- OSC Work token
							(
								(
									SELECT clientId '@clientId'
									FROM #DumpingClients
									FOR XML PATH('entityList'),TYPE
								)
							)
							FOR XML PATH('App_SubmitWorkQueueReq')
						)
		EXEC AppWorkQueueSubmitRequestXMLOUTPUT @xmlForOscWQ, @workQueueOutput output
		SELECT @errorCode = ISNULL(attr.value('@errorCode', 'INT'),0),
				@errorString = ISNULL(attr.value('@errorMessage', 'NVARCHAR(1024)'),'')
		FROM
			@workQueueOutput.nodes('App_GenericResp') tci(attr)
		IF @errorCode <> 0
			GOTO EXIT_ON_ERROR
	END
END TRY
--=====================================================================
--==============  COME HERE IF THERE WAS A PROBLEM!     ===============
--=====================================================================
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode	 = ERROR_NUMBER()
	SET @errorString = 'Problems Executing [' + @function +'] Error Message [' + ERROR_MESSAGE() + '].'
	IF @errorCode = 1205  --DEADLOCK error
    BEGIN
	        ;THROW;   -- rethrow the DEADLOCK so XE captures.
    END
END CATCH
EXIT_ON_ERROR:
 IF ( CURSOR_STATUS('global', 'WORKLIST') >= 0   OR CURSOR_STATUS('local', 'WORKLIST') >= 0 )  -- CLOSE CURSOR IF OPEN
        CLOSE WORKLIST
IF ( CURSOR_STATUS('global','WORKLIST') = -1     OR CURSOR_STATUS('local','WORKLIST') = -1 )
    DEALLOCATE WORKLIST
--------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
ALL_DONE:
IF OBJECT_ID('tempdb.dbo.#tempActivityControl') IS NOT NULL
	DROP TABLE #tempActivityControl
IF OBJECT_ID('tempdb.dbo.#tempActivityControlOld') IS NOT NULL
	DROP TABLE #tempActivityControlOld
IF OBJECT_ID('tempdb.dbo.#DumpingClients') IS NOT NULL
	DROP TABLE #DumpingClients
SELECT  1                    as TAG,
        NULL                 as Parent,
    @errorCode               as [CVGui_GenericResp!1!errorCode],
    @errorString             as [CVGui_GenericResp!1!errorMessage]
FOR XML EXPLICIT
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPSetActivityControl')
	delete from GxQscripts where name = 'APPSetActivityControl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPSetActivityControl')
	delete from GXDBVersions where aliasname = 'APPSetActivityControl'
GO

insert into GXDBVersions values(2, 'APPSetActivityControl',  '00010017000200190000', 'APPSetActivityControl', '00010017000200190000')
GO

