

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPSPGetRecoveryPointParams.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998-2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPSPGetRecoveryPointParams')
BEGIN
	print '>>> Drop Stored Procedure: APPSPGetRecoveryPointParams <<<'
	drop procedure APPSPGetRecoveryPointParams
END
IF EXISTS (select * from GxQscripts where name='APPSPGetRecoveryPointParams')
	delete from GxQscripts where name = 'APPSPGetRecoveryPointParams'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPSPGetRecoveryPointParams')
	delete from GXDBVersions where aliasname = 'APPSPGetRecoveryPointParams'
GO
print '... Creating Procedure: APPSPGetRecoveryPointParams'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPSPGetRecoveryPointParams
  @inputxml XML
AS
-- 8/24/18, OVK: InstanceName and dbName known
/* Input parameters */
declare @dbName varchar(100) = '';
declare @instanceName varchar(100) = ''
DECLARE @farmSubClientId int = 0;
DECLARE @reqFromTime int = 0;
DECLARE @reqToTime int = 0;
SET @dbName = dbo.DecodeInvalidXMLChar(ISNULL((SELECT ref.value('@dbName', 'varchar(1024)') FROM @inputXML.nodes('App_SPGetRecoveryPointParamsRequest') R(ref)), ''));
SET @instanceName = dbo.DecodeInvalidXMLChar(ISNULL((SELECT ref.value('@instanceName', 'varchar(1024)') FROM @inputXML.nodes('App_SPGetRecoveryPointParamsRequest') R(ref)), ''));
SET @farmSubClientId = ISNULL((SELECT ref.value('@farmSubClientId', 'INTEGER')FROM @inputXML.nodes('App_SPGetRecoveryPointParamsRequest') R(ref)), 0);
SET @reqFromTime = ISNULL((SELECT ref.value('@fromTime', 'INTEGER')FROM @inputXML.nodes('App_SPGetRecoveryPointParamsRequest') R(ref)), 0);
SET @reqToTime = ISNULL((SELECT ref.value('@toTime', 'INTEGER')FROM @inputXML.nodes('App_SPGetRecoveryPointParamsRequest') R(ref)), 0);
IF @reqToTime=0
BEGIN
	SET @reqToTime = dbo.GetUnixTime(DATEADD(day,1,GetDate()));
END
declare @PROPERTY_MSSQL_DB as int = 118;
declare @SQL_AppTypeId as int = 81;
declare @sqlClientID int = 0;
DECLARE @sqlSubClientID int = 0;
declare @instanceId int = 0;
DECLARE @Error_MultipleMatchingInstances int = 1;
DECLARE @Error_MultipleMatchingSQLSubClients int = 2;
DECLARE @ErrorCode int = 0;
DECLARE @MSSQLAGPseudoClientStatus int = 536870912; -- 0x20000000
select @sqlClientID=C.id, @instanceId=I.id -- Multiple matches - fail and return sqlClientId=0 and errorCode in @respToTime
from APP_InstanceName I (nolock)
	JOIN APP_Application SC (nolock) ON I.id=SC.instance
	JOIN APP_Client C (nolock) ON C.id=SC.clientId
where (I.name=@instanceName OR I.name LIKE @instanceName + '/%') -- For XYZ/AG1 matching
	AND SC.appTypeId=@SQL_AppTypeId
	AND C.status IN (0,@MSSQLAGPseudoClientStatus) -- 0 is Active client. C.modified is irrelevant, should not be checked
	AND I.status=0 -- 0=Means active/licensed, 2=means unlicensed
	AND SC.subclientStatus IN (0,8) -- 0=user created active sub-client, 8= default sub-client
GROUP BY c.id, i.id
ORDER BY c.id asc, i.id asc
IF @@ROWCOUNT>1
BEGIN
	SET @ErrorCode = @Error_MultipleMatchingInstances;
END
IF @ErrorCode=0
BEGIN
	SELECT @sqlSubClientID = SC.Id
	FROM APP_BackupSetName N (nolock)
		JOIN APP_Application SC (nolock) ON SC.backupSet=N.id
		JOIN APP_InstanceName I (nolock) ON I.id=SC.instance
		JOIN APP_Client C (nolock) ON C.id=SC.clientId
		JOIN APP_SubClientProp SCP (nolock) ON SCP.componentNameId=SC.id
	WHERE C.id=@sqlClientID
		AND SC.appTypeId=@SQL_AppTypeId
		AND SCP.attrType=@PROPERTY_MSSQL_DB
		AND SCP.attrName=@DBName
		AND I.Id=@instanceId
		AND I.status=0
		-- Backupset for SQL is not changeable, do not check
		AND SCP.modified=0 -- 0=Current record
	GROUP BY Sc.Id
	IF @@ROWCOUNT>1
	BEGIN
		SET @ErrorCode = @Error_MultipleMatchingSQLSubClients;
	END
END
IF ISNULL(@sqlSubClientID,0)=0 AND @ErrorCode=0
BEGIN
	-- Fail-over to default
	SELECT @sqlSubClientID=Sc.id
	FROM APP_BackupSetName N (nolock)
		JOIN APP_Application SC (nolock) ON SC.backupSet=N.id
		JOIN APP_InstanceName (nolock) I ON I.id=SC.instance
		JOIN APP_Client C (nolock) ON C.id=SC.clientId
	WHERE C.id=@sqlClientID
		AND SC.appTypeId=@SQL_AppTypeId
		--AND SC.subclientname='default'
		AND I.Id=@instanceId
		AND I.status=0
		AND SC.subclientStatus=8 -- 8 - Default sub-client
		AND C.status=0
	GROUP BY Sc.Id
	IF @@ROWCOUNT>1
	BEGIN
		SET @ErrorCode = @Error_MultipleMatchingSQLSubClients;
	END
END
-- 5/12/2020, OVK: Get databaseId
DECLARE @databaseId int = 0;
SELECT TOP 1 @databaseId=databaseId
FROM SqlDatabaseInfo SDI (nolock)
WHERE instanceId=@instanceId AND appId=@sqlSubClientID AND DatabaseName=@dbName
ORDER BY LastOkBackupTime DESC
DECLARE @farmBackupTime int = NULL;
IF @ErrorCode=0
BEGIN
	select TOP 1
	@farmBackupTime=JBS.servStartDate
	from APP_Application SC (nolock)
	JOIN JMBkpStats JBS (NOLOCK) ON SC.id = JBS.appId
	where SC.id=@farmSubClientId
	AND (JBS.status=1 OR JBS.status=3) -- Success OR PartialSuccess
	AND JBS.bkplevel IN (1,2,4,256) -- For SQL Client (Full and Differential will be relevant)
	AND (JBS.servStartDate BETWEEN @reqFromTime and @reqToTime)
	ORDER by JBS.jobId desc
END
declare @respFromTime int = 0, @respToTime int = 0, @sqlBackupJobId int = 0;
IF @farmBackupTime IS NOT NULL
BEGIN
	select TOP 1
	@sqlBackupJobId=JBS.JobId
	,@respFromTime=JBS.servStartDate
	,@respToTime=JBS.servEndDate
	from APP_Application SC (nolock)
	JOIN JMBkpStats JBS (NOLOCK) ON SC.id = JBS.appId
	where SC.id=@sqlSubClientID
	AND (JBS.status=1 OR JBS.status=3)-- Success OR PartialSuccess.
	AND JBS.bkplevel IN (1,2,4,256) -- For SQL Client (Full and Differential will be relevant)
	ORDER BY ABS(@farmBackupTime - JBS.servStartDate) ASC
END
IF @ErrorCode<>0
BEGIN
	SET @sqlClientId=0;
	SET @instanceId=0;
	SET @sqlSubClientID=0;
	SET @sqlBackupJobId=0;
	SET @respFromTime = @ErrorCode;
	SET @respToTime = @ErrorCode;
	SET @databaseId = 0;
END
DECLARE @rv XML;
SET @rv= (
SELECT
	@sqlClientId as sqlClientId
	,@instanceId as instanceId
	,@sqlSubClientID as sqlSubClientId
	,@sqlBackupJobId as sqlBackupJobId
	,@respFromTime as fromTime
	,@respToTime as toTime
	,@databaseId as databaseId
FOR XML PATH (''), ROOT('App_SPGetRecoveryPointParamsResponse'))
SELECT @rv as XMLResponse;
GO

IF EXISTS (select * from GxQscripts where name = 'APPSPGetRecoveryPointParams')
	delete from GxQscripts where name = 'APPSPGetRecoveryPointParams'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPSPGetRecoveryPointParams')
	delete from GXDBVersions where aliasname = 'APPSPGetRecoveryPointParams'
GO

insert into GXDBVersions values(2, 'APPSPGetRecoveryPointParams',  '00000000000000000000', 'APPSPGetRecoveryPointParams', '00000000000000000000')
GO

