

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPSCGV2GenerateQueryParams.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPSCGV2GenerateQueryParams.sp,v $ $Id: APPSCGV2GenerateQueryParams.sp,v 1.1.2.12 2020/10/28 00:13:06 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='APPSCGV2GenerateQueryParams')
BEGIN
	print '>>> Drop Stored Procedure: APPSCGV2GenerateQueryParams <<<'
	drop procedure APPSCGV2GenerateQueryParams
END
IF EXISTS (select * from GxQscripts where name='APPSCGV2GenerateQueryParams')
	delete from GxQscripts where name = 'APPSCGV2GenerateQueryParams'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPSCGV2GenerateQueryParams')
	delete from GXDBVersions where aliasname = 'APPSCGV2GenerateQueryParams'
GO
print '... Creating Procedure: APPSCGV2GenerateQueryParams'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure APPSCGV2GenerateQueryParams
-- Input arguments
  @scgRuleXML XML,
  @o_exitCode INT OUTPUT,
  @o_exitMessage VARCHAR(1024) OUTPUT,
  @o_ruleQuery NVARCHAR(MAX) OUTPUT
AS
BEGIN
	SET NOCOUNT ON
	--PRINT 'Input XML[' + CAST(@scgRuleXML AS NVARCHAR(MAX)) + ']'
	DECLARE @exitCode	INT = 0
	DECLARE @exitMsg	VARCHAR(128) = 'Success'
	DECLARE @newLine	NVARCHAR(3) = NCHAR(13)	-- + NCHAR(10)
	DECLARE @selectV2	NVARCHAR(24) = N'SELECT clientId FROM '
	DECLARE @selectV1	NVARCHAR(24) = N'SELECT c.id FROM APP_Client c WITH(READUNCOMMITTED) WHERE '
	DECLARE @intersect	NVARCHAR(11) = N' INTERSECT '	-- and op for V2 no where clauses
	DECLARE @union		NVARCHAR(11) = N' UNION '		-- or op for V2 no where clauses
	DECLARE @except		NVARCHAR(11) = N' EXCEPT '		-- not op for V2 no where clauses
	DECLARE @ruleVars	NVARCHAR(512) = N'DECLARE @inClientId INT = 0/*GetAllClients*/; '		-- no not remove or change inline comment, it is keyword for replacing 0 with an actual clientId
	SET @ruleVars += @newLine + N'DECLARE @inSCGId INT = 0/*SCGProcessing*/; ' + @newLine;
	-- Has Group Rules been supplied?
	-- Note: First node name can be either App_SCGRuleGroup or scgRule
	IF (@scgRuleXML.exist('//rules') = 0)
	BEGIN
		-- No Group Rules supplied.  Create dummy query so that only Scope is applied.
		SET @o_exitCode = @exitCode
		SET @o_exitMessage = @exitMsg
		SET @ruleVars += '
(
	SELECT clientId FROM dbo.scgV2ClientScopeOnly(''TRUE'',  1 , @inClientId, @inSCGId)
)
'
		SET @o_ruleQuery = @ruleVars
		GOTO END_OF_PROC
	END
	-- Group Rules Supplied, parse and create SCG Query for inputted rules
	IF OBJECT_ID('tempdb.dbo.#RuleTree') IS NOT NULL
		 DROP TABLE #RuleTree
	CREATE TABLE #RuleTree (
		id			INT IDENTITY(1,1),
		masterOp	INT,
		[group]		INT,
		number		INT,
		filterID	INT,
		propID		INT,
		propType	INT,
		secValue	NVARCHAR(MAX),
		value		NVARCHAR(MAX),
		op			INT,
		flags		INT,
		funcName	NVARCHAR(256),
		ruleQuery	NVARCHAR(MAX),
		PRIMARY KEY ([group], number, id)
	)
	BEGIN TRY
		DECLARE @ruleCount INT = 0
		-- flatten the XML SCG Rule out as a table
		INSERT INTO #RuleTree(masterOp, [group], number, filterID, propID, propType, secValue, value, op, flags, funcName)
			SELECT
				r.value('../../../../@op', 'int') masterOp,
				gc.value('for $a in . return 1+count($a/../*[. << $a])','int') [group],
				rc.value('for $a in . return 1+count($a/../*[. << $a])','int') number,
				r.value('@filterID', 'int') filterID,
				r.value('@propID', 'int') propID,
				r.value('@propType', 'int') propType,
				r.value('@secValue', 'NVARCHAR(max)') secValue,
				CASE
					WHEN r.value('@propType', 'int') = 6 OR r.value('@propType', 'int') = 7 THEN		-- SCGP_SELECTION or SCGP_SELECTION_V2
						CASE
							WHEN CHARINDEX('UTF-8', r.value('@value', 'VARCHAR(max)'), 0) > 0 THEN CAST(CAST(r.value('@value', 'VARCHAR(max)') AS XML) AS NVARCHAR(MAX))	-- remove UTF-8 XML Header
							ELSE CAST(CAST(r.value('@value', 'NVARCHAR(max)') AS XML) AS NVARCHAR(MAX))	-- remove XML Header
						END
					ELSE r.value('@value', 'NVARCHAR(max)')
				END value,
				r.value('../../@op', 'int') op,
				ISNULL(p.flags, up.flags) flags,
				ISNULL(p.funcName, up.funcName) funcName
			FROM
				@scgRuleXML.nodes('//rules/rule/rules/rule') t(r)
				LEFT OUTER JOIN App_SCGProperty p WITH(READUNCOMMITTED) ON		-- propID < 10000	CS Supplied SCG Function
					p.id = r.value('@propID', 'int')
				LEFT OUTER JOIN App_SCGUserProperty up WITH(READUNCOMMITTED) ON	-- propID >= 10000	User Defined SCG Function
					up.id = r.value('@propID', 'int')
				CROSS APPLY r.nodes('..') rc(rc)			-- rule count / number
				CROSS APPLY r.nodes('../../..') gc(gc)			-- rule group count / number	NOTE if full path /scgRule/rules/rule/rules/rule -> '../../..'
		SET @ruleCount = @@ROWCOUNT
		IF (@ruleCount = 0)
		BEGIN
			-- Try to parse input where no grouping level nodes exist
			INSERT INTO #RuleTree(masterOp, [group], number, filterID, propID, propType, secValue, value, op, flags, funcName)
				SELECT
					r.value('../../@op', 'int') masterOp,
					1 [group],	-- only one grouping
					rc.value('for $a in . return 1+count($a/../*[. << $a])','int') number,
					r.value('@filterID', 'int') filterID,
					r.value('@propID', 'int') propID,
					r.value('@propType', 'int') propType,
					r.value('@secValue', 'NVARCHAR(max)') secValue,
					CASE
						WHEN r.value('@propType', 'int') = 6 THEN
							CASE
								WHEN CHARINDEX('UTF-8', r.value('@value', 'VARCHAR(max)'), 0) > 0 THEN CAST(CAST(r.value('@value', 'VARCHAR(max)') AS XML) AS NVARCHAR(MAX))	-- remove UTF-8 XML Header
								ELSE CAST(CAST(r.value('@value', 'NVARCHAR(max)') AS XML) AS NVARCHAR(MAX))	-- remove XML Header
							END
						ELSE r.value('@value', 'NVARCHAR(max)')
					END value,
					r.value('../../@op', 'int') op,		-- same as masterOp
					ISNULL(p.flags, up.flags) flags,
					ISNULL(p.funcName, up.funcName) funcName
				FROM
					@scgRuleXML.nodes('//rules/rule') t(r)
					LEFT OUTER JOIN App_SCGProperty p WITH(READUNCOMMITTED) ON		-- propID < 10000	CS Supplied SCG Function
						p.id = r.value('@propID', 'int')
					LEFT OUTER JOIN App_SCGUserProperty up WITH(READUNCOMMITTED) ON	-- propID >= 10000	User Defined SCG Function
						up.id = r.value('@propID', 'int')
					CROSS APPLY r.nodes('..') rc(rc)			-- rule count / number
				WHERE
					r.exist('rules/rule') = 0		-- and no lower level nodes exist
			SET @ruleCount = @@ROWCOUNT
			IF (@ruleCount = 0)
			BEGIN
				SET @exitCode = 1
				SET @exitMsg = 'SCG XML Rule parsing error'
				GOTO END_OF_PROC_ERROR
			END
		END
		-- Make sure no mixed SCG Function Versions selected
		DECLARE @v2Count	INT = 0
		DECLARE @v1Count	INT = 0
		SELECT
			@v1Count += CASE WHEN rt.flags = 0 THEN 1 ELSE 0 END,
			@v2Count += CASE WHEN (rt.flags & 1) = 1 THEN 1 ELSE 0 END
		FROM #RuleTree rt
		IF (@v1Count <> @ruleCount AND @v2Count <> @ruleCount)
		BEGIN
			SET @exitCode = 2
			SET @exitMsg = 'Mixed SCG Function Versions Error'
			GOTO END_OF_PROC_ERROR
		END
		DECLARE @versionType INT
		SELECT @versionType = CASE WHEN @v1Count = @ruleCount THEN 1 ELSE 2 END
		-- Generate SCG SQL Command
		IF (@versionType = 1)
		BEGIN
			SET @exitCode = 3
			SET @exitMsg = 'Generate SCG Function Version 1 Not Supported by procedure'
			GOTO END_OF_PROC_ERROR
		END
		ELSE
		BEGIN
			-- Generate individual SCG SQL Command for each rule
			UPDATE rt
				SET ruleQuery = CASE
									WHEN rt.number > 1 AND rt.op = 0 THEN @intersect + N' '
									WHEN rt.number > 1 AND rt.op = 1 THEN @union + N' '
									WHEN rt.number > 1 AND rt.op = 2 THEN @except + N' '
									ELSE ''
								END
								+ @selectV2
								+ rt.funcName
								+ N'('
								+ dbo.scgV2HelperGetParameters(rt.flags, rt.filterID, rt.propType, rt.value, rt.secValue)
								+ N' , @inClientId, @inSCGId '
								+ N') '
			FROM #RuleTree rt
			--SELECT * FROM #RuleTree
			-- Generate the full SCG SQL Command
			DECLARE @ruleQuery	NVARCHAR(MAX) = N''
			SELECT
				@ruleQuery += CASE
									WHEN q.[group] > 1 AND q.masterOp = 0 THEN ') ' + @intersect + N' ('
									WHEN q.[group] > 1 AND q.masterOp = 1 THEN ') ' + @union + N' ('
									WHEN q.[group] > 1 AND q.masterOp = 2 THEN ') ' + @except + N' ('
									ELSE N'('
								END
								+ @newLine
								+ q.[rule]
			FROM (
				SELECT
					q.[group],
					q.masterOp,
					r.value('(ruleQuery)[1]', 'NVARCHAR(MAX)') [rule]
				FROM
					(SELECT --DISTINCT
						q.[group],
						q.masterOp,
						CAST((N'<ruleQuery> ' + q.[rule] + N'</ruleQuery>') AS XML) [rule]
					FROM
						(SELECT DISTINCT
							ort.[group],
							ort.masterOp,
							CAST(
								(SELECT
									irt.ruleQuery + @newLine
								FROM #RuleTree irt
								WHERE irt.[group] = ort.[group]
								ORDER BY irt.[group], irt.number
								FOR XML PATH(''), TYPE)
							AS NVARCHAR(MAX)) AS [rule]
						FROM #RuleTree ort) q) q
					CROSS APPLY [rule].nodes('.') doc(r)) q
			SET @ruleQuery += N')' + @newLine
			SET @ruleQuery = @ruleVars + @ruleQuery
			-- Removed printing query due to LIKE and % operations can causing dbupgrade to crash
			--PRINT @ruleQuery
			-- test the generated query for any syntax errors
			IF OBJECT_ID('tempdb.dbo.#TestTable') IS NOT NULL
				 DROP TABLE #TestTable
			CREATE TABLE #TestTable (clientId	INT)
			INSERT INTO #TestTable
				EXEC(@ruleQuery)
			--SELECT clientId FROM #TestTable
		END
		SET @o_exitCode = @exitCode
		SET @o_exitMessage = @exitMsg
		SET @o_ruleQuery = @ruleQuery
		GOTO END_OF_PROC
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @exitCode = 5
		SET @exitMsg = 'Catch Block Error'
	END CATCH
END_OF_PROC_ERROR:
	SET @o_exitCode = @exitCode
	SET @o_exitMessage = @exitMsg
	SET @o_ruleQuery = N''
END_OF_PROC:
END
GO

IF EXISTS (select * from GxQscripts where name = 'APPSCGV2GenerateQueryParams')
	delete from GxQscripts where name = 'APPSCGV2GenerateQueryParams'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPSCGV2GenerateQueryParams')
	delete from GXDBVersions where aliasname = 'APPSCGV2GenerateQueryParams'
GO

insert into GXDBVersions values(2, 'APPSCGV2GenerateQueryParams',  '00010001000200120000', 'APPSCGV2GenerateQueryParams', '00010001000200120000')
GO

