

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPResetEDCInstanceReferenceTime.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--		July 08, 2009: Converted to SP for performance/debugging  -SKatz
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPResetEDCInstanceReferenceTime.sp,v $ $Id: APPResetEDCInstanceReferenceTime.sp,v 1.2.274.2 2018/03/22 01:51:08 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPResetEDCInstanceReferenceTime <<<'

IF EXISTS (select * from sysobjects where name='APPResetEDCInstanceReferenceTime')
	drop procedure APPResetEDCInstanceReferenceTime
IF EXISTS (select * from GxQscripts where name='APPResetEDCInstanceReferenceTime')
	delete from GxQscripts where name = 'APPResetEDCInstanceReferenceTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPResetEDCInstanceReferenceTime')
	delete from GXDBVersions where aliasname = 'APPResetEDCInstanceReferenceTime'
GO
print '... Creating Procedure: APPResetEDCInstanceReferenceTime'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPResetEDCInstanceReferenceTime
  @i_clientId integer,
  @i_appType integer
AS
BEGIN
DECLARE @instanceType nvarchar(max);
DECLARE @Id int;
DECLARE @errorCode int;
DECLARE @errorString nvarchar(max);
SET NOCOUNT ON
SET @errorCode = 0;
SET @errorString = N'';
SET	@instanceType = (case @i_appType when 61 then '10' -- EDCInstanceType.APP_EDC_NETAPP_SNAP_MANAGER_SAP_ORACLE
when 22 then '9' -- EDCInstanceType.APP_EDC_NETAPP_SNAP_MANAGER_ORACLE
when 81	then  '11' -- EDCInstanceType.APP_EDC_NETAPP_SNAP_MANAGER_MSSQL
when 53 then '2' --EDCInstanceType.APP_EDC_NETAPP_SNAP_EXCHANGE,
			else N'0' end	)
IF @instanceType = 0
	BEGIN
		SET @errorCode = 1;
		SET @errorString = N'Invalid AppType Type. This apptype is not supported';
		GOTO SUCCEESS_EXIT
	END
ELSE
	BEGIN
		SET @Id = (
		select top 1 id
		from APP_Application A
		where A.clientId = @i_clientId
and A.appTypeId = 127 and A.instance in
											(select componentNameId
											from APP_InstanceProp I
											where I.attrName = 'EDC Instance Type'
												and I.attrVal = @instanceType ))
		DELETE APP_SubClientProp
		where componentNameId = @Id
			and (attrName = 'sys:last incr' or attrName = 'sys:last full')
	END
SUCCEESS_EXIT:
	BEGIN
	SELECT	1			         as TAG,
			NULL		         as Parent,
			@errorCode			 as [CVGui_GenericResp!1!errorCode],
			@errorString	         as [CVGui_GenericResp!1!errorMessage]
		 FOR XML EXPLICIT
	END
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPResetEDCInstanceReferenceTime')
	delete from GxQscripts where name = 'APPResetEDCInstanceReferenceTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPResetEDCInstanceReferenceTime')
	delete from GXDBVersions where aliasname = 'APPResetEDCInstanceReferenceTime'
GO

insert into GXDBVersions values(2, 'APPResetEDCInstanceReferenceTime',  '00010002027400020000', 'APPResetEDCInstanceReferenceTime', '00010002027400020000')
GO

