

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPResetCSNameChangeOnClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  APPGetEntityFirewallXML
--  |
--  | Description:  Procedure to return all the Firewall properties of an entity
--  |
--  |       Input:  XML Containing clientId/ClientGroupId
--  |
--  |      Output:  XML containing firewall properties
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1       Shilpa Nagendra					Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPResetCSNameChangeOnClients <<<'

IF EXISTS (select * from sysobjects where name='APPResetCSNameChangeOnClients')
	drop procedure APPResetCSNameChangeOnClients
IF EXISTS (select * from GxQscripts where name='APPResetCSNameChangeOnClients')
	delete from GxQscripts where name = 'APPResetCSNameChangeOnClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPResetCSNameChangeOnClients')
	delete from GXDBVersions where aliasname = 'APPResetCSNameChangeOnClients'
GO
print '... Creating Procedure: APPResetCSNameChangeOnClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPResetCSNameChangeOnClients
  @cshostname nvarchar(MAX),
  @entityInfo XML	OUTPUT
AS
DECLARE @clientList table ( clientId integer)
DECLARE @rootTag INTEGER=0
SET @rootTag = (SELECT @entityInfo.exist('/App_NameChangeResponse'))
IF  @rootTag = 1
BEGIN
	INSERT INTO @clientList
	SELECT  ref.value('@clientId', 'INTEGER')
	FROM    @entityInfo.nodes('App_NameChangeResponse/failedClientList/entity') R ( ref )
END
ELSE
BEGIN
	INSERT INTO @clientList
	SELECT  ref.value('@clientId', 'INTEGER')
	FROM    @entityInfo.nodes('EVGui_ClientNameControlResp/clientList') R ( ref ) --ClientNameControlResp
END
UPDATE	App_Client
SET	CsHostName = @cshostname
WHERE	id in (select clientId from @clientList)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPResetCSNameChangeOnClients')
	delete from GxQscripts where name = 'APPResetCSNameChangeOnClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPResetCSNameChangeOnClients')
	delete from GXDBVersions where aliasname = 'APPResetCSNameChangeOnClients'
GO

insert into GXDBVersions values(2, 'APPResetCSNameChangeOnClients',  '00000000000000000000', 'APPResetCSNameChangeOnClients', '00000000000000000000')
GO

