

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPPostServicePackClientUpgrade.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPPostServicePackClientUpgrade.sp,v $ $Id: APPPostServicePackClientUpgrade.sp,v 1.1.2.5 2019/04/30 19:31:15 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPPostServicePackClientUpgrade')
BEGIN
	print '>>> Drop Stored Procedure: APPPostServicePackClientUpgrade <<<'
	drop procedure APPPostServicePackClientUpgrade
END
IF EXISTS (select * from GxQscripts where name='APPPostServicePackClientUpgrade')
	delete from GxQscripts where name = 'APPPostServicePackClientUpgrade'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPPostServicePackClientUpgrade')
	delete from GXDBVersions where aliasname = 'APPPostServicePackClientUpgrade'
GO
print '... Creating Procedure: APPPostServicePackClientUpgrade'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPPostServicePackClientUpgrade
--  User Input arguments
  @inClientId INT
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @errorCode INT
  DECLARE @errorMsg NVARCHAR(1024)
BEGIN
	SET NOCOUNT ON
	SET @errorCode = 0
	SET @errorMsg = N'Success'
	DECLARE @tranCnt INT
	DECLARE @nowTime INT
	SET	@nowTime = dbo.GetUnixTime(GETUTCDATE())
	-- Cloud / CCS Laptop Client
	-- Is CCS Functionality enabled on the CommServer?
	DECLARE @ccsEnabled INT = 0
	SELECT @ccsEnabled = CAST(value AS INT) FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'CommServCCSEnabled'
	IF (@ccsEnabled = 1)
	BEGIN
		-- Is Cloud / CCS Laptop Client configuration meet
		IF EXISTS (
			SELECT 1
			FROM ClientsWithValidCCSCfgsView  WITH(NOLOCK)
			WHERE clientId = @inClientId
		)
		BEGIN
			IF EXISTS(SELECT 1 FROM APP_ClientProp WHERE attrName = N'CCS Enabled' AND componentNameId = @inClientId AND modified = 0)
			BEGIN
				GOTO END_OF_PROC
			END
			DECLARE @ccsDisabled INT = 0
			SELECT TOP 1
				@ccsDisabled = 1
			FROM APP_AdvanceSettings a WITH(NOLOCK)
			WHERE
				a.entityId = @inClientId
				AND a.entityType = 3	-- client type
				AND a.keyName = N'DisableCCSDbMode'
				AND a.enabled = 1
				AND a.deleted = 0
				AND CAST(a.value AS NVARCHAR(32)) = N'1'
			BEGIN TRY
				-- Determine Transaction Status
				SET @tranCnt = @@TRANCOUNT
				IF (@tranCnt > 0)
				BEGIN
					-- Create save point
					SAVE TRANSACTION CCS_TRANS
				END
				ELSE
				BEGIN
					BEGIN TRANSACTION
				END
				-- Perform CCS Configuration
				UPDATE APP_ClientProp
					SET attrVal = CASE @ccsDisabled WHEN 1 THEN N'0' ELSE N'1' END
				WHERE attrName = N'CCS Enabled'
					AND componentNameId = @inClientId
					AND modified = 0
				IF @@ROWCOUNT = 0
				BEGIN
					INSERT INTO App_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
						VALUES (@inClientId, N'CCS Enabled', 2, (CASE @ccsDisabled WHEN 1 THEN N'0' ELSE N'1' END), @nowTime, 0, 0)
				END
				-- CCS Client Registry key
				UPDATE APP_AdvanceSettings
					SET value = (CASE @ccsDisabled WHEN 1 THEN N'DISABLED' ELSE N'LOAD' END),
						enabled = 1,
						deleted = 0
				WHERE
					entityType = 3      -- client
					AND entityId = @inClientId
					AND keyName = N'sCCSDbStatus'
				IF @@ROWCOUNT = 0
				BEGIN
					DECLARE @ccsId INT
					INSERT INTO APP_AdvanceSettings (entityId, keyName, type, relativePath, value, enabled, deleted, entityType, sourceId, sourceEntityType)
						VALUES (@inClientId, N'sCCSDbStatus', N'STRING', N'iDataAgent', (CASE @ccsDisabled WHEN 1 THEN N'DISABLED' ELSE N'LOAD' END), 1, 0, 3 /* client */, 0, 0)
					SET @ccsId = SCOPE_IDENTITY()
					INSERT INTO APP_AdvanceSettingsEx (keyId, details, hidden)
						VALUES (@ccsId, N'', 1)
				END
				-- Work Queue CCS Operations
				INSERT INTO APP_WorkQueueRequest (clientId, remoteClient, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag)
					VALUES (@inClientId, -1, 6 /*WORK_TOKEN_REGISTRY*/, '', @nowTime, 0, 0, 0),
							(@inClientId, -1, 49 /*WORK_TOKEN_CCS_DB_CHANGE_STATE*/, (CASE @ccsDisabled WHEN 1 THEN N'DISABLED' ELSE N'LOAD' END), @nowTime, 0, 0, 0)
				IF (@tranCnt = 0)
				BEGIN
					-- Commit this block's transaction, we are the owner of it
					COMMIT TRANSACTION
				END
			END TRY
			BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
				SET @errorCode = ERROR_NUMBER();
				SET @errorMsg = ERROR_MESSAGE();
				IF (@tranCnt = 0)
				BEGIN
					-- Rollback our started transaction
					ROLLBACK TRANSACTION
				END
				ELSE
				BEGIN
					IF XACT_STATE() <> -1
					BEGIN
						-- Rollback the transaction or save point
						ROLLBACK TRANSACTION CCS_TRANS
					END
				END
			END CATCH
		END
	END
END_OF_PROC:
	SELECT @errorCode errorCode, @errorMsg errorMsg
	RETURN
END

IF EXISTS (select * from GxQscripts where name = 'APPPostServicePackClientUpgrade')
	delete from GxQscripts where name = 'APPPostServicePackClientUpgrade'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPPostServicePackClientUpgrade')
	delete from GXDBVersions where aliasname = 'APPPostServicePackClientUpgrade'
GO

insert into GXDBVersions values(2, 'APPPostServicePackClientUpgrade',  '00010001000200050000', 'APPPostServicePackClientUpgrade', '00010001000200050000')
GO

