

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetWebServiceUrlXML.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  APPGetWebServiceUrlXML
--  | Description:
--  |
--  |			Provides preferred webservice url
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetWebServiceUrlXML.sp,v $ $Id: APPGetWebServiceUrlXML.sp,v 1.1.2.5 2020/06/22 22:15:11 sgolla Exp $";
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetWebServiceUrlXML')
BEGIN
	print '>>> Drop Stored Procedure: APPGetWebServiceUrlXML <<<'
	drop procedure APPGetWebServiceUrlXML
END
IF EXISTS (select * from GxQscripts where name='APPGetWebServiceUrlXML')
	delete from GxQscripts where name = 'APPGetWebServiceUrlXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetWebServiceUrlXML')
	delete from GXDBVersions where aliasname = 'APPGetWebServiceUrlXML'
GO
print '... Creating Procedure: APPGetWebServiceUrlXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetWebServiceUrlXML
  @i_xmlText XML
AS
  DECLARE @o_xmlText XML;
  DECLARE @o_webServiceURL nvarchar(1024) = N''
DECLARE @clientId INT = 0
DECLARE @webserverName   nvarchar(max) = ''
DECLARE @includeAlias tinyint = 0
DECLARE @includeEndPoint tinyint = 0
SET @includeAlias = 1
SET @includeEndPoint = 1
DECLARE @IsValidInput INT = 1
if @i_xmlText IS NOT NULL
BEGIN
	SELECT @clientId = T.item.value('@webServerId', 'int'), @webserverName = T.item.value('@webServerName', 'nvarchar(512)')
	FROM @i_xmlText.nodes('/App_WebServiceURLReq/webServerInfo') T(item)
	IF ISNULL(@clientId, 0) = 0 AND ISNULL(@webserverName, '') <> ''
	BEGIN
		SET @clientId = ISNULL((SELECT TOP 1 Id FROM App_client (NOLOCK) WHERE name = @webserverName),0)
		IF @clientId = 0
		BEGIN
			SET @IsValidInput = 0
		END
	END
	-- If specified input client doesn't belong to a web server, then no point in further processing
	-- so check that here to see if we really have to go into the logic of building the URL.
	--
IF @clientId > 0 AND NOT EXISTS (SELECT 1 FROM SimInstalledPackages (NOLOCK) WHERE ClientId = @clientId AND simPackageId in (803, 852))
	BEGIN
		SET @IsValidInput = 0
	END
END
IF @IsValidInput = 1
BEGIN
--Default webserver can be specified in control panel=>browse/search/recovery=>default web server for search
IF ISNULL(@clientId, 0) = 0
BEGIN
		SET @clientId = ISNULL((SELECT TOP 1 value FROM GXGlobalParam (NOLOCK) WHERE name = 'Web Search Server for Super Search'),0)
END
--if specified client does not have webserver package installed, pick CS webserver first otherwise any other webserver
IF @clientId =0 OR NOT EXISTS (SELECT 1 FROM simInstalledPackages (NOLOCK) WHERE simPackageID IN (803, 852) AND clientId = @clientId)
SET @clientId = ISNULL((SELECT TOP 1 ClientId FROM simInstalledPackages (NOLOCK) WHERE simPackageID IN (803, 852)),0)
--webservice url
IF @clientId > 0
BEGIN
	SELECT @o_webServiceURL = dbo.AppFetchWebServiceURL(@clientId, @includeAlias, @includeEndPoint)
	SELECT @webserverName = dbo.GetClientMangledHostName(@clientId,NULL)
END
-- all logic moved to .spb to promote re-use
SET @o_xmlText = (SELECT @o_webServiceURL '@webServerUrl',
                    ( SELECT  @webserverName 'webServerName'
                    FOR XML PATH('webServerInfo'), TYPE
             ) FOR XML PATH('WebServiceURLResp')
            )
END
IF @o_xmlText IS NULL
    SET @o_xmlText = '<WebServiceURLResp/>'
SELECT @o_xmlText AS [o_xmlText]
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetWebServiceUrlXML')
	delete from GxQscripts where name = 'APPGetWebServiceUrlXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetWebServiceUrlXML')
	delete from GXDBVersions where aliasname = 'APPGetWebServiceUrlXML'
GO

insert into GXDBVersions values(2, 'APPGetWebServiceUrlXML',  '00010001000200050000', 'APPGetWebServiceUrlXML', '00010001000200050000')
GO

