

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetWebServiceURL.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  APPGetWebServiceURL
--  | Description:   Creates/ delete entries in  DM2Cloud table
--  |
--  |			create analytics servers cloud
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetWebServiceURL.sp,v $ $Id: APPGetWebServiceURL.sp,v 1.1.4.11 2020/03/17 23:12:16 sgolla Exp $";
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetWebServiceURL')
BEGIN
	print '>>> Drop Stored Procedure: APPGetWebServiceURL <<<'
	drop procedure APPGetWebServiceURL
END
IF EXISTS (select * from GxQscripts where name='APPGetWebServiceURL')
	delete from GxQscripts where name = 'APPGetWebServiceURL'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetWebServiceURL')
	delete from GXDBVersions where aliasname = 'APPGetWebServiceURL'
GO
print '... Creating Procedure: APPGetWebServiceURL'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetWebServiceURL
AS
  DECLARE @o_webServiceURL nvarchar(1024) = N''
DECLARE @clientId INT = 0
DECLARE @webserverName   nvarchar(max) = ''
DECLARE @includeAlias tinyint = 0
DECLARE @includeEndPoint tinyint = 0
--first get webserver from gxglobalparam (existing setups)
SELECT @webserverName = ISNULL(value, '') FROM GXGlobalParam WHERE name = 'DefaultWebserverForAnalytics'
IF @webserverName != ''
BEGIN
	SET @clientId = ISNULL((SELECT TOP 1 Id FROM App_client (NOLOCK) WHERE name = @webserverName),0)
END
-- Logic to consider global settings if no input is given in part of AppGetWebServiceUrl.spb
--
--Default webserver can be specified in control panel=>browse/search/recovery=>default web server for search
IF ISNULL(@clientId, 0) = 0
BEGIN
		SET @clientId = ISNULL((SELECT TOP 1 value FROM GXGlobalParam (NOLOCK) WHERE name = 'Web Search Server for Super Search'),0)
END
--if specified client does not have webserver package installed, pick CS webserver first otherwise any other webserver
IF @clientId =0 OR NOT EXISTS (SELECT 1 FROM simInstalledPackages (NOLOCK) WHERE simPackageID IN (803, 852) AND clientId = @clientId)
SET @clientId = ISNULL((SELECT TOP 1 ClientId FROM simInstalledPackages (NOLOCK) WHERE simPackageID IN (803, 852)),0)
--webservice url
IF @clientId > 0
BEGIN
	SELECT @o_webServiceURL = dbo.AppFetchWebServiceURL(@clientId, @includeAlias, @includeEndPoint)
	SELECT @webserverName = dbo.GetClientMangledHostName(@clientId,NULL)
END
IF LEN (@o_webServiceURL) > 0
	SELECT @o_webServiceURL
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetWebServiceURL')
	delete from GxQscripts where name = 'APPGetWebServiceURL'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetWebServiceURL')
	delete from GXDBVersions where aliasname = 'APPGetWebServiceURL'
GO

insert into GXDBVersions values(2, 'APPGetWebServiceURL',  '00010001000400110000', 'APPGetWebServiceURL', '00010001000400110000')
GO

