

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetWebConsoleURLForClient.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='APPGetWebConsoleURLForClient')
BEGIN
	print '>>> Drop Stored Procedure: APPGetWebConsoleURLForClient <<<'
	drop procedure APPGetWebConsoleURLForClient
END
IF EXISTS (select * from GxQscripts where name='APPGetWebConsoleURLForClient')
	delete from GxQscripts where name = 'APPGetWebConsoleURLForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetWebConsoleURLForClient')
	delete from GXDBVersions where aliasname = 'APPGetWebConsoleURLForClient'
GO
print '... Creating Procedure: APPGetWebConsoleURLForClient'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure APPGetWebConsoleURLForClient
  @clientId INT,
  @userId INT,
  @xmlText XML OUTPUT
AS
DECLARE @webConsoleURL NVARCHAR(MAX) = ''
DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(MAX) = ''
/*
This SP fetched webconsoleUrl for given client
Priority Order
1. check if sCustomWebConsoleUrl is present for client
2. check if sCustomWebConsoleUrl is present for client grp
3. check if webconsoleUrl is present in GXGlobalParam
*/
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
		IF(@clientId = 0 OR ((SELECT 1 FROM App_Client WHERE id = @clientId) IS NULL))
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Invalid ClientId'
			GOTO SEND_RESP
		END
		-- check if custom webconsoleUrl is set at client level
		SELECT  @webConsoleURL = value FROM App_AdvanceSettings
WHERE keyName = 'sCustomWebConsoleUrl' AND entityId = @clientId AND entityType = 3
		IF @webConsoleURL IS NOT NULL AND LTRIM(RTRIM(@webConsoleURL)) <> ''
        BEGIN
            SET @webConsoleURL = LTRIM(RTRIM(REPLACE(@webConsoleURL,'/clientDetails/fsDetails.do?clientName=CLIENTNAME','')))
        END
		-- check if webconsoleUrl is present at client grp level
		IF(@webConsoleURL IS NULL OR LTRIM(RTRIM(@webConsoleURL)) = '')
		BEGIN
			SELECT  @webConsoleURL = value FROM App_AdvanceSettings AP
			INNER JOIN APP_ClientGroupAssoc Assoc
				ON Assoc.clientId = @clientId
WHERE AP.keyName = 'sCustomWebConsoleUrl' AND AP.entityId = Assoc.clientGroupId AND AP.entityType = 28
			IF @webConsoleURL IS NOT NULL AND LTRIM(RTRIM(@webConsoleURL)) <> ''
			BEGIN
				SET @webConsoleURL = LTRIM(RTRIM(REPLACE(@webConsoleURL,'/clientDetails/fsDetails.do?clientName=CLIENTNAME','')))
			END
		END
		-- fetch from GXGlobalParam
		IF(@webConsoleURL IS NULL OR LTRIM(RTRIM(@webConsoleURL)) = '')
		BEGIN
			SELECT @webConsoleURL = value FROM GXGlobalParam WHERE name = N'WebConsoleURL'
			IF @webConsoleURL IS NOT NULL AND LTRIM(RTRIM(@webConsoleURL)) <> ''
			BEGIN
				SET @webConsoleURL = LTRIM(RTRIM(REPLACE(@webConsoleURL,'/clientDetails/fsDetails.do?clientName=CLIENTNAME','')))
			END
		END
		IF(@webConsoleURL IS NULL OR LTRIM(RTRIM(@webConsoleURL)) = '')
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'WebconsoleUrl is not present in DB'
			GOTO SEND_RESP
		END
		SEND_RESP:
			SET @xmlText =
					(SELECT @webConsoleURL as '@webConsoleUrl',
						(SELECT @errorCode   AS '@errorCode',
							@errorString AS '@errorString'
						FOR xml PATH('error'), TYPE),
						(SELECT @clientId as '@clientId'
						FOR XML PATH('client'), TYPE)
					FOR XML PATH('App_WebConsoleForClientResp'))
END TRY
BEGIN CATCH
		SET @errorCode = ERROR_NUMBER()
		SET @errorString = ERROR_MESSAGE()
		SET @xmlText =
					(SELECT
						(SELECT @errorCode   AS '@errorCode',
							@errorString AS '@errorString'
						FOR xml PATH('error'), TYPE)
					FOR XML PATH('App_WebConsoleForClientResp'))
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetWebConsoleURLForClient')
	delete from GxQscripts where name = 'APPGetWebConsoleURLForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetWebConsoleURLForClient')
	delete from GXDBVersions where aliasname = 'APPGetWebConsoleURLForClient'
GO

insert into GXDBVersions values(2, 'APPGetWebConsoleURLForClient',  '00000000000000000000', 'APPGetWebConsoleURLForClient', '00000000000000000000')
GO

