

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetVpnRouter.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2015  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--		This SP takes clientId as input and returns the VPN Router rules as per below algo.
--		1. If VPN Router is enabled for this clientId
--			a. Return all rules specified for this clientId only.
--		2. If VPN Router is not enabled for this clientId, pick one client group to which this client belongs to and which has VPN Router enabled at the group level.
--			a. Return all rules specified against that client group only.
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetVpnRouter <<<'

IF EXISTS (select * from sysobjects where name='APPGetVpnRouter')
	drop procedure APPGetVpnRouter
IF EXISTS (select * from GxQscripts where name='APPGetVpnRouter')
	delete from GxQscripts where name = 'APPGetVpnRouter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetVpnRouter')
	delete from GXDBVersions where aliasname = 'APPGetVpnRouter'
GO
print '... Creating Procedure: APPGetVpnRouter'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetVpnRouter
  @clientId INT
AS
  DECLARE @o_clientId INT
  DECLARE @o_clientName nvarchar(255)
  DECLARE @o_clientHostName nvarchar(255)
  DECLARE @o_clientGUID nvarchar(255)
  DECLARE @o_ruleType tinyint
  DECLARE @o_userId INT
  DECLARE @o_userGroupId INT
  DECLARE @o_dstName nvarchar(max)
  DECLARE @o_dstPorts nvarchar(max)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE	@resultTbl				TABLE(id INT, name nvarchar(255), hostName nvarchar(255), GUID nvarchar(255),
								ruleType tinyint, userId INT, userGroupId INT, dstName nvarchar(max), dstPorts nvarchar(max))
DECLARE	@routerRules			nvarchar(max)
DECLARE	@ruleXML				XML
DECLARE	@ruleType				tinyint
DECLARE	@allClients				INT
DECLARE	@allUsers				INT
DECLARE	@destinationName		nvarchar(max)
DECLARE	@destinationPorts		nvarchar(max)
DECLARE	@clientsTbl				TABLE(id INT)
DECLARE	@clientGroupsTbl		TABLE(id INT)
DECLARE	@usersTbl				TABLE(id INT)
DECLARE	@userGroupsTbl			TABLE(id INT)
DECLARE	@adGroupsTbl			TABLE(id INT, name nvarchar(255))
DECLARE	@clientDetails			TABLE(id INT, name nvarchar(255), net_hostname nvarchar(255), GUID nvarchar(255))
DECLARE @VpnRouterEnabled		INT = 0
SET @VpnRouterEnabled = (SELECT attrVal FROM APP_clientProp WHERE attrName='VPNEnableRouter' AND componentNameId = @clientId AND modified = 0)
IF @VpnRouterEnabled IS NOT NULL AND @VpnRouterEnabled <> 0
BEGIN
    DECLARE cur CURSOR STATIC FOR SELECT routerRules, ruleType FROM APP_FirewallVpnRouter WHERE routerClientId = @clientId
OPEN cur                                                                                                                                                
  FETCH NEXT FROM cur INTO @routerRules, @ruleType                                                                                                        
      WHILE @@FETCH_STATUS = 0                                                                                                                            
      BEGIN                                                                                                                                               
          SET @ruleXML = CAST(CAST(@routerRules AS TEXT) AS XML)                                                                                          
          SET @allClients = ISNULL((SELECT ref.value('@allClients', 'int') FROM @ruleXML.nodes('App_VpnRouterRules') R(ref)), 0)                          
          SET @allUsers = ISNULL((SELECT ref.value('@allUsers', 'int') FROM @ruleXML.nodes('App_VpnRouterRules') R(ref)), 0)                              
          SET @destinationName = ISNULL((SELECT ref.value('@destinationName', 'nvarchar(max)') FROM @ruleXML.nodes('App_VpnRouterRules') R(ref)), '*')    
          SET @destinationPorts = ISNULL((SELECT ref.value('@destinationPorts', 'nvarchar(max)') FROM @ruleXML.nodes('App_VpnRouterRules') R(ref)), '')   
                                                                                                                                                          
          DELETE @clientsTbl                                                                                                                              
          DELETE @clientGroupsTbl                                                                                                                         
          DELETE @usersTbl                                                                                                                                
          DELETE @userGroupsTbl                                                                                                                           
          DELETE @adGroupsTbl                                                                                                                             
          DELETE @clientDetails                                                                                                                           
                                                                                                                                                          
          IF @allClients <> 1                                                                                                                             
          BEGIN                                                                                                                                           
              INSERT INTO @clientsTbl SELECT ref.value('@clientId', 'int') FROM @ruleXML.nodes('App_VpnRouterRules/clients') R(ref)                       
              INSERT INTO @clientGroupsTbl SELECT ref.value('@clientGroupId', 'int') FROM @ruleXML.nodes('App_VpnRouterRules/clientGroups') R(ref)        
                                                                                                                                                          
              INSERT INTO @clientsTbl                                                                                                                     
              SELECT DISTINCT AC.id                                                                                                                       
              FROM @clientGroupsTbl as CG                                                                                                                 
              INNER JOIN APP_ClientGroupAssoc ACGA ON CG.id = ACGA.clientGroupId                                                                          
              INNER JOIN APP_CLIENT AC ON AC.id = ACGA.clientId AND AC.releaseId >= 16 AND AC.GUID IS NOT NULL                              
                                                                                                                                                          
              INSERT INTO @clientDetails                                                                                                                  
              SELECT DISTINCT AC.id, AC.name, AC.net_hostname, AC.GUID                                                                                    
              FROM @clientsTbl as C                                                                                                                       
              INNER JOIN APP_CLIENT AC ON AC.id = C.id AND AC.releaseId >= 16 AND AC.GUID IS NOT NULL                                       
          END                                                                                                                                             
                                                                                                                                                          
          IF @allUsers <> 1                                                                                                                               
          BEGIN                                                                                                                                           
              INSERT INTO @usersTbl SELECT ref.value('@userId', 'int') FROM @ruleXML.nodes('App_VpnRouterRules/users') R(ref)                             
              INSERT INTO @userGroupsTbl SELECT ref.value('@userGroupId', 'int') FROM @ruleXML.nodes('App_VpnRouterRules/userGroups') R(ref)              
              INSERT INTO @adGroupsTbl SELECT ref.value('@providerId', 'int'), ref.value('@externalGroupName', 'nvarchar(255)') FROM @ruleXML.nodes('App_VpnRouterRules/adGroups') R(ref)    
              INSERT INTO @userGroupsTbl SELECT UMDS.id FROM @adGroupsTbl as AD INNER JOIN UMDSgroups UMDS ON UMDS.umdsProviderId = AD.id AND UMDS.name = AD.name                         
          END                                                                                                                                             
                                                                                                                                                          
          IF @allClients = 1                                                                                                                              
          BEGIN                                                                                                                                           
              IF @allUsers = 1                                                                                                                            
              BEGIN                                                                                                                                       
                  INSERT INTO @resultTbl VALUES(0, NULL, NULL, NULL, @ruleType, 0, 0, @destinationName, @destinationPorts)                                
              END                                                                                                                                         
              ELSE                                                                                                                                        
              BEGIN                                                                                                                                       
                  INSERT INTO @resultTbl                                                                                                                  
                  SELECT 0, NULL, NULL, NULL, @ruleType, U.id, 0, @destinationName, @destinationPorts                                                     
                  FROM @usersTbl as U                                                                                                                     
                                                                                                                                                          
                  INSERT INTO @resultTbl                                                                                                                  
                  SELECT 0, NULL, NULL, NULL, @ruleType, 0, UG.id, @destinationName, @destinationPorts                                                    
                  FROM @userGroupsTbl as UG                                                                                                               
              END                                                                                                                                         
          END                                                                                                                                             
          ELSE                                                                                                                                            
          BEGIN                                                                                                                                           
              IF @allUsers = 1                                                                                                                            
              BEGIN                                                                                                                                       
                  INSERT INTO @resultTbl                                                                                                                  
                  SELECT DISTINCT CD.id, CD.name, CD.net_hostname, CD.GUID, @ruleType, 0, 0, @destinationName, @destinationPorts                          
                  FROM @clientDetails as CD                                                                                                               
              END                                                                                                                                         
              ELSE                                                                                                                                        
              BEGIN                                                                                                                                       
                  INSERT INTO @resultTbl                                                                                                                  
                  SELECT DISTINCT CD.id, CD.name, CD.net_hostname, CD.GUID, @ruleType, U.id, 0, @destinationName, @destinationPorts                       
                  FROM @clientDetails as CD, @usersTbl as U                                                                                               
                                                                                                                                                          
                  INSERT INTO @resultTbl                                                                                                                  
                  SELECT DISTINCT CD.id, CD.name, CD.net_hostname, CD.GUID, @ruleType, 0, UG.id, @destinationName, @destinationPorts                      
                  FROM @clientDetails as CD, @userGroupsTbl as UG                                                                                         
              END                                                                                                                                         
          END                                                                                                                                             
      FETCH NEXT FROM cur INTO @routerRules, @ruleType                                                                                                    
  END                                                                                                                                                     
  CLOSE  cur                                                                                                                                              
  DEALLOCATE cur
END
ELSE
BEGIN
    INSERT INTO @clientGroupsTbl
    SELECT ACGA.clientGroupId
    FROM APP_ClientGroupAssoc as ACGA
INNER JOIN APP_ClientGroup ACG ON ACG.id = ACGA.clientGroupId AND ACGA.clientId = @clientId AND (ACG.flag & 0x8000) = 0x8000
    DECLARE @pickClientGroup INT = 0
    SET @pickClientGroup = (SELECT TOP 1 id from @clientGroupsTbl)
    IF @pickClientGroup IS NOT NULL AND @pickClientGroup <> 0
    BEGIN
		DECLARE cur CURSOR STATIC FOR SELECT routerRules, ruleType FROM APP_FirewallVpnRouter WHERE routerClientGroupId = @pickClientGroup
OPEN cur                                                                                                                                                
  FETCH NEXT FROM cur INTO @routerRules, @ruleType                                                                                                        
      WHILE @@FETCH_STATUS = 0                                                                                                                            
      BEGIN                                                                                                                                               
          SET @ruleXML = CAST(CAST(@routerRules AS TEXT) AS XML)                                                                                          
          SET @allClients = ISNULL((SELECT ref.value('@allClients', 'int') FROM @ruleXML.nodes('App_VpnRouterRules') R(ref)), 0)                          
          SET @allUsers = ISNULL((SELECT ref.value('@allUsers', 'int') FROM @ruleXML.nodes('App_VpnRouterRules') R(ref)), 0)                              
          SET @destinationName = ISNULL((SELECT ref.value('@destinationName', 'nvarchar(max)') FROM @ruleXML.nodes('App_VpnRouterRules') R(ref)), '*')    
          SET @destinationPorts = ISNULL((SELECT ref.value('@destinationPorts', 'nvarchar(max)') FROM @ruleXML.nodes('App_VpnRouterRules') R(ref)), '')   
                                                                                                                                                          
          DELETE @clientsTbl                                                                                                                              
          DELETE @clientGroupsTbl                                                                                                                         
          DELETE @usersTbl                                                                                                                                
          DELETE @userGroupsTbl                                                                                                                           
          DELETE @adGroupsTbl                                                                                                                             
          DELETE @clientDetails                                                                                                                           
                                                                                                                                                          
          IF @allClients <> 1                                                                                                                             
          BEGIN                                                                                                                                           
              INSERT INTO @clientsTbl SELECT ref.value('@clientId', 'int') FROM @ruleXML.nodes('App_VpnRouterRules/clients') R(ref)                       
              INSERT INTO @clientGroupsTbl SELECT ref.value('@clientGroupId', 'int') FROM @ruleXML.nodes('App_VpnRouterRules/clientGroups') R(ref)        
                                                                                                                                                          
              INSERT INTO @clientsTbl                                                                                                                     
              SELECT DISTINCT AC.id                                                                                                                       
              FROM @clientGroupsTbl as CG                                                                                                                 
              INNER JOIN APP_ClientGroupAssoc ACGA ON CG.id = ACGA.clientGroupId                                                                          
              INNER JOIN APP_CLIENT AC ON AC.id = ACGA.clientId AND AC.releaseId >= 16 AND AC.GUID IS NOT NULL                              
                                                                                                                                                          
              INSERT INTO @clientDetails                                                                                                                  
              SELECT DISTINCT AC.id, AC.name, AC.net_hostname, AC.GUID                                                                                    
              FROM @clientsTbl as C                                                                                                                       
              INNER JOIN APP_CLIENT AC ON AC.id = C.id AND AC.releaseId >= 16 AND AC.GUID IS NOT NULL                                       
          END                                                                                                                                             
                                                                                                                                                          
          IF @allUsers <> 1                                                                                                                               
          BEGIN                                                                                                                                           
              INSERT INTO @usersTbl SELECT ref.value('@userId', 'int') FROM @ruleXML.nodes('App_VpnRouterRules/users') R(ref)                             
              INSERT INTO @userGroupsTbl SELECT ref.value('@userGroupId', 'int') FROM @ruleXML.nodes('App_VpnRouterRules/userGroups') R(ref)              
              INSERT INTO @adGroupsTbl SELECT ref.value('@providerId', 'int'), ref.value('@externalGroupName', 'nvarchar(255)') FROM @ruleXML.nodes('App_VpnRouterRules/adGroups') R(ref)    
              INSERT INTO @userGroupsTbl SELECT UMDS.id FROM @adGroupsTbl as AD INNER JOIN UMDSgroups UMDS ON UMDS.umdsProviderId = AD.id AND UMDS.name = AD.name                         
          END                                                                                                                                             
                                                                                                                                                          
          IF @allClients = 1                                                                                                                              
          BEGIN                                                                                                                                           
              IF @allUsers = 1                                                                                                                            
              BEGIN                                                                                                                                       
                  INSERT INTO @resultTbl VALUES(0, NULL, NULL, NULL, @ruleType, 0, 0, @destinationName, @destinationPorts)                                
              END                                                                                                                                         
              ELSE                                                                                                                                        
              BEGIN                                                                                                                                       
                  INSERT INTO @resultTbl                                                                                                                  
                  SELECT 0, NULL, NULL, NULL, @ruleType, U.id, 0, @destinationName, @destinationPorts                                                     
                  FROM @usersTbl as U                                                                                                                     
                                                                                                                                                          
                  INSERT INTO @resultTbl                                                                                                                  
                  SELECT 0, NULL, NULL, NULL, @ruleType, 0, UG.id, @destinationName, @destinationPorts                                                    
                  FROM @userGroupsTbl as UG                                                                                                               
              END                                                                                                                                         
          END                                                                                                                                             
          ELSE                                                                                                                                            
          BEGIN                                                                                                                                           
              IF @allUsers = 1                                                                                                                            
              BEGIN                                                                                                                                       
                  INSERT INTO @resultTbl                                                                                                                  
                  SELECT DISTINCT CD.id, CD.name, CD.net_hostname, CD.GUID, @ruleType, 0, 0, @destinationName, @destinationPorts                          
                  FROM @clientDetails as CD                                                                                                               
              END                                                                                                                                         
              ELSE                                                                                                                                        
              BEGIN                                                                                                                                       
                  INSERT INTO @resultTbl                                                                                                                  
                  SELECT DISTINCT CD.id, CD.name, CD.net_hostname, CD.GUID, @ruleType, U.id, 0, @destinationName, @destinationPorts                       
                  FROM @clientDetails as CD, @usersTbl as U                                                                                               
                                                                                                                                                          
                  INSERT INTO @resultTbl                                                                                                                  
                  SELECT DISTINCT CD.id, CD.name, CD.net_hostname, CD.GUID, @ruleType, 0, UG.id, @destinationName, @destinationPorts                      
                  FROM @clientDetails as CD, @userGroupsTbl as UG                                                                                         
              END                                                                                                                                         
          END                                                                                                                                             
      FETCH NEXT FROM cur INTO @routerRules, @ruleType                                                                                                    
  END                                                                                                                                                     
  CLOSE  cur                                                                                                                                              
  DEALLOCATE cur
    END
END
SELECT DISTINCT * from @resultTbl
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetVpnRouter')
	delete from GxQscripts where name = 'APPGetVpnRouter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetVpnRouter')
	delete from GXDBVersions where aliasname = 'APPGetVpnRouter'
GO

insert into GXDBVersions values(2, 'APPGetVpnRouter',  '00000000000000000000', 'APPGetVpnRouter', '00000000000000000000')
GO

