

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetVpnClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2015  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetVpnClient.sp,v $ $Id: APPGetVpnClient.sp,v 1.3.12.2 2018/03/22 01:50:10 jiechen Exp $";
--		This SP takes clientId as input and returns the VPN Client rules as per below algo.
--		1. If VPN Client is enabled for this clientId
--			a. Return all rules specified for this clientId only.
--		2. If VPN Client is not enabled for this clientId, pick one client group to which this client belongs to and which has VPN Client enabled at the group level.
--			a. Return all rules specified against that client group only.
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetVpnClient <<<'

IF EXISTS (select * from sysobjects where name='APPGetVpnClient')
	drop procedure APPGetVpnClient
IF EXISTS (select * from GxQscripts where name='APPGetVpnClient')
	delete from GxQscripts where name = 'APPGetVpnClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetVpnClient')
	delete from GXDBVersions where aliasname = 'APPGetVpnClient'
GO
print '... Creating Procedure: APPGetVpnClient'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure APPGetVpnClient
  @clientId INT
AS
  DECLARE @o_clientId INT
  DECLARE @o_clientName nvarchar(255)
  DECLARE @o_clientHostName nvarchar(255)
  DECLARE @o_clientGUID nvarchar(255)
  DECLARE @o_pattern nvarchar(max)
  DECLARE @o_resolvable tinyint
  DECLARE @o_connectDirectly tinyint
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE	@resultTbl				TABLE(id INT, name nvarchar(255), hostName nvarchar(255), GUID nvarchar(255), pattern nvarchar(max), resolvable tinyint, connectDirectly tinyint)
DECLARE	@row					INT
DECLARE	@pattern				nvarchar(max)
DECLARE	@resolvable				tinyint
DECLARE	@connectDirectly		tinyint
DECLARE	@rcid					INT
DECLARE	@rcgid					INT
DECLARE	@id						INT
DECLARE	@name					nvarchar(255)
DECLARE	@hostName				nvarchar(255)
DECLARE	@GUID					nvarchar(255)
DECLARE @VpnClientEnabled		INT = 0
SET @VpnClientEnabled = (SELECT attrVal FROM APP_clientProp WHERE attrName='VPNEnableClient' AND componentNameId = @clientId AND modified = 0)
IF @VpnClientEnabled IS NOT NULL AND @VpnClientEnabled <> 0
BEGIN
    DECLARE cur CURSOR STATIC FOR SELECT id, pattern, resolvable, connectDirectly, routerClientId, routerClientGroupId FROM APP_FirewallVpnclient WHERE clientId = @clientId
OPEN cur                                                                                                                                                
  FETCH NEXT FROM cur INTO @row, @pattern, @resolvable, @connectDirectly, @rcid, @rcgid                                                                   
  WHILE @@FETCH_STATUS = 0                                                                                                                                
  BEGIN                                                                                                                                                   
      IF @rcid = 0 AND @rcgid = 0 AND @connectDirectly = 1                                                                                                
      BEGIN                                                                                                                                               
          INSERT INTO @resultTbl VALUES(0, NULL, NULL, NULL, @pattern, @resolvable, @connectDirectly)                                                     
      END                                                                                                                                                 
      ELSE IF @rcid <> 0                                                                                                                                  
      BEGIN                                                                                                                                               
          SET @id = 0                                                                                                                                     
          SET @name = NULL                                                                                                                                
          SET @hostName = NULL                                                                                                                            
          SET @guid = NULL                                                                                                                                
          SELECT @id = id, @name = name, @hostName = net_hostname, @guid = GUID FROM APP_CLIENT WHERE id = @rcid AND releaseId >= 16        
          IF @guid IS NOT NULL                                                                                                                            
              INSERT INTO @resultTbl VALUES(@id, @name, @hostName, @guid, @pattern, @resolvable, @connectDirectly)                                        
      END                                                                                                                                                 
      ELSE IF @rcgid <> 0                                                                                                                                 
      BEGIN                                                                                                                                               
          INSERT INTO @resultTbl                                                                                                                          
          SELECT AC.id, AC.name, AC.net_hostname, AC.GUID, T.pattern, T.resolvable, T.connectDirectly                                                     
          FROM APP_FirewallVpnclient as T                                                                                                                 
          INNER JOIN APP_ClientGroupAssoc ACGA ON T.id = @row AND T.routerClientGroupId = ACGA.clientGroupId                                              
          INNER JOIN APP_CLIENT AC ON AC.id = ACGA.clientId AND AC.releaseId >= 16 AND AC.GUID IS NOT NULL                                  
      END                                                                                                                                                 
      FETCH NEXT FROM cur INTO @row, @pattern, @resolvable, @connectDirectly, @rcid, @rcgid                                                               
  END                                                                                                                                                     
  CLOSE  cur                                                                                                                                              
  DEALLOCATE cur
END
ELSE
BEGIN
    DECLARE @clientGroupTbl TABLE(id INT)
    INSERT INTO @clientGroupTbl
    SELECT ACGA.clientGroupId
    FROM APP_ClientGroupAssoc as ACGA
INNER JOIN APP_ClientGroup ACG ON ACG.id = ACGA.clientGroupId AND ACGA.clientId = @clientId AND (ACG.flag & 0x4000) = 0x4000
    DECLARE @pickClientGroup INT = 0
    SET @pickClientGroup = (SELECT TOP 1 id from @clientGroupTbl)
    IF @pickClientGroup IS NOT NULL AND @pickClientGroup <> 0
    BEGIN
        DECLARE cur CURSOR STATIC FOR SELECT id, pattern, resolvable, connectDirectly, routerClientId, routerClientGroupId FROM APP_FirewallVpnclient WHERE clientGroupId = @pickClientGroup
OPEN cur                                                                                                                                                
  FETCH NEXT FROM cur INTO @row, @pattern, @resolvable, @connectDirectly, @rcid, @rcgid                                                                   
  WHILE @@FETCH_STATUS = 0                                                                                                                                
  BEGIN                                                                                                                                                   
      IF @rcid = 0 AND @rcgid = 0 AND @connectDirectly = 1                                                                                                
      BEGIN                                                                                                                                               
          INSERT INTO @resultTbl VALUES(0, NULL, NULL, NULL, @pattern, @resolvable, @connectDirectly)                                                     
      END                                                                                                                                                 
      ELSE IF @rcid <> 0                                                                                                                                  
      BEGIN                                                                                                                                               
          SET @id = 0                                                                                                                                     
          SET @name = NULL                                                                                                                                
          SET @hostName = NULL                                                                                                                            
          SET @guid = NULL                                                                                                                                
          SELECT @id = id, @name = name, @hostName = net_hostname, @guid = GUID FROM APP_CLIENT WHERE id = @rcid AND releaseId >= 16        
          IF @guid IS NOT NULL                                                                                                                            
              INSERT INTO @resultTbl VALUES(@id, @name, @hostName, @guid, @pattern, @resolvable, @connectDirectly)                                        
      END                                                                                                                                                 
      ELSE IF @rcgid <> 0                                                                                                                                 
      BEGIN                                                                                                                                               
          INSERT INTO @resultTbl                                                                                                                          
          SELECT AC.id, AC.name, AC.net_hostname, AC.GUID, T.pattern, T.resolvable, T.connectDirectly                                                     
          FROM APP_FirewallVpnclient as T                                                                                                                 
          INNER JOIN APP_ClientGroupAssoc ACGA ON T.id = @row AND T.routerClientGroupId = ACGA.clientGroupId                                              
          INNER JOIN APP_CLIENT AC ON AC.id = ACGA.clientId AND AC.releaseId >= 16 AND AC.GUID IS NOT NULL                                  
      END                                                                                                                                                 
      FETCH NEXT FROM cur INTO @row, @pattern, @resolvable, @connectDirectly, @rcid, @rcgid                                                               
  END                                                                                                                                                     
  CLOSE  cur                                                                                                                                              
  DEALLOCATE cur
    END
END
SELECT * from @resultTbl
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetVpnClient')
	delete from GxQscripts where name = 'APPGetVpnClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetVpnClient')
	delete from GXDBVersions where aliasname = 'APPGetVpnClient'
GO

insert into GXDBVersions values(2, 'APPGetVpnClient',  '00010003001200020000', 'APPGetVpnClient', '00010003001200020000')
GO

