

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetVirtualMachineOptionsForAutoProxy.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetVirtualMachineOptionsForAutoProxy.sp,v $ $Id: APPGetVirtualMachineOptionsForAutoProxy.sp,v 1.1.2.14.6.1 2021/01/22 22:01:06 ishaarora Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetVirtualMachineOptionsForAutoProxy"
--	|	Generates list of VirtualMachineOptions for a given AutoProxy jobId
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetVirtualMachineOptionsForAutoProxy')
BEGIN
	print '>>> Drop Stored Procedure: AppGetVirtualMachineOptionsForAutoProxy <<<'
	drop procedure AppGetVirtualMachineOptionsForAutoProxy
END
IF EXISTS (select * from GxQscripts where name='AppGetVirtualMachineOptionsForAutoProxy')
	delete from GxQscripts where name = 'AppGetVirtualMachineOptionsForAutoProxy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVirtualMachineOptionsForAutoProxy')
	delete from GXDBVersions where aliasname = 'AppGetVirtualMachineOptionsForAutoProxy'
GO
print '... Creating Procedure: AppGetVirtualMachineOptionsForAutoProxy'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetVirtualMachineOptionsForAutoProxy
-- Input arguments
  @i_jobId INT
AS
  DECLARE @o_xml XML
BEGIN TRY
	declare @vsaClientId int
	declare @instanceId int
	declare @errorCode   int = 0
	declare @errorString  nvarchar(1024)
	declare @parentJobId int
	--------Policy Info------------
	declare @policyId   int
	declare @policyType  int
	declare @policyName  nvarchar(1024)
	declare @vmInstanceType nvarchar(1024)
	declare @iamRoleName nvarchar(1024)
	declare @createPublicIp int
	declare @hostName nvarchar(1024)
	--------------------------------
	-------------Constansts---------
	declare @WIN_OS int = 1
	declare @LINUX_OS int = 2
	declare @AMAZON_POLICY_TYPE int = 1
	declare @AZURE_POLICY_TYPE int = 7
	---------------------------------
	IF object_id('tempdb.dbo.#tmpCreateProxyVmReq') IS NOT null DROP TABLE #tmpCreateProxyVmReq
			create table #tmpCreateProxyVmReq(
									regionName   nvarchar(1024),
									osType		 int,
									numberOfVmsToCreate	  int
			)
	--Collect request parameters based on the jobId
	declare @jobXml xml
	declare @vmpassword nvarchar(256)
	declare @vmUsername nvarchar(256) ='AutoProxyUser'
	select @vmpassword = newid()
	select @jobXml = xmlValue
	from TM_JobXMLOptions
	where jobId = @i_jobId
	insert into #tmpCreateProxyVmReq
	SELECT
		c.value('(vmInfo/vmLocation/@dataCenterName)[1]','NVARCHAR(1024)'),
		isNull(c.value('(vmInfo/@osType)[1]','int'),@WIN_OS),
		c.value('@numberOfVmsToCreate', 'int')
	FROM @jobXml.nodes('/TMMsg_JobOption/adminOpts/vmProvisioningOption/virtualMachineOption') T(c)
	--Fetch policyId from the vsaClientId
	set @vsaClientId = isNull(@jobXml.value('(/TMMsg_JobOption/adminOpts/vmProvisioningOption/virtualMachineOption[1]/vmInfo/vmLocation/virtualizationClient/@clientId)[1]', 'int'),0)
	-- Fetch parentJobId
	set @parentJobId = isNull(@jobXml.value('(/TMMsg_JobOption/adminOpts/vmProvisioningOption/@parentJobId)[1]', 'int'),0)
	if(@vsaClientId = 0)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'VSA Psudo client Id is missing int the request'
		GOTO ERROR_EXIT
	END
	select TOP 1 @instanceId = instance from APP_Application where clientId = @vsaClientId and appTypeId = 106
	--Check Admin account
	declare @adminInstanceId INT = 0
	select @adminInstanceId = cast (attrVal as int) from APP_InstanceProp where componentNameId = @instanceId and attrName = 'Amazon Admin Instance Id' and modified = 0
	if isNull(@adminInstanceId,0) > 0
	begin
		set @instanceId = @adminInstanceId
		SET @vsaClientId = (SELECT TOP 1 clientId FROM APP_Application WITH(NOLOCK) WHERE instance = @adminInstanceId AND appTypeId = 106)
	end
	select @policyId = cast (attrVal as int) FROM APP_InstanceProp WHERE componentNameId= @instanceId AND attrName='Auto Scale Policy'
	if(isNull(@policyId,0)=0)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'VSA Psudo client Id ['+ @vsaClientId +'] is not associated with Auto Proxy policy'
		GOTO ERROR_EXIT
	END
	--Collect common policy info
	SELECT
		@policyType =  c.value('(entity/@policyType)[1]', 'int'),
		@policyName = c.value('(entity/@vmAllocPolicyName)[1]', 'NVARCHAR(1024)'),
		@vmInstanceType = ISNULL(c.value('(amazonPolicy/instanceType/instanceType/@vmInstanceTypeName)[1]', 'nvarchar(1024)'),'Auto'),
		@iamRoleName = c.value('(roleInfo/@name)[1]', 'nvarchar(1024)'),
		@createPublicIp = ISNULL(c.value('@isPublicIPSettingsAllowed', 'int'),0),
		@hostName = c.value('(esxServers/@esxServerName)[1]','nvarchar(1024)')
	from App_VmAllocationPolicy P
	CROSS APPLY P.vxml.nodes ('policy') T(c)
	where id = @policyId and alive = 1
	IF ( @vmInstanceType = 'Auto')
	begin
		if @policyType =@AMAZON_POLICY_TYPE
         	set @vmInstanceType = 'c4.large'
		else if @policyType = @AZURE_POLICY_TYPE
			set @vmInstanceType = 'Standard_F2s_v2' --changing  Standard_B4ms  to Standard_F2s_v2 as per azure team discussion
	end
	IF object_id('tempdb.dbo.#policyRegionSpecificInfo') IS NOT null DROP TABLE #policyRegionSpecificInfo
			create table #policyRegionSpecificInfo(
									regionName   nvarchar(1024),
									securityGroupXml xml,
									subnetId nvarchar(1024),
									subnetName nvarchar(1024),
									subnetLabel nvarchar(1024),
									networkName nvarchar(1024),
									networkId nvarchar(1024),
									storageAccount nvarchar(1024),
									keyPairName nvarchar(1024)
			)
	--Collect Region specific policy Info
	insert into #policyRegionSpecificInfo
	SELECT
		c.value('@regionName', 'NVARCHAR(1024)'),
		c.query('securityGroups'),
		c.value('@subnetId', 'NVARCHAR(1024)'),
		c.value('@subnetName', 'NVARCHAR(1024)'),
		c.value('@subnetLabel', 'NVARCHAR(1024)'),
		c.value('@networkName', 'NVARCHAR(1024)'),
		c.value('@networkId', 'NVARCHAR(1024)'),
		c.value('@storageAccount','nvarchar(1024)'),
		c.value('@keyPairName','NVARCHAR(1024)')
	FROM App_VmAllocationPolicy P
	CROSS APPLY P.vxml.nodes ('policy') VMP(ref)
	CROSS APPLY ref.nodes('scaleOption/scaleOutParam/regionSpecificInfo') T(c)
	where id = @policyId and alive = 1
	IF object_id('tempdb.dbo.#templateInfo') IS NOT null DROP TABLE #templateInfo
			create table #templateInfo(
									regionName   nvarchar(1024),
									templateName nvarchar(1024),
									templateId nvarchar(1024),
									osType	int
			)
	declare @cloudTemplatesXML xml
	select @cloudTemplatesXML = cast(value as XML)  from GXGlobalParam where name = 'CVCloudVMTemplates' and modified =0
	--Collect Template Information
	if @policyType = @AMAZON_POLICY_TYPE
	BEGIN
		insert into #templateInfo
		select
			c.value('@region', 'nvarchar(1024)'),
			c.value('@name', 'nvarchar(1024)'),
			c.value('@id', 'nvarchar(1024)'),
			c.value('@os', 'int')
			from @cloudTemplatesXML.nodes('CloudVMTemplates/Amazon/Template') as T(c)
	END
	set @o_xml = '<TMMsg_VMProvisioningOption/>'
	-- Traverse the createProxyRequest row by row using cursor.
	-- For every row, based on the number of vms to create, populate the required virtualMachineOptions
	DECLARE @currRegion nvarchar(1024)
	DECLARE @currOsType int
	DECLARE @currNoOfVmsToCreate int
	DECLARE @vmSuffixId int = 1
	DECLARE proxyReqCursor CURSOR
	FOR
		SELECT regionName, osType, numberOfVmsToCreate FROM #tmpCreateProxyVmReq
	OPEN proxyReqCursor
	FETCH NEXT FROM proxyReqCursor INTO @currRegion, @currOsType, @currNoOfVmsToCreate
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF object_id('tempdb.dbo.#tmpVmInfo') IS NOT null DROP TABLE #tmpVmInfo
			create table #tmpVmInfo(
							vmName nvarchar(1024)
			)
		if(	@currNoOfVmsToCreate = 1)
		BEGIN
			insert into #tmpVmInfo
			select 'cvautoproxy'  + cast(@i_jobId as nvarchar(1024))
		END
		ELSE
		BEGIN
			declare @i int =1
			While ( @i <= @currNoOfVmsToCreate)
			BEGIN
				insert into #tmpVmInfo
				select 'cvautoproxy' + cast(@i_jobId as nvarchar(1024)) + cast(@vmSuffixId as nvarchar(1024))
				set @vmSuffixId = @vmSuffixId + 1
				set @i = @i + 1
			END
		END
		declare @operatingSystem nvarchar(1024)
		if @currOsType = @WIN_OS
			set @operatingSystem = 'Windows'
			set @vmUsername = 'administrator'
		if @currOsType = @LINUX_OS
		BEGIN
			set @operatingSystem = 'Linux'
			set @vmUsername = 'root'
		END
		DECLARE @restoreAsManagedVM int = 0
		if @policyType = @AZURE_POLICY_TYPE
		BEGIN
			set @vmUsername = 'AutoProxyUser'
			set @restoreAsManagedVM = 1
		END
		set @o_xml =  (select @parentJobId '@parentJobId', (select @i_jobId  '@jobId', @createPublicIp '@createPublicIp',@restoreAsManagedVM '@restoreAsManagedVM',
						(select @policyId '@vmAllocPolicyId', @policyName '@vmAllocPolicyName', @policyType '@policyType', @instanceId '@instanceId'
							FOR XML PATH  ('vmAllocPolicy') , TYPE),
						(select  T.templateId as '@vmGUID',
								 T.templateName as '@vmName'
							FOR XML PATH ('vmEntity') , type),
							(select @vmUsername '@userName',
							@vmpassword '@password'
							FOR XML PATH ('password'), TYPE),
						(
						  select @operatingSystem '@operatingSystem',
								 @currOsType '@osType',
								 P.keyPairName '@keyPairName',
								 @policyId '@vmAllocPolicyId',
								 '1' '@numberOfNICs',
							(select @vmInstanceType '@vmInstanceTypeName'
								FOR XML PATH ('instanceTypeEntity'), TYPE),
							(select @hostName '@hostName', @currRegion '@dataCenterName',
							        (select P.storageAccount '@name'
									  for xml path('datastore'), TYPE)
								FOR XML PATH ('vmLocation'), TYPE),
							(select vmName as '@vmName'
								FOR XML PATH ('vm') , type),
							P.securityGroupXml.query('/node()') ,
							 (select
								(   select P.networkName as '@networkName',
										(select P.subnetId as '@name' FOR XML PATH ('subnetNames') , type)
											FOR XML PATH ('networkCards'), TYPE)
									 FOR XML PATH ('advancedProperties'), TYPE),
							 (select @iamRoleName '@name'
								FOR XML PATH ('roleInfo'), TYPE)
							FOR XML PATH  ('vmInfo') , TYPE)
						from #tmpVmInfo
						left join #policyRegionSpecificInfo P on P.regionName = @currRegion
						left join #templateInfo T on T.regionName = @currRegion and T.osType = @currOsType
					FOR XML PATH ('virtualMachineOption'), TYPE) for XML PATH ('TMMsg_VMProvisioningOption'))
		FETCH NEXT FROM proxyReqCursor INTO  @currRegion, @currOsType, @currNoOfVmsToCreate
	END
	CLOSE proxyReqCursor
	DEALLOCATE proxyReqCursor
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SET @errorCode = ERROR_NUMBER()
SET @errorString = ERROR_MESSAGE()
END CATCH
ERROR_EXIT:
IF @errorCode <> 0
BEGIN
	SET @o_xml = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
                            FOR XML PATH('Ida_GenericResp'), TYPE)
END
select @o_xml as 'o_xml'
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetVirtualMachineOptionsForAutoProxy')
	delete from GxQscripts where name = 'APPGetVirtualMachineOptionsForAutoProxy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetVirtualMachineOptionsForAutoProxy')
	delete from GXDBVersions where aliasname = 'APPGetVirtualMachineOptionsForAutoProxy'
GO

insert into GXDBVersions values(2, 'APPGetVirtualMachineOptionsForAutoProxy',  'v1.1.2.14.6.1', 'APPGetVirtualMachineOptionsForAutoProxy', 'v1.1.2.14.6.1')
GO

