

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetVirtualMachineOptions.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetVirtualMachineOptions.sp,v $ $Id: APPGetVirtualMachineOptions.sp,v 1.1.2.43 2020/12/29 21:27:05 ssanakkayala Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "GetDataCenterList"
--	|	This Procedure is used to get the list of available data centers
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='APPGetVirtualMachineOptions')
BEGIN
	print '>>> Drop Stored Procedure: APPGetVirtualMachineOptions <<<'
	drop procedure APPGetVirtualMachineOptions
END
IF EXISTS (select * from GxQscripts where name='APPGetVirtualMachineOptions')
	delete from GxQscripts where name = 'APPGetVirtualMachineOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetVirtualMachineOptions')
	delete from GXDBVersions where aliasname = 'APPGetVirtualMachineOptions'
GO
print '... Creating Procedure: APPGetVirtualMachineOptions'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure APPGetVirtualMachineOptions
-- Input arguments
  @request XML,
  @jobId INT
AS
  DECLARE @o_xml XML
  DECLARE @vm_xml XML
  DECLARE @ph_xml XML
  DECLARE @vmOp_xml XML
  DECLARE @networkOp_xml XML
BEGIN TRY
	--set @request = '<CvEntities_VirtualAppEntity vAppId="71" vAppName="Lab1_Model" />'
	SET NOCOUNT ON
	declare @vAppId		int
	declare @vAppName	nvarchar(256)
	declare @vAppXml		XML
	declare @policyId   int
	declare @policyName nvarchar(255)
	declare @policyType  int
	declare @errorCode   int
	declare @errorString  nvarchar(1024)
	declare @isVirtualLab int
	declare @taskId int
	declare @subTaskId int
	declare @taskXML xml
	declare @powerOnVirtualLabAfterRestore int =1
	declare @operationTypeFromVapp int -- 1 = LiveMount , 16 = Failover , 32 = Virtual Lab
	-- when run from web console these values need to be fetched from job options
	declare @labName nvarchar(256)
	declare @labDescription nvarchar(256)
	declare @opType int
	DECLARE @expirationTime     BIGINT
	DECLARE @labPropList xml
	declare @networkName nvarchar(max)
	declare @vappSource int = 0 -- 0 = Backup, 1= Replication , 2 = Templates
	declare @cloneFromOsDisk nvarchar(255) = 'false'
	declare @dataStoreName nvarchar(1024)
	declare @networkXmlFromPolicy xml
	declare @subnetId nvarchar(max)
	declare @validationSubclientId int = 0
	declare @validationClientId int = 0
	declare @useSourceESXMount int = 0
	declare @virtualizationClientId int =0
	declare @replicationType  int =0
	declare @copyId int
	declare @validationBrowseTime bigint
	select top 1 @taskId = taskId,
	       @subTaskId = subTaskId
	FROM TM_JobOptions with (nolock)
	where jobid = @jobId
	order by taskid desc
	select @labName = isnull(xmlValue.value('(/TMMsg_JobOption/adminOpts/vmProvisioningOption/virtualMachineOption/vmInfo/advancedProperties/@labName)[1]', 'nvarchar(256)'),''),
		   @labDescription = isnull(xmlValue.value('(/TMMsg_JobOption/adminOpts/vmProvisioningOption/virtualMachineOption/vmInfo/@purpose)[1]', 'nvarchar(256)'),''),
		   @expirationTime = isnull(xmlValue.value('(/TMMsg_JobOption/adminOpts/vmProvisioningOption/virtualMachineOption/vmInfo/expirationTime/@time)[1]', 'BIGINT'),0),
           @labPropList = xmlValue.query('/TMMsg_JobOption/adminOpts/vmProvisioningOption/virtualMachineOption/vmInfo/advancedProperties/customVMParams'),
		   @opType = isnull(xmlValue.value('(/TMMsg_JobOption/adminOpts/vmProvisioningOption/@operationType)[1]','int'),23), -- default is livemount
		   @validationSubclientId = isnull(xmlValue.value('(/TMMsg_JobOption/adminOpts/vmProvisioningOption/validationEntity/@subclientId)[1]', 'int'),0),
		   @validationClientId = isnull(xmlValue.value('(/TMMsg_JobOption/adminOpts/vmProvisioningOption/validationEntity/@clientId)[1]', 'int'),0),
		   @validationBrowseTime = xmlValue.value('(/TMMsg_JobOption/adminOpts/vmProvisioningOption/virtualMachineOption/oneTouchResponse/dataBrowseTime/@time)[1]', 'BIGINT')
	from TM_JobXMLOptions with (nolock)
	where taskId = @taskId and subTaskId = @subTaskId
	select @vAppId = @request.value('/CvEntities_VirtualAppEntity[1]/@vAppId', 'int')
	select @vAppXml =vxml, @vAppName = name
	from App_VirtualApp
	where id = @vAppId
	-- if lab name is empty, we set the default name
	IF @labName =''
			SET @labName = @vAppName+'_'+cast(@jobId as varchar(255))
    select @operationTypeFromVapp = isnull(@vAppXml.value('Api_VirtualAppReq[1]/vApp[1]/@operationType', 'int'),1)
	select @isVirtualLab = isnull(@vAppXml.value('Api_VirtualAppReq[1]/vApp[1]/@isVirtualLab', 'int'),0)
	select @vappSource = isnull(@vAppXml.value('Api_VirtualAppReq[1]/vApp[1]/@source', 'int'),0)
	select @replicationType = isnull(@vAppXml.value('Api_VirtualAppReq[1]/vApp[1]/@replicationType', 'int'),0)
	select @copyId = isnull(@vAppXml.value('Api_VirtualAppReq[1]/vApp[1]/arrayReplication[1]/@copyId', 'int'),0)
	IF object_id('tempdb.dbo.#tmpClientList') IS NOT null DROP TABLE #tmpClientList
	create table #tmpClientList(
								clientId				int,
								name			nvarchar(255),
								GUID			nvarchar(255),
								backupsetId				int
	)
	IF ( @isVirtualLab = 0)
	BEGIN
		select @policyId = isnull(P.value('@vmAllocPolicyId', 'int'),0),
		   @policyName = P.value('@vmAllocPolicyName', 'nvarchar(255)'),
		   @policyType = P.value('@policyType', 'int')
		FROM @vAppXml.nodes('Api_VirtualAppReq/vApp/policy/entity') V(P)
	END
	ELSE
	BEGIN
		select @policyId = isnull(P.value('vmPolicy[1]/@vmAllocPolicyId', 'int'),0),
			   @policyName = P.value('vmPolicy[1]/@vmAllocPolicyName', 'nvarchar(255)'),
			   @policyType = P.value('vmPolicy[1]/@policyType', 'int'),
			   @powerOnVirtualLabAfterRestore = P.value('@powerOnVirtualLabAfterRestore', 'int')
		FROM @vAppXml.nodes('Api_VirtualAppReq/vApp/config') V(P)
	END
	IF @validationClientId > 0
	BEGIN
set @validationSubclientId = ( select top 1 attrval from app_clientprop where attrName = 'VSA Discover Subclient ID'  and componentNameId = @validationClientId and modified = 0 order by id desc)
		-- If VM is removed from VMGroup try checking with LastBackupSubclient
		If isnull(@validationSubclientId,0) =0
		BEGIN
		set @validationSubclientId = (select top 1 attrval from app_clientprop where attrName ='Last Backup Subclient'  and componentNameId = @validationClientId and modified = 0 order by id desc)
		END
	END
	IF @validationSubclientId > 0
	BEGIN
if not exists ( select attrval from APP_SubClientProp where attrname = 'VS App Validation' and attrval = '1' and modified =0 and componentNameId = @validationSubclientId)
		begin
SET @errorCode = (177 | (CAST(POWER(2, 24) AS BIGINT) * 72))
SET @errorString = dbo.fn_EvFormatEventMsgText(0, 0, (177 | (CAST(POWER(2, 24) AS BIGINT) * 72)), 0, 2);
	            GOTO ERROR_EXIT
		end
		SET @useSourceESXMount = ISNULL((select attrval from APP_SubClientProp where attrname = 'Use Source ESX Mount' and modified =0 and componentNameId = @validationSubclientId), 0)
		IF @useSourceESXMount = 0
		BEGIN
			select @policyId = vmp.id, @policyType = vmp.vxml.value('(/policy/entity/@policyType)[1]','int'),
			@policyName = vmp.name from app_vmallocationpolicy vmp
			inner join APP_SubClientProp sp
			on sp.attrName ='Validation Policy Id'
			and sp.modified =0
			and vmp.id = sp.attrVal
			and sp.componentNameId = @validationSubclientId
		END
	END
	IF object_id('tempdb.dbo.#tmpReplicationPairs') IS NOT null DROP TABLE #tmpReplicationPairs
	create table #tmpReplicationPairs(
							sourceGuid			nvarchar(255),
							sourceName			nvarchar(255),
							destGuid			nvarchar(255),
							destName			nvarchar(255),
							vmName				nvarchar(255),
							groupId				int,
							replicationId		int
	)
	declare @isIsolateNetwork int = 0
	declare @restoreNetworkName nvarchar(max)
	-- execute only if vappSource is based on templates
	if @vappSource = 2
	begin
		if @policyId = 0
		BEGIN
			SET @errorCode = 1
            SET @errorString = 'Failover/DevTest group is not associated with a VM Target Policy'
            GOTO ERROR_EXIT
        END
		IF object_id('tempdb.dbo.#tmpVMOpReq') IS NOT null DROP TABLE #tmpVMOpReq
		create table #tmpVMOpReq(
								templateGuid			nvarchar(255),
								templateName			nvarchar(255),
								vmName					nvarchar(255),
								vmInstanceType			nvarchar(255),
								groupId					  int,
								privateIpPreferenceOrder  int,
								guestScript				  nvarchar(MAX),
								guestScriptType			  int,
								createPublicIp			  int,
								privateIpAddress		  nvarchar(255)
		)
		insert into #tmpVMOpReq(templateGuid,templateName,vmInstanceType,groupId,privateIpPreferenceOrder,guestScript,guestScriptType,createPublicIp,privateIpAddress)
		select c.value('vmInfo[1]/@vmGUID', 'nvarchar(256)'), c.value('vmInfo[1]/@vmName', 'nvarchar(256)'),
			   isnull(c.value('vmInfo[1]/@amazonInstanceId', 'nvarchar(256)'),''),
			   c.value('parent::*/@groupId', 'int'),
			   isnull(c.value('@privateIpPreferenceOrder','int'),0),
			   isnull(c.value('postScript[1]/@scriptContent','nvarchar(MAX)'),''),
			   isnull(c.value('postScript[1]/@type','int'),0),
			   isnull(c.value('@createPublicIp','int'),0),
			   isnull(c.value('networkCards[1]/@privateIPAddress','nvarchar(256)'),'')
		FROM  @vAppXML.nodes('/Api_VirtualAppReq/vApp/config/vmGroups/vmSequence') N(C)
		declare @vsInstanceId	int = 0
		declare @dataCenterId	int
		declare @datacenterName nvarchar(255)
		declare @hostName  nvarchar(255)
		declare @keyPair		nvarchar(255)
		declare @rsaKey nvarchar(max)
		declare @daysRetainUntil int
		declare @securityGroups xml
		declare @subNetworkXml xml
		SELECT @vsInstanceId =  DCM.instanceId,
			@dataCenterId = DC.id,
			@datacenterName = DC.name,
			@hostName = VH.name,
			@networkXmlFromPolicy = P.vxml.query('policy/networkInfo'),
			@keyPair = kp.value('@keyPairName', 'NVARCHAR(255)'),
			@daysRetainUntil = ref.value('@daysRetainUntil','int'),
			@dataStoreName = D.name,
			@securityGroups = P.vxml.query('policy/securityGroups')
		FROM App_VmAllocationPolicy P
		INNER JOIN App_VMAllocationPolicyProp PP1 ON P.id = PP1.componentNameId and (PP1.attrName = 'availabilityZones' or PP1.attrName = 'esxserver')
		INNER JOIN APP_VMHost VH on VH.id = cast(PP1.attrVal as int)
		INNER JOIN APP_VMDataCenter DC on P.vDataCenterId = DC.id
		INNER JOIN App_VMDataCenterMap DCM ON DCM.vDataCenterId = DC.id
        INNER JOIN APP_InstanceProp IP ON DCM.instanceId = IP.componentNameId AND IP.attrName = 'Virtual Server Instance Type' AND IP.modified = 0
		LEFT JOIN App_VMAllocationPolicyProp PP2 ON P.id = PP2.componentNameId and PP2.attrName = 'datastore'
		LEFT JOIN APP_VMDataStore D on D.id = cast(PP2.attrVal as int)
		CROSS APPLY P.vxml.nodes ('policy') VMP(ref)
		OUTER APPLY ref.nodes('amazonPolicy/keyPair') KP(kp)
		WHERE P.id = @policyId
		if @networkXmlFromPolicy is null or  @networkXmlFromPolicy.exist('*') = 0
        BEGIN
            SET @errorCode = 1
            SET @errorString = 'Test Network is not configured in Vm Target Policy [' + @policyName + ']'
            GOTO ERROR_EXIT
        END
		set @networkName = isnull(@networkXmlFromPolicy.value('(/networkInfo/@networkName)[1]', 'nvarchar(255)'),'')
		if @policyType = 1 --Amazon Specific
		BEGIN
			-- Get RSA value from given key pair name
			IF(@keyPair IS not null)
			BEGIN
			  Select @rsaKey = rsaPrivateKey FROM App_VMKeyPairs where name = @keyPair AND vDataCenterId = @dataCenterId
			  IF (  @rsaKey IS null)
			  BEGIN
				 SET @errorCode = (128 | (CAST(POWER(2, 24) AS BIGINT) * 72))
				 SET @errorString = 'Failed to find RSA Key for keyPair name provided in Allocation Policy'
				 GOTO ERROR_EXIT
				END
			END
			ELSE
			BEGIN
				SET @errorCode = (128 | (CAST(POWER(2, 24) AS BIGINT) * 72))
				SET @errorString = 'Key Pair is not a member of the Allocation Policy'
				GOTO ERROR_EXIT
			END
			-- update script tags based on script type
			update #tmpVMOpReq
			set guestScript = case
							when guestScriptType = 2
							then '<powershell>' + guestScript + '</powershell>'
							when guestScriptType = 3
							then '<script>' + guestScript + '</script>'
						  end
			--set subNetworkXml
			set @subNetworkXml = (select @labName as '@name' FOR XML PATH ('subnetNames') , type)
		END
		if @policyType = 7 -- Azure specific
		BEGIN
			set @cloneFromOsDisk = 'true'
			--set subNetworkXml
			set @subNetworkXml = @networkXmlFromPolicy.query('/node()[1]/node()')
			-- If user has selected new network option , subnet id would be empty. so network name needs to be appended with job id so that
			-- multiple networks can be created with the given network name in the policy.
			set @subnetId = isnull(@networkXmlFromPolicy.value('(/networkInfo/subnetNames[1]/@subnetId)[1]', 'nvarchar(255)'),'')
			if @subnetId = ''
				set @networkName = @networkName + '_'+cast(@jobId as nvarchar(255))
		END
		update #tmpVMOpReq
		set vmName = templateName +'_'+cast(@jobId as varchar(255)),
			vmInstanceType = IsNULL(NULLIF((SUBSTRING(vmInstanceType, CHARINDEX('(', vmInstanceType + '(') + 1,
							 CHARINDEX(')', vmInstanceType + '()') - CHARINDEX('(', vmInstanceType + '(') - 1)),''),vmInstanceType)
		if @expirationTime = 0 and @daysRetainUntil > 0
			set @expirationTime = dbo.GetUnixTime (GetUTCdate()) + @daysRetainUntil*24 * 60 * 60
		SET @vmOp_xml =
                    (select @jobId  '@jobId',@cloneFromOsDisk '@cloneFromOsDisk', vmOpList.createPublicIp '@createPublicIp',
					(select @policyId '@vmAllocPolicyId', @policyName '@vmAllocPolicyName', @policyType '@policyType', @vsInstanceId '@instanceId'
						FOR XML PATH  ('vmAllocPolicy') , TYPE),
					(select  templateGuid as '@vmGUID',
								templateName as '@vmName'
						FOR XML PATH ('vmEntity') , type),
						(select 'Administrator' '@userName'
						FOR XML PATH ('password'), TYPE),
					(
					  select VM.value('@guestOS', 'nvarchar(1024)') '@operatingSystem',
							 @rsaKey '@rsaPrivateKey',
							 @keyPair '@keyPairName',
							 @labDescription '@purpose',
							 @policyId '@vmAllocPolicyId',
							 '1' '@numberOfNICs',
						(select @expirationTime '@time'
							FOR XML PATH ('expirationTime'), TYPE),
						(select vmOpList.vmInstanceType '@vmInstanceTypeName'
							FOR XML PATH ('instanceTypeEntity'), TYPE),
						(select @datacenterName '@dataCenterName', @hostName '@hostName',
							(select @dataStoreName '@name'
										FOR XML PATH ('datastore'), TYPE)
                            FOR XML PATH ('vmLocation'), TYPE),
						(select vmName as '@vmName'
							FOR XML PATH ('vm') , type),
						@securityGroups,
						 (select @labName as '@labName', groupId as '@vmGroupId',
							(	select guestScript '@scriptContent',guestScriptType '@type'
								FOR XML PATH ('guestScript'), TYPE),
								(select @labPropList FOR XML PATH (''), TYPE),
							(	select @networkName '@networkName', vmOpList.privateIpAddress '@privateIPAddress',
									@subNetworkXml
									FOR XML PATH ('networkCards'), TYPE)
							FOR XML PATH ('advancedProperties'), TYPE
						),
						(select
							(select TOP 1 CASE WHEN ISNULL(ref.value('@summary', 'nvarchar(1024)'), '') <> '' THEN ref.value('@summary', 'nvarchar(1024)')
                                  ELSE ISNULL(ref.value('@volumeId', 'nvarchar(1024)'), '') END 'hardDisk/@label' ,
								  ref.value('@capacityInKb', 'bigint')/(1024*1024) 'hardDisk/@diskSize',
								  '4' 'hardDisk/@srcHdType' -- indicates root hard disk
								FROM hd.nodes('*') O(ref)
								FOR XML PATH (''), TYPE)
							FOR XML PATH ('hardDisks'), TYPE)
						FOR XML PATH  ('vmInfo') , TYPE)
                    FROM  #tmpVMOpReq vmOpList
                    LEFT JOIN App_VM VM ON vmOpList.templateGuid = VM.GUID AND VM.removalTimeStamp IS null
                    OUTER APPLY VM.vxml.nodes ('QSMServer_QVirtualMachineReq') M(vm)
                    OUTER APPLY vm.nodes ('./hardDisks') D(hd)
					order by groupId,privateIpPreferenceOrder
                FOR XML PATH ('virtualMachineOption'))
		SET @networkOp_xml =
			(select @hostName '@hostName' ,
            (SELECT @networkName AS '@networkName',
                 @subNetworkXml
				FOR XML PATH ('network'),type),
			(select @vsInstanceId as '@instanceId' FOR XML PATH ('instance') , type)
		FOR XML PATH ('networkOption')
		)
		SET @vm_xml = (select @vmOp_xml,@networkOp_xml
		FOR XML PATH (''))
	end
	else if @vappSource = 1 and @opType = 34 -- replication source and Virtual Lab operation
	begin
		declare @repScheduleSubTaskId int
		if @policyId = 0
		BEGIN
			SET @errorCode = 1
            SET @errorString = 'Failover/DevTest group is not associated with a VM Target Policy'
            GOTO ERROR_EXIT
        END
		insert into #tmpReplicationPairs(sourceGuid,sourceName,groupId,replicationId)
		select isNull(c.value('vmInfo[1]/@vmGUID', 'nvarchar(256)'),''),
			   isNull(c.value('vmInfo[1]/@vmName', 'nvarchar(256)'),''),
			   isNull(c.value('parent::*/@groupId', 'int'),0),
			   isNull(c.value('@replicationId', 'int'),0)
		FROM  @vAppXML.nodes('/Api_VirtualAppReq/vApp/config/vmGroups/vmSequence') N(C)
		--Fetch replication target details
		select @policyName = P.name,
		@datacenterName =  P.vxml.value('(policy/dataCenter/@dataCenterName)[1]', 'nvarchar(255)'),
		@hostName =  P.vxml.value('(policy/esxServers/@esxServerName)[1]', 'nvarchar(255)'),
		@dataStoreName =  P.vxml.value('(policy/dataStores/@dataStoreName)[1]', 'nvarchar(255)'),
		@virtualizationClientId =  P.vxml.value('(policy/destinationHyperV/@clientId)[1]', 'int'),
		@daysRetainUntil = P.vxml.value('(policy/@daysRetainUntil)[1]','int'),
		@networkXmlFromPolicy = P.vxml.query('policy/networkInfo'),
		@securityGroups = P.vxml.query('policy/securityGroups')
		from App_VmAllocationPolicy P
		where P.id = @policyId
		if @networkXmlFromPolicy is null or  @networkXmlFromPolicy.exist('*') = 0
		BEGIN
			SET @errorCode = 1
            SET @errorString = 'Test Network is not configured in Vm Target Policy [' + @policyName + ']'
            GOTO ERROR_EXIT
        END
		-- get the instance id using the Virtualization Client id.
		select TOP 1 @vsInstanceId = instance from APP_Application where clientId = @virtualizationClientId and appTypeId = 106
		--Fetch destination details and subtaskid from APP_VSAReplication
		update RP
		set RP.destGuid = VSR.destinationGuid,
			RP.destName = VSR.destinationName,
			RP.vmName = VSR.destinationName + '_'+ cast(@jobId as varchar(255)),
			@repScheduleSubTaskId = st.subTaskId
		from #tmpReplicationPairs RP inner join APP_VSAReplication VSR
		on VSR.sourceGuid= RP.sourceGuid and VSR.replicationId = RP.replicationId
		inner join tm_task T on VSR.taskId = T.taskId
		left join TM_SubTask st on T.taskId = st.taskId
		IF object_id('tempdb.dbo.#tmpVmScheduleOptions') IS NOT null DROP TABLE #tmpVmScheduleOptions
		create table #tmpVmScheduleOptions(
								sourceGuid			nvarchar(255),
								createPublicIp		int
		)
		--Fetch vmlevel replication schedule options from the schedule xml
		insert into #tmpVmScheduleOptions(sourceGuid,createPublicIp)
		select ref.value('(@guid)' ,'nvarchar(255)'),
        isnull(ref.value('(@createPublicIP)' ,'int'),0)
        FROM TM_SubTaskXMLOptions st
		CROSS APPLY st.xmlValue.nodes ('/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions') VMOptions(ref)
		where st.subTaskId = @repScheduleSubTaskId
		--set expiry time and lab name if not already set
		if @expirationTime = 0 and @daysRetainUntil > 0
            set @expirationTime = dbo.GetUnixTime (GetUTCdate()) + @daysRetainUntil*24 * 60 * 60
		if @policyType = 7 -- if policy is azure
			set @cloneFromOsDisk = 'true'
		-- If user has selected new network option , subnet id would be empty. so network name needs to be appended with job id so that
		-- multiple networks can be created with the given network name in the policy.
		set @networkName = isnull(@networkXmlFromPolicy.value('(/networkInfo/@networkName)[1]', 'nvarchar(255)'),'')
		set @subnetId = isnull(@networkXmlFromPolicy.value('(/networkInfo/subnetNames[1]/@subnetId)[1]', 'nvarchar(255)'),'')
		if @subnetId = ''
			set @networkName = @networkName + '_'+cast(@jobId as nvarchar(255))
		--create virtualMachineOptions
		SET @vmOp_xml =
                    (select @jobId  '@jobId', @cloneFromOsDisk '@cloneFromOsDisk', VMO.createPublicIp '@createPublicIp',
                    (select @policyId '@vmAllocPolicyId', @policyName '@vmAllocPolicyName', @policyType '@policyType', @vsInstanceId '@instanceId'
                        FOR XML PATH  ('vmAllocPolicy') , TYPE),
                    (select  RPS.destGuid as '@vmGUID',
                                RPS.destName as '@vmName'
                        FOR XML PATH ('vmEntity') , type),
                    (
                      select @labDescription '@purpose',
                             @policyId '@vmAllocPolicyId',
							 '1' '@numberOfNICs',
                        (select @expirationTime '@time'
                            FOR XML PATH ('expirationTime'), TYPE),
                        (select @datacenterName '@dataCenterName', @hostName '@hostName',
							(select @dataStoreName '@name'
								 FOR XML PATH ('datastore'), TYPE)
                            FOR XML PATH ('vmLocation'), TYPE),
                        (select RPS.vmName as '@vmName'
                            FOR XML PATH ('vm') , type),
						 @securityGroups,
                         (select @labName as '@labName', RPS.groupId as '@vmGroupId',
                                (select @labPropList FOR XML PATH (''), TYPE),
							(	select @networkName '@networkName',
								@networkXmlFromPolicy.query('/node()[1]/node()')
								FOR XML PATH ('networkCards'), TYPE)
                            FOR XML PATH ('advancedProperties'), TYPE
                        )
                        FOR XML PATH  ('vmInfo') , TYPE)
                    FROM  #tmpReplicationPairs RPS
					inner join #tmpVmScheduleOptions VMO on VMO.sourceGuid = RPS.sourceGuid
                    order by groupId
                FOR XML PATH ('virtualMachineOption'))
		--create networkOption
		SET @networkOp_xml =
			(select @hostName '@hostName' ,
			--(select replace(cast(@networkXml as nvarchar(max)), 'networkInfo', 'network') FOR XML PATH (''),type),
			(SELECT @networkName AS '@networkName',
				 @networkXmlFromPolicy.query('/node()[1]/node()')
				FOR XML PATH ('network'),type),
			(select @vsInstanceId as '@instanceId' FOR XML PATH ('instance') , type)
		FOR XML PATH ('networkOption')
		)
		SET @vm_xml = (select @vmOp_xml,@networkOp_xml
		FOR XML PATH (''))
	end
	else if  @replicationType =3
	begin
		declare @minutesRetainUntil int
		insert into #tmpReplicationPairs(sourceGuid,sourceName,groupId,replicationId )
		select isNull(c.value('vmInfo[1]/@vmGUID', 'nvarchar(256)'),''),
			   isNull(c.value('vmInfo[1]/@vmName', 'nvarchar(256)'),''),
			   isNull(c.value('parent::*/@groupId', 'int'),0),
			   isNull(c.value('@replicationId', 'int'),0)
		FROM  @vAppXML.nodes('/Api_VirtualAppReq/vApp/config/vmGroups/vmSequence') N(C)
		--Fetch replication target details
		select @policyName = P.name,
		@datacenterName =  P.vxml.value('(policy/dataCenter/@dataCenterName)[1]', 'nvarchar(255)'),
		@hostName =  P.vxml.value('(policy/esxServers/@esxServerName)[1]', 'nvarchar(255)'),
		@dataStoreName =  P.vxml.value('(policy/dataStores/@dataStoreName)[1]', 'nvarchar(255)'),
		@virtualizationClientId =  P.vxml.value('(policy/destinationHyperV/@clientId)[1]', 'int'),
		@daysRetainUntil = P.vxml.value('(policy/@daysRetainUntil)[1]','int'),
		@minutesRetainUntil = P.vxml.value('(policy/@minutesRetainUntil)[1]','int'),
		@securityGroups = P.vxml.query('policy/securityGroups')
		from App_VmAllocationPolicy P
		where P.id = @policyId
		-- get the instance id using the Virtualization Client id.
		select TOP 1 @vsInstanceId = instance from APP_Application where clientId = @virtualizationClientId and appTypeId = 106
		--Fetch destination details and subtaskid from APP_VSAReplication
		update RP
		set RP.destGuid = NULL ,
			RP.destName = RP.sourceName + '_LM' ,
			RP.vmName = RP.sourceName
		from #tmpReplicationPairs RP
		declare @copyPrecedence int
		select @copyPrecedence = copy from archGroupCopy where id = @copyId
		INSERT into #tmpClientList
		SELECT	C.value('@clientId','int'),
				c.value('@clientName', 'nvarchar(256)'),
								isnull(C.value('@clientGUID', 'nvarchar(255)'),''),
				C.value('@backupsetId','int')
		FROM  @vAppXML.nodes('/Api_VirtualAppReq/vApp/clientList') N(C)
		--set existing network label for the virtual lab policy
		SELECT @networkName = vxml.value('/policy[1]/networkNames[1]/@val', 'nvarchar(max)'),
				   @isIsolateNetwork =  isnull(vxml.value('/policy[1]/@createIsolatedNetwork', 'int'), 0)
		FROM App_VmAllocationPolicy p
		WHERE p.id = @policyId
		SELECT @restoreNetworkName = vxml.value('/policy[1]/networkList[1]/@destinationNetwork', 'nvarchar(max)')
		FROM App_VmAllocationPolicy p
		WHERE p.id = @policyId
		--set expiry time and lab name if not already set
		if @expirationTime = 0 and @daysRetainUntil > 0
            set @expirationTime = dbo.GetUnixTime (GetUTCdate()) + @daysRetainUntil*24 * 60 * 60
		if @expirationTime = 0 and  @minutesRetainUntil> 0
            set @expirationTime = dbo.GetUnixTime (GetUTCdate()) + @minutesRetainUntil* 60 * 60
		--create virtualMachineOptions
		SET @vmOp_xml =
                    (SELECT 0 as '@powerOnVM', @jobId  '@jobId', @cloneFromOsDisk '@cloneFromOsDisk',
                    (select @policyId '@vmAllocPolicyId', @policyName '@vmAllocPolicyName', @policyType '@policyType', @vsInstanceId '@instanceId'
                        FOR XML PATH  ('vmAllocPolicy') , TYPE),
					 ( select @copyPrecedence as '@copyPrecedence'
					FOR XML PATH('oneTouchResponse'), TYPE
		 			),
					(select  cl.clientId as '@clientId', RPS.destGuid as '@vmGUID',
                                RPS.vmName as '@vmName'
                        FOR XML PATH ('vmEntity') , type),
                    (
                      select @labDescription '@purpose',
                             @policyId '@vmAllocPolicyId',
							 '1' '@numberOfNICs',
                        (select @expirationTime '@time'
                            FOR XML PATH ('expirationTime'), TYPE),
                        (select @datacenterName '@dataCenterName', @hostName '@hostName',
							(select @dataStoreName '@name'
								 FOR XML PATH ('datastore'), TYPE)
                            FOR XML PATH ('vmLocation'), TYPE),
                        (select RPS.destName as '@vmName'
                            FOR XML PATH ('vm') , type),
						 @securityGroups,
                         (select @labName as '@labName', RPS.groupId as '@vmGroupId',
                                (select @labPropList FOR XML PATH (''), TYPE),
							(	select @networkName '@networkName',
								@networkXmlFromPolicy.query('/node()[1]/node()')
								FOR XML PATH ('networkCards'), TYPE)
                            FOR XML PATH ('advancedProperties'), TYPE
                        )
                        FOR XML PATH  ('vmInfo') , TYPE)
                    FROM  #tmpReplicationPairs RPS
					inner join #tmpClientList cl
					on rps.sourceGuid = cl.GUID
                    order by groupId
                FOR XML PATH ('virtualMachineOption'))
		--create networkOption
		SET @networkOp_xml =
			(select @hostName '@hostName' ,
			--(select replace(cast(@networkXml as nvarchar(max)), 'networkInfo', 'network') FOR XML PATH (''),type),
			(SELECT @networkName AS '@networkName',
				 @networkXmlFromPolicy.query('/node()[1]/node()')
				FOR XML PATH ('network'),type),
			(select @vsInstanceId as '@instanceId' FOR XML PATH ('instance') , type)
		FOR XML PATH ('networkOption')
		)
		SET @vm_xml = (select @vmOp_xml,@networkOp_xml
		FOR XML PATH (''))
	end
	else
	begin
		IF object_id('tempdb.dbo.#tmpVMSequence') IS NOT null DROP TABLE #tmpVMSequence
		create table #tmpVMSequence(
								clientId		int,
								name			nvarchar(255),
								destName		nvarchar(255),
								GUID			nvarchar(255),
								copyPrecedence			int,
								networkLabel	nvarchar(255),
								dataBrowseTime  int,
								hwconfig XML,
								copyId           int,
								copyPrecedenceApplicable int,
								subTaskId int,
								replicationId int,
								enableBootDiskOnly int,
								instanceId			int,
								hostname			nvarchar(255)
		)
		IF object_id('tempdb.dbo.#tmpPhysicalConfig') IS NOT null DROP TABLE #tmpPhysicalConfig
		create table #tmpPhysicalConfig(
								id   int identity(1,1),
     							clientId int,
								name			nvarchar(255),
								destName		nvarchar(255),
								backupsetId		int,
								networkLabel   nvarchar(256),
								oneTouch  XML,
								hwconfig XML,
								dataBrowseTime int,
								enableBootDiskOnly int
		)
		--set existing network label for the virtual lab policy
		if @isVirtualLab = 1
			SELECT @networkName = vxml.value('/policy[1]/networkNames[1]/@val', 'nvarchar(max)'),
				   @isIsolateNetwork =  isnull(vxml.value('/policy[1]/@createIsolatedNetwork', 'int'), 0)
			FROM App_VmAllocationPolicy p
			WHERE p.id = @policyId
			SELECT @restoreNetworkName = vxml.value('/policy[1]/@restoreNetworkName', 'nvarchar(max)')
			FROM App_VmAllocationPolicy p
			WHERE p.id = @policyId
		INSERT into #tmpClientList
		SELECT	C.value('@clientId','int'),
				c.value('@clientName', 'nvarchar(256)'),
				isnull(C.value('@GUID', 'nvarchar(255)'),''),
				C.value('@backupsetId','int')
		FROM  @vAppXML.nodes('/Api_VirtualAppReq/vApp/clientList') N(C)
		INSERT into #tmpVMSequence
		SELECT	'',
				c.value('vmInfo[1]/@vmName', 'nvarchar(256)'),
				'',
				C.value('vmInfo[1]/@vmGUID', 'nvarchar(255)'),
				C.value('@copyPrecedence', 'int'),
				CASE WHEN @operationTypeFromVapp =1 and @isVirtualLab =1 and isnull(@networkName,'')!='' and @isIsolateNetwork = 0  THEN @networkName
				WHEN @operationTypeFromVapp =1 and @isVirtualLab =1 and @isIsolateNetwork = 1 THEN ''
				ELSE C.value('networkCards[1]/@label', 'nvarchar(255)')
				END,
				'',
				'',
				0,
				0,
				0,
				isnull(c.value('@replicationId', 'int'),0),
				isnull(C.value('@enableBootDiskOnly', 'int'),1),
				0,
				''
		FROM  @vAppXML.nodes('/Api_VirtualAppReq/vApp/config/vmGroups/vmSequence') N(C)
		declare @vmapps table ( clientid int, name nvarchar(1024), guid nvarchar(256), appsExists int)
		If(@validationSubclientId > 0)
		BEGIN
			insert into @vmapps
			select 	cp1.componentNameId, c.name , cp1.attrval,  1 FROM APP_Clientprop cp1
				inner join app_client c
				on c.id = cp1.componentNameId
				and cp1.modified =0
				and cp1.attrname ='Virtual Machine Instance UUID'
		END
		IF ( @validationClientId >0)
		BEGIN
		INSERT into #tmpClientList
			select distinct clientId,
				   name ,
				   guid,
				   0
			FROM @vmapps
			where clientid = @validationClientId
		END
		ELSE IF ( @validationSubclientId >0)
		BEGIN
		INSERT into #tmpClientList
			select distinct  cp.componentNameId,
					vmapps.name ,
				    guid,
				    0
			FROM @vmapps vmapps
			inner join   APP_ClientProp cp
			on  attrname = 'VSA Discover Subclient ID' and modified =0
			and vmapps.clientid = cp.componentNameId
			and cp.attrVal = @validationSubclientId
		END
		IF @validationSubclientId > 0
		BEGIN
			INSERT into #tmpVMSequence(clientid, name, guid, dataBrowseTime)
			select clientId, name, guid, @validationBrowseTime
			from #tmpClientList
			IF(ISNULL(@validationBrowseTime, 0)) > 0
			BEGIN
				delete VM
				from #tmpVMSequence VM
				left join (
				select MAX(V.jobId) jobid, V.VMclientId
				from APP_VMProp V
				inner join #tmpVMSequence S
				on S.clientId = V.VMclientId
				and V.attrName = 'vmBackupEndTime'
				and V.attrVal <= @validationBrowseTime
				group by V.VMclientId )T
				on VM.clientId = T.VMclientId
				where T.VMclientId is null
			END
			IF @useSourceESXMount = 1
			BEGIN
				-- Update vmLocation hostname
				update vmSeq
				set hostname = P1.attrval
				from #tmpVMSequence vmSeq
				inner join APP_VMProp P1 WITH (NOLOCK)
				on P1.VMclientId = vmSeq.clientId
				and P1.attrName = 'vmHost'
				inner join App_clientprop CP WITH(NOLOCK)
				on CP.componentNameId = P1.VMclientId
				and CP.attrName = 'Last Backup JobID'
				and CP.attrVal = P1.jobId
				set @virtualizationClientId = (select clientId from App_application where id = @validationSubclientId and appTypeId = 106)
			END
		END
		INSERT into #tmpPhysicalConfig
		select clientId,
		name,
		'',
		backupsetId,
		@restoreNetworkName,
		'',
		'',
		'',
		0
		from #tmpClientList
		where guid =''
		--update hwconfig from virtual app to responsefile temp table.
		UPDATE CL
			SET CL.hwconfig = VMS.hwconfig,
				CL.dataBrowseTime = VMS.dataBrowseTime,
				CL.enableBootDiskOnly = VMS.enableBootDiskOnly
			FROM #tmpPhysicalConfig CL
			INNER JOIN #tmpVMSequence VMS
			ON VMS.name = CL.name
		delete from #tmpVMSequence where GUID =''
		update #tmpPhysicalConfig
		set oneTouch = cast ( replace(cast(T.attrVal as nvarchar(max)),'<?xml version="1.0" encoding="UTF-8" standalone="no" ?>','')  as xml)
		from #tmpphysicalConfig PC
		INNER JOIN  ( select row_number() over ( partition by clientId, backupset order by attrName desc) as rn,
							 clientId,
							 backupset,
							 attrVal
					   from APP_ExtendedProperties
					   where attrType =127 ) T
		on T.clientId = PC.clientId
		and t.backupSet = PC.backupsetId
		and T.rn =1
		declare @csClientName nvarchar(256)
		declare @csHostName nvarchar(256)
		declare @csIPAddress nvarchar(256)
		declare @userName nvarchar(256)
		declare @userPassword nvarchar(256)
		declare @encrypTPassword nvarchar(256)
		select @csClientName = name ,
			   @csHostName = net_hostname,
			   @csIPAddress = cp.stringVal
		FROM app_client C
		inner join APP_CommCell CC
		on C.id = CC.clientId
		inner join APP_ComponentProp cp
		on c.id = cp.componentId
and cp.propertyTypeId = 2102
		and cc.id = 2
		and cp.modified = 0
		select @userName = login,
			   @userPassword = password
		from UMUsers
		where flags & 67 = 67
		EXEC dbo.pswEncryptionManaged @userPassword , @encrypTPassword OUTPUT
		declare @tempXML xml
		set @tempXML = ( select (select @csClientName 'clientName',
								@csHostName 'hostName'
						  for xml path('commservInfo'), TYPE
						 ),
						 ( select @csipaddress 'address'
							 for xml path ('ip'), TYPE
						   ),
					   (select @userName '@userName',
							   @encrypTPassword  '@password'
						FOR XML PATH('creds') , TYPE
						)
		FOR XML PATH('csinfo') )
		update #tmpPhysicalConfig
		set oneTouch.modify('
				delete (/ResponseFile_ResponseFileBean/csinfo[1])
				');
		update #tmpPhysicalConfig
		set oneTouch.modify('
				insert (
					sql:variable("@tempXML")
					) after (ResponseFile_ResponseFileBean/clients)[1]
				');
		set @tempXML = (select @userName '@userName',
			   @userPassword  '@password'
		FOR XML PATH('creds') )
		update #tmpPhysicalConfig
		set oneTouch.modify('
				delete (/ResponseFile_ResponseFileBean/csInfo[1]/creds[1])
				');
		update #tmpPhysicalConfig
		set oneTouch.modify('insert (sql:variable("@tempXML")
					 ) after (ResponseFile_ResponseFileBean/csInfo)[1]
				');
		DECLARE @count int = ( select count(*) from #tmpPhysicalConfig)
		declare @i int =1
		declare @backupsetId int
		declare @backupSetName nvarchar(256)
		declare @destname nvarchar(256)
		declare @networkLabel nvarchar(256)
		declare @nicCount int =0
		declare @autoReboot int =0
		declare @automationTest int =1 --flag to install the vmware tools/hyper-v integration services.
		declare @goToMiniSetUp int = 1 --disable sysprep for physical clients which will stop resetting password.
		declare @isClone int = 1 --clone
		declare @mem_size int = 1024 -- minimum memory to be set
		declare @hwconfig XML
		declare @enableBootDiskOnly int --use OS disk only for sureBackup test
		update PhysicalClients
		set PhysicalClients.name = C.name,
		PhysicalClients.destName = C.name + '_LM_' + cast(@jobId as varchar(10))
		from #tmpPhysicalConfig PhysicalClients inner join app_client C on PhysicalClients.clientId = C.id
		update #tmpPhysicalConfig
		set oneTouch.modify('replace value of (/ResponseFile_ResponseFileBean/@autoReboot)[1] with  sql:variable("@autoReboot")')
			where oneTouch.exist('/ResponseFile_ResponseFileBean/@autoReboot') =1
		update #tmpPhysicalConfig
		set oneTouch.modify('insert attribute autoReboot {sql:variable("@autoReboot")} into (/ResponseFile_ResponseFileBean)[1]')
			where oneTouch.exist('/ResponseFile_ResponseFileBean/@autoReboot') =0
		--automationTest used for installing VMware/Integration service tools inside VM post 1-touch restore
		update #tmpPhysicalConfig
		set oneTouch.modify('replace value of (/ResponseFile_ResponseFileBean/@automationTest)[1] with  sql:variable("@automationTest")')
			where oneTouch.exist('/ResponseFile_ResponseFileBean/@automationTest') =1
		update #tmpPhysicalConfig
		set oneTouch.modify('insert attribute automationTest {sql:variable("@automationTest")} into (/ResponseFile_ResponseFileBean)[1]')
			where oneTouch.exist('/ResponseFile_ResponseFileBean/@automationTest') =0
		While ( @i <= @count)
		BEGIN
			select @backupsetId = backupsetId ,
				   @destname = destName,
				   @networkLabel = networkLabel,
				   @hwconfig = hwconfig,
				   @enableBootDiskOnly = enableBootDiskOnly
			from #tmpPhysicalConfig where id = @i
			select @backupSetName = name from APP_BackupSetName where id = @backupsetId
			update #tmpPhysicalConfig
			set oneTouch.modify('insert attribute backupsetName {sql:variable("@backupSetName")} into (/ResponseFile_ResponseFileBean/clients/backupSet)[1]')
			where id = @i
			update #tmpPhysicalConfig
			set oneTouch.modify('insert attribute backupsetId {sql:variable("@backupsetId")} into (/ResponseFile_ResponseFileBean/clients/backupSet)[1]')
			where id = @i
			IF @hwconfig is not null and @hwconfig.exist('/hwconfig') =1 and isnull(@hwconfig.value('/hwconfig[1]/@mtpt_count', 'int'),0) != 0
			BEGIN
				update #tmpPhysicalConfig
					set oneTouch.modify('
							delete (/ResponseFile_ResponseFileBean/hwconfig[1])
					')
				where id = @i
				update #tmpPhysicalConfig
					set oneTouch.modify('
							insert  (sql:variable("@hwconfig")) into (/ResponseFile_ResponseFileBean)[1]
					')
				where id = @i
				update #tmpPhysicalConfig
					set oneTouch.modify('
							delete (/ResponseFile_ResponseFileBean/dataBrowseTime[1])
					')
				where id = @i
				DECLARE @dataBrowse XML = (SELECT (SELECT dataBrowseTime FROM #tmpPhysicalConfig WHERE id = @i) '@time', 55 '@_type_'
					FOR XML PATH ('dataBrowseTime'), TYPE)
				update #tmpPhysicalConfig
					set oneTouch.modify('
							insert  (sql:variable("@dataBrowse")) into (/ResponseFile_ResponseFileBean)[1]
					')
				where id = @i
			END
			DECLARE @xml xml
			DECLARE @nodeCount int
			DECLARE @j int
			IF @enableBootDiskOnly = 1
			BEGIN
				SET @xml = isnull((SELECT oneTouch FROM #tmpPhysicalConfig where id = @i),'')
				SET @j = 1
				SET @nodeCount = @xml.value('count(ResponseFile_ResponseFileBean/hwconfig/mtpt_list)','int')
				WHILE (@j <= @nodeCount)
				BEGIN
				IF @xml.value('(/ResponseFile_ResponseFileBean/hwconfig/mtpt_list[sql:variable("@j")]/@alwaysEnabled)[1]','int') = 0
				BEGIN
					Set @xml.modify('replace value of (ResponseFile_ResponseFileBean/hwconfig/mtpt_list[sql:variable("@j")]/@enabled)[1] with "0"')
				END
				SET @j = @j + 1
				END
				update #tmpPhysicalConfig
						set oneTouch = @xml
					where id = @i
			END
			update #tmpPhysicalConfig
			set oneTouch.modify('replace value of (/ResponseFile_ResponseFileBean/hwconfig/@vmName)[1] with  sql:variable("@destname")' )
			where id = @i
			 --goToMiniSetUp used disable sysprep for physical clients which will stop resetting password inside VM post 1-touch restore
			update #tmpPhysicalConfig
				   set oneTouch.modify('replace value of (/ResponseFile_ResponseFileBean/clients/platformConfig/@goToMiniSetUp)[1] with  sql:variable("@goToMiniSetUp")')
					where id = @i and oneTouch.exist('(/ResponseFile_ResponseFileBean/clients/platformConfig/@goToMiniSetUp)[1]') =1
			update #tmpPhysicalConfig
					set oneTouch.modify('insert attribute goToMiniSetUp {sql:variable("@goToMiniSetUp")} into (/ResponseFile_ResponseFileBean/clients/platformConfig)[1]')
					 where id = @i and oneTouch.exist('(/ResponseFile_ResponseFileBean/clients/platformConfig/@goToMiniSetUp)[1]') =0
			update #tmpPhysicalConfig
					set oneTouch.modify('replace value of (/ResponseFile_ResponseFileBean/hwconfig/@mem_size)[1] with  sql:variable("@mem_size")')
					where id = @i and oneTouch.exist('(/ResponseFile_ResponseFileBean/hwconfig/@mem_size)[1]') =1 AND oneTouch.value('(/ResponseFile_ResponseFileBean/hwconfig/@mem_size)[1]','int') < @mem_size
			update #tmpPhysicalConfig
					set oneTouch.modify('insert attribute mem_size {sql:variable("@mem_size")} into (/ResponseFile_ResponseFileBean/hwconfig)[1]')
					 where id = @i and oneTouch.exist('(/ResponseFile_ResponseFileBean/hwconfig/@mem_size)[1]') =0
			--setting clone flag to true and adding new client information
			update #tmpPhysicalConfig
					set oneTouch.modify('replace value of (/ResponseFile_ResponseFileBean/clients/@clone)[1] with  sql:variable("@isClone")')
					where id = @i and oneTouch.exist('(/ResponseFile_ResponseFileBean/clients/@clone)[1]') =1
			update #tmpPhysicalConfig
					set oneTouch.modify('insert attribute clone {sql:variable("@isClone")} into (/ResponseFile_ResponseFileBean/clients)[1]')
					where id = @i and oneTouch.exist('(/ResponseFile_ResponseFileBean/clients/@clone)[1]') =0
			update #tmpPhysicalConfig
					set oneTouch.modify('delete (/ResponseFile_ResponseFileBean/clients/newclient)[1]')
					where id = @i and oneTouch.exist('(/ResponseFile_ResponseFileBean/clients/newclient)[1]') =1
			DECLARE @newClientXML XML =(SELECT @destname AS '@hostName',
						@destname AS '@clientName',
						0 AS '@type'
				FOR XML PATH('newclient'), TYPE)
			update #tmpPhysicalConfig
					set oneTouch.modify('insert sql:variable("@newClientXML") into (/ResponseFile_ResponseFileBean/clients)[1]')
					where id = @i and oneTouch.exist('(/ResponseFile_ResponseFileBean/clients/newclient)[1]') =0
			select @nicCount = oneTouch.value('count(/ResponseFile_ResponseFileBean/clients/netconfig/ipinfo/interfaces)','int')
			from #tmpPhysicalConfig where id = @i
			DECLARE @n int =1
			WHILE (@n <= @nicCount)
			begin
				update #tmpPhysicalConfig
				set oneTouch.modify('replace value of  (/ResponseFile_ResponseFileBean/clients/netconfig/ipinfo/interfaces[sql:variable("@n")]/@networkLabel)[1] with sql:variable("@networkLabel")')
				where id = @i
				and networkLabel is not null
				set @n = @n +1
			end
			set @i = @i +1
		END
		if ( @operationTypeFromVapp =2 or @vappSource = 1)
		begin
			update VMClients
			set dataBrowseTime = lastBackupTime,
				subTaskId = st.subTaskId
			from #tmpVMSequence VMClients
			inner join APP_VSAReplication VSR
			on VMClients.replicationId  = VSR.replicationId
			inner join tm_task T
			on VSR.taskId = T.taskId
			left join TM_SubTask st
			on T.taskId = st.taskId
			-- update copy precedence based on the replication setting
			update VMClients
			set copyPrecedence = T.copyPrecedence,
				copyPrecedenceApplicable = T.copyPrecedenceApplicable,
				copyId = T.copyId
			FROM (
			         select guid,
                           st.xmlValue.value('(/TMMsg_JobOption/restoreOptions/browseOption/mediaOption/copyPrecedence/@copyPrecedenceApplicable)[1]' ,'int') as copyPrecedenceApplicable ,
                           ISNULL(st.xmlValue.value('(TMMsg_JobOption/restoreOptions/browseOption/mediaOption/copyPrecedence/@copyPrecedence)[1]' ,'int'),0) as copyPrecedence,
                           isnull(st.xmlValue.value('(/TMMsg_JobOption/restoreOptions/storagePolicy/@copyId)[1]','int'),0) as copyId
                    FROM TM_SubTaskXMLOptions st
					inner join #tmpVMSequence VM
					on st.subTaskId = VM.subTaskId
					) T
			inner join #tmpVMSequence VMClients
			on VMClients.GUID = T.GUID
            update VSA
            set copyPrecedenceApplicable = case when copy =1 then 0 else 1 end,
                copyPrecedence = case when copy =1 then 0 else copy end
            FROM #tmpVMSequence VSA
            INNER JOIN archGroupCopy CP
            on VSA.copyId = CP.id
            and VSA.copyId >0
		end
		update VMClients
		set VMClients.clientId = TCL.clientId,
		VMClients.name = C.name,
		VMClients.destName = C.name + '_LM'
		from #tmpVMSequence VMClients inner join #tmpClientList TCL on TCL.GUID = VMClients.GUID
		inner join app_client C on TCL.clientId = C.id
	-- output xml for vm clients
		SET @vm_xml = (SELECT 0 as '@powerOnVM',
		(CASE WHEN @policyId <> 0 THEN (select  @policyName as '@vmAllocPolicyName',
				 @policyId as '@vmAllocPolicyId',
				 @policyType as '@policyType'
		 FOR XML PATH('vmAllocPolicy'), TYPE) END),
		 ( select copyPrecedence as '@copyPrecedence',
					(SELECT dataBrowseTime '@time', 55 '@_type_'
					FOR XML PATH ('dataBrowseTime'), TYPE)
			FOR XML PATH('oneTouchResponse'), TYPE
		 ),
		(select  clientId as '@clientId',
				name as '@clientName'
		FOR XML PATH ('vmEntity') , type
		),
		( select
			(CASE WHEN @useSourceESXMount = 1 THEN
				(select hostName as '@hostName',
					(SELECT @virtualizationClientId as '@clientId'
					FOR XML PATH ('virtualizationClient'), TYPE)
			for XML PATH ('vmLocation'), TYPE) END),
			(select destName as '@vmName'
		   for XML PATH ('vm'), TYPE ),
		   (select @labName as '@labName',
		   (select networkLabel as '@label'
			for xml path ('networkCards'), TYPE)
			FOR XML PATH ('advancedProperties'), TYPE
			),
			(select 'false' for XML PATH ('isPhysical'),TYPE)
		FOR XML PATH  ('vmInfo') , TYPE
		 )
		FROM #tmpVMSequence
		FOR XML PATH ('virtualMachineOption')
		)
	-- output xml for physical clients
		update #tmpPhysicalConfig
		set oneTouch = replace(cast(oneTouch as nvarchar(max)), 'ResponseFile_ResponseFileBean', 'oneTouchResponse')
		SET @ph_xml = (SELECT 0 as '@powerOnVM',
		(select  @policyName as '@vmAllocPolicyName',
				 @policyId as '@vmAllocPolicyId',
				 @policyType as '@policyType'
		 FOR XML PATH('vmAllocPolicy'), TYPE
		 ),
		 (select oneTouch),
		 (select  clientId as '@clientId',
				name as '@clientName'
		FOR XML PATH ('vmEntity') , type
		),
		( select
		   (select 'true' for XML PATH ('isPhysical'),TYPE)
				  FOR XML PATH  ('vmInfo') , TYPE
		 )
		FROM #tmpPhysicalConfig
		FOR XML PATH ('virtualMachineOption')
		)
	end
	set @o_xml = (select @vm_xml,@ph_xml,
				( SELECT @validationSubclientId as '@subclientId'
							 FOR XML PATH ('validationEntity'), TYPE
							 )
	FOR XML PATH ('TMMsg_VMProvisioningOption'))
	SET @taskXML = (SELECT
	(
		   select 1 as '@invokeWorkflowperJob',
	       @opType as '@operationType',
		   @vm_xml,@ph_xml,
		   @vAppXml.query('Api_VirtualAppReq/vApp/config'),
		   ( SELECT @vAppId as '@vAppId',
					@vAppName as '@vAppName'
			 FOR XML PATH ('vAppEntity'), TYPE
			 ),
			(CASE WHEN @validationClientId = 0 AND @validationSubclientId = 0 THEN
			( SELECT  'CreateLab' as '@workflowName'
			  FOR XML PATH ('workflow') , TYPE
			  )
			 ELSE '' END),
			(CASE WHEN @validationClientId > 0  THEN
			( SELECT @validationClientId as '@clientId'
			 FOR XML PATH ('validationEntity'), TYPE
			 )
			 WHEN @validationSubclientId > 0 THEN
			( SELECT @validationSubclientId as '@subclientId'
			 FOR XML PATH ('validationEntity'), TYPE
			 )
			 ELSE '' END)
	FOR XML PATH ('vmProvisioningOption'), TYPE, ROOT ('adminOpts')
	)
	FOR XML PATH ('TMMsg_JobOption'))
	select top 1 @taskId = taskId,
	       @subTaskId = subTaskId
	FROM TM_JobOptions
	where jobid = @jobId
	if ( ISNULL(@taskId,0) >0 and
	     ISNULL(@subTaskid, 0) >0
		 )
	BEGIN
		update TM_JobXMLOptions set xmlValue = @taskXML where taskId = @taskId and subTaskId = @subTaskId
	end
	select @o_xml
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SET @errorCode = ERROR_NUMBER()
SET @errorString = ERROR_MESSAGE()
END CATCH
ERROR_EXIT:
IF @errorCode <> 0
BEGIN
	SET @o_xml = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
                            FOR XML PATH('Ida_GenericResp'), TYPE)
	select @o_xml
END
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetVirtualMachineOptions')
	delete from GxQscripts where name = 'APPGetVirtualMachineOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetVirtualMachineOptions')
	delete from GXDBVersions where aliasname = 'APPGetVirtualMachineOptions'
GO

insert into GXDBVersions values(2, 'APPGetVirtualMachineOptions',  '00010001000200430000', 'APPGetVirtualMachineOptions', '00010001000200430000')
GO

