

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetTreeViewForSCP.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetTreeViewForSCP.sp,v $ $Id: APPGetTreeViewForSCP.sp,v 1.8.192.1 2018/03/22 01:46:42 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						Cursor: "GetTreeViewForSCP"						|
--	|																		|
--  |																		|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetTreeViewForSCP <<<'

IF EXISTS (select * from sysobjects where name='APPGetTreeViewForSCP')
	drop procedure APPGetTreeViewForSCP
IF EXISTS (select * from GxQscripts where name='APPGetTreeViewForSCP')
	delete from GxQscripts where name = 'APPGetTreeViewForSCP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetTreeViewForSCP')
	delete from GXDBVersions where aliasname = 'APPGetTreeViewForSCP'
GO
print '... Creating Procedure: APPGetTreeViewForSCP'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetTreeViewForSCP
  @client_id integer, 
  @instance_id integer,
  @scp_id integer,
  @allowSPcreate_id integer=0
AS
  DECLARE @o_backupSet int
  DECLARE @o_name nvarchar(128)
  DECLARE @o_scpId int
  DECLARE @o_scName nvarchar(128)
  DECLARE @o_allow int
BEGIN
	IF object_id('tempdb.dbo.#GTV_TMP') IS NOT NULL DROP TABLE #GTV_TMP
	IF object_id('tempdb.dbo.#OUT_TMP') IS NOT NULL DROP TABLE #OUT_TMP
	CREATE TABLE #GTV_TMP (backupSet int, name nvarchar(128), subclientName nvarchar(128), subclientStatus int, id int, systemStateFlag int, scpid int, spName nvarchar(128), allow int, bsStatus int)
	CREATE TABLE #OUT_TMP (backupSet int, name nvarchar(128), scpId int, spName nvarchar(128), allow int)
	BEGIN
		INSERT INTO #GTV_TMP
		SELECT APP.backupSet, name = BUS.name,
			APP.subclientName, APP.subclientStatus, APP.id,
			systemStateFlag = SUP.attrVal,
			scpid = BUP.attrVal,
			NULL, 1, BUS.status
		FROM APP_Application as APP
		INNER JOIN APP_BackupSetName BUS ON BUS.id=APP.backupSet
		LEFT OUTER JOIN APP_BackupSetProp BUP ON BUP.componentNameId=BUS.id AND BUP.attrName = 'Associated subclient Policy' AND BUP.modified = 0
		LEFT OUTER JOIN APP_SubClientProp SUP ON SUP.componentNameId=APP.id AND SUP.attrName = 'System State Subclient' AND SUP.modified=0
		WHERE  clientId = @client_id AND instance = @instance_id
		AND appTypeId in (select appTypeId from APP_IDAName where clientId = @client_id AND appTypeId in (select type from APP_idaType where displayName LIKE '%File system' ))
		AND ((subclientStatus & 4) <> 4)--exclude deleted subclients
		AND BUS.status&128<>128
		delete #GTV_TMP where name = N'Indexing BackupSet'
		IF (@allowSPcreate_id <> 0)
			delete #GTV_TMP where EXISTS(SELECT * FROM APP_BackupSetProp where componentNameId=backupSet AND attrName='OnDemand Backupset' AND attrVal='1')
		update #GTV_TMP set spName = (SELECT name FROM APP_BackupSetName WHERE id=scpid)
		--get rid of any backupsets having user-defined subclients unless they are already assoc'd with scp
		IF (@allowSPcreate_id = 0)
		BEGIN
			delete #GTV_TMP where backupSet IN (select backupSet
				FROM #GTV_TMP
				WHERE (scpid IS NULL AND subclientStatus = 0 AND (systemStateFlag <> 1 OR systemStateFlag IS NULL)))
		END
		ELSE
		BEGIN
			update #GTV_TMP set allow = 0 where backupSet IN (select backupSet
				FROM #GTV_TMP
				WHERE (scpid IS NULL AND subclientStatus = 0 AND (systemStateFlag <> 1 OR systemStateFlag IS NULL)))
		END
		if (@scp_id <> 0)
		BEGIN
			IF (@allowSPcreate_id = 0)
				delete #GTV_TMP where ((scpid <> 0) AND (scpid <> @scp_id))
			ELSE
				update #GTV_TMP set allow = 0 where scpid <> 0 AND bsStatus&8=8
		END
		--if scpId sent from GUI is zero, then return only
		--eligible backupsets that are not associated with any scp
		ELSE
		BEGIN
			IF (@allowSPcreate_id = 0)
				delete #GTV_TMP where scpid <> 0
			ELSE
				update #GTV_TMP set allow = 0 where scpid <> 0
				AND (select COUNT(*) from APP_Application where backupSet=scpid) > 1 --MR82856 - DON'T ALLOW RE-ASSOCIATION FOR POLICIES WITH MORE THAN DEFAULT SUBCLIENTS
		END
		--DON'T ALL ASSOCIATION FOR CLIENTS WITH MORE THAN ONE FILES SYSTEM INSTALLED
		UPDATE #GTV_TMP SET allow = 0 WHERE
		(select count(appTypeId) from APP_IDAName WHERE clientId = @client_id AND appTypeId in (select type from APP_idaType WHERE displayName LIKE '%File system' )) > 1
		--select * from #GTV_TMP
		--eliminate duplicate rows for each backupset
		INSERT INTO #OUT_TMP
		SELECT DISTINCT backupSet, name, scpid, spName, allow from #GTV_TMP
		select * from #OUT_TMP
	END
	drop table #GTV_TMP
	drop table #OUT_TMP
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'APPGetTreeViewForSCP')
	delete from GxQscripts where name = 'APPGetTreeViewForSCP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetTreeViewForSCP')
	delete from GXDBVersions where aliasname = 'APPGetTreeViewForSCP'
GO

insert into GXDBVersions values(2, 'APPGetTreeViewForSCP',  '00010008019200010000', 'APPGetTreeViewForSCP', '00010008019200010000')
GO

