

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetTopologyIdForClientGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- $Id: APPGetTopologyIdForClientGroup.sp,v 1.1.4.2 2017/11/15 16:47:15 kmokshagundam Exp $;
--
--  +====================================================================================================================+
--  |   Procedure:  APPGetTopologyIdForClientGroup
--  |
--  | Description:  This procedure is used to get the id of the non-smart network topology, the client group is part of.
--  |
--  |       Input:  clientGroupId
--  |
--  |      Output:  Topology Id of the non-smart network topology, the client group is part of.
-- 	|
--  |      Return:  xxxxxxxxxxxxxxxx
--  |
--  |   Revision	Author					Description
--  |   ---------  	-------					--------------------------------
--  |   1.1        	kmokshagundam   		Initial Edit
--  +======================================================================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetTopologyIdForClientGroup <<<'

IF EXISTS (select * from sysobjects where name='APPGetTopologyIdForClientGroup')
	drop procedure APPGetTopologyIdForClientGroup
IF EXISTS (select * from GxQscripts where name='APPGetTopologyIdForClientGroup')
	delete from GxQscripts where name = 'APPGetTopologyIdForClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetTopologyIdForClientGroup')
	delete from GXDBVersions where aliasname = 'APPGetTopologyIdForClientGroup'
GO
print '... Creating Procedure: APPGetTopologyIdForClientGroup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure APPGetTopologyIdForClientGroup
  @clientGroupId INTEGER
AS
  DECLARE @topologyId INTEGER
SET NOCOUNT ON
BEGIN
SELECT AFTA.topologyId FROM APP_FirewallTopologyAssoc AFTA WITH (NOLOCK) INNER JOIN APP_FirewallTopology AFT WITH (NOLOCK) ON AFTA.topologyId = AFT.topologyId WHERE AFT.flag & 1 = 0 AND AFTA.groupId = @clientGroupId
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetTopologyIdForClientGroup')
	delete from GxQscripts where name = 'APPGetTopologyIdForClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetTopologyIdForClientGroup')
	delete from GXDBVersions where aliasname = 'APPGetTopologyIdForClientGroup'
GO

insert into GXDBVersions values(2, 'APPGetTopologyIdForClientGroup',  '00010001000400020000', 'APPGetTopologyIdForClientGroup', '00010001000400020000')
GO

